/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.cache;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;

public class MemcacheResourceStream
extends AbstractResourceStream {
    private static final long serialVersionUID = -1317280662500181698L;
    private byte[] data;
    private String contentType;
    private int length;

    MemcacheResourceStream(IResourceStream resourceStream) {
        this.setLocale(resourceStream.getLocale());
        this.setStyle(resourceStream.getStyle());
        this.setVariation(resourceStream.getVariation());
        this.contentType = resourceStream.getContentType();
        try {
            this.data = ByteStreams.toByteArray((InputStream)resourceStream.getInputStream());
            this.length = this.data.length;
        }
        catch (Exception e) {
            throw new RuntimeException("ResourceStream loading error: " + resourceStream, e);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public Bytes length() {
        return Bytes.bytes((long)this.length);
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return new ByteArrayInputStream(this.data);
    }

    public void close() throws IOException {
    }

    public Time lastModifiedTime() {
        return null;
    }
}

