/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.gwt;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.MetaDataHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.Response;

public class GwtScriptAppender
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final String[] sources;
    private IModel<String> localeModel;
    private String polymerImportPrefix;

    public GwtScriptAppender(String ... source) {
        this((IModel<String>)null, source);
    }

    public GwtScriptAppender(IModel<String> localeModel, String ... sources) {
        this.sources = (String[])Preconditions.checkNotNull((Object)sources);
        this.localeModel = localeModel;
    }

    public void setWebComponentsImportPrefix(String prefix) {
        this.polymerImportPrefix = prefix;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        IModel model = component.getDefaultModel();
        if (this.localeModel != null && model != null) {
            response.render((HeaderItem)MetaDataHeaderItem.forMetaTag((IModel)new Model((Serializable)((Object)"gwt:property")), this.localeModel));
        }
    }

    public void afterRender(Component component) {
        super.afterRender(component);
        Response r = component.getResponse();
        if (!Strings.isNullOrEmpty((String)this.polymerImportPrefix)) {
            r.write((CharSequence)"<script src=\"");
            r.write((CharSequence)this.polymerImportPrefix);
            r.write((CharSequence)"/bower_components/webcomponentsjs/webcomponents.js");
            r.write((CharSequence)"\">");
            r.write((CharSequence)"</script>");
        }
        for (String src : this.sources) {
            r.write((CharSequence)"<script type=\"text/javascript\" language=\"javascript\" src=\"");
            r.write((CharSequence)src);
            r.write((CharSequence)"\">");
            r.write((CharSequence)"</script>");
        }
    }

    public boolean isTemporary(Component component) {
        return true;
    }
}

