/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.gwt;

import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.time.Duration;

public abstract class RestServiceProfileTimer
extends WebMarkupContainer {
    private static final long serialVersionUID = 4297419133376026538L;
    private static String PROFILE_OBO_EMAIL = "CTOOLKIT_OBO_EMAIL";
    private static String PROFILE_TOKEN = "CTOOLKIT_TOKEN";
    private static String script = "var RestServiceProfile  = '{'CTOOLKIT_SERVICE_ROOT: ''{0}'''}'; var UserProfile  = '{'EMAIL: ''{1}'',DOMICILE: ''{2}'''}';";

    public RestServiceProfileTimer(String id) {
        super(id);
        this.add(new Behavior[]{new Timer()});
    }

    public static void deleteCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (PROFILE_OBO_EMAIL.equals(cookie.getName())) {
                cookie.setMaxAge(0);
                cookie.setValue("");
                cookie.setPath("/");
                response.addCookie(cookie);
                continue;
            }
            if (!PROFILE_TOKEN.equals(cookie.getName())) continue;
            cookie.setMaxAge(0);
            cookie.setValue("");
            cookie.setPath("/");
            response.addCookie(cookie);
        }
    }

    protected void onInitialize() {
        super.onInitialize();
        this.getPage().add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component component, IHeaderResponse response) {
                String serviceRootUrl = RestServiceProfileTimer.this.getServiceRootUrl();
                if (Strings.isNullOrEmpty((String)serviceRootUrl)) {
                    throw new NullPointerException("REST service URL cannot be null or empty!");
                }
                String email = RestServiceProfileTimer.this.getEmail();
                if (Strings.isNullOrEmpty((String)email)) {
                    throw new NullPointerException("Email cannot be null or empty!");
                }
                String domicile = RestServiceProfileTimer.this.getDomicile();
                if (Strings.isNullOrEmpty((String)domicile)) {
                    throw new NullPointerException("Seller's domicile cannot be null or empty!");
                }
                String script = MessageFormat.format(script, serviceRootUrl, email, domicile);
                response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)script, (String)component.getMarkupId()));
            }
        }});
    }

    public void updateCookies(HttpServletResponse response) {
        this.updateCookies(response, null);
    }

    private void updateCookies(HttpServletResponse response, Long seconds) {
        String email = this.getEmail();
        if (Strings.isNullOrEmpty((String)email)) {
            throw new NullPointerException("Email cannot be null or empty!");
        }
        String accessToken = this.getAccessToken();
        if (Strings.isNullOrEmpty((String)accessToken)) {
            throw new NullPointerException("Access token cannot be null or empty!");
        }
        Long age = seconds == null ? this.getRemainingSeconds() : seconds;
        age = age + 30L;
        Cookie cookie = new Cookie(PROFILE_OBO_EMAIL, email);
        cookie.setPath("/");
        cookie.setMaxAge(age.intValue());
        response.addCookie(cookie);
        cookie = new Cookie(PROFILE_TOKEN, accessToken);
        cookie.setPath("/");
        cookie.setMaxAge(age.intValue());
        response.addCookie(cookie);
    }

    protected abstract String getEmail();

    protected abstract String getDomicile();

    protected abstract String getAccessToken();

    protected abstract Date getExpirationTime();

    protected abstract String getServiceRootUrl();

    private Long getRemainingSeconds() {
        Date expirationTime = this.getExpirationTime();
        Long seconds = 3600L;
        if (expirationTime != null) {
            long time = expirationTime.getTime();
            seconds = (time - new Date().getTime()) / 1000L - 30L;
        }
        return seconds;
    }

    private class Timer
    extends AjaxSelfUpdatingTimerBehavior {
        private static final long serialVersionUID = 1L;

        Timer() {
            super(Duration.seconds((int)20));
        }

        protected void onPostProcessTarget(AjaxRequestTarget target) {
            Long seconds = RestServiceProfileTimer.this.getRemainingSeconds();
            this.setUpdateInterval(Duration.seconds((double)seconds.longValue()));
            Response response = target.getHeaderResponse().getResponse();
            RestServiceProfileTimer.this.updateCookies((HttpServletResponse)response.getContainerResponse(), seconds);
        }
    }
}

