/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.identity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class FirebaseConfig
implements Serializable {
    private static final long serialVersionUID = 649739600329865627L;
    private String signInSuccessUrl;
    private SignInFlow signInFlow = SignInFlow.REDIRECT;
    private String termsUrl;
    private CredentialHelper credentialHelper = CredentialHelper.NONE;
    private String apiKey;
    private String projectId;
    private String databaseName;
    private String bucketName;
    private String senderId;
    private String clientId;
    private List<Provider> providers = new ArrayList<Provider>();
    private String uiWidgetVersion = "3.0.0";
    private String firebaseVersion = "5.0.4";
    private boolean requireDisplayName;
    private ListMultimap<Provider, String> scopes = MultimapBuilder.ListMultimapBuilder.enumKeys(Provider.class).arrayListValues().build();
    private ListMultimap<Provider, CustomParameter> customParameters = MultimapBuilder.ListMultimapBuilder.enumKeys(Provider.class).arrayListValues().build();

    public String getSignInSuccessUrl() {
        return this.signInSuccessUrl;
    }

    public void setSignInSuccessUrl(String signInSuccessUrl) {
        this.signInSuccessUrl = signInSuccessUrl;
    }

    public String getSignInFlow() {
        return this.signInFlow.getValue();
    }

    public FirebaseConfig redirect() {
        this.signInFlow = SignInFlow.REDIRECT;
        return this;
    }

    public FirebaseConfig popup() {
        this.signInFlow = SignInFlow.POPUP;
        return this;
    }

    public String getTermsUrl() {
        return this.termsUrl;
    }

    public void setTermsUrl(String termsUrl) {
        this.termsUrl = termsUrl;
    }

    public String getCredentialHelper() {
        return this.credentialHelper.getValue();
    }

    public void setCredentialHelper(CredentialHelper credentialHelper) {
        this.credentialHelper = credentialHelper;
    }

    public FirebaseConfig none() {
        this.credentialHelper = CredentialHelper.NONE;
        return this;
    }

    public FirebaseConfig oneTapSignUp(@Nonnull String clientId) {
        String errorMessage = "Client Id is being required if Google one tap sign-up has been configured.";
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)errorMessage);
        this.credentialHelper = CredentialHelper.ONE_TAP;
        return this;
    }

    public FirebaseConfig accountChooser() {
        this.credentialHelper = CredentialHelper.ACCOUNT_CHOOSER;
        return this;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public List<String> getSignInOptions() {
        ArrayList<String> options = new ArrayList<String>();
        for (Provider next : this.providers) {
            options.add(next.getValue());
        }
        return options;
    }

    public FirebaseConfig add(@Nonnull Provider provider) {
        Preconditions.checkNotNull((Object)((Object)provider));
        if (this.providers.contains((Object)provider)) {
            throw new IllegalArgumentException((Object)((Object)provider) + " has been already configured!");
        }
        this.providers.add(provider);
        return this;
    }

    private Provider lastProvider() {
        if (this.providers.isEmpty()) {
            return null;
        }
        return this.providers.get(this.providers.size() - 1);
    }

    public FirebaseConfig google() {
        return this.add(Provider.Google);
    }

    public FirebaseConfig facebook() {
        return this.add(Provider.Facebook);
    }

    public FirebaseConfig twitter() {
        return this.add(Provider.Twitter);
    }

    public FirebaseConfig github() {
        return this.add(Provider.Github);
    }

    public FirebaseConfig email() {
        return this.email(true);
    }

    public FirebaseConfig email(boolean requireDisplayName) {
        this.requireDisplayName = requireDisplayName;
        return this.add(Provider.Email);
    }

    public FirebaseConfig scope(@Nonnull String scope) {
        Preconditions.checkNotNull((Object)scope);
        Provider provider = this.lastProvider();
        if (provider == null) {
            throw new IllegalArgumentException("First at least one Provider must be added.");
        }
        this.scopes.put((Object)provider, (Object)scope);
        return this;
    }

    public FirebaseConfig parameter(@Nonnull String property, @Nonnull String value) {
        Preconditions.checkNotNull((Object)property);
        Preconditions.checkNotNull((Object)value);
        Provider provider = this.lastProvider();
        if (provider == null) {
            throw new IllegalArgumentException("First at least one Provider must be added.");
        }
        this.customParameters.put((Object)provider, (Object)new CustomParameter(property, value));
        return this;
    }

    public String getSignInOptionsAsString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Provider> providersIterator = this.providers.iterator();
        while (providersIterator.hasNext()) {
            Object next;
            boolean hasProviderBody;
            Provider provider = providersIterator.next();
            List providerScopes = this.scopes.get((Object)provider);
            List providerCustomParameters = this.customParameters.get((Object)provider);
            boolean appendGoogleSpecifics = provider == Provider.Google && this.credentialHelper == CredentialHelper.ONE_TAP;
            boolean appendEmailSpecifics = provider == Provider.Email;
            boolean bl = hasProviderBody = appendGoogleSpecifics || appendEmailSpecifics || !providerScopes.isEmpty() || !providerCustomParameters.isEmpty();
            if (hasProviderBody) {
                builder.append("{");
                builder.append("\n");
                builder.append("provider: ");
            }
            builder.append(provider.getValue());
            if (appendGoogleSpecifics) {
                builder.append(",");
                builder.append("\n");
                builder.append("authMethod: 'https://accounts.google.com',");
                builder.append("\n");
                builder.append("clientId: '");
                builder.append(this.clientId);
                builder.append("'");
            } else if (appendEmailSpecifics) {
                builder.append(",");
                builder.append("\n");
                builder.append("requireDisplayName: ");
                builder.append(this.requireDisplayName);
            }
            if (!providerScopes.isEmpty()) {
                builder.append(",");
                builder.append("\n");
                builder.append("scopes: [");
                builder.append("\n");
                Iterator scopesIterator = providerScopes.iterator();
                while (scopesIterator.hasNext()) {
                    next = (String)scopesIterator.next();
                    builder.append("'");
                    builder.append((String)next);
                    builder.append("'");
                    if (!scopesIterator.hasNext()) continue;
                    builder.append(",");
                    builder.append("\n");
                }
                builder.append("\n");
                builder.append("]");
            }
            if (!providerCustomParameters.isEmpty()) {
                builder.append(",");
                builder.append("\n");
                builder.append("customParameters: {");
                Iterator customParametersIterator = providerCustomParameters.iterator();
                while (customParametersIterator.hasNext()) {
                    next = (CustomParameter)customParametersIterator.next();
                    builder.append("\n");
                    builder.append(((CustomParameter)next).property);
                    builder.append(": ");
                    builder.append("'");
                    builder.append(((CustomParameter)next).value);
                    builder.append("'");
                    if (!customParametersIterator.hasNext()) continue;
                    builder.append("\n");
                    builder.append(",");
                }
                builder.append("\n");
                builder.append("}");
            }
            if (hasProviderBody) {
                builder.append("\n");
                builder.append("}");
            }
            if (!providersIterator.hasNext()) continue;
            builder.append(",");
            builder.append("\n");
        }
        return builder.toString();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public String getUiWidgetVersion() {
        return this.uiWidgetVersion;
    }

    public void setUiWidgetVersion(String version) {
        this.uiWidgetVersion = version;
    }

    public String getFirebaseVersion() {
        return this.firebaseVersion;
    }

    public void setFirebaseVersion(String version) {
        this.firebaseVersion = version;
    }

    private static class CustomParameter {
        private String property;
        private String value;

        CustomParameter(String property, String value) {
            this.property = property;
            this.value = value;
        }
    }

    static enum SignInFlow {
        REDIRECT("redirect"),
        POPUP("popup");

        private String value;

        private SignInFlow(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    static enum CredentialHelper {
        ACCOUNT_CHOOSER("firebaseui.auth.CredentialHelper.ACCOUNT_CHOOSER_COM"),
        ONE_TAP("firebaseui.auth.CredentialHelper.GOOGLE_YOLO"),
        NONE("firebaseui.auth.CredentialHelper.NONE");

        private String value;

        private CredentialHelper(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    static enum Provider {
        Google("firebase.auth.GoogleAuthProvider.PROVIDER_ID"),
        Facebook("firebase.auth.FacebookAuthProvider.PROVIDER_ID"),
        Twitter("firebase.auth.TwitterAuthProvider.PROVIDER_ID"),
        Github("firebase.auth.GithubAuthProvider.PROVIDER_ID"),
        Email("firebase.auth.EmailAuthProvider.PROVIDER_ID");

        private String value;

        private Provider(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

