/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.identity.behavior;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.UrlResourceReference;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.ctoolkit.wicket.standard.identity.FirebaseConfig;

public class FirebaseAppInit
extends Behavior {
    private static final long serialVersionUID = 1L;
    private static final String FIREBASE_BASE_URL = "https://www.gstatic.com/firebasejs/";
    private static final String FIREBASE_UI_BASE_URL = "https://www.gstatic.com/firebasejs/ui/";
    private static final String JS_AUTH_CDN_URL = "https://www.gstatic.com/firebasejs/ui/{0}/firebase-ui-auth{1}.js";
    private final String uiWidgetVersion;
    private final String firebaseVersion;
    private final boolean uiOn;
    private UrlResourceReference cssAuthCdnReference;
    private UrlResourceReference jsFirebaseAuthCdnReference;
    private UrlResourceReference jsFirebaseAppCdnReference;
    private String firebaseInitScript;
    private FirebaseConfig options;

    public FirebaseAppInit(@Nonnull FirebaseConfig options) {
        this(options, false);
    }

    public FirebaseAppInit(@Nonnull FirebaseConfig options, boolean uiOn) {
        String errorMessage = "FirebaseUI for Web - Auth widget version is mandatory";
        this.uiWidgetVersion = (String)Preconditions.checkNotNull((Object)options.getUiWidgetVersion(), (Object)errorMessage);
        errorMessage = "Firebase version is mandatory";
        this.firebaseVersion = (String)Preconditions.checkNotNull((Object)options.getFirebaseVersion(), (Object)errorMessage);
        this.options = (FirebaseConfig)Preconditions.checkNotNull((Object)options);
        this.uiOn = uiOn;
    }

    public void bind(Component component) {
        Url url = Url.parse((CharSequence)(FIREBASE_BASE_URL + this.firebaseVersion + "/firebase-app.js"));
        this.jsFirebaseAppCdnReference = new UrlResourceReference(url);
        url = Url.parse((CharSequence)(FIREBASE_BASE_URL + this.firebaseVersion + "/firebase-auth.js"));
        this.jsFirebaseAuthCdnReference = new UrlResourceReference(url);
        PackageTextTemplate template = new PackageTextTemplate(FirebaseAppInit.class, "FirebaseAppInit.js");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("apiKey", this.options.getApiKey());
        variables.put("projectId", this.options.getProjectId());
        variables.put("databaseName", this.options.getDatabaseName());
        variables.put("bucketName", this.options.getBucketName());
        variables.put("senderId", this.options.getSenderId());
        this.firebaseInitScript = template.asString(variables);
        if (this.uiOn) {
            template = new PackageTextTemplate(FirebaseAppInit.class, "FirebaseUiConfig.js");
            variables = new HashMap();
            variables.put("signInSuccessUrl", this.options.getSignInSuccessUrl());
            variables.put("credentialHelper", this.options.getCredentialHelper());
            variables.put("signInOptions", this.options.getSignInOptionsAsString());
            variables.put("termsUrl", this.options.getTermsUrl());
            this.firebaseInitScript = this.firebaseInitScript + template.asString(variables);
        }
        url = Url.parse((CharSequence)(FIREBASE_UI_BASE_URL + this.uiWidgetVersion + "/firebase-ui-auth.css"));
        this.cssAuthCdnReference = new UrlResourceReference(url);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        String stringUrl;
        String language = component.getLocale().getLanguage();
        MessageFormat fmt = new MessageFormat(JS_AUTH_CDN_URL);
        Object[] args = new Object[2];
        args[0] = this.uiWidgetVersion;
        if (Strings.isEmpty((CharSequence)language)) {
            args[1] = "";
            stringUrl = fmt.format(args);
        } else {
            args[1] = "__" + language.toLowerCase();
            stringUrl = fmt.format(args);
        }
        Url url = Url.parse((CharSequence)stringUrl);
        UrlResourceReference jsAuthCdnReference = new UrlResourceReference(url);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)this.cssAuthCdnReference));
        JavaScriptReferenceHeaderItem headerItem = JavaScriptHeaderItem.forReference((ResourceReference)this.jsFirebaseAppCdnReference);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)headerItem));
        headerItem = JavaScriptHeaderItem.forReference((ResourceReference)this.jsFirebaseAuthCdnReference);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)headerItem));
        headerItem = JavaScriptHeaderItem.forReference((ResourceReference)jsAuthCdnReference);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)headerItem));
        JavaScriptContentHeaderItem scriptItem = JavaScriptHeaderItem.forScript((CharSequence)this.firebaseInitScript, (String)"firebase_init");
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)scriptItem));
    }
}

