/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.markup.html.form.ajax;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxChannel;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.ctoolkit.wicket.standard.event.AjaxSubmitErrorEvent;
import org.ctoolkit.wicket.standard.event.AjaxSubmitEvent;
import org.ctoolkit.wicket.standard.markup.html.basic.ajax.AjaxStandardIndicatorAppender;

public class IndicatingAjaxButton
extends AjaxFallbackButton
implements IAjaxIndicatorAware {
    public static final String FEEDBACK_MARKUP_ID = "feedback";
    private static final long serialVersionUID = 1L;
    private final AjaxStandardIndicatorAppender indicatorAppender = new AjaxStandardIndicatorAppender();

    public IndicatingAjaxButton(String id, Form<?> form) {
        super(id, form);
        this.add(new Behavior[]{this.indicatorAppender});
    }

    public IndicatingAjaxButton(String id, IModel<String> model, Form<?> form) {
        super(id, model, form);
        this.add(new Behavior[]{this.indicatorAppender});
    }

    protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
        this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new AjaxSubmitEvent(target));
        Component feedback = this.getPage().get(FEEDBACK_MARKUP_ID);
        if (feedback != null && target != null) {
            target.add(new Component[]{feedback});
        }
    }

    protected void onError(AjaxRequestTarget target, Form<?> form) {
        this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new AjaxSubmitErrorEvent(target));
        Component feedback = this.getPage().get(FEEDBACK_MARKUP_ID);
        if (target != null) {
            if (feedback != null) {
                target.add(new Component[]{feedback});
            }
            target.add(new Component[]{form});
        }
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        attributes.setChannel(new AjaxChannel("blocking", AjaxChannel.Type.ACTIVE));
    }

    public String getAjaxIndicatorMarkupId() {
        return this.indicatorAppender.getMarkupId();
    }
}

