/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.markup.html.formrow;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public class FormRowBehavior
extends Behavior {
    private static final long serialVersionUID = -8684400463659951337L;
    private static FormRowBehavior DEFAULT;
    private static FormRowBehavior LABEL_NOT_RENDERED;
    private boolean componentFirst;
    private Boolean labelNotRendered;
    private Variant variant;
    private IModel<String> label;

    public FormRowBehavior() {
        this(Variant.INLINE_BLOCK, null, false);
    }

    public FormRowBehavior(boolean componentFirst) {
        this(Variant.INLINE_BLOCK, null, componentFirst);
    }

    public FormRowBehavior(Variant variant) {
        this(variant, null, false);
    }

    public FormRowBehavior(IModel<String> label) {
        this(Variant.INLINE_BLOCK, label, false);
    }

    public FormRowBehavior(Variant variant, IModel<String> label, boolean componentFirst) {
        this.variant = variant;
        this.label = label;
        this.componentFirst = componentFirst;
    }

    public static FormRowBehavior get() {
        if (DEFAULT == null) {
            DEFAULT = new FormRowBehavior();
        }
        return DEFAULT;
    }

    public static FormRowBehavior labelNotRendered() {
        if (LABEL_NOT_RENDERED == null) {
            LABEL_NOT_RENDERED = new FormRowBehavior();
            FormRowBehavior.LABEL_NOT_RENDERED.labelNotRendered = Boolean.TRUE;
        }
        return LABEL_NOT_RENDERED;
    }

    public String getRowMarkupId(Component component) {
        return component.getMarkupId() + "-row";
    }

    public void beforeRender(Component component) {
        StringBuilder builder = new StringBuilder("<div class='");
        builder.append(this.getCssClass(component));
        builder.append("'");
        if (component.getOutputMarkupId()) {
            builder.append(" id='");
            builder.append(this.getRowMarkupId(component));
            builder.append("'");
        }
        builder.append(">");
        Response response = component.getResponse();
        response.write((CharSequence)builder.toString());
        if (!this.componentFirst) {
            this.renderLabel(component, response);
        }
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        if (component.hasErrorMessage()) {
            tag.append("class", (CharSequence)"error", " ");
        }
    }

    private void renderLabel(Component component, Response response) {
        if (this.labelNotRendered != null && this.labelNotRendered.booleanValue()) {
            return;
        }
        String label = (String)this.getLabel(component).getObject();
        if (!Strings.isEmpty((CharSequence)label)) {
            response.write((CharSequence)("<label for='" + component.getMarkupId(true) + "'>"));
            response.write((CharSequence)label);
            response.write((CharSequence)"</label>");
        }
    }

    protected IModel<String> getLabel(Component component) {
        if (component instanceof FormComponent) {
            FormComponent fc = (FormComponent)component;
            if (fc.getLabel() == null) {
                throw new RuntimeException("Label must be set via component.setLabel(new I18ResourceBundle('label.componentName'))");
            }
            return fc.getLabel();
        }
        return this.label;
    }

    protected boolean isRequired(Component component) {
        if (component instanceof FormComponent) {
            FormComponent fc = (FormComponent)component;
            return fc.isRequired();
        }
        return false;
    }

    public void afterRender(Component component) {
        Response response = component.getResponse();
        if (this.componentFirst) {
            this.renderLabel(component, response);
        }
        response.write((CharSequence)"</div>");
    }

    protected String getCssClass(Component component) {
        StringBuilder sb = new StringBuilder();
        if (this.componentFirst) {
            sb.append("component-first ");
        } else if (component instanceof CheckBox) {
            sb.append("component-checkbox ");
        }
        sb.append("form-row");
        if (this.isRequired(component)) {
            sb.append(" required");
        }
        if (this.variant == Variant.BLOCK) {
            sb.append(" block");
        }
        if (this.variant == Variant.INLINE) {
            sb.append(" inline");
        }
        return sb.toString();
    }

    public static enum Variant {
        INLINE,
        BLOCK,
        INLINE_BLOCK;

    }
}

