/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.markup.html.panel;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ctoolkit.wicket.standard.markup.html.basic.ULabel;

public class MessagePanel
extends GenericPanel<String> {
    private static final long serialVersionUID = 6887752734845883174L;

    public MessagePanel(String id, IModel<String> message, Level level) {
        this(id, message, (IModel<Level>)new Model((Serializable)((Object)level)));
    }

    public MessagePanel(String id, IModel<String> message, IModel<Level> level) {
        super(id, message);
        WebMarkupContainer ul = new WebMarkupContainer("ul");
        this.add(new Component[]{ul});
        WebMarkupContainer li = new WebMarkupContainer("li");
        li.add(new Behavior[]{AttributeModifier.replace((String)"class", (IModel)new ClassModel(level))});
        ul.add(new Component[]{li});
        ULabel span = new ULabel("span", this.getModel());
        span.add(new Behavior[]{AttributeModifier.replace((String)"class", (IModel)new ClassModel(level))});
        li.add(new Component[]{span});
    }

    public void setMessage(Model<String> message) {
        this.get("ul").get("li").get("span").setDefaultModel(message);
    }

    protected String getCss(String levelAsString) {
        return "feedbackPanel" + levelAsString;
    }

    private class ClassModel
    extends AbstractReadOnlyModel<String> {
        private static final long serialVersionUID = 6935818251136100844L;
        private final IModel<Level> level;

        ClassModel(IModel<Level> level) {
            this.level = (IModel)Preconditions.checkNotNull(level);
        }

        public String getObject() {
            return MessagePanel.this.getCss(((Level)((Object)this.level.getObject())).name());
        }
    }

    public static enum Level {
        INFO,
        SUCCESS,
        WARNING,
        ERROR;

    }
}

