/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.markup.html.social;

import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.StringHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class GooglePlusButton
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final String GOOGLE_SCRIPT = "<script type=''text/javascript'' src=''{0}'' async defer>'{'lang:''{1}'' '}'</script>";
    private static final String GOOGLE_PLUS_SDK = "https://apis.google.com/js/platform.js";
    protected String size = "medium";
    protected String annotation = "none";

    public GooglePlusButton(String id, IModel<String> model) {
        super(id);
        this.setDefaultModel(model);
        final String lang = this.getLocale().getLanguage();
        this.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component component, IHeaderResponse response) {
                response.render((HeaderItem)StringHeaderItem.forString((CharSequence)MessageFormat.format(GooglePlusButton.GOOGLE_SCRIPT, GooglePlusButton.GOOGLE_PLUS_SDK, lang + "_" + lang.toUpperCase())));
            }
        }});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("class", (CharSequence)"g-plusone");
        tag.put("data-href", (CharSequence)this.getDefaultModelObjectAsString());
        tag.put("data-size", (CharSequence)this.size);
        tag.put("data-annotation", (CharSequence)this.annotation);
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }
}

