/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.markup.html.social;

import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.StringHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.encoding.UrlEncoder;

public class LinkedInShareButton
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final String SCRIPT = "<script type=''text/javascript'' src=''{0}''> lang: en_US </script>";
    private static final String SRC = "//platform.linkedin.com/in.js";
    private String counter;

    public LinkedInShareButton(String id, IModel<String> model) {
        super(id);
        this.setDefaultModel(model);
        this.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component component, IHeaderResponse response) {
                response.render((HeaderItem)StringHeaderItem.forString((CharSequence)MessageFormat.format(LinkedInShareButton.SCRIPT, LinkedInShareButton.SRC)));
            }
        }});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        UrlEncoder encoder = UrlEncoder.FULL_PATH_INSTANCE;
        String url = encoder.encode(this.getDefaultModelObjectAsString(), "UTF-8");
        tag.setName("script");
        tag.put("type", (CharSequence)"IN/Share");
        tag.put("data-url", (CharSequence)url);
        if (this.counter != null) {
            tag.put("data-counter", (CharSequence)this.counter);
        }
    }

    public String getCounter() {
        return this.counter;
    }

    public void setCounter(String counter) {
        this.counter = counter;
    }
}

