/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.model;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wicket.model.ChainingModel;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DropDownBridgeModel<CHOICE, T>
extends ChainingModel<CHOICE> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DropDownBridgeModel.class);
    private IModel<Map<String, CHOICE>> choicesModel;

    public DropDownBridgeModel(IModel<T> model, IModel<Map<String, CHOICE>> choicesModel) {
        super(Preconditions.checkNotNull(model));
        this.choicesModel = (IModel)Preconditions.checkNotNull(choicesModel);
    }

    public CHOICE getObject() {
        Object target = super.getObject();
        Preconditions.checkNotNull((Object)target, (Object)"The target instance of the model cannot be null.");
        String value = this.getCode(target);
        if (value == null) {
            return null;
        }
        Map choices = (Map)this.choicesModel.getObject();
        Preconditions.checkNotNull((Object)choices, (Object)"The choices map cannot be null.");
        if (choices.isEmpty()) {
            logger.warn("The choices map is empty.");
            return null;
        }
        return (CHOICE)choices.get(value);
    }

    public void setObject(CHOICE object) {
        Object target = super.getObject();
        Preconditions.checkNotNull((Object)target, (Object)"The target instance of the model cannot be null.");
        this.updateCode(object, target);
    }

    protected abstract String getCode(@Nonnull T var1);

    protected abstract void updateCode(@Nullable CHOICE var1, @Nonnull T var2);

    public void detach() {
        this.choicesModel.detach();
        super.detach();
    }
}

