/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.model;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.core.util.lang.PropertyResolverConverter;
import org.apache.wicket.model.AbstractPropertyModel;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DropDownListBridgeModel<CHOICE, T>
extends AbstractPropertyModel<CHOICE> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DropDownListBridgeModel.class);
    private final String expression;
    private final IModel<List<CHOICE>> listModel;

    public DropDownListBridgeModel(IModel<?> targetModel, String expression, IModel<List<CHOICE>> listModel) {
        super(Preconditions.checkNotNull(targetModel));
        this.expression = (String)Preconditions.checkNotNull((Object)expression);
        this.listModel = (IModel)Preconditions.checkNotNull(listModel);
    }

    public CHOICE getObject() {
        Object target = super.getObject();
        for (Object next : (List)this.listModel.getObject()) {
            Preconditions.checkNotNull(next, (Object)"A choice from the list cannot be null.");
            if (!this.equals(next, target)) continue;
            return (CHOICE)next;
        }
        logger.warn("No code book instance has been found for evaluated code: " + target);
        return null;
    }

    public void setObject(CHOICE object) {
        String propertyExpression = this.propertyExpression();
        if (propertyExpression.startsWith(".")) {
            throw new IllegalArgumentException("Property expressions cannot start with a '.' character");
        }
        PropertyResolverConverter prc = new PropertyResolverConverter(Application.get().getConverterLocator(), Session.get().getLocale());
        PropertyResolver.setValue((String)propertyExpression, (Object)this.getInnermostModelOrObject(), this.getValue(object), (PropertyResolverConverter)prc);
    }

    protected abstract boolean equals(@Nonnull CHOICE var1, @Nullable T var2);

    protected abstract T getValue(@Nullable CHOICE var1);

    protected String propertyExpression() {
        return this.expression;
    }

    public void detach() {
        this.listModel.detach();
        super.detach();
    }
}

