/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.recaptcha;

import com.google.common.base.Strings;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.model.IModel;

public class ReCaptchaBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private IModel<String> languageModel;
    private String dataSiteKey;

    public ReCaptchaBehavior(String key) {
        this(null, key);
    }

    public ReCaptchaBehavior(IModel<String> languageModel, String key) {
        this.languageModel = languageModel;
        this.dataSiteKey = key;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)this.getScript(component), (String)"grecaptcha-id"));
    }

    public void afterRender(Component component) {
        String language;
        String url = "https://www.google.com/recaptcha/api.js?onload=onloadCallback";
        String string = language = this.languageModel == null ? null : (String)this.languageModel.getObject();
        if (!Strings.isNullOrEmpty((String)language)) {
            url = url + "&hl=" + language.toLowerCase();
        }
        component.getResponse().write((CharSequence)("<script src=\"" + url + "\" async defer>\n</script>"));
    }

    private String getScript(Component component) {
        return "function onloadCallback() {grecaptcha.render('" + component.getMarkupId() + "',{sitekey:'" + this.dataSiteKey + "'})}";
    }
}

