/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.recaptcha;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;
import org.ctoolkit.wicket.standard.recaptcha.ReCaptchaBehavior;
import org.ctoolkit.wicket.standard.util.WicketUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReCaptchaWidget
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ReCaptchaWidget.class);
    private String dataSiteKey;
    private String reCaptchaSecret;
    private Boolean validToken;
    private Date timer;
    private int millisToExpire = 60000;
    private boolean validationRequired = true;

    public ReCaptchaWidget(String id, String dataSiteKey, String reCaptchaSecret, IModel<String> model) {
        super(id);
        this.add(new Behavior[]{new ReCaptchaBehavior(model, dataSiteKey)});
        this.dataSiteKey = dataSiteKey;
        this.reCaptchaSecret = reCaptchaSecret;
        this.setOutputMarkupId(true);
    }

    private static boolean fetchResponse(HTTPRequest request) {
        HTTPResponse fetched;
        try {
            URLFetchService urlFetchService = URLFetchServiceFactory.getURLFetchService();
            fetched = urlFetchService.fetch(request);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            return false;
        }
        int responseCode = fetched.getResponseCode();
        boolean success = false;
        if (responseCode == 200) {
            try {
                JSONObject json = new JSONObject(new String(fetched.getContent()));
                success = json.getBoolean("success");
            }
            catch (JSONException e) {
                logger.error("Response code: " + responseCode, (Throwable)e);
            }
        } else {
            logger.error("Response code: " + responseCode);
        }
        return success;
    }

    private String getToken() {
        HttpServletRequest request = ((ServletWebRequest)RequestCycle.get().getRequest()).getContainerRequest();
        return request.getParameter("g-recaptcha-response");
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("data-sitekey", (CharSequence)this.dataSiteKey);
    }

    public final boolean isValid() {
        if (this.validToken != null && this.validToken.booleanValue()) {
            return true;
        }
        String token = this.getToken();
        if (Strings.isEmpty((CharSequence)token)) {
            this.validToken = null;
            return false;
        }
        this.validToken = this.checkToken(token);
        return this.validToken;
    }

    public void startTimer() {
        this.timer = new Date();
    }

    public int getTimeToExpire() {
        return this.millisToExpire;
    }

    public void setTimeToExpire(int millisToExpire) {
        if (millisToExpire < 0) {
            throw new IllegalArgumentException("Only positive values are allowed");
        }
        this.millisToExpire = millisToExpire;
    }

    public final boolean isTimerExpired() {
        if (this.timer == null) {
            return false;
        }
        Date now = new Date();
        now.setTime(now.getTime() - (long)this.millisToExpire);
        return now.after(this.timer);
    }

    public void resetTimer() {
        this.timer = null;
    }

    public final boolean isValidationRequired() {
        return this.validationRequired;
    }

    protected void onBeforeRender() {
        if (this.validToken == null) {
            HttpSession session = WicketUtil.getHttpServletRequest().getSession();
            this.validToken = (Boolean)session.getAttribute(ReCaptchaWidget.class.getName());
        }
        if (this.validToken != null && this.validToken.booleanValue()) {
            this.validationRequired = false;
            this.resetTimer();
        } else {
            this.validationRequired = !this.isTimerExpired();
        }
        super.onBeforeRender();
    }

    protected void onAfterRender() {
        super.onAfterRender();
        if (this.validToken != null && this.validToken.booleanValue()) {
            HttpSession session = WicketUtil.getHttpServletRequest().getSession();
            session.setAttribute(ReCaptchaWidget.class.getName(), (Object)this.validToken);
        }
    }

    private boolean checkToken(String token) {
        HTTPRequest request;
        Preconditions.checkNotNull((Object)this.reCaptchaSecret, (Object)"reCAPTCHA secret key cannot be null.");
        FetchOptions options = FetchOptions.Builder.withDefaults();
        options.disallowTruncate();
        options.validateCertificate();
        options.followRedirects();
        Url url = Url.parse((CharSequence)"https://www.google.com/recaptcha/api/siteverify");
        url.addQueryParameter("secret", (Object)this.reCaptchaSecret);
        url.addQueryParameter("response", (Object)token);
        String fullUrl = "https://www.google.com" + url;
        try {
            request = new HTTPRequest(new URL(fullUrl), HTTPMethod.GET, options);
        }
        catch (IOException e) {
            logger.error("URL: " + url, (Throwable)e);
            return false;
        }
        return ReCaptchaWidget.fetchResponse(request);
    }
}

