/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.resource.bundles;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.bundles.ConcatResourceBundleReference;
import org.apache.wicket.util.string.Strings;

public class CssBundleInit
extends ConcatResourceBundleReference<CssReferenceHeaderItem> {
    public static final String NAME = "theme-bundle.css";
    private static final long serialVersionUID = 1L;
    private final String name;
    private Class<?> scope;

    public CssBundleInit(@Nonnull List<String> cssFiles) {
        this(CssBundleInit.class, NAME, cssFiles);
    }

    public CssBundleInit(@Nonnull Class<?> scope, @Nonnull List<String> cssFiles) {
        this(scope, NAME, cssFiles);
    }

    public CssBundleInit(@Nonnull Class<?> scope, @Nonnull String name, @Nonnull List<String> cssFiles) {
        super(scope, (String)Preconditions.checkNotNull((Object)name), CssBundleInit.getHeaderItems(scope, cssFiles));
        this.scope = (Class)Preconditions.checkNotNull(scope);
        this.name = name;
    }

    private static List<CssReferenceHeaderItem> getHeaderItems(@Nonnull Class<?> scope, @Nonnull List<String> cssFiles) {
        ArrayList<CssReferenceHeaderItem> resources = new ArrayList<CssReferenceHeaderItem>();
        for (String file : cssFiles) {
            if (Strings.isEmpty((CharSequence)file)) continue;
            CssResourceReference reference = new CssResourceReference(scope, file);
            resources.add(CssHeaderItem.forReference((ResourceReference)reference));
        }
        return resources;
    }

    public boolean register(@Nonnull WebApplication application) {
        List resources = this.getProvidedResources();
        if (!resources.isEmpty()) {
            ConcatResourceBundleReference concatenated = new ConcatResourceBundleReference(this.scope, this.name, resources);
            application.mountResource("/" + this.name, (ResourceReference)concatenated);
            application.getResourceBundles().addBundle((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)concatenated));
        }
        return application.getResourceReferenceRegistry().registerResourceReference((ResourceReference)this);
    }
}

