/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.resource.bundles;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.bundles.ConcatResourceBundleReference;
import org.apache.wicket.util.string.Strings;

public class JavaScriptBundleInit
extends ConcatResourceBundleReference<JavaScriptReferenceHeaderItem> {
    public static final String NAME = "javascript-bundle.js";
    private static final long serialVersionUID = 1L;
    private final String name;
    private Class<?> scope;

    public JavaScriptBundleInit(@Nonnull List<String> jsFiles) {
        this(JavaScriptBundleInit.class, NAME, jsFiles);
    }

    public JavaScriptBundleInit(@Nonnull Class<?> scope, @Nonnull List<String> jsFiles) {
        this(scope, NAME, jsFiles);
    }

    public JavaScriptBundleInit(@Nonnull Class<?> scope, @Nonnull String name, @Nonnull List<String> jsFiles) {
        super(JavaScriptBundleInit.class, (String)Preconditions.checkNotNull((Object)name), JavaScriptBundleInit.getHeaderItems(scope, jsFiles));
        this.scope = (Class)Preconditions.checkNotNull(scope);
        this.name = name;
    }

    private static List<JavaScriptReferenceHeaderItem> getHeaderItems(@Nonnull Class<?> scope, @Nonnull List<String> jsFiles) {
        ArrayList<JavaScriptReferenceHeaderItem> resources = new ArrayList<JavaScriptReferenceHeaderItem>();
        for (String file : jsFiles) {
            if (Strings.isEmpty((CharSequence)file)) continue;
            JavaScriptResourceReference reference = new JavaScriptResourceReference(scope, file);
            resources.add(JavaScriptHeaderItem.forReference((ResourceReference)reference));
        }
        return resources;
    }

    public boolean register(@Nonnull WebApplication application) {
        List resources = this.getProvidedResources();
        if (!resources.isEmpty()) {
            ConcatResourceBundleReference concatenated = new ConcatResourceBundleReference(this.scope, this.name, resources);
            application.mountResource("/" + this.name, (ResourceReference)concatenated);
            application.getResourceBundles().addBundle((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)concatenated));
        }
        return application.getResourceReferenceRegistry().registerResourceReference((ResourceReference)this);
    }
}

