/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.upload;

import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.blobstore.BlobstoreService;
import com.google.appengine.api.blobstore.UploadOptions;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.UrlResourceReference;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.ctoolkit.wicket.standard.upload.BlobUploadResourceReference;

public class BlobUploadBehavior
extends Behavior {
    public static final String PARAMETER_FILE_FIELD = "__file_field";
    public static final String UPLOAD_NAME = "upload-name";
    private static final long serialVersionUID = 1L;
    private final String thumbnailMarkupId;
    private final String uploadName;
    @Inject
    private AppIdentityService appIdentityService;
    @Inject
    private BlobstoreService blobstoreService;

    public BlobUploadBehavior(String thumbnailMarkupId, String uploadName) {
        this.thumbnailMarkupId = thumbnailMarkupId;
        this.uploadName = uploadName;
        Injector.get().inject((Object)this);
    }

    public void bind(Component component) {
        super.bind(component);
        component.setOutputMarkupId(true);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        String script = this.getScript(component);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)script));
        Url jsCdn = Url.parse((CharSequence)"https://hayageek.github.io/jQuery-Upload-File/4.0.1/jquery.uploadfile.min.js");
        UrlResourceReference jsCdnReference = new UrlResourceReference(jsCdn);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)jsCdnReference));
    }

    private String getScript(Component component) {
        String componentUrl = component.urlFor((ResourceReference)BlobUploadResourceReference.get(), null).toString();
        String bucketName = this.appIdentityService.getDefaultGcsBucketName();
        UploadOptions uploadOptions = UploadOptions.Builder.withGoogleStorageBucketName((String)bucketName);
        String url = this.blobstoreService.createUploadUrl(componentUrl, uploadOptions);
        PackageTextTemplate template = new PackageTextTemplate(BlobUploadBehavior.class, "upload-file-init.js");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("markupId", component.getMarkupId());
        variables.put("thumbnailMarkupId", this.thumbnailMarkupId);
        variables.put("actionUrl", url);
        variables.put("fileField", PARAMETER_FILE_FIELD);
        variables.put("uploadStr", component.getString("button.upload"));
        variables.put("cancelStr", component.getString("button.cancel"));
        variables.put("buttonClass", "button");
        variables.put(UPLOAD_NAME, this.uploadName);
        return template.asString(variables);
    }
}

