/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.upload;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreService;
import com.google.appengine.api.blobstore.FileInfo;
import com.google.appengine.api.images.ImagesService;
import com.google.appengine.api.images.ServingUrlOptions;
import com.google.common.eventbus.EventBus;
import com.google.common.html.HtmlEscapers;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.ajax.json.JSONArray;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.http.flow.AbortWithHttpErrorCodeException;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.upload.FileUploadException;
import org.ctoolkit.wicket.standard.upload.BlobUploadSuccessEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobUploadResource
extends AbstractResource {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(BlobUploadResource.class);
    @Inject
    private BlobstoreService blobstoreService;
    @Inject
    private ImagesService imageService;
    @Inject
    private EventBus eventBus;

    public BlobUploadResource() {
        Injector.get().inject((Object)this);
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        ServletWebRequest webRequest = (ServletWebRequest)attributes.getRequest();
        try {
            this.prepareResponse(response, webRequest);
        }
        catch (IOException | FileUploadException e) {
            logger.error("An error occurred while uploading a blob", e);
            throw new AbortWithHttpErrorCodeException(500, e.getMessage());
        }
        return response;
    }

    private void prepareResponse(AbstractResource.ResourceResponse response, ServletWebRequest webRequest) throws FileUploadException, IOException {
        String responseContent;
        String accept = webRequest.getHeader("Accept");
        if (!Strings.isEmpty((CharSequence)accept) && accept.contains("text/html")) {
            response.setContentType("text/html");
            responseContent = this.generateHtmlResponse(webRequest);
        } else {
            response.setContentType("application/json");
            responseContent = this.generateJsonResponse(webRequest);
        }
        response.setWriteCallback(new AbstractResource.WriteCallback(){

            public void writeData(IResource.Attributes attributes) throws IOException {
                attributes.getResponse().write((CharSequence)responseContent);
            }
        });
    }

    private String generateHtmlResponse(ServletWebRequest webRequest) {
        String json = this.generateJsonResponse(webRequest);
        return HtmlEscapers.htmlEscaper().escape(json);
    }

    private String generateJsonResponse(ServletWebRequest webRequest) {
        JSONArray json = new JSONArray();
        JSONObject jsonEntry = new JSONObject();
        try {
            HttpServletRequest request = webRequest.getContainerRequest();
            Map fileInfos = this.blobstoreService.getFileInfos(request);
            List list = (List)fileInfos.get("__file_field");
            FileInfo info = (FileInfo)list.get(0);
            Map blobs = this.blobstoreService.getUploads(request);
            BlobKey blobKey = (BlobKey)((List)blobs.get("__file_field")).get(0);
            String uploadName = request.getParameter("upload-name");
            String gStorageName = info.getGsObjectName();
            logger.info("Upload name: " + uploadName);
            logger.info("BlobKey: " + blobKey);
            logger.info("StorageName: " + gStorageName);
            ServingUrlOptions options = ServingUrlOptions.Builder.withBlobKey((BlobKey)blobKey).crop(false).secureUrl(true);
            String servingUrl = this.imageService.getServingUrl(options);
            logger.info("Thumbnail URL: " + servingUrl);
            this.eventBus.post((Object)new BlobUploadSuccessEvent(blobKey, info, servingUrl, uploadName));
            jsonEntry.put("thumbnail_url", (Object)servingUrl);
            json.put((Object)jsonEntry);
        }
        catch (Exception e) {
            try {
                jsonEntry.put("error", (Object)e.getMessage());
            }
            catch (JSONException e1) {
                logger.error("An error occurred while generating a response", (Throwable)e1);
            }
            logger.error("An error occurred while generating a response", (Throwable)e);
        }
        return json.toString();
    }
}

