/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.turnonline;

import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Application;
import org.apache.wicket.IApplicationListener;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebResponse;
import org.apache.wicket.protocol.https.HttpsConfig;
import org.apache.wicket.protocol.https.HttpsMapper;
import org.apache.wicket.protocol.https.Scheme;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.ctoolkit.wicket.standard.markup.html.basic.HtmlBottomJavaScriptDecorator;
import org.wicketstuff.gae.GaeApplication;

public abstract class AppEngineApplication
extends AuthenticatedWebApplication
implements GaeApplication {
    public static final String SHOPPING_CART = "/shopping-cart";
    public static final String SIGNUP = "/sign-up";
    public static final String LOGIN = "/login";
    public static final String LOGOUT = "/logout";
    public static final String MY_ACCOUNT = "/my-account";
    public static final String PARAM_PRODUCT_NAME = "_productName";
    private static final String[] botAgents = new String[]{"googlebot", "msnbot", "slurp", "jeeves", "yadex", "baidu", "bing", "appie", "architext", "jeeves", "bjaaland", "ferret", "gulliver", "harvest", "htdig", "linkwalker", "lycos_", "moget", "muscatferret", "myweb", "nomad", "scooter", "yahoo!\\sslurp\\schina", "slurp", "weblayers", "antibot", "bruinbot", "digout4u", "echo!", "ia_archiver", "jennybot", "mercator", "netcraft", "msnbot", "petersnews", "unlost_web_crawler", "voila", "webbase", "webcollage", "cfetch", "zyborg", "wisenutbot", "robot", "crawl", "spider", "ahrefsbot", "aihitbot", "seznam"};

    protected void init() {
        this.getApplicationListeners().add((Object)new IApplicationListener(){

            public void onAfterInitialized(Application application) {
                AppEngineApplication.this.setRootRequestMapper((IRequestMapper)AppEngineApplication.this.getHttpsMapper());
            }

            public void onBeforeDestroyed(Application application) {
            }
        });
        super.init();
        this.setHeaderResponseDecorator(new HtmlBottomJavaScriptDecorator("html-bottom-container"));
        this.getMarkupSettings().setDefaultMarkupEncoding("UTF-8");
        this.getMarkupSettings().setStripWicketTags(true);
        this.getRequestCycleSettings().setRenderStrategy(IRequestCycleSettings.RenderStrategy.ONE_PASS_RENDER);
        this.getPageSettings().setVersionPagesByDefault(false);
        this.mountPage("/sitemap.xml", this.getSiteMapPage());
        this.mountPage("/robots.txt", this.getRobotsPage());
    }

    protected HttpsMapper getHttpsMapper() {
        return new HttpsMapper(this.getRootRequestMapper(), new HttpsConfig(80, 443)){

            protected Scheme getDesiredSchemeFor(Class<? extends IRequestablePage> pageClass) {
                if (AppEngineApplication.this.getConfigurationType() == RuntimeConfigurationType.DEVELOPMENT) {
                    return Scheme.HTTP;
                }
                return super.getDesiredSchemeFor(pageClass);
            }
        };
    }

    protected abstract Class<? extends WebPage> getSiteMapPage();

    protected abstract Class<? extends WebPage> getRobotsPage();

    protected WebResponse newWebResponse(final WebRequest webRequest, HttpServletResponse httpServletResponse) {
        return new ServletWebResponse((ServletWebRequest)webRequest, httpServletResponse){

            public String encodeURL(CharSequence url) {
                return AppEngineApplication.this.isAgent(webRequest.getHeader("User-Agent")) ? url.toString() : super.encodeURL(url);
            }

            public String encodeRedirectURL(CharSequence url) {
                return AppEngineApplication.this.isAgent(webRequest.getHeader("User-Agent")) ? url.toString() : super.encodeRedirectURL(url);
            }
        };
    }

    private boolean isAgent(String agent) {
        if (agent != null) {
            for (String bot : botAgents) {
                if (!agent.toLowerCase().contains(bot.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }
}

