/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.turnonline.markup.html.page;

import com.google.common.base.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.request.http.WebResponse;
import org.ctoolkit.wicket.standard.markup.html.basic.ULabel;
import org.ctoolkit.wicket.turnonline.markup.html.page.SiteMapItem;

public abstract class BaseSiteMap
extends WebPage {
    public BaseSiteMap() {
        RepeatingView rv = new RepeatingView("urlList");
        this.add(new Component[]{rv});
        for (SiteMapItem item : this.getItems()) {
            WebMarkupContainer urlNode = new WebMarkupContainer(rv.newChildId());
            rv.add(new Component[]{urlNode});
            urlNode.add(new Component[]{new ULabel("loc", item.getLoc())});
            urlNode.add(new Component[]{new ULabel("lastmod", this.formatSiteMapDate(item.getLastmod()))});
            urlNode.add(new Component[]{new ULabel("changefreq", item.getChangefreq().name().toLowerCase())});
            urlNode.add(new Component[]{new ULabel("priority", Double.valueOf(item.getPriority()).toString())});
        }
    }

    private String formatSiteMapDate(Date date) {
        Preconditions.checkNotNull((Object)date, (Object)"Date cannot be null!");
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format((Object)date);
    }

    protected void onAfterRender() {
        super.onAfterRender();
        ((WebResponse)this.getResponse()).setContentType("application/xml");
    }

    protected abstract List<SiteMapItem> getItems();
}

