/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.turnonline.markup.html.page;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.filter.HeaderResponseContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.https.RequireHttps;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.ctoolkit.wicket.standard.markup.html.basic.ImageComponent;
import org.ctoolkit.wicket.standard.markup.html.basic.ULabel;
import org.ctoolkit.wicket.standard.model.ExternalLinkModel;
import org.ctoolkit.wicket.standard.model.I18NResourceModel;
import org.ctoolkit.wicket.turnonline.markup.html.page.Skeleton;
import org.ctoolkit.wicket.turnonline.menu.MenuSchema;
import org.ctoolkit.wicket.turnonline.menu.Navigation;
import org.ctoolkit.wicket.turnonline.model.IModelFactory;

@RequireHttps
public abstract class DecoratedPage<T>
extends Skeleton<T> {
    private static final long serialVersionUID = 1L;

    public DecoratedPage() {
    }

    public DecoratedPage(IModel<T> model) {
        super(model);
    }

    public DecoratedPage(PageParameters parameters) {
        super(parameters);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        IModelFactory factory = this.modelFactory();
        final IModel loggedInModel = (IModel)Preconditions.checkNotNull(factory.isLoggedInModel(), (Object)"LoggedInModel cannot be null!");
        Class loginPage = (Class)Preconditions.checkNotNull(factory.getLoginPage(), (Object)"The login page class is mandatory!");
        Class signUpPage = (Class)Preconditions.checkNotNull(factory.getSignUpPage(), (Object)"The sign up page class is mandatory!");
        Class myAccountPage = (Class)Preconditions.checkNotNull(factory.getMyAccountPage(), (Object)"The my account page class is mandatory!");
        Class settingsPage = (Class)Preconditions.checkNotNull(factory.getAccountSettingsPage(), (Object)"The account settings page class is mandatory!");
        final Roles roles = factory.getRoles();
        final String accountRole = factory.getAccountRole();
        IModel loggedInAccountModel = factory.getLoggedInAccountModel();
        Application application = Application.get();
        RuntimeConfigurationType type = application.getConfigurationType();
        Behavior[] behaviors = factory.getBehaviors(type, null);
        if (behaviors != null) {
            for (Behavior next : behaviors) {
                this.add(new Behavior[]{next});
            }
        }
        this.add(new Component[]{new ULabel("title", this.getPageTitle())});
        this.add(new Component[]{new BookmarkablePageLink("logo-link", application.getHomePage())});
        FeedbackPanel feedbackPanel = this.newFeedbackPanel();
        feedbackPanel.setEscapeModelStrings(false);
        feedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{feedbackPanel});
        BookmarkablePageLink login = new BookmarkablePageLink("link-login", loginPage){
            private static final long serialVersionUID = -6308037382669267883L;

            public boolean isVisible() {
                Boolean modelObject = (Boolean)loggedInModel.getObject();
                return (modelObject == null ? Boolean.FALSE : modelObject) == false;
            }
        };
        this.add(new Component[]{login});
        BookmarkablePageLink signUp = new BookmarkablePageLink("link-signUp", signUpPage){
            private static final long serialVersionUID = -6003066496511986670L;

            public boolean isVisible() {
                Boolean modelObject = (Boolean)loggedInModel.getObject();
                return (modelObject == null ? Boolean.FALSE : modelObject) == false;
            }
        };
        this.add(new Component[]{signUp});
        WebMarkupContainer myAccountContainer = new WebMarkupContainer("wrapper-myAccount"){
            private static final long serialVersionUID = 8956879706072490572L;

            public boolean isVisible() {
                Boolean modelObject = (Boolean)loggedInModel.getObject();
                return modelObject == null ? Boolean.FALSE : modelObject;
            }
        };
        myAccountContainer.add(new Component[]{new ULabel("label-myAccount", (IModel<?>)PropertyModel.of((Object)loggedInAccountModel, (String)"email"))});
        this.add(new Component[]{myAccountContainer});
        ImageComponent imageComponent = new ImageComponent("picture", (IModel<?>)PropertyModel.of((Object)loggedInAccountModel, (String)"picture"));
        myAccountContainer.add(new Component[]{imageComponent});
        BookmarkablePageLink myAccount = new BookmarkablePageLink("link-myAccount", myAccountPage);
        myAccountContainer.add(new Component[]{myAccount});
        ExternalLink logout = new ExternalLink("link-logout", (IModel)new ExternalLinkModel("/logout"));
        myAccountContainer.add(new Component[]{logout});
        String script = "firebase.auth().signOut().then(function(){window.location.href='/logout'});";
        logout.add(new Behavior[]{new AttributeAppender("onclick", (Serializable)((Object)script), ";")});
        BookmarkablePageLink settings = new BookmarkablePageLink("link-settings", settingsPage){
            private static final long serialVersionUID = 3764066608838121794L;

            public boolean isVisible() {
                return roles != null && roles.hasRole(accountRole);
            }
        };
        myAccountContainer.add(new Component[]{settings});
        Page page = this.getPage();
        MenuSchema schema = factory.provideMenuSchema(page, roles);
        this.add(new Component[]{new Navigation("navigation", schema.getMenuItems())});
        this.add(new Component[]{new HeaderResponseContainer("html-bottom-container", "html-bottom-container")});
    }

    public IModel<?> getPageTitle() {
        return new I18NResourceModel("title.changeit", new Object[0]);
    }
}

