/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.turnonline.markup.html.page;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Locale;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.MetaDataHeaderItem;
import org.apache.wicket.markup.head.StringHeaderItem;
import org.apache.wicket.markup.html.GenericWebPage;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.flow.AbortWithHttpErrorCodeException;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.UrlResourceReference;
import org.apache.wicket.util.string.Strings;
import org.ctoolkit.wicket.standard.behavior.IdAttributeModifier;
import org.ctoolkit.wicket.turnonline.model.IModelFactory;

public abstract class Skeleton<T>
extends GenericWebPage<T> {
    public static final String FEEDBACK_MARKUP_ID = "feedback";
    public static final String HTML_BOTTOM_FILTER_NAME = "html-bottom-container";
    public static final String PARAM_LANG = "lang";
    static final String DEFAULT_HEADER_DESCRIPTION_EXPRESSION = "headerDescription";
    static final String DEFAULT_HEADER_KEYWORDS_EXPRESSION = "headerKeywords";
    private static final long serialVersionUID = 1L;
    private boolean checkDefaultModelObjectIsNull = false;
    @Inject
    private IModelFactory modelFactory;

    public Skeleton() {
    }

    public Skeleton(IModel<T> model) {
        super(model);
    }

    public Skeleton(PageParameters parameters) {
        super(parameters);
    }

    protected IModelFactory modelFactory() {
        return this.modelFactory;
    }

    private String getLangParam() {
        Request request = RequestCycle.get().getRequest();
        return request.getRequestParameters().getParameterValue(PARAM_LANG).toOptionalString();
    }

    protected void checkDefaultModelObjectIsNull(boolean check) {
        this.checkDefaultModelObjectIsNull = check;
    }

    protected void onInitialize() {
        String keywordsExpression;
        String descriptionExpression;
        if (this.checkDefaultModelObjectIsNull && this.getModelObject() == null) {
            throw new AbortWithHttpErrorCodeException(404, "Default model object is null!");
        }
        super.onInitialize();
        String langParam = this.getLangParam();
        if (langParam != null) {
            this.getSession().setLocale(new Locale(langParam));
        }
        final IModel model = this.getModel();
        final String trackingId = this.getGoogleAnalyticsTrackingId();
        if (!Strings.isEmpty((CharSequence)trackingId)) {
            this.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 1L;

                public void renderHead(Component component, IHeaderResponse response) {
                    response.render((HeaderItem)StringHeaderItem.forString((CharSequence)Skeleton.this.getGoogleAnalyticsScript(trackingId)));
                }
            }});
        }
        if ((descriptionExpression = this.getHeaderDescriptionExpression()) != null && model != null) {
            this.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 1L;

                public void renderHead(Component component, IHeaderResponse response) {
                    PropertyModel content = new PropertyModel((Object)model, descriptionExpression);
                    response.render((HeaderItem)MetaDataHeaderItem.forMetaTag((IModel)new Model((Serializable)((Object)"description")), (IModel)content));
                }
            }});
        }
        if ((keywordsExpression = this.getHeaderKeywordsExpression()) != null && model != null) {
            this.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 1L;

                public void renderHead(Component component, IHeaderResponse response) {
                    PropertyModel content = new PropertyModel((Object)model, keywordsExpression);
                    response.render((HeaderItem)MetaDataHeaderItem.forMetaTag((IModel)new Model((Serializable)((Object)"keywords")), (IModel)content));
                }
            }});
        }
    }

    protected HttpServletRequest getContainerRequest() {
        return ((ServletWebRequest)this.getRequest()).getContainerRequest();
    }

    protected HttpServletResponse getContainerResponse() {
        return (HttpServletResponse)this.getResponse().getContainerResponse();
    }

    protected void addStyle(final String style) {
        this.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component component, IHeaderResponse response) {
                response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new UrlResourceReference(Url.parse((CharSequence)style))));
            }
        }});
    }

    protected void addScript(final String script) {
        this.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component component, IHeaderResponse response) {
                response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new UrlResourceReference(Url.parse((CharSequence)script))));
            }
        }});
    }

    protected String getHeaderDescriptionExpression() {
        return null;
    }

    protected String getHeaderKeywordsExpression() {
        return null;
    }

    public String getVariation() {
        String fullVariation = this.getContainerRequest().getServerName();
        String productName = this.getPageParameters().get("_productName").toOptionalString();
        if (productName != null) {
            fullVariation = fullVariation + "/" + productName;
        }
        return fullVariation;
    }

    protected FeedbackPanel newFeedbackPanel() {
        return this.newFeedbackPanel(FEEDBACK_MARKUP_ID);
    }

    protected FeedbackPanel newFeedbackPanel(String id) {
        return new FeedbackPanel(id){
            private static final long serialVersionUID = 1221594216921232749L;

            protected Component newMessageDisplayComponent(String id, FeedbackMessage message) {
                Component reporter = message.getReporter();
                String markupId = reporter.getMarkupId();
                for (IdAttributeModifier am : reporter.getBehaviors(IdAttributeModifier.class)) {
                    markupId = am.getMarkupId();
                }
                Component component = super.newMessageDisplayComponent(id, message);
                if (reporter instanceof FormComponent && message.getLevel() == 400) {
                    String value = "document.getElementById('" + markupId + "').focus()";
                    component.add(new Behavior[]{AttributeModifier.append((String)"onclick", (Serializable)((Object)value))});
                    component.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"feedbackPanelAnchor"))});
                }
                return component;
            }
        };
    }

    protected String getGoogleAnalyticsTrackingId() {
        return null;
    }

    protected String getGoogleAnalyticsScript(String trackingId) {
        Preconditions.checkNotNull((Object)trackingId);
        return "<script>\n(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){\n(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\nm=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\n})(window,document,'script','//www.google-analytics.com/analytics.js','ga');\n\nga('create', '" + trackingId + "', 'auto');\nga('send', 'pageview');\n\n</script>";
    }
}

