/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.turnonline.menu;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.Url;
import org.ctoolkit.wicket.standard.model.I18NResourceModel;

public class LanguagePanel
extends Panel {
    private static final long serialVersionUID = 764336739357423363L;

    public LanguagePanel(String id, final List<Locale> items) {
        super(id);
        this.setOutputMarkupId(false);
        this.setRenderBodyOnly(true);
        WebMarkupContainer language = new WebMarkupContainer("language");
        this.add(new Component[]{language});
        IModel itemsModel = Model.ofList(items);
        ListView<Locale> listView = new ListView<Locale>("flag-repeater", itemsModel){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return items.size() >= 2;
            }

            protected void populateItem(ListItem<Locale> item) {
                Locale locale = (Locale)item.getModelObject();
                item.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)("flag flag-" + locale.getLanguage())))});
                String url = LanguagePanel.this.createLocalizationUrl(locale);
                I18NResourceModel labelModel = new I18NResourceModel("language." + locale.getLanguage(), new Object[0]);
                ExternalLink flag = new ExternalLink("flag", (IModel)Model.of((Serializable)((Object)url)), (IModel)labelModel);
                item.add(new Component[]{flag});
            }
        };
        language.add(new Component[]{listView});
    }

    private String createLocalizationUrl(Locale item) {
        Url url = this.getRequest().getUrl();
        List params = url.getQueryParameters();
        Iterator iterator = params.iterator();
        while (iterator.hasNext()) {
            Url.QueryParameter next = (Url.QueryParameter)iterator.next();
            if (!"lang".equals(next.getName())) continue;
            iterator.remove();
        }
        Url.QueryParameter langParam = new Url.QueryParameter("lang", item.getLanguage());
        params.add(langParam);
        String done = url.toString();
        return url.isContextAbsolute() ? done : "/" + done;
    }
}

