/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.turnonline.menu;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.ctoolkit.wicket.turnonline.menu.NavItem;
import org.ctoolkit.wicket.turnonline.util.CookiesUtil;

public class Navigation
extends ListView<NavItem> {
    private static final long serialVersionUID = 7770930801430140492L;

    public Navigation(String id) {
        super(id);
    }

    public Navigation(String id, IModel<? extends List<? extends NavItem>> model) {
        super(id, model);
    }

    public Navigation(String id, List<? extends NavItem> list) {
        super(id, list);
    }

    private boolean actualPageClassSelected(Class<? extends Page> actualPage) {
        List items = this.getList();
        for (NavItem item : items) {
            if (item.getPageClass() == null || !item.getPageClass().equals(actualPage)) continue;
            return true;
        }
        return false;
    }

    protected void populateItem(ListItem<NavItem> populated) {
        ExternalLink link;
        IModel model = populated.getModel();
        NavItem item = (NavItem)model.getObject();
        if (item.getUrlModel() != null) {
            link = new ExternalLink("link-nav-item", item.getUrlModel());
        } else if (item.getPageClass() != null) {
            Class currentPage = this.getPage().getPageClass();
            link = new BookmarkablePageLink("link-nav-item", item.getPageClass());
            if (item.getPageClass().equals(currentPage)) {
                link.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"selected"))});
            } else if (!this.actualPageClassSelected(currentPage) && item.getPageClass().equals(CookiesUtil.getPageClassFromCookie())) {
                link.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"selected"))});
            }
        } else {
            String message = "You must specify either link url or page class to be able render navigation item link: ";
            throw new IllegalArgumentException(message + item);
        }
        Label linkLabel = new Label("link-nav-item-label", item.getLabelModel());
        linkLabel.setEscapeModelStrings(false);
        linkLabel.setRenderBodyOnly(true);
        link.add(new Component[]{linkLabel});
        if (item.getCssClass() != null) {
            link.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)item.getCssClass()))});
        }
        populated.add(new Component[]{link});
    }
}

