/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.turnonline.menu;

import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AbstractAutoCompleteRenderer;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.ctoolkit.wicket.turnonline.menu.SearchResponse;
import org.ctoolkit.wicket.turnonline.util.FormatUtil;

public abstract class SearchBox
extends AutoCompleteTextField<SearchResponse> {
    private static final long serialVersionUID = 1723221946022273137L;
    private static final AutoCompleteSettings SETTINGS = new AutoCompleteSettings();
    private static final SearchBoxRenderer RENDERER = new SearchBoxRenderer();

    public SearchBox(String id) {
        super(id, null, null, (IAutoCompleteRenderer)RENDERER, SETTINGS);
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.getScript((Component)this)));
    }

    private String getScript(Component component) {
        PackageTextTemplate template = new PackageTextTemplate(SearchBox.class, "search-box.js");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("markupId", component.getMarkupId());
        return template.asString(variables);
    }

    static {
        SETTINGS.setMinInputLength(3);
        SETTINGS.setAdjustInputWidth(false);
        SETTINGS.setShowCompleteListOnFocusGain(true);
    }

    private static class SearchBoxRenderer
    extends AbstractAutoCompleteRenderer<SearchResponse> {
        private static final long serialVersionUID = -1661088661471669616L;

        private SearchBoxRenderer() {
        }

        protected void renderChoice(SearchResponse object, Response response, String criteria) {
            StringBuilder sb = new StringBuilder();
            if (object instanceof SearchResponse.SectionSearchResponse) {
                SearchResponse.SectionSearchResponse section = (SearchResponse.SectionSearchResponse)object;
                sb.append("<div class='search-response-section ").append(section.getIcon().getCssName()).append("'>");
                sb.append(section.getTitle());
                sb.append("</div>");
            } else if (object instanceof SearchResponse.ItemSearchResponse) {
                SearchResponse.ItemSearchResponse item = (SearchResponse.ItemSearchResponse)object;
                sb.append("<a href='").append(item.getUrl()).append("'").append(" class='search-response-item'>");
                sb.append("<div class='search-response-title'>");
                sb.append(FormatUtil.highlight(object.getTitle(), criteria));
                sb.append("</div>");
                sb.append("<div class='search-response-description'>");
                sb.append(FormatUtil.highlight(item.getDescription(), criteria));
                sb.append("</div>");
                sb.append("</a>");
            } else {
                throw new IllegalArgumentException("Unknown object type: " + object.getClass());
            }
            response.write((CharSequence)sb.toString());
        }

        protected String getTextValue(SearchResponse object) {
            return object.getTitle();
        }
    }
}

