/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.turnonline.menu;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ctoolkit.wicket.turnonline.menu.NavItem;

public class SwipeMenu
extends Panel {
    private static final long serialVersionUID = -3928863090779279417L;
    private IModel<List<NavItem>> items;
    private RepeatingView repeater;

    public SwipeMenu(String id, IModel<List<NavItem>> items) {
        super(id);
        this.setOutputMarkupId(true);
        this.setRenderBodyOnly(false);
        this.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"swipe-menu"))});
        this.items = items;
        final ExternalLink closeButton = new ExternalLink("close-btn", (IModel)new Model());
        closeButton.setOutputMarkupId(true);
        closeButton.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 392822691174061858L;

            public void renderHead(Component component, IHeaderResponse response) {
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("$('#" + closeButton.getMarkupId() + "').click(function(){$('#" + SwipeMenu.this.getMarkupId() + "').removeClass('swipe-menu-on')})")));
            }
        }});
        this.add(new Component[]{closeButton});
        this.repeater = new RepeatingView("swipe-menu");
        this.add(new Component[]{this.repeater});
        this.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = -6125102892966321239L;

            public void renderHead(Component component, IHeaderResponse response) {
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("$('#" + SwipeMenu.this.getMarkupId() + " ul li a').click(function(){$('.swipe-menu ul li a.selected').removeClass('selected');$(this).addClass('selected')})")));
            }
        }});
    }

    protected void onBeforeRender() {
        Class actualPage = this.getPage().getPageClass();
        this.repeater.removeAll();
        for (NavItem item : (List)this.items.getObject()) {
            ExternalLink link;
            WebMarkupContainer navItem = new WebMarkupContainer(this.repeater.newChildId());
            this.repeater.add(new Component[]{navItem});
            if (item.getUrlModel() != null) {
                link = new ExternalLink("link-nav-item", item.getUrlModel());
            } else if (item.getPageClass() != null) {
                link = new BookmarkablePageLink("link-nav-item", item.getPageClass());
                if (item.getPageClass().equals(actualPage)) {
                    link.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"selected"))});
                }
            } else {
                link = new ExternalLink("link-nav-item", "");
                link.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"swipe-menu-item-root-element"))});
                link.setEnabled(false);
            }
            link.setBody(item.getLabelModel());
            navItem.add(new Component[]{link});
            if (item.getCssClass() == null) continue;
            link.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)item.getCssClass()))});
        }
        super.onBeforeRender();
    }
}

