/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.turnonline.myaccount.panel;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidator;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillBehavior;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillOff;
import org.ctoolkit.wicket.standard.markup.html.form.ajax.IndicatingAjaxCheckBox;
import org.ctoolkit.wicket.standard.markup.html.formrow.FormRowBehavior;
import org.ctoolkit.wicket.standard.model.I18NResourceModel;
import org.ctoolkit.wicket.turnonline.validator.CompanyIdValidator;
import org.ctoolkit.wicket.turnonline.validator.TaxIdValidator;
import org.ctoolkit.wicket.turnonline.validator.VatIdValidator;

public abstract class CompanyBasicInfo<T>
extends GenericPanel<T> {
    private static final long serialVersionUID = -1540918786954705782L;
    private String businessNamePath;
    private String legalFormPath;
    private String companyIdPath;
    private String taxIdPath;
    private String vatIdPath;
    private String vatPayerPath;

    public CompanyBasicInfo(String id, IModel<T> model) {
        this(id, model, false, false);
    }

    public CompanyBasicInfo(String id, IModel<T> model, boolean readOnly) {
        this(id, model, readOnly, false);
    }

    public CompanyBasicInfo(String id, IModel<T> model, boolean readOnly, boolean required) {
        super(id, (IModel)new CompoundPropertyModel(model));
        TextField businessName = new TextField("businessName");
        businessName.setRequired(required);
        businessName.setLabel((IModel)new I18NResourceModel("label.businessName", new Object[0]));
        businessName.setEnabled(!readOnly);
        this.add(new Component[]{businessName});
        businessName.add(new Behavior[]{new FormRowBehavior()});
        businessName.add(new Behavior[]{new AutofillBehavior(AutofillBehavior.Autofill.ORGANIZATION)});
        DropDownChoice legalForm = this.provideLegalForm("legalForm");
        legalForm.setRequired(required);
        legalForm.setLabel((IModel)new I18NResourceModel("label.legalForm", new Object[0]));
        legalForm.setEnabled(!readOnly);
        legalForm.setNullValid(false);
        this.add(new Component[]{legalForm});
        legalForm.add(new Behavior[]{new FormRowBehavior()});
        TextField companyId = new TextField("companyId");
        companyId.setRequired(required);
        companyId.setLabel((IModel)new I18NResourceModel("label.companyId", new Object[0]));
        companyId.setEnabled(!readOnly);
        this.add(new Component[]{companyId});
        companyId.add(new Behavior[]{new FormRowBehavior()});
        companyId.add((IValidator)CompanyIdValidator.get());
        companyId.add(new Behavior[]{AutofillOff.get()});
        TextField taxId = new TextField("taxId");
        taxId.setRequired(required);
        taxId.setLabel((IModel)new I18NResourceModel("label.taxId", new Object[0]));
        taxId.setEnabled(!readOnly);
        this.add(new Component[]{taxId});
        taxId.add(new Behavior[]{new FormRowBehavior()});
        taxId.add((IValidator)TaxIdValidator.get());
        taxId.add(new Behavior[]{AutofillOff.get()});
        WebMarkupContainer wrapperVatId = new WebMarkupContainer("wrapper.vatId");
        TextField vatId = new TextField("vatId");
        vatId.setLabel((IModel)new I18NResourceModel("label.vatId", new Object[0]));
        vatId.setEnabled(!readOnly);
        wrapperVatId.setOutputMarkupId(true);
        wrapperVatId.add(new Component[]{vatId});
        this.add(new Component[]{wrapperVatId});
        vatId.add(new Behavior[]{new FormRowBehavior()});
        vatId.add((IValidator)VatIdValidator.get());
        vatId.add(new Behavior[]{AutofillOff.get()});
        IndicatingAjaxCheckBox vatPayer = new IndicatingAjaxCheckBox("vatPayer");
        vatPayer.add(new Behavior[]{new FormRowBehavior()});
        vatPayer.setLabel((IModel)new I18NResourceModel("label.vatPayer", new Object[0]));
        vatPayer.setVisible(!readOnly);
        this.add(new Component[]{vatPayer});
        this.businessNamePath = businessName.getPageRelativePath();
        this.legalFormPath = legalForm.getPageRelativePath();
        this.companyIdPath = companyId.getPageRelativePath();
        this.taxIdPath = taxId.getPageRelativePath();
        this.vatIdPath = vatId.getPageRelativePath();
        this.vatPayerPath = vatPayer.getPageRelativePath();
    }

    protected abstract DropDownChoice provideLegalForm(String var1);

    public TextField addBusinessName(Behavior ... behaviors) {
        return (TextField)this.getBusinessName().add(behaviors);
    }

    public DropDownChoice addLegalForm(Behavior ... behaviors) {
        return (DropDownChoice)this.getLegalForm().add(behaviors);
    }

    public TextField addCompanyId(Behavior ... behaviors) {
        return (TextField)this.getCompanyId().add(behaviors);
    }

    public TextField addTaxId(Behavior ... behaviors) {
        return (TextField)this.getTaxId().add(behaviors);
    }

    public TextField addVatId(Behavior ... behaviors) {
        return (TextField)this.getVatId().add(behaviors);
    }

    public CheckBox addVatPayer(Behavior ... behaviors) {
        return (CheckBox)this.getVatPayer().add(behaviors);
    }

    public TextField getBusinessName() {
        String componentPath = this.getPageRelativePath() + ":" + this.businessNamePath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public DropDownChoice getLegalForm() {
        String componentPath = this.getPageRelativePath() + ":" + this.legalFormPath;
        Component component = this.getPage().get(componentPath);
        return (DropDownChoice)component;
    }

    public TextField getCompanyId() {
        String componentPath = this.getPageRelativePath() + ":" + this.companyIdPath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getTaxId() {
        String componentPath = this.getPageRelativePath() + ":" + this.taxIdPath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getVatId() {
        String componentPath = this.getPageRelativePath() + ":" + this.vatIdPath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public CheckBox getVatPayer() {
        String componentPath = this.getPageRelativePath() + ":" + this.vatPayerPath;
        Component component = this.getPage().get(componentPath);
        return (CheckBox)component;
    }
}

