/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.turnonline.myaccount.panel;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidator;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillAddress;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillCity;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillCountry;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillPostalCode;
import org.ctoolkit.wicket.standard.markup.html.formrow.FormRowBehavior;
import org.ctoolkit.wicket.standard.model.I18NResourceModel;
import org.ctoolkit.wicket.turnonline.validator.ZipValidator;

public abstract class PersonalAddressPanel<T>
extends GenericPanel<T> {
    private static final long serialVersionUID = 3308357904788269745L;
    private String streetPath;
    private String cityPath;
    private String postcodePath;
    private String countryPath;

    public PersonalAddressPanel(String id, IModel<T> model) {
        this(id, model, false, false);
    }

    public PersonalAddressPanel(String id, IModel<T> model, boolean readOnly) {
        this(id, model, readOnly, false);
    }

    public PersonalAddressPanel(String id, IModel<T> model, boolean readOnly, boolean required) {
        super(id, (IModel)new CompoundPropertyModel(model));
        TextField street = new TextField("street");
        street.setRequired(required);
        street.setLabel((IModel)new I18NResourceModel("label.street", new Object[0]));
        street.setEnabled(!readOnly);
        this.add(new Component[]{street});
        street.add(new Behavior[]{new FormRowBehavior()});
        street.add(new Behavior[]{AutofillAddress.get()});
        TextField city = new TextField("city");
        city.setRequired(required);
        city.setLabel((IModel)new I18NResourceModel("label.city", new Object[0]));
        city.setEnabled(!readOnly);
        this.add(new Component[]{city});
        city.add(new Behavior[]{new FormRowBehavior()});
        city.add(new Behavior[]{AutofillCity.get()});
        TextField postcode = new TextField("postcode");
        postcode.setRequired(required);
        postcode.setLabel((IModel)new I18NResourceModel("label.postcode", new Object[0]));
        postcode.setEnabled(!readOnly);
        this.add(new Component[]{postcode});
        postcode.add(new Behavior[]{new FormRowBehavior()});
        postcode.add((IValidator)ZipValidator.get());
        postcode.add(new Behavior[]{AutofillPostalCode.get()});
        DropDownChoice country = this.provideCountry("country");
        country.setRequired(required);
        country.setLabel((IModel)new I18NResourceModel("label.country", new Object[0]));
        country.setEnabled(!readOnly);
        country.setNullValid(false);
        this.add(new Component[]{country});
        country.add(new Behavior[]{new FormRowBehavior()});
        country.add(new Behavior[]{AutofillCountry.get()});
        this.streetPath = street.getPageRelativePath();
        this.cityPath = city.getPageRelativePath();
        this.postcodePath = postcode.getPageRelativePath();
        this.countryPath = country.getPageRelativePath();
    }

    protected abstract DropDownChoice provideCountry(String var1);

    public TextField addStreet(Behavior ... behaviors) {
        return (TextField)this.getStreet().add(behaviors);
    }

    public TextField addCity(Behavior ... behaviors) {
        return (TextField)this.getCity().add(behaviors);
    }

    public TextField addPostcode(Behavior ... behaviors) {
        return (TextField)this.getPostcode().add(behaviors);
    }

    public DropDownChoice addCountry(Behavior ... behaviors) {
        return (DropDownChoice)this.getCountry().add(behaviors);
    }

    public TextField getStreet() {
        String componentPath = this.getPageRelativePath() + ":" + this.streetPath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getCity() {
        String componentPath = this.getPageRelativePath() + ":" + this.cityPath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getPostcode() {
        String componentPath = this.getPageRelativePath() + ":" + this.postcodePath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public DropDownChoice getCountry() {
        String componentPath = this.getPageRelativePath() + ":" + this.countryPath;
        Component component = this.getPage().get(componentPath);
        return (DropDownChoice)component;
    }
}

