/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.turnonline.myaccount.panel;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.ctoolkit.wicket.standard.behavior.VisibleIfModelFalse;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillAddress;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillCity;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillCountry;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillGivenName;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillOff;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillOrganization;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillPostalCode;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillSurname;
import org.ctoolkit.wicket.standard.markup.html.form.ajax.IndicatingAjaxCheckBox;
import org.ctoolkit.wicket.standard.markup.html.formrow.FormRowBehavior;
import org.ctoolkit.wicket.standard.model.I18NResourceModel;
import org.ctoolkit.wicket.turnonline.myaccount.event.ToggleCompanyPersonChangeEvent;
import org.ctoolkit.wicket.turnonline.validator.ZipValidator;

public abstract class PostalAddressPanel<T>
extends GenericPanel<T> {
    private static final long serialVersionUID = 2507614442540217563L;
    private String businessNamePath;
    private String firstNamePath;
    private String lastNamePath;
    private String streetPath;
    private String cityPath;
    private String postcodePath;
    private String countryPath;

    public PostalAddressPanel(String id, IModel<T> model, IModel<Boolean> hidden) {
        this(id, model, hidden, false);
    }

    public PostalAddressPanel(String id, IModel<T> model, final IModel<Boolean> hidden, boolean readOnly) {
        super(id, (IModel)new CompoundPropertyModel(model));
        this.setOutputMarkupId(true);
        PropertyModel company = new PropertyModel(model, "company");
        IndicatingAjaxCheckBox hasPostalAddress = new IndicatingAjaxCheckBox("hasPostalAddress", hidden);
        hasPostalAddress.setLabel((IModel)new TitleModel((IModel<Boolean>)company));
        hasPostalAddress.setVisible(!readOnly);
        hasPostalAddress.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{PostalAddressPanel.this});
            }
        }});
        this.add(new Component[]{hasPostalAddress});
        hasPostalAddress.add(new Behavior[]{new FormRowBehavior(true)});
        hasPostalAddress.add(new Behavior[]{AutofillOff.get()});
        TextField<String> businessName = new TextField<String>("businessName", (IModel)company){
            private static final long serialVersionUID = 7086952516840223357L;
            final /* synthetic */ IModel val$company;
            {
                this.val$company = iModel2;
                super(x0);
            }

            protected void onConfigure() {
                super.onConfigure();
                Boolean visibleObject = (Boolean)hidden.getObject();
                boolean isVisible = visibleObject == null ? false : visibleObject;
                Boolean companyObject = (Boolean)this.val$company.getObject();
                boolean isCompany = companyObject == null ? false : companyObject;
                this.setVisible(!isVisible && isCompany);
            }
        };
        businessName.setLabel((IModel)new I18NResourceModel("label.businessName", new Object[0]));
        businessName.setEnabled(!readOnly);
        businessName.setRequired(!readOnly);
        this.add(new Component[]{businessName});
        businessName.add(new Behavior[]{new FormRowBehavior()});
        businessName.add(new Behavior[]{AutofillOrganization.get()});
        TextField<String> firstName = new TextField<String>("firstName", (IModel)company){
            private static final long serialVersionUID = 6959658578636824879L;
            final /* synthetic */ IModel val$company;
            {
                this.val$company = iModel2;
                super(x0);
            }

            protected void onConfigure() {
                super.onConfigure();
                Boolean visibleObject = (Boolean)hidden.getObject();
                boolean isVisible = visibleObject == null ? false : visibleObject;
                Boolean companyObject = (Boolean)this.val$company.getObject();
                boolean isCompany = companyObject == null ? false : companyObject;
                this.setVisible(!isVisible && !isCompany);
            }
        };
        firstName.setLabel((IModel)new I18NResourceModel("label.firstName", new Object[0]));
        firstName.setEnabled(!readOnly);
        firstName.setRequired(!readOnly);
        this.add(new Component[]{firstName});
        firstName.add(new Behavior[]{new FormRowBehavior()});
        firstName.add(new Behavior[]{AutofillGivenName.get()});
        TextField<String> lastName = new TextField<String>("lastName", (IModel)company){
            private static final long serialVersionUID = 4172820888920886458L;
            final /* synthetic */ IModel val$company;
            {
                this.val$company = iModel2;
                super(x0);
            }

            protected void onConfigure() {
                super.onConfigure();
                Boolean visibleObject = (Boolean)hidden.getObject();
                boolean isVisible = visibleObject == null ? false : visibleObject;
                Boolean companyObject = (Boolean)this.val$company.getObject();
                boolean isCompany = companyObject == null ? false : companyObject;
                this.setVisible(!isVisible && !isCompany);
            }
        };
        lastName.setLabel((IModel)new I18NResourceModel("label.lastName", new Object[0]));
        lastName.setEnabled(!readOnly);
        lastName.setRequired(!readOnly);
        this.add(new Component[]{lastName});
        lastName.add(new Behavior[]{new FormRowBehavior()});
        lastName.add(new Behavior[]{AutofillSurname.get()});
        TextField street = new TextField("street");
        street.setLabel((IModel)new I18NResourceModel("label.street", new Object[0]));
        street.setEnabled(!readOnly);
        street.setRequired(!readOnly);
        this.add(new Component[]{street});
        street.add(new Behavior[]{new FormRowBehavior()});
        street.add(new Behavior[]{AutofillAddress.get()});
        street.add(new Behavior[]{new VisibleIfModelFalse(hidden)});
        TextField city = new TextField("city");
        city.setLabel((IModel)new I18NResourceModel("label.city", new Object[0]));
        city.setEnabled(!readOnly);
        city.setRequired(!readOnly);
        this.add(new Component[]{city});
        city.add(new Behavior[]{new FormRowBehavior()});
        city.add(new Behavior[]{AutofillCity.get()});
        city.add(new Behavior[]{new VisibleIfModelFalse(hidden)});
        TextField postcode = new TextField("postcode");
        postcode.setLabel((IModel)new I18NResourceModel("label.postcode", new Object[0]));
        postcode.setEnabled(!readOnly);
        postcode.setRequired(!readOnly);
        this.add(new Component[]{postcode});
        postcode.add(new Behavior[]{new FormRowBehavior()});
        postcode.add((IValidator)ZipValidator.get());
        postcode.add(new Behavior[]{AutofillPostalCode.get()});
        postcode.add(new Behavior[]{new VisibleIfModelFalse(hidden)});
        DropDownChoice country = this.provideCountry("country");
        country.setLabel((IModel)new I18NResourceModel("label.country", new Object[0]));
        country.setEnabled(!readOnly);
        country.setRequired(!readOnly);
        this.add(new Component[]{country});
        country.add(new Behavior[]{new FormRowBehavior()});
        country.add(new Behavior[]{AutofillCountry.get()});
        country.add(new Behavior[]{new VisibleIfModelFalse(hidden)});
        this.businessNamePath = businessName.getPageRelativePath();
        this.firstNamePath = firstName.getPageRelativePath();
        this.lastNamePath = lastName.getPageRelativePath();
        this.streetPath = street.getPageRelativePath();
        this.cityPath = city.getPageRelativePath();
        this.postcodePath = postcode.getPageRelativePath();
        this.countryPath = country.getPageRelativePath();
    }

    protected abstract DropDownChoice provideCountry(String var1);

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof ToggleCompanyPersonChangeEvent) {
            ToggleCompanyPersonChangeEvent payload = (ToggleCompanyPersonChangeEvent)event.getPayload();
            payload.getTarget().add(new Component[]{this});
        }
    }

    public TextField addBusinessName(Behavior ... behaviors) {
        return (TextField)this.getBusinessName().add(behaviors);
    }

    public TextField addFirstName(Behavior ... behaviors) {
        return (TextField)this.getFirstName().add(behaviors);
    }

    public TextField addLastName(Behavior ... behaviors) {
        return (TextField)this.getLastName().add(behaviors);
    }

    public TextField addStreet(Behavior ... behaviors) {
        return (TextField)this.getStreet().add(behaviors);
    }

    public TextField addCity(Behavior ... behaviors) {
        return (TextField)this.getCity().add(behaviors);
    }

    public TextField addPostcode(Behavior ... behaviors) {
        return (TextField)this.getPostcode().add(behaviors);
    }

    public DropDownChoice addCountry(Behavior ... behaviors) {
        return (DropDownChoice)this.getCountry().add(behaviors);
    }

    public TextField getBusinessName() {
        String componentPath = this.getPageRelativePath() + ":" + this.businessNamePath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getFirstName() {
        String componentPath = this.getPageRelativePath() + ":" + this.firstNamePath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getLastName() {
        String componentPath = this.getPageRelativePath() + ":" + this.lastNamePath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getStreet() {
        String componentPath = this.getPageRelativePath() + ":" + this.streetPath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getCity() {
        String componentPath = this.getPageRelativePath() + ":" + this.cityPath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getPostcode() {
        String componentPath = this.getPageRelativePath() + ":" + this.postcodePath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public DropDownChoice getCountry() {
        String componentPath = this.getPageRelativePath() + ":" + this.countryPath;
        Component component = this.getPage().get(componentPath);
        return (DropDownChoice)component;
    }

    private static class TitleModel
    extends AbstractReadOnlyModel<String> {
        private static final long serialVersionUID = 4067237872815260428L;
        private final I18NResourceModel falseLabelModel;
        private final I18NResourceModel trueLabelModel;
        private final IModel<Boolean> model;

        TitleModel(IModel<Boolean> model) {
            this.model = model;
            this.falseLabelModel = new I18NResourceModel("label.sameAddress", new Object[0]);
            this.trueLabelModel = new I18NResourceModel("label.sameCompanyAddress", new Object[0]);
        }

        public String getObject() {
            Boolean modelObject = (Boolean)this.model.getObject();
            boolean is = modelObject == null ? false : modelObject;
            return is ? this.trueLabelModel.getString() : this.falseLabelModel.getString();
        }

        public void detach() {
            this.model.detach();
            this.falseLabelModel.detach();
            this.trueLabelModel.detach();
            super.detach();
        }
    }
}

