/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.turnonline.myaccount.panel;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.EmailAddressValidator;
import org.ctoolkit.wicket.standard.markup.autofill.AutofillOff;
import org.ctoolkit.wicket.standard.markup.html.form.ajax.IndicatingAjaxCheckBox;
import org.ctoolkit.wicket.standard.markup.html.formrow.FormRowBehavior;
import org.ctoolkit.wicket.standard.model.I18NResourceModel;

public class SimplifiedContactFieldSet<T>
extends GenericPanel<T> {
    private static final long serialVersionUID = 1L;
    private String visibilityPath;
    private String prefixPath;
    private String firstNamePath;
    private String lastNamePath;
    private String suffixPath;
    private String phonePath;
    private String emailPath;
    private boolean expanded;

    public SimplifiedContactFieldSet(String id, IModel<T> model) {
        super(id, (IModel)new CompoundPropertyModel(model));
        this.setOutputMarkupId(true);
        PropertyModel expandedModel = PropertyModel.of((Object)((Object)this), (String)"expanded");
        IndicatingAjaxCheckBox visibility = new IndicatingAjaxCheckBox("expanded", (IModel)expandedModel){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return SimplifiedContactFieldSet.this.isEnabled();
            }
        };
        visibility.setLabel((IModel)new I18NResourceModel("label.show", new Object[0]));
        visibility.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{SimplifiedContactFieldSet.this});
            }
        }});
        this.add(new Component[]{visibility});
        visibility.add(new Behavior[]{new FormRowBehavior(true)});
        visibility.add(new Behavior[]{AutofillOff.get()});
        TextField<String> contactPrefix = new TextField<String>("prefix"){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return SimplifiedContactFieldSet.this.isExpanded();
            }
        };
        contactPrefix.setLabel((IModel)new I18NResourceModel("label.prefix", new Object[0]));
        this.add(new Component[]{contactPrefix});
        contactPrefix.add(new Behavior[]{new FormRowBehavior()});
        contactPrefix.add(new Behavior[]{AutofillOff.get()});
        TextField<String> firstName = new TextField<String>("firstName"){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return SimplifiedContactFieldSet.this.isExpanded();
            }
        };
        firstName.setLabel((IModel)new I18NResourceModel("label.firstName", new Object[0]));
        this.add(new Component[]{firstName});
        firstName.add(new Behavior[]{new FormRowBehavior()});
        firstName.add(new Behavior[]{AutofillOff.get()});
        TextField<String> lastName = new TextField<String>("lastName"){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return SimplifiedContactFieldSet.this.isExpanded();
            }
        };
        lastName.setLabel((IModel)new I18NResourceModel("label.lastName", new Object[0]));
        this.add(new Component[]{lastName});
        lastName.add(new Behavior[]{new FormRowBehavior()});
        lastName.add(new Behavior[]{AutofillOff.get()});
        TextField<String> contactSuffix = new TextField<String>("suffix"){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return SimplifiedContactFieldSet.this.isExpanded();
            }
        };
        contactSuffix.setLabel((IModel)new I18NResourceModel("label.suffix", new Object[0]));
        this.add(new Component[]{contactSuffix});
        contactSuffix.add(new Behavior[]{new FormRowBehavior()});
        contactSuffix.add(new Behavior[]{AutofillOff.get()});
        TextField<String> phoneNumber = new TextField<String>("phone"){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return SimplifiedContactFieldSet.this.isExpanded();
            }
        };
        phoneNumber.setLabel((IModel)new I18NResourceModel("label.phoneNumber", new Object[0]));
        this.add(new Component[]{phoneNumber});
        phoneNumber.add(new Behavior[]{new FormRowBehavior()});
        phoneNumber.add(new Behavior[]{AutofillOff.get()});
        TextField<String> contactEmail = new TextField<String>("email"){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return SimplifiedContactFieldSet.this.isExpanded();
            }
        };
        contactEmail.setLabel((IModel)new I18NResourceModel("label.email", new Object[0]));
        this.add(new Component[]{contactEmail});
        contactEmail.add(new Behavior[]{new FormRowBehavior()});
        contactEmail.add((IValidator)EmailAddressValidator.getInstance());
        contactEmail.add(new Behavior[]{AutofillOff.get()});
        this.visibilityPath = visibility.getPageRelativePath();
        this.prefixPath = contactPrefix.getPageRelativePath();
        this.firstNamePath = firstName.getPageRelativePath();
        this.lastNamePath = lastName.getPageRelativePath();
        this.suffixPath = contactSuffix.getPageRelativePath();
        this.phonePath = phoneNumber.getPageRelativePath();
        this.emailPath = contactEmail.getPageRelativePath();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isEdited() {
        boolean edited = true;
        if (this.getFirstName().getModelObject() == null && this.getLastName().getModelObject() == null && this.getPhoneNumber().getModelObject() == null && this.getContactEmail().getModelObject() == null) {
            edited = false;
        }
        return edited;
    }

    public CheckBox addVisibility(Behavior ... behaviors) {
        return (CheckBox)this.getVisibility().add(behaviors);
    }

    public TextField addPrefix(Behavior ... behaviors) {
        return (TextField)this.getPrefix().add(behaviors);
    }

    public TextField addFirstName(Behavior ... behaviors) {
        return (TextField)this.getFirstName().add(behaviors);
    }

    public TextField addLastName(Behavior ... behaviors) {
        return (TextField)this.getLastName().add(behaviors);
    }

    public TextField addSuffix(Behavior ... behaviors) {
        return (TextField)this.getSuffix().add(behaviors);
    }

    public TextField addPhoneNumber(Behavior ... behaviors) {
        return (TextField)this.getPhoneNumber().add(behaviors);
    }

    public TextField addContactEmail(Behavior ... behaviors) {
        return (TextField)this.getContactEmail().add(behaviors);
    }

    public CheckBox getVisibility() {
        String componentPath = this.getPageRelativePath() + ":" + this.visibilityPath;
        Component component = this.getPage().get(componentPath);
        return (CheckBox)component;
    }

    public TextField getPrefix() {
        String componentPath = this.getPageRelativePath() + ":" + this.prefixPath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getFirstName() {
        String componentPath = this.getPageRelativePath() + ":" + this.firstNamePath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getLastName() {
        String componentPath = this.getPageRelativePath() + ":" + this.lastNamePath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getSuffix() {
        String componentPath = this.getPageRelativePath() + ":" + this.suffixPath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getPhoneNumber() {
        String componentPath = this.getPageRelativePath() + ":" + this.phonePath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }

    public TextField getContactEmail() {
        String componentPath = this.getPageRelativePath() + ":" + this.emailPath;
        Component component = this.getPage().get(componentPath);
        return (TextField)component;
    }
}

