/*
 * Decompiled with CFR 0.152.
 */
package org.cuberact.swing.layout;

import java.awt.Component;
import java.awt.Dimension;

public class Cell<T extends Component> {
    public static final int CENTER = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 4;
    public static final int LEFT = 8;
    public static final int RIGHT = 16;
    private Integer minWidth;
    private Integer minHeight;
    private Integer prefWidth;
    private Integer prefHeight;
    private Integer maxWidth;
    private Integer maxHeight;
    private boolean rowEnd;
    final T widget;
    int spaceTop;
    int spaceLeft;
    int spaceBottom;
    int spaceRight;
    int padTop;
    int padLeft;
    int padBottom;
    int padRight;
    boolean fillX;
    boolean fillY;
    boolean expandX;
    boolean expandY;
    int align;
    int colspan;
    boolean uniformX;
    boolean uniformY;
    int widgetX;
    int widgetY;
    int widgetWidth;
    int widgetHeight;
    int column;
    int row;
    int cellAboveIndex = -1;
    int computedPadTop;
    int computedPadLeft;
    int computedPadBottom;
    int computedPadRight;

    public Cell() {
        this.widget = null;
        this.minWidth = null;
        this.minHeight = null;
        this.prefWidth = null;
        this.prefHeight = null;
        this.maxWidth = null;
        this.maxHeight = null;
        this.spaceTop = 0;
        this.spaceLeft = 0;
        this.spaceBottom = 0;
        this.spaceRight = 0;
        this.padTop = 0;
        this.padLeft = 0;
        this.padBottom = 0;
        this.padRight = 0;
        this.fillX = false;
        this.fillY = false;
        this.align = 1;
        this.expandX = false;
        this.expandY = false;
        this.colspan = 1;
        this.uniformX = false;
        this.uniformY = false;
    }

    public Cell(Cell defaultCell) {
        this(null, defaultCell);
    }

    public Cell(T widget, Cell defaultCell) {
        this.widget = widget;
        if (defaultCell != null) {
            this.minWidth = defaultCell.minWidth;
            this.minHeight = defaultCell.minHeight;
            this.prefWidth = defaultCell.prefWidth;
            this.prefHeight = defaultCell.prefHeight;
            this.maxWidth = defaultCell.maxWidth;
            this.maxHeight = defaultCell.maxHeight;
            this.spaceTop = defaultCell.spaceTop;
            this.spaceLeft = defaultCell.spaceLeft;
            this.spaceBottom = defaultCell.spaceBottom;
            this.spaceRight = defaultCell.spaceRight;
            this.padTop = defaultCell.padTop;
            this.padLeft = defaultCell.padLeft;
            this.padBottom = defaultCell.padBottom;
            this.padRight = defaultCell.padRight;
            this.fillX = defaultCell.fillX;
            this.fillY = defaultCell.fillY;
            this.align = defaultCell.align;
            this.expandX = defaultCell.expandX;
            this.expandY = defaultCell.expandY;
            this.colspan = defaultCell.colspan;
            this.uniformX = defaultCell.uniformX;
            this.uniformY = defaultCell.uniformY;
        }
    }

    public Cell<T> size(Integer width, Integer height) {
        this.minWidth = width;
        this.minHeight = height;
        this.prefWidth = width;
        this.prefHeight = height;
        this.maxWidth = width;
        this.maxHeight = height;
        return this;
    }

    public Cell<T> width(Integer width) {
        this.minWidth = width;
        this.prefWidth = width;
        this.maxWidth = width;
        return this;
    }

    public Cell<T> height(Integer height) {
        this.minHeight = height;
        this.prefHeight = height;
        this.maxHeight = height;
        return this;
    }

    public Cell<T> minSize(Integer width, Integer height) {
        this.minWidth = width;
        this.minHeight = height;
        return this;
    }

    public Cell<T> minWidth(Integer minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public Cell<T> minHeight(Integer minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    public Cell<T> prefSize(Integer width, Integer height) {
        this.prefWidth = width;
        this.prefHeight = height;
        return this;
    }

    public Cell<T> prefWidth(Integer prefWidth) {
        this.prefWidth = prefWidth;
        return this;
    }

    public Cell<T> prefHeight(Integer prefHeight) {
        this.prefHeight = prefHeight;
        return this;
    }

    public Cell<T> maxSize(Integer width, Integer height) {
        this.maxWidth = width;
        this.maxHeight = height;
        return this;
    }

    public Cell<T> maxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public Cell<T> maxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public Cell<T> space(int space) {
        this.spaceTop = space;
        this.spaceLeft = space;
        this.spaceBottom = space;
        this.spaceRight = space;
        return this;
    }

    public Cell<T> space(int top, int left, int bottom, int right) {
        this.spaceTop = top;
        this.spaceLeft = left;
        this.spaceBottom = bottom;
        this.spaceRight = right;
        return this;
    }

    public Cell<T> spaceTop(int spaceTop) {
        this.spaceTop = spaceTop;
        return this;
    }

    public Cell<T> spaceLeft(int spaceLeft) {
        this.spaceLeft = spaceLeft;
        return this;
    }

    public Cell<T> spaceBottom(int spaceBottom) {
        this.spaceBottom = spaceBottom;
        return this;
    }

    public Cell<T> spaceRight(int spaceRight) {
        this.spaceRight = spaceRight;
        return this;
    }

    public Cell<T> pad(int pad) {
        return this.pad(pad, pad, pad, pad);
    }

    public Cell<T> pad(int top, int left, int bottom, int right) {
        this.padTop = top;
        this.padLeft = left;
        this.padBottom = bottom;
        this.padRight = right;
        return this;
    }

    public Cell<T> padTop(int padTop) {
        this.padTop = padTop;
        return this;
    }

    public Cell<T> padLeft(int padLeft) {
        this.padLeft = padLeft;
        return this;
    }

    public Cell<T> padBottom(int padBottom) {
        this.padBottom = padBottom;
        return this;
    }

    public Cell<T> padRight(int padRight) {
        this.padRight = padRight;
        return this;
    }

    public Cell<T> fill() {
        this.fillX = true;
        this.fillY = true;
        return this;
    }

    public Cell<T> fillX() {
        this.fillX = true;
        return this;
    }

    public Cell<T> fillY() {
        this.fillY = true;
        return this;
    }

    public Cell<T> fill(boolean x, boolean y) {
        this.fillX = x;
        this.fillY = y;
        return this;
    }

    public Cell<T> expand() {
        this.expandX = true;
        this.expandY = true;
        return this;
    }

    public Cell<T> expandX() {
        this.expandX = true;
        return this;
    }

    public Cell<T> expandY() {
        this.expandY = true;
        return this;
    }

    public Cell<T> expand(boolean x, boolean y) {
        this.expandX = x;
        this.expandY = y;
        return this;
    }

    public Cell<T> align(int align) {
        this.align = align;
        return this;
    }

    public Cell<T> colspan(int colspan) {
        this.colspan = colspan;
        return this;
    }

    public Cell<T> uniform() {
        this.uniformX = true;
        this.uniformY = true;
        return this;
    }

    public Cell<T> uniformX() {
        this.uniformX = true;
        return this;
    }

    public Cell<T> uniformY() {
        this.uniformY = true;
        return this;
    }

    public Cell<T> uniform(boolean x, boolean y) {
        this.uniformX = x;
        this.uniformY = y;
        return this;
    }

    public Cell<T> rowEnd(boolean rowEnd) {
        this.rowEnd = rowEnd;
        return this;
    }

    public T getWidget() {
        return this.widget;
    }

    public boolean hasWidget() {
        return this.widget != null;
    }

    public Size getSize() {
        Size size = new Size();
        Dimension widgetMinSize = null;
        if (this.widget != null && (this.minWidth == null || this.minHeight == null)) {
            widgetMinSize = ((Component)this.widget).getMinimumSize();
        }
        size.min.width = this.minWidth == null ? (widgetMinSize == null ? 0 : widgetMinSize.width) : this.minWidth;
        size.min.height = this.minHeight == null ? (widgetMinSize == null ? 0 : widgetMinSize.height) : this.minHeight;
        Dimension widgetPrefSize = null;
        if (this.widget != null && (this.prefWidth == null || this.prefHeight == null)) {
            widgetPrefSize = ((Component)this.widget).getPreferredSize();
        }
        size.pref.width = this.prefWidth == null ? (widgetPrefSize == null ? 0 : widgetPrefSize.width) : this.prefWidth;
        size.pref.height = this.prefHeight == null ? (widgetPrefSize == null ? 0 : widgetPrefSize.height) : this.prefHeight;
        Dimension widgetMaxSize = null;
        if (this.widget != null && (this.maxWidth == null || this.maxHeight == null)) {
            widgetMaxSize = ((Component)this.widget).getMaximumSize();
        }
        int n = this.maxWidth == null ? (widgetMaxSize == null ? 0 : widgetMaxSize.width) : (size.max.width = this.maxWidth.intValue());
        int n2 = this.maxHeight == null ? (widgetMaxSize == null ? 0 : widgetMaxSize.height) : (size.max.height = this.maxHeight.intValue());
        if (size.max.width > 0) {
            size.min.width = Math.min(size.min.width, size.max.width);
            size.pref.width = Math.min(size.pref.width, size.max.width);
        }
        if (size.max.height > 0) {
            size.min.height = Math.min(size.min.height, size.max.height);
            size.pref.height = Math.min(size.pref.height, size.max.height);
        }
        size.pref.width = Math.max(size.pref.width, size.min.width);
        size.pref.height = Math.max(size.pref.height, size.min.height);
        return size;
    }

    public int getSpaceTop() {
        return this.spaceTop;
    }

    public int getSpaceLeft() {
        return this.spaceLeft;
    }

    public int getSpaceBottom() {
        return this.spaceBottom;
    }

    public int getSpaceRight() {
        return this.spaceRight;
    }

    public int getPadTop() {
        return this.padTop;
    }

    public int getPadLeft() {
        return this.padLeft;
    }

    public int getPadBottom() {
        return this.padBottom;
    }

    public int getPadRight() {
        return this.padRight;
    }

    public boolean isFillX() {
        return this.fillX;
    }

    public boolean isFillY() {
        return this.fillY;
    }

    public boolean isExpandX() {
        return this.expandX;
    }

    public boolean isExpandY() {
        return this.expandY;
    }

    public int getAlign() {
        return this.align;
    }

    public int getColspan() {
        return this.colspan;
    }

    public boolean isUniformX() {
        return this.uniformX;
    }

    public boolean isUniformY() {
        return this.uniformY;
    }

    public boolean isRowEnd() {
        return this.rowEnd;
    }

    public static class Size {
        public final Dimension min = new Dimension();
        public final Dimension pref = new Dimension();
        public final Dimension max = new Dimension();
    }
}

