/*
 * Decompiled with CFR 0.152.
 */
package org.cuberact.swing.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.cuberact.swing.layout.Cell;
import org.cuberact.swing.layout.CompositeLayout;
import org.cuberact.swing.layout.Stack;

public class Composite
extends JComponent
implements Iterable<Cell<? extends Component>> {
    private CompositeLayout layout;

    public Cell<JLabel> addCell(String text) {
        return this.addCell(new JLabel(text));
    }

    public Cell<JLabel> addCell(ImageIcon icon, String text) {
        return this.addCell(new JLabel(text, icon, 2));
    }

    public Cell<?> addCell() {
        return this.addCell((Component)null);
    }

    public <T extends Component> Cell<T> addCell(T widget) {
        this.initLayoutIfNull();
        return this.layout.add(widget);
    }

    public Cell<Stack> addStack(Component ... widgets) {
        Stack stack = new Stack();
        for (Component component : widgets) {
            stack.add(component);
        }
        return this.addCell(stack);
    }

    public Cell<?> row() {
        this.initLayoutIfNull();
        return this.layout.row();
    }

    public Cell<?> defaults() {
        this.initLayoutIfNull();
        return this.layout.defaults();
    }

    public <T extends Component> Cell<T> getCell(T widget) {
        return this.layout != null ? this.layout.getCell(widget) : null;
    }

    public List<Cell<? extends Component>> getCells() {
        this.initLayoutIfNull();
        return this.layout.getCells();
    }

    public Composite align(int align) {
        this.initLayoutIfNull();
        this.layout.align(align);
        return this;
    }

    public Composite pad(int pad) {
        return this.pad(pad, pad, pad, pad);
    }

    public Composite pad(int top, int left, int bottom, int right) {
        this.initLayoutIfNull();
        this.layout.pad(top, left, bottom, right);
        return this;
    }

    public Composite padTop(int top) {
        this.initLayoutIfNull();
        this.layout.padTop(top);
        return this;
    }

    public Composite padLeft(int left) {
        this.initLayoutIfNull();
        this.layout.padLeft(left);
        return this;
    }

    public Composite padBottom(int bottom) {
        this.initLayoutIfNull();
        this.layout.padBottom(bottom);
        return this;
    }

    public Composite padRight(int right) {
        this.initLayoutIfNull();
        this.layout.padRight(right);
        return this;
    }

    public int getAlign() {
        return this.layout != null ? this.layout.getAlign() : 1;
    }

    public int getPadTop() {
        return this.layout != null ? this.layout.getPadTop() : 0;
    }

    public int getPadLeft() {
        return this.layout != null ? this.layout.getPadLeft() : 0;
    }

    public int getPadBottom() {
        return this.layout != null ? this.layout.getPadBottom() : 0;
    }

    public int getPadRight() {
        return this.layout != null ? this.layout.getPadRight() : 0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isBackgroundSet()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
    }

    @Override
    public void setBackground(Color bg) {
        this.setOpaque(bg != null && bg.getAlpha() == 255);
        super.setBackground(bg);
    }

    @Override
    public void remove(Component widget) {
        super.remove(widget);
    }

    @Override
    public void remove(int index) {
        if (this.layout != null) {
            this.layout.removeCell(index);
        }
        super.remove(index);
    }

    @Override
    public void removeAll() {
        if (this.layout != null) {
            this.layout.removeAllCells();
            super.removeAll();
        }
    }

    @Override
    public Component add(Component comp, int index) {
        throw new UnsupportedOperationException("Composite - please use addCell methods");
    }

    @Override
    public Component add(Component comp) {
        throw new UnsupportedOperationException("Composite - please use addCell methods");
    }

    @Override
    public Component add(String name, Component comp) {
        throw new UnsupportedOperationException("Composite - please use addCell methods");
    }

    @Override
    public void add(Component comp, Object constraints) {
        throw new UnsupportedOperationException("Composite - please use addCell methods");
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        throw new UnsupportedOperationException("Composite - please use addCell methods");
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.layout != null) {
            this.layout.invalidateSize();
        }
    }

    private void initLayoutIfNull() {
        if (this.layout == null) {
            this.layout = new CompositeLayout(this);
            this.setLayout(new CompositeLayoutManager(this.layout));
        }
    }

    @Override
    public Iterator<Cell<? extends Component>> iterator() {
        if (this.layout == null) {
            return Collections.emptyListIterator();
        }
        return this.layout.getCells().iterator();
    }

    private static class CompositeLayoutManager
    implements LayoutManager {
        private final CompositeLayout layout;
        private Dimension minSize = new Dimension();
        private Dimension prefSize = new Dimension();

        private CompositeLayoutManager(CompositeLayout layout) {
            this.layout = layout;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.layout.layout();
            return this.layout.getPrefSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            this.layout.layout();
            return this.layout.getMinSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            this.layout.layout();
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

