/*
 * Decompiled with CFR 0.152.
 */
package org.cuberact.swing.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import org.cuberact.swing.layout.Cell;
import org.cuberact.swing.layout.Composite;

class CompositeLayout {
    private final Composite composite;
    private final Cell compositeDefaults = new Cell();
    private final List<Cell<? extends Component>> cells = new ArrayList<Cell<? extends Component>>();
    private final Insets borderInsets = new Insets(0, 0, 0, 0);
    private Cell rowDefaults;
    private Map<Cell, Cell.Size> cellSizesShortTimeCache = new HashMap<Cell, Cell.Size>();
    private int columns;
    private int rows;
    private boolean sizeInvalid = true;
    private int[] columnMinWidth;
    private int[] rowMinHeight;
    private int[] columnPrefWidth;
    private int[] rowPrefHeight;
    private int tableMinWidth;
    private int tableMinHeight;
    private int tablePrefWidth;
    private int tablePrefHeight;
    private int[] columnWidth;
    private int[] rowHeight;
    private boolean[] expandWidth;
    private boolean[] expandHeight;
    private int[] columnWeightedWidth;
    private int[] rowWeightedHeight;
    private int padTop;
    private int padLeft;
    private int padBottom;
    private int padRight;
    private int align = 1;

    CompositeLayout(Composite composite) {
        this.composite = composite;
    }

    Cell<?> defaults() {
        return this.compositeDefaults;
    }

    <T extends Component> Cell<T> add(T widget) {
        Cell<T> cell = new Cell<T>(widget, this.rowDefaults != null ? this.rowDefaults : this.compositeDefaults);
        if (widget != null) {
            this.composite.addImpl(widget, null, -1);
        }
        this.cells.add(cell);
        return cell;
    }

    Cell<?> row() {
        if (!this.cells.isEmpty()) {
            this.cells.get(this.cells.size() - 1).rowEnd(true);
        }
        this.rowDefaults = new Cell(this.compositeDefaults);
        return this.rowDefaults;
    }

    void removeCell(int componentIndex) {
        int cellIndex = -1;
        int widgetIndex = -1;
        for (Cell<? extends Component> cell : this.cells) {
            ++cellIndex;
            if (cell.widget == null || ++widgetIndex != componentIndex) continue;
            break;
        }
        if (cellIndex != -1) {
            if (cellIndex > 0 && this.cells.get(cellIndex).isRowEnd()) {
                this.cells.get(cellIndex - 1).rowEnd(true);
            }
            this.cells.remove(cellIndex);
        }
    }

    void removeAllCells() {
        this.cells.clear();
        this.rows = 0;
        this.columns = 0;
    }

    <T extends Component> Cell<T> getCell(T widget) {
        for (Cell<? extends Component> c : this.cells) {
            if (c.widget != widget) continue;
            return c;
        }
        return null;
    }

    List<Cell<? extends Component>> getCells() {
        return this.cells;
    }

    Dimension getMinSize() {
        if (this.sizeInvalid) {
            this.computeSize(true);
        }
        return new Dimension(this.tableMinWidth, this.tableMinHeight);
    }

    Dimension getPrefSize() {
        if (this.sizeInvalid) {
            this.computeSize(true);
        }
        return new Dimension(this.tablePrefWidth, this.tablePrefHeight);
    }

    void pad(int top, int left, int bottom, int right) {
        if (this.padTop != top || this.padLeft != left || this.padBottom != bottom || this.padRight != right) {
            this.padTop = top;
            this.padLeft = left;
            this.padBottom = bottom;
            this.padRight = right;
            this.invalidateCompositeIfValid();
        }
    }

    void padTop(int top) {
        if (this.padTop != top) {
            this.padTop = top;
            this.invalidateCompositeIfValid();
        }
    }

    void padLeft(int left) {
        if (this.padLeft != left) {
            this.padLeft = left;
            this.invalidateCompositeIfValid();
        }
    }

    void padBottom(int bottom) {
        if (this.padBottom != bottom) {
            this.padBottom = bottom;
            this.invalidateCompositeIfValid();
        }
    }

    void padRight(int right) {
        if (this.padRight != right) {
            this.padRight = right;
            this.invalidateCompositeIfValid();
        }
    }

    void align(int align) {
        if (this.align != align) {
            this.align = align;
            this.invalidateCompositeIfValid();
        }
    }

    int getPadTop() {
        return this.padTop;
    }

    int getPadLeft() {
        return this.padLeft;
    }

    int getPadBottom() {
        return this.padBottom;
    }

    int getPadRight() {
        return this.padRight;
    }

    int getAlign() {
        return this.align;
    }

    int[] ensureSize(int[] array, int size) {
        if (array == null || array.length < size) {
            return new int[size];
        }
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = 0;
        }
        return array;
    }

    boolean[] ensureSize(boolean[] array, int size) {
        if (array == null || array.length < size) {
            return new boolean[size];
        }
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = false;
        }
        return array;
    }

    void layout() {
        this.computeLayout();
        for (Cell<? extends Component> cell : this.cells) {
            Component component = cell.getWidget();
            component.setLocation(cell.widgetX, cell.widgetY);
            component.setSize(cell.widgetWidth, cell.widgetHeight);
        }
    }

    void invalidateCompositeIfValid() {
        if (this.composite.isValid()) {
            this.composite.invalidate();
        }
    }

    void invalidateSize() {
        this.sizeInvalid = true;
    }

    void updateCells() {
        this.columns = 0;
        this.rows = 0;
        if (!this.cells.isEmpty()) {
            int column = 0;
            int row = 0;
            ArrayList table = new ArrayList();
            ArrayList<Cell<? extends Component>> tableRow = new ArrayList<Cell<? extends Component>>();
            for (Cell<? extends Component> cell : this.cells) {
                cell.column = column;
                cell.row = row;
                for (int i = 0; i < cell.colspan; ++i) {
                    tableRow.add(cell);
                }
                if (cell.isRowEnd()) {
                    ++row;
                    column = 0;
                    table.add(tableRow);
                    tableRow = new ArrayList();
                    continue;
                }
                column += cell.colspan;
            }
            if (!tableRow.isEmpty()) {
                table.add(tableRow);
            }
            if (!table.isEmpty()) {
                List tableFirstRow = (List)table.get(0);
                for (Cell cell : tableFirstRow) {
                    cell.cellAboveIndex = -1;
                }
            }
            if (table.size() > 1) {
                for (int i = 1; i < table.size(); ++i) {
                    List list = (List)table.get(i - 1);
                    List tableRowActual = (List)table.get(i);
                    for (int j = 0; j < tableRowActual.size() && j < list.size(); j += ((Cell)tableRowActual.get((int)j)).colspan) {
                        ((Cell)tableRowActual.get((int)j)).cellAboveIndex = this.cells.indexOf(list.get(j));
                    }
                }
            }
            for (List list : table) {
                this.columns = Math.max(this.columns, list.size());
            }
            this.rows = table.size();
        }
    }

    private void computeSize(boolean flushCellSizesCacheAfter) {
        int i;
        this.updateBorderInsets();
        this.updateCells();
        this.fillCellSizesCache();
        this.sizeInvalid = false;
        this.columnMinWidth = this.ensureSize(this.columnMinWidth, this.columns);
        this.rowMinHeight = this.ensureSize(this.rowMinHeight, this.rows);
        this.columnPrefWidth = this.ensureSize(this.columnPrefWidth, this.columns);
        this.rowPrefHeight = this.ensureSize(this.rowPrefHeight, this.rows);
        this.columnWidth = this.ensureSize(this.columnWidth, this.columns);
        this.rowHeight = this.ensureSize(this.rowHeight, this.rows);
        this.expandWidth = this.ensureSize(this.expandWidth, this.columns);
        this.expandHeight = this.ensureSize(this.expandHeight, this.rows);
        int spaceRightLast = 0;
        for (Cell<? extends Component> cell : this.cells) {
            if (cell.expandY && !this.expandHeight[cell.row]) {
                this.expandHeight[cell.row] = true;
            }
            if (cell.colspan == 1 && cell.expandX && !this.expandWidth[cell.column]) {
                this.expandWidth[cell.column] = true;
            }
            cell.computedPadLeft = cell.padLeft + (cell.column == 0 ? 0 : CompositeLayout.max(0, cell.spaceLeft - spaceRightLast));
            cell.computedPadTop = cell.padTop;
            if (cell.cellAboveIndex != -1) {
                Cell<? extends Component> above = this.cells.get(cell.cellAboveIndex);
                cell.computedPadTop += Math.max(0, cell.spaceTop - above.spaceBottom);
            }
            int spaceRight = cell.spaceRight;
            cell.computedPadRight = cell.padRight + (cell.column + cell.colspan == this.columns ? 0 : spaceRight);
            cell.computedPadBottom = cell.padBottom + (cell.row == this.rows - 1 ? 0 : cell.spaceBottom);
            spaceRightLast = spaceRight;
            Cell.Size size = this.cellSizesShortTimeCache.get(cell);
            if (cell.colspan == 1) {
                int hPadding = cell.computedPadLeft + cell.computedPadRight;
                this.columnPrefWidth[cell.column] = CompositeLayout.max(this.columnPrefWidth[cell.column], size.pref.width + hPadding);
                this.columnMinWidth[cell.column] = CompositeLayout.max(this.columnMinWidth[cell.column], size.min.width + hPadding);
            }
            int vPadding = cell.computedPadTop + cell.computedPadBottom;
            this.rowPrefHeight[cell.row] = CompositeLayout.max(this.rowPrefHeight[cell.row], size.pref.height + vPadding);
            this.rowMinHeight[cell.row] = CompositeLayout.max(this.rowMinHeight[cell.row], size.min.height + vPadding);
        }
        block1: for (Cell<? extends Component> cell : this.cells) {
            int column;
            if (!cell.expandX) continue;
            int nn = column + cell.colspan;
            for (column = cell.column; column < nn; ++column) {
                if (this.expandWidth[column]) continue block1;
            }
            nn = column + cell.colspan;
            for (column = cell.column; column < nn; ++column) {
                this.expandWidth[column] = true;
            }
        }
        for (Cell<? extends Component> cell : this.cells) {
            int column;
            int column2;
            int spannedMinWidth;
            if (cell.colspan == 1) continue;
            int spannedPrefWidth = spannedMinWidth = -(cell.computedPadLeft + cell.computedPadRight);
            int nn = column2 + cell.colspan;
            for (column2 = cell.column; column2 < nn; ++column2) {
                spannedMinWidth += this.columnMinWidth[column2];
                spannedPrefWidth += this.columnPrefWidth[column2];
            }
            int totalExpandWidth = 0;
            int nn2 = column + cell.colspan;
            for (column = cell.column; column < nn2; ++column) {
                totalExpandWidth += this.expandWidth[column] ? 1 : 0;
            }
            Cell.Size size = this.cellSizesShortTimeCache.get(cell);
            int extraMinWidth = CompositeLayout.max(0, size.min.width - spannedMinWidth);
            int extraPrefWidth = CompositeLayout.max(0, size.pref.width - spannedPrefWidth);
            int column3 = cell.column;
            int nn3 = column3 + cell.colspan;
            while (column3 < nn3) {
                float ratio = totalExpandWidth == 0 ? 1.0f / (float)cell.colspan : (this.expandWidth[column3] ? 1.0f / (float)totalExpandWidth : 0.0f);
                int n = column3;
                this.columnMinWidth[n] = this.columnMinWidth[n] + (int)((float)extraMinWidth * ratio);
                int n2 = column3++;
                this.columnPrefWidth[n2] = this.columnPrefWidth[n2] + (int)((float)extraPrefWidth * ratio);
            }
        }
        int uniformMinWidth = 0;
        int uniformMinHeight = 0;
        int uniformPrefWidth = 0;
        int uniformPrefHeight = 0;
        for (Cell<? extends Component> cell : this.cells) {
            if (cell.uniformX == Boolean.TRUE && cell.colspan == 1) {
                int hpadding = cell.computedPadLeft + cell.computedPadRight;
                uniformMinWidth = CompositeLayout.max(uniformMinWidth, this.columnMinWidth[cell.column] - hpadding);
                uniformPrefWidth = CompositeLayout.max(uniformPrefWidth, this.columnPrefWidth[cell.column] - hpadding);
            }
            if (cell.uniformY != Boolean.TRUE) continue;
            int vpadding = cell.computedPadTop + cell.computedPadBottom;
            uniformMinHeight = CompositeLayout.max(uniformMinHeight, this.rowMinHeight[cell.row] - vpadding);
            uniformPrefHeight = CompositeLayout.max(uniformPrefHeight, this.rowPrefHeight[cell.row] - vpadding);
        }
        if (uniformPrefWidth > 0 || uniformPrefHeight > 0) {
            for (Cell<? extends Component> cell : this.cells) {
                if (uniformPrefWidth > 0 && cell.uniformX == Boolean.TRUE && cell.colspan == 1) {
                    int hPadding = cell.computedPadLeft + cell.computedPadRight;
                    this.columnMinWidth[cell.column] = uniformMinWidth + hPadding;
                    this.columnPrefWidth[cell.column] = uniformPrefWidth + hPadding;
                }
                if (uniformPrefHeight <= 0 || cell.uniformY != Boolean.TRUE) continue;
                int vPadding = cell.computedPadTop + cell.computedPadBottom;
                this.rowMinHeight[cell.row] = uniformMinHeight + vPadding;
                this.rowPrefHeight[cell.row] = uniformPrefHeight + vPadding;
            }
        }
        this.tableMinWidth = 0;
        this.tableMinHeight = 0;
        this.tablePrefWidth = 0;
        this.tablePrefHeight = 0;
        for (i = 0; i < this.columns; ++i) {
            this.tableMinWidth += this.columnMinWidth[i];
            this.tablePrefWidth += this.columnPrefWidth[i];
        }
        for (i = 0; i < this.rows; ++i) {
            this.tableMinHeight += this.rowMinHeight[i];
            this.tablePrefHeight += CompositeLayout.max(this.rowMinHeight[i], this.rowPrefHeight[i]);
        }
        int hPadding = this.getPadLeft() + this.getPadRight() + this.borderInsets.left + this.borderInsets.right;
        int vPadding = this.getPadTop() + this.getPadBottom() + this.borderInsets.top + this.borderInsets.bottom;
        this.tableMinWidth += hPadding;
        this.tableMinHeight += vPadding;
        this.tablePrefWidth = CompositeLayout.max(this.tablePrefWidth + hPadding, this.tableMinWidth);
        this.tablePrefHeight = CompositeLayout.max(this.tablePrefHeight + vPadding, this.tableMinHeight);
        if (flushCellSizesCacheAfter) {
            this.cellSizesShortTimeCache.clear();
        }
    }

    private void computeLayout() {
        int i;
        int lastIndex;
        int[] rowWeightedHeight;
        int[] columnWeightedWidth;
        int i2;
        if (this.sizeInvalid) {
            this.computeSize(false);
        } else {
            this.updateBorderInsets();
            this.fillCellSizesCache();
        }
        int hPadding = this.getPadLeft() + this.getPadRight() + this.borderInsets.left + this.borderInsets.right;
        int vPadding = this.getPadTop() + this.getPadBottom() + this.borderInsets.top + this.borderInsets.bottom;
        int totalExpandWidth = 0;
        int totalExpandHeight = 0;
        for (i2 = 0; i2 < this.columns; ++i2) {
            totalExpandWidth += this.expandWidth[i2] ? 1 : 0;
        }
        for (i2 = 0; i2 < this.rows; ++i2) {
            totalExpandHeight += this.expandHeight[i2] ? 1 : 0;
        }
        int totalGrowWidth = this.tablePrefWidth - this.tableMinWidth;
        if (totalGrowWidth == 0) {
            columnWeightedWidth = this.columnMinWidth;
        } else {
            int extraWidth = CompositeLayout.min(totalGrowWidth, CompositeLayout.max(0, this.composite.getWidth() - this.tableMinWidth));
            this.columnWeightedWidth = this.ensureSize(this.columnWeightedWidth, this.columns);
            columnWeightedWidth = this.columnWeightedWidth;
            for (int i3 = 0; i3 < this.columns; ++i3) {
                int growWidth = this.columnPrefWidth[i3] - this.columnMinWidth[i3];
                float growRatio = (float)growWidth / (float)totalGrowWidth;
                columnWeightedWidth[i3] = (int)((float)this.columnMinWidth[i3] + (float)extraWidth * growRatio);
            }
        }
        int totalGrowHeight = this.tablePrefHeight - this.tableMinHeight;
        if (totalGrowHeight == 0) {
            rowWeightedHeight = this.rowMinHeight;
        } else {
            this.rowWeightedHeight = this.ensureSize(this.rowWeightedHeight, this.rows);
            rowWeightedHeight = this.rowWeightedHeight;
            int extraHeight = CompositeLayout.min(totalGrowHeight, CompositeLayout.max(0, this.composite.getHeight() - this.tableMinHeight));
            for (int i4 = 0; i4 < this.rows; ++i4) {
                int growHeight = this.rowPrefHeight[i4] - this.rowMinHeight[i4];
                float growRatio = (float)growHeight / (float)totalGrowHeight;
                rowWeightedHeight[i4] = (int)((float)this.rowMinHeight[i4] + (float)extraHeight * growRatio);
            }
        }
        for (Cell<? extends Component> c : this.cells) {
            int column;
            int spannedWeightedWidth = 0;
            int nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                spannedWeightedWidth += columnWeightedWidth[column];
            }
            int weightedHeight = rowWeightedHeight[c.row];
            Cell.Size size = this.cellSizesShortTimeCache.get(c);
            c.widgetWidth = CompositeLayout.min(spannedWeightedWidth - c.computedPadLeft - c.computedPadRight, size.pref.width);
            c.widgetHeight = CompositeLayout.min(weightedHeight - c.computedPadTop - c.computedPadBottom, size.pref.height);
            if (c.colspan == 1) {
                this.columnWidth[c.column] = CompositeLayout.max(this.columnWidth[c.column], spannedWeightedWidth);
            }
            this.rowHeight[c.row] = CompositeLayout.max(this.rowHeight[c.row], weightedHeight);
        }
        if (totalExpandWidth > 0) {
            int extra = this.composite.getWidth() - hPadding;
            for (int i5 = 0; i5 < this.columns; ++i5) {
                extra -= this.columnWidth[i5];
            }
            int used = 0;
            lastIndex = 0;
            for (int i6 = 0; i6 < this.columns; ++i6) {
                if (!this.expandWidth[i6]) continue;
                int amount = (int)((float)(extra * (this.expandWidth[i6] ? 1 : 0)) / (float)totalExpandWidth);
                int n = i6;
                this.columnWidth[n] = this.columnWidth[n] + amount;
                used += amount;
                lastIndex = i6;
            }
            int n = lastIndex;
            this.columnWidth[n] = this.columnWidth[n] + (extra - used);
        }
        if (totalExpandHeight > 0) {
            int extra = this.composite.getHeight() - vPadding;
            for (int i7 = 0; i7 < this.rows; ++i7) {
                extra -= this.rowHeight[i7];
            }
            int used = 0;
            lastIndex = 0;
            for (int i8 = 0; i8 < this.rows; ++i8) {
                if (!this.expandHeight[i8]) continue;
                int amount = (int)((float)(extra * (this.expandHeight[i8] ? 1 : 0)) / (float)totalExpandHeight);
                int n = i8;
                this.rowHeight[n] = this.rowHeight[n] + amount;
                used += amount;
                lastIndex = i8;
            }
            int n = lastIndex;
            this.rowHeight[n] = this.rowHeight[n] + (extra - used);
        }
        for (Cell<? extends Component> c : this.cells) {
            int column;
            if (c.colspan == 1) continue;
            int extraWidth = 0;
            int nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                extraWidth += columnWeightedWidth[column] - this.columnWidth[column];
            }
            extraWidth -= Math.max(0, c.computedPadLeft + c.computedPadRight);
            if ((extraWidth /= c.colspan) <= 0) continue;
            column = c.column;
            nn = column + c.colspan;
            while (column < nn) {
                int n = column++;
                this.columnWidth[n] = this.columnWidth[n] + extraWidth;
            }
        }
        int tableWidth = hPadding;
        int tableHeight = vPadding;
        for (i = 0; i < this.columns; ++i) {
            tableWidth += this.columnWidth[i];
        }
        for (i = 0; i < this.rows; ++i) {
            tableHeight += this.rowHeight[i];
        }
        int x = this.getPadLeft() + this.borderInsets.left;
        if ((this.align & 0x10) != 0) {
            x += this.composite.getWidth() - tableWidth;
        } else if ((this.align & 8) == 0) {
            x += (this.composite.getWidth() - tableWidth) / 2;
        }
        int y = this.getPadTop() + this.borderInsets.top;
        if ((this.align & 4) != 0) {
            y += this.composite.getHeight() - tableHeight;
        } else if ((this.align & 2) == 0) {
            y += (this.composite.getHeight() - tableHeight) / 2;
        }
        int currentX = x;
        int currentY = y;
        for (Cell<? extends Component> c : this.cells) {
            int column;
            int spannedCellWidth = 0;
            int nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                spannedCellWidth += this.columnWidth[column];
            }
            spannedCellWidth -= c.computedPadLeft + c.computedPadRight;
            currentX += c.computedPadLeft;
            Cell.Size size = null;
            if (c.fillX || c.fillY) {
                size = this.cellSizesShortTimeCache.get(c);
            }
            if (c.fillX) {
                c.widgetWidth = spannedCellWidth;
                if (size.max.width > 0) {
                    c.widgetWidth = CompositeLayout.min(c.widgetWidth, size.max.width);
                }
            }
            if (c.fillY) {
                c.widgetHeight = this.rowHeight[c.row] - c.computedPadTop - c.computedPadBottom;
                if (size.max.height > 0) {
                    c.widgetHeight = CompositeLayout.min(c.widgetHeight, size.max.height);
                }
            }
            c.widgetX = (c.align & 8) != 0 ? currentX : ((c.align & 0x10) != 0 ? currentX + spannedCellWidth - c.widgetWidth : currentX + (spannedCellWidth - c.widgetWidth) / 2);
            c.widgetY = (c.align & 2) != 0 ? currentY + c.computedPadTop : ((c.align & 4) != 0 ? currentY + this.rowHeight[c.row] - c.widgetHeight - c.computedPadBottom : currentY + (this.rowHeight[c.row] - c.widgetHeight + c.computedPadTop - c.computedPadBottom) / 2);
            if (c.isRowEnd()) {
                currentX = x;
                currentY += this.rowHeight[c.row];
                continue;
            }
            currentX += spannedCellWidth + c.computedPadRight;
        }
        this.cellSizesShortTimeCache.clear();
    }

    private void fillCellSizesCache() {
        this.cellSizesShortTimeCache.clear();
        for (Cell<? extends Component> cell : this.cells) {
            this.cellSizesShortTimeCache.put(cell, cell.getSize());
        }
    }

    private void updateBorderInsets() {
        Border border = this.composite.getBorder();
        if (border != null) {
            if (border instanceof AbstractBorder) {
                ((AbstractBorder)border).getBorderInsets(this.composite, this.borderInsets);
                return;
            }
            Insets insets = border.getBorderInsets(this.composite);
            if (insets != null) {
                this.borderInsets.set(insets.top, insets.left, insets.bottom, insets.right);
                return;
            }
        }
        this.borderInsets.set(0, 0, 0, 0);
    }

    private static int max(int value1, int value2) {
        return value1 > value2 ? value1 : value2;
    }

    private static int min(int value1, int value2) {
        return value1 < value2 ? value1 : value2;
    }
}

