/*
 * Decompiled with CFR 0.152.
 */
package org.danbrough.kotlinxtras.binaries;

import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.danbrough.kotlinxtras.KonanTargetExtnsKt;
import org.danbrough.kotlinxtras.LoggingKt;
import org.danbrough.kotlinxtras.XtrasKt;
import org.danbrough.kotlinxtras.binaries.ArchiveTasksKt;
import org.danbrough.kotlinxtras.binaries.LibraryExtension;
import org.danbrough.kotlinxtras.binaries.SourceConfig;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.configurationcache.extensions.CharSequenceExtensionsKt;
import org.gradle.kotlin.dsl.DependencyHandlerScope;
import org.gradle.kotlin.dsl.ProjectExtensionsKt;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"cleanupTaskName", "", "Lorg/danbrough/kotlinxtras/binaries/LibraryExtension;", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "registerCleanBuildTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "kotlin.jvm.PlatformType", "registerCreateArchiveTask", "registerDownloadArchiveTask", "registerExtractLibsTask", "registerProvideArchiveTask", "resolveBinariesFromMaven", "Ljava/io/File;", "plugin"})
public final class ArchiveTasksKt {
    private static final String cleanupTaskName(LibraryExtension $this$cleanupTaskName, KonanTarget target) {
        return "xtrasCleanUp" + XtrasKt.capitalize($this$cleanupTaskName.getLibName()) + XtrasKt.capitalize(KonanTargetExtnsKt.getPlatformName(target));
    }

    private static final TaskProvider<Task> registerCleanBuildTask(LibraryExtension $this$registerCleanBuildTask, KonanTarget target) {
        TaskProvider taskProvider = $this$registerCleanBuildTask.getProject().getTasks().register(ArchiveTasksKt.cleanupTaskName($this$registerCleanBuildTask, target), new Action($this$registerCleanBuildTask, target){
            final /* synthetic */ LibraryExtension $this_registerCleanBuildTask;
            final /* synthetic */ KonanTarget $target;
            {
                this.$this_registerCleanBuildTask = $receiver;
                this.$target = $target;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                File buildDir2 = LibraryExtension.buildDir$default(this.$this_registerCleanBuildTask, this.$target, null, null, 6, null);
                File sourcesDir2 = (File)this.$this_registerCleanBuildTask.getSourcesDir().invoke((Object)this.$target);
                $this$register.getActions().add(new Action(buildDir2, this.$this_registerCleanBuildTask, this.$target, sourcesDir2){
                    final /* synthetic */ File $buildDir;
                    final /* synthetic */ LibraryExtension $this_registerCleanBuildTask;
                    final /* synthetic */ KonanTarget $target;
                    final /* synthetic */ File $sourcesDir;
                    {
                        this.$buildDir = $buildDir;
                        this.$this_registerCleanBuildTask = $receiver;
                        this.$target = $target;
                        this.$sourcesDir = $sourcesDir;
                    }

                    public final void execute(@NotNull Task $this$add) {
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        if (this.$buildDir.exists()) {
                            Project project = $this$add.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                            LoggingKt.log$default(project, ArchiveTasksKt.access$cleanupTaskName(this.$this_registerCleanBuildTask, this.$target) + " deleting " + this.$buildDir, null, 2, null);
                            FilesKt.deleteRecursively((File)this.$buildDir);
                        }
                        SourceConfig sourceConfig = this.$this_registerCleanBuildTask.getSourceConfig$plugin();
                        boolean bl = sourceConfig != null ? sourceConfig.getDeleteSourcesOnClean() : false;
                        if (bl && this.$sourcesDir.exists()) {
                            Project project = $this$add.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                            LoggingKt.log$default(project, ArchiveTasksKt.access$cleanupTaskName(this.$this_registerCleanBuildTask, this.$target) + " deleting " + this.$sourcesDir, null, 2, null);
                            FilesKt.deleteRecursively((File)this.$sourcesDir);
                        }
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"LibraryExtension.registe\u2026ively()\n      }\n    }\n  }");
        return taskProvider;
    }

    @NotNull
    public static final TaskProvider<Task> registerProvideArchiveTask(@NotNull LibraryExtension $this$registerProvideArchiveTask, @NotNull KonanTarget target) {
        Intrinsics.checkNotNullParameter((Object)$this$registerProvideArchiveTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        TaskProvider taskProvider = $this$registerProvideArchiveTask.getProject().getTasks().register(LibraryExtension.provideArchiveTaskName$default($this$registerProvideArchiveTask, target, null, 2, null), new Action($this$registerProvideArchiveTask, target){
            final /* synthetic */ LibraryExtension $this_registerProvideArchiveTask;
            final /* synthetic */ KonanTarget $target;
            {
                this.$this_registerProvideArchiveTask = $receiver;
                this.$target = $target;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("xtras");
                String string = this.$this_registerProvideArchiveTask.getLibName();
                String string2 = KonanTargetExtnsKt.getPlatformName(this.$target);
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                $this$register.setDescription("Ensures that the binary archive for " + string + ":" + string2 + " exists in the " + XtrasKt.getXtrasPackagesDir(project) + " folder");
                if (this.$this_registerProvideArchiveTask.getDeferToPrebuiltPackages()) {
                    Object[] objectArray = new Object[]{LibraryExtension.downloadArchiveTaskName$default(this.$this_registerProvideArchiveTask, this.$target, null, 2, null)};
                    $this$register.dependsOn(objectArray);
                } else {
                    Object[] objectArray = new Object[]{LibraryExtension.createArchiveTaskName$default(this.$this_registerProvideArchiveTask, this.$target, null, 2, null)};
                    $this$register.dependsOn(objectArray);
                }
                $this$register.getOutputs().file((Object)LibraryExtension.archiveFile$default(this.$this_registerProvideArchiveTask, this.$target, null, 2, null));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"LibraryExtension.registe\u2026(archiveFile(target))\n  }");
        return taskProvider;
    }

    @NotNull
    public static final TaskProvider<Task> registerExtractLibsTask(@NotNull LibraryExtension $this$registerExtractLibsTask, @NotNull KonanTarget target) {
        Intrinsics.checkNotNullParameter((Object)$this$registerExtractLibsTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        TaskProvider taskProvider = $this$registerExtractLibsTask.getProject().getTasks().register(LibraryExtension.extractArchiveTaskName$default($this$registerExtractLibsTask, target, null, 2, null), new Action($this$registerExtractLibsTask, target){
            final /* synthetic */ LibraryExtension $this_registerExtractLibsTask;
            final /* synthetic */ KonanTarget $target;
            {
                this.$this_registerExtractLibsTask = $receiver;
                this.$target = $target;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("xtras");
                $this$register.setDescription("Unpacks " + this.$this_registerExtractLibsTask.getLibName() + ":" + KonanTargetExtnsKt.getPlatformName(this.$target) + " into the " + LibraryExtension.libsDir$default(this.$this_registerExtractLibsTask, this.$target, null, null, 6, null) + " directory");
                Object[] objectArray = new Object[]{LibraryExtension.provideArchiveTaskName$default(this.$this_registerExtractLibsTask, this.$target, null, 2, null)};
                $this$register.dependsOn(objectArray);
                File archiveFile = LibraryExtension.archiveFile$default(this.$this_registerExtractLibsTask, this.$target, null, 2, null);
                $this$register.getInputs().file((Object)archiveFile);
                $this$register.getOutputs().dir((Object)LibraryExtension.libsDir$default(this.$this_registerExtractLibsTask, this.$target, null, null, 6, null));
                $this$register.getActions().add(new Action(this.$this_registerExtractLibsTask, this.$target, archiveFile){
                    final /* synthetic */ LibraryExtension $this_registerExtractLibsTask;
                    final /* synthetic */ KonanTarget $target;
                    final /* synthetic */ File $archiveFile;
                    {
                        this.$this_registerExtractLibsTask = $receiver;
                        this.$target = $target;
                        this.$archiveFile = $archiveFile;
                    }

                    public final void execute(@NotNull Task $this$add) {
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        $this$add.getProject().exec(new Action(this.$this_registerExtractLibsTask, this.$target, $this$add, this.$archiveFile){
                            final /* synthetic */ LibraryExtension $this_registerExtractLibsTask;
                            final /* synthetic */ KonanTarget $target;
                            final /* synthetic */ Task $this_add;
                            final /* synthetic */ File $archiveFile;
                            {
                                this.$this_registerExtractLibsTask = $receiver;
                                this.$target = $target;
                                this.$this_add = $this_add;
                                this.$archiveFile = $archiveFile;
                            }

                            public final void execute(@NotNull ExecSpec $this$exec) {
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                $this$exec.workingDir((Object)LibraryExtension.libsDir$default(this.$this_registerExtractLibsTask, this.$target, null, null, 6, null));
                                Project project = this.$this_add.getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                                LoggingKt.log$default(project, "extracting: " + this.$archiveFile + " to " + $this$exec.getWorkingDir(), null, 2, null);
                                Object[] objectArray = new Object[]{"tar", "xvpfz", this.$archiveFile.getAbsolutePath()};
                                $this$exec.commandLine(objectArray);
                            }
                        });
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"LibraryExtension.registe\u2026tePath)\n      }\n    }\n  }");
        return taskProvider;
    }

    @NotNull
    public static final TaskProvider<Task> registerCreateArchiveTask(@NotNull LibraryExtension $this$registerCreateArchiveTask, @NotNull KonanTarget target) {
        Intrinsics.checkNotNullParameter((Object)$this$registerCreateArchiveTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ArchiveTasksKt.registerCleanBuildTask($this$registerCreateArchiveTask, target);
        TaskProvider taskProvider = $this$registerCreateArchiveTask.getProject().getTasks().register(LibraryExtension.createArchiveTaskName$default($this$registerCreateArchiveTask, target, null, 2, null), new Action($this$registerCreateArchiveTask, target){
            final /* synthetic */ LibraryExtension $this_registerCreateArchiveTask;
            final /* synthetic */ KonanTarget $target;
            {
                this.$this_registerCreateArchiveTask = $receiver;
                this.$target = $target;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("xtras");
                $this$register.setDescription("Outputs binary archive for " + this.$this_registerCreateArchiveTask.getLibName() + ":" + KonanTargetExtnsKt.getPlatformName(this.$target));
                Object[] objectArray = new Object[]{LibraryExtension.buildSourcesTaskName$default(this.$this_registerCreateArchiveTask, this.$target, null, 2, null)};
                $this$register.dependsOn(objectArray);
                $this$register.getInputs().dir((Object)LibraryExtension.buildDir$default(this.$this_registerCreateArchiveTask, this.$target, null, null, 6, null));
                File archiveFile = LibraryExtension.archiveFile$default(this.$this_registerCreateArchiveTask, this.$target, null, 2, null);
                $this$register.getOutputs().file((Object)archiveFile);
                $this$register.getActions().add(new Action(this.$this_registerCreateArchiveTask, this.$target, archiveFile){
                    final /* synthetic */ LibraryExtension $this_registerCreateArchiveTask;
                    final /* synthetic */ KonanTarget $target;
                    final /* synthetic */ File $archiveFile;
                    {
                        this.$this_registerCreateArchiveTask = $receiver;
                        this.$target = $target;
                        this.$archiveFile = $archiveFile;
                    }

                    public final void execute(@NotNull Task $this$add) {
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        $this$add.getProject().exec(new Action(this.$this_registerCreateArchiveTask, this.$target, this.$archiveFile){
                            final /* synthetic */ LibraryExtension $this_registerCreateArchiveTask;
                            final /* synthetic */ KonanTarget $target;
                            final /* synthetic */ File $archiveFile;
                            {
                                this.$this_registerCreateArchiveTask = $receiver;
                                this.$target = $target;
                                this.$archiveFile = $archiveFile;
                            }

                            public final void execute(@NotNull ExecSpec $this$exec) {
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                $this$exec.workingDir((Object)LibraryExtension.buildDir$default(this.$this_registerCreateArchiveTask, this.$target, null, null, 6, null));
                                Object[] objectArray = new Object[]{"tar", "cvpfz", this.$archiveFile.getAbsolutePath(), "--exclude=**share", "--exclude=**pkgconfig", "./"};
                                $this$exec.commandLine(objectArray);
                            }
                        });
                    }
                });
                Object[] objectArray2 = new Object[]{"publish" + CharSequenceExtensionsKt.capitalized((CharSequence)this.$this_registerCreateArchiveTask.getLibName()) + CharSequenceExtensionsKt.capitalized((CharSequence)KonanTargetExtnsKt.getPlatformName(this.$target)) + "PublicationToXtrasRepository"};
                $this$register.finalizedBy(objectArray2);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"LibraryExtension.registe\u2026askName(target)\n    )\n  }");
        return taskProvider;
    }

    @Nullable
    public static final File resolveBinariesFromMaven(@NotNull LibraryExtension $this$resolveBinariesFromMaven, @NotNull KonanTarget target) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveBinariesFromMaven, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String mavenID = $this$resolveBinariesFromMaven.getPublishingGroup() + ":" + $this$resolveBinariesFromMaven.getLibName() + CharSequenceExtensionsKt.capitalized((CharSequence)KonanTargetExtnsKt.getPlatformName(target)) + ":" + $this$resolveBinariesFromMaven.getVersion();
        LoggingKt.log$default($this$resolveBinariesFromMaven.getProject(), "LibraryExtension.resolveBinariesFromMaven():" + target + " " + mavenID, null, 2, null);
        Object object = $this$resolveBinariesFromMaven.getProject().getConfigurations().create("configuration" + CharSequenceExtensionsKt.capitalized((CharSequence)$this$resolveBinariesFromMaven.getLibName()) + "Binaries" + CharSequenceExtensionsKt.capitalized((CharSequence)KonanTargetExtnsKt.getPlatformName(target)), (Action)resolveBinariesFromMaven.binariesConfiguration.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations.c\u2026anBeResolved = true\n    }");
        Configuration binariesConfiguration2 = (Configuration)object;
        $this$resolveBinariesFromMaven.getProject().getRepositories().all(new Action($this$resolveBinariesFromMaven, target){
            final /* synthetic */ LibraryExtension $this_resolveBinariesFromMaven;
            final /* synthetic */ KonanTarget $target;
            {
                this.$this_resolveBinariesFromMaven = $receiver;
                this.$target = $target;
            }

            public final void execute(@NotNull ArtifactRepository $this$all) {
                Intrinsics.checkNotNullParameter((Object)$this$all, (String)"$this$all");
                if ($this$all instanceof MavenArtifactRepository) {
                    LoggingKt.log$default(this.$this_resolveBinariesFromMaven.getProject(), "LibraryExtension.resolveBinariesFromMaven():" + this.$target + " REPO: " + ((MavenArtifactRepository)$this$all).getName() + ":" + ((MavenArtifactRepository)$this$all).getUrl(), null, 2, null);
                }
            }
        });
        ProjectExtensionsKt.dependencies((Project)$this$resolveBinariesFromMaven.getProject(), (Function1)((Function1)new Function1<DependencyHandlerScope, Unit>(binariesConfiguration2, mavenID){
            final /* synthetic */ Configuration $binariesConfiguration;
            final /* synthetic */ String $mavenID;
            {
                this.$binariesConfiguration = $binariesConfiguration;
                this.$mavenID = $mavenID;
                super(1);
            }

            public final void invoke(@NotNull DependencyHandlerScope $this$dependencies) {
                Intrinsics.checkNotNullParameter((Object)$this$dependencies, (String)"$this$dependencies");
                $this$dependencies.invoke(this.$binariesConfiguration, (Object)this.$mavenID);
            }
        }));
        LibraryExtension libraryExtension = $this$resolveBinariesFromMaven;
        try {
            LibraryExtension $this$resolveBinariesFromMaven_u24lambda_u241 = libraryExtension;
            boolean bl = false;
            Set set = binariesConfiguration2.resolve();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"binariesConfiguration.resolve()");
            Object object2 = CollectionsKt.first((Iterable)set);
            File it = (File)object2;
            boolean bl2 = false;
            LoggingKt.log$default($this$resolveBinariesFromMaven_u24lambda_u241.getProject(), "LibraryExtension.resolveBinariesFromMaven():" + target + " found " + it.getAbsolutePath(), null, 2, null);
            return (File)object2;
        }
        catch (Throwable bl) {
            block3: {
                Throwable throwable = Result.exceptionOrNull-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl)));
                if (throwable == null) break block3;
                Throwable it = throwable;
                boolean bl3 = false;
                LoggingKt.log$default($this$resolveBinariesFromMaven.getProject(), "LibraryExtension.resolveBinariesFromMaven():" + target + " Failed for " + mavenID + ": " + it.getMessage(), null, 2, null);
                if ($this$resolveBinariesFromMaven.getDeferToPrebuiltPackages()) {
                    LoggingKt.log$default($this$resolveBinariesFromMaven.getProject(), "Do you need to set deferToPrebuiltPackages = false on the LibraryExtension?", null, 2, null);
                }
            }
            return null;
        }
    }

    @NotNull
    public static final TaskProvider<Task> registerDownloadArchiveTask(@NotNull LibraryExtension $this$registerDownloadArchiveTask, @NotNull KonanTarget target) {
        Intrinsics.checkNotNullParameter((Object)$this$registerDownloadArchiveTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        TaskProvider taskProvider = $this$registerDownloadArchiveTask.getProject().getTasks().register(LibraryExtension.downloadArchiveTaskName$default($this$registerDownloadArchiveTask, target, null, 2, null), new Action($this$registerDownloadArchiveTask, target){
            final /* synthetic */ LibraryExtension $this_registerDownloadArchiveTask;
            final /* synthetic */ KonanTarget $target;
            {
                this.$this_registerDownloadArchiveTask = $receiver;
                this.$target = $target;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("xtras");
                File archiveFile = LibraryExtension.archiveFile$default(this.$this_registerDownloadArchiveTask, this.$target, null, 2, null);
                $this$register.getOutputs().file((Object)archiveFile);
                $this$register.getActions().add(new Action(this.$this_registerDownloadArchiveTask, this.$target, archiveFile){
                    final /* synthetic */ LibraryExtension $this_registerDownloadArchiveTask;
                    final /* synthetic */ KonanTarget $target;
                    final /* synthetic */ File $archiveFile;
                    {
                        this.$this_registerDownloadArchiveTask = $receiver;
                        this.$target = $target;
                        this.$archiveFile = $archiveFile;
                    }

                    public final void execute(@NotNull Task $this$add) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                            File file = ArchiveTasksKt.resolveBinariesFromMaven(this.$this_registerDownloadArchiveTask, this.$target);
                            if (file == null) break block0;
                            File file2 = file;
                            File file3 = this.$archiveFile;
                            File it = file2;
                            boolean bl = false;
                            Project project = $this$add.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                            LoggingKt.log$default(project, $this$add.getName() + ": resolved " + it.getAbsolutePath() + " copying to " + file3, null, 2, null);
                            FilesKt.copyTo$default((File)it, (File)file3, (boolean)true, (int)0, (int)4, null);
                        }
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"LibraryExtension.registe\u2026= true)\n      }\n    }\n  }");
        return taskProvider;
    }

    public static final /* synthetic */ String access$cleanupTaskName(LibraryExtension $receiver, KonanTarget target) {
        return ArchiveTasksKt.cleanupTaskName($receiver, target);
    }
}

