/*
 * Decompiled with CFR 0.152.
 */
package org.danbrough.kotlinxtras.binaries;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.danbrough.kotlinxtras.KonanTargetExtnsKt;
import org.danbrough.kotlinxtras.LoggingKt;
import org.danbrough.kotlinxtras.ProjectExtnsKt;
import org.danbrough.kotlinxtras.XtrasKt;
import org.danbrough.kotlinxtras.binaries.BinaryExtension;
import org.danbrough.kotlinxtras.binaries.LibraryExtension;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.jvm.tasks.KotlinJvmTest;
import org.jetbrains.kotlin.konan.target.HostManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/danbrough/kotlinxtras/binaries/BinaryPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "target", "plugin"})
public final class BinaryPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        LoggingKt.log$default(target, "Initializing BinaryPlugin...", null, 2, null);
        Object object = target.getExtensions().create("xtrasBinaries", BinaryExtension.class, new Object[0]);
        BinaryExtension $this$apply_u24lambda_u240 = (BinaryExtension)object;
        boolean bl = false;
        String binaryPropertyPrefix = "xtras.bin";
        Function2 binaryProperty2 = (Function2)new Function2<String, String, String>(target, binaryPropertyPrefix){
            final /* synthetic */ Project $target;
            final /* synthetic */ String $binaryPropertyPrefix;
            {
                this.$target = $target;
                this.$binaryPropertyPrefix = $binaryPropertyPrefix;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke(@NotNull String exe, @NotNull String defValue) {
                String string;
                void $this$projectProperty$iv$iv;
                void $this$projectProperty$iv;
                Intrinsics.checkNotNullParameter((Object)exe, (String)"exe");
                Intrinsics.checkNotNullParameter((Object)defValue, (String)"defValue");
                Project project = this.$target;
                String name$iv = this.$binaryPropertyPrefix + "." + exe;
                boolean $i$f$projectProperty = false;
                void var6_6 = $this$projectProperty$iv;
                boolean hasDefault$iv$iv = true;
                boolean $i$f$projectProperty2 = false;
                if (!$this$projectProperty$iv$iv.getProperties().containsKey(name$iv)) {
                    string = defValue;
                } else {
                    Object object;
                    String value$iv$iv = String.valueOf($this$projectProperty$iv$iv.getProperties().get(name$iv));
                    KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                        object = value$iv$iv;
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                        object = Integer.parseInt(value$iv$iv);
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                        object = Float.valueOf(Float.parseFloat(value$iv$iv));
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                        object = Double.parseDouble(value$iv$iv);
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                        object = Long.parseLong(value$iv$iv);
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                        object = Boolean.parseBoolean(value$iv$iv);
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(File.class))) {
                        object = new File(value$iv$iv);
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(URI.class))) {
                        object = URI.create(value$iv$iv);
                    } else {
                        throw new Error("Invalid property type: " + Reflection.getOrCreateKotlinClass(String.class));
                    }
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = object;
                }
                return string;
            }
        };
        $this$apply_u24lambda_u240.setGitBinary((String)binaryProperty2.invoke((Object)"git", (Object)$this$apply_u24lambda_u240.getGitBinary()));
        $this$apply_u24lambda_u240.setWgetBinary((String)binaryProperty2.invoke((Object)"wget", (Object)$this$apply_u24lambda_u240.getWgetBinary()));
        $this$apply_u24lambda_u240.setGoBinary((String)binaryProperty2.invoke((Object)"go", (Object)$this$apply_u24lambda_u240.getGoBinary()));
        $this$apply_u24lambda_u240.setTarBinary((String)binaryProperty2.invoke((Object)"tar", (Object)$this$apply_u24lambda_u240.getTarBinary()));
        $this$apply_u24lambda_u240.setAutoreconfBinary((String)binaryProperty2.invoke((Object)"autoreconf", (Object)$this$apply_u24lambda_u240.getAutoreconfBinary()));
        $this$apply_u24lambda_u240.setMakeBinary((String)binaryProperty2.invoke((Object)"make", (Object)$this$apply_u24lambda_u240.getMakeBinary()));
        $this$apply_u24lambda_u240.setCmakeBinary((String)binaryProperty2.invoke((Object)"cmake", (Object)$this$apply_u24lambda_u240.getCmakeBinary()));
        target.getTasks().register("xtrasConfig", new Action(binaryPropertyPrefix, $this$apply_u24lambda_u240){
            final /* synthetic */ String $binaryPropertyPrefix;
            final /* synthetic */ BinaryExtension $this_apply;
            {
                this.$binaryPropertyPrefix = $binaryPropertyPrefix;
                this.$this_apply = $receiver;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("xtras");
                $this$register.setDescription("Prints out the xtras configuration details");
                $this$register.doFirst(new Action(this.$binaryPropertyPrefix, this.$this_apply){
                    final /* synthetic */ String $binaryPropertyPrefix;
                    final /* synthetic */ BinaryExtension $this_apply;
                    {
                        this.$binaryPropertyPrefix = $binaryPropertyPrefix;
                        this.$this_apply = $receiver;
                    }

                    public final void execute(@NotNull Task $this$doFirst) {
                        Intrinsics.checkNotNullParameter((Object)$this$doFirst, (String)"$this$doFirst");
                        String string = this.$this_apply.getGitBinary();
                        String string2 = this.$this_apply.getWgetBinary();
                        String string3 = this.$this_apply.getTarBinary();
                        String string4 = this.$this_apply.getGoBinary();
                        String string5 = this.$this_apply.getAutoreconfBinary();
                        String string6 = this.$this_apply.getMakeBinary();
                        String string7 = this.$this_apply.getCmakeBinary();
                        Project project = $this$doFirst.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                        File file = XtrasKt.getXtrasDir(project);
                        Project project2 = $this$doFirst.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                        File file2 = XtrasKt.getXtrasLibsDir(project2);
                        Project project3 = $this$doFirst.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                        File file3 = XtrasKt.getXtrasDownloadsDir(project3);
                        Project project4 = $this$doFirst.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                        File file4 = XtrasKt.getXtrasPackagesDir(project4);
                        Project project5 = $this$doFirst.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
                        File file5 = XtrasKt.getXtrasDocsDir(project5);
                        Project project6 = $this$doFirst.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
                        String string8 = StringsKt.trimIndent((String)("\n                \n                Binaries:\n                  " + this.$binaryPropertyPrefix + ".git:            " + string + "\n                  " + this.$binaryPropertyPrefix + ".wget:           " + string2 + "\n                  " + this.$binaryPropertyPrefix + ".tar:            " + string3 + "\n                  " + this.$binaryPropertyPrefix + ".go:             " + string4 + "\n                  " + this.$binaryPropertyPrefix + ".autoreconf:     " + string5 + "\n                  " + this.$binaryPropertyPrefix + ".make:           " + string6 + "\n                  " + this.$binaryPropertyPrefix + ".cmake:          " + string7 + "\n                \n                Paths:\n                  xtras.dir:            " + file + "\n                  xtras.dir.libs:       " + file2 + "\n                  xtras.dir.downloads:  " + file3 + "\n                  xtras.dir.packages:   " + file4 + "\n                  xtras.dir.docs:       " + file5 + "\n                  xtras.dir.cinterops:  " + XtrasKt.getXtrasCInteropsDir(project6) + "\n                "));
                        System.out.println((Object)string8);
                    }
                });
            }
        });
        target.afterEvaluate(new Action($this$apply_u24lambda_u240){
            final /* synthetic */ BinaryExtension $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public final void execute(@NotNull Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                $this$afterEvaluate.getTasks().withType(KotlinJvmTest.class, new Action(this.$this_apply, $this$afterEvaluate){
                    final /* synthetic */ BinaryExtension $this_apply;
                    final /* synthetic */ Project $this_afterEvaluate;
                    {
                        this.$this_apply = $receiver;
                        this.$this_afterEvaluate = $this_afterEvaluate;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(@NotNull KotlinJvmTest $this$withType) {
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$withType, (String)"$this$withType");
                        Object[] objectArray = new Object[1];
                        Iterable iterable = this.$this_apply.getLibraryExtensions();
                        int n = 0;
                        Object[] objectArray2 = objectArray;
                        KotlinJvmTest kotlinJvmTest = $this$withType;
                        boolean $i$f$map = false;
                        void var5_8 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            LibraryExtension libraryExtension = (LibraryExtension)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(LibraryExtension.extractArchiveTaskName$default((LibraryExtension)it, HostManager.Companion.getHost(), null, 2, null));
                        }
                        collection = (List)destination$iv$iv;
                        objectArray2[n] = collection;
                        kotlinJvmTest.dependsOn(objectArray);
                        String string = KonanTargetExtnsKt.getSHARED_LIBRARY_PATH_NAME();
                        Project project = this.$this_afterEvaluate;
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"execute");
                        $this$withType.environment(string, (Object)ProjectExtnsKt.sharedLibraryPath$default(project, null, false, 3, null));
                    }
                });
            }
        });
    }
}

