/*
 * Decompiled with CFR 0.152.
 */
package org.danbrough.kotlinxtras.binaries;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.danbrough.kotlinxtras.LoggingKt;
import org.danbrough.kotlinxtras.XtrasKt;
import org.danbrough.kotlinxtras.binaries.ArchiveSourceConfig;
import org.danbrough.kotlinxtras.binaries.BinaryPluginKt;
import org.danbrough.kotlinxtras.binaries.DirectorySourceConfig;
import org.danbrough.kotlinxtras.binaries.GitSourceConfig;
import org.danbrough.kotlinxtras.binaries.LibraryExtension;
import org.danbrough.kotlinxtras.binaries.SourcesTasksKt;
import org.danbrough.kotlinxtras.binaries.XtrasDSLMarker;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Exec;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a-\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\b\bH\u0007\u001a\u001c\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0007\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u001c\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u001c\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0013H\u0000\u001a\u001c\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u00a8\u0006\u0018"}, d2={"download", "", "Lorg/danbrough/kotlinxtras/binaries/LibraryExtension;", "url", "", "configure", "Lkotlin/Function1;", "Lorg/danbrough/kotlinxtras/binaries/ArchiveSourceConfig;", "Lkotlin/ExtensionFunctionType;", "git", "commit", "registerArchiveDownloadTask", "registerArchiveExtractTask", "srcConfig", "konanTarget", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "registerDirectorySourcesTask", "Lorg/danbrough/kotlinxtras/binaries/DirectorySourceConfig;", "registerGitDownloadTask", "Lorg/danbrough/kotlinxtras/binaries/GitSourceConfig;", "registerGitExtractTask", "sourceDir", "file", "Ljava/io/File;", "plugin"})
public final class SourcesTasksKt {
    /*
     * WARNING - void declaration
     */
    @XtrasDSLMarker
    public static final void download(@NotNull LibraryExtension $this$download, @NotNull String url, @NotNull Function1<? super ArchiveSourceConfig, Unit> configure) {
        void $this$download_u24lambda_u240;
        String string;
        ArchiveSourceConfig archiveSourceConfig;
        Intrinsics.checkNotNullParameter((Object)$this$download, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        $this$download.setSourceURL(url);
        ArchiveSourceConfig archiveSourceConfig2 = archiveSourceConfig = new ArchiveSourceConfig(false, null, false, 7, null);
        LibraryExtension libraryExtension = $this$download;
        boolean bl = false;
        if (StringsKt.endsWith((String)url, (String)".tar.gz", (boolean)true)) {
            string = "xfz";
        } else if (StringsKt.endsWith((String)url, (String)".tar.bz2", (boolean)true)) {
            string = "xfj";
        } else {
            throw new Error("Missing tarExtractOptions for " + url);
        }
        $this$download_u24lambda_u240.setTarExtractOptions(string);
        configure.invoke((Object)$this$download_u24lambda_u240);
        libraryExtension.setSourceConfig$plugin(archiveSourceConfig);
    }

    @XtrasDSLMarker
    public static final void sourceDir(@NotNull LibraryExtension $this$sourceDir, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        $this$sourceDir.setSourceConfig$plugin(new DirectorySourceConfig(file, false, 2, null));
    }

    @XtrasDSLMarker
    public static final void git(@NotNull LibraryExtension $this$git, @NotNull String url, @NotNull String commit) {
        Intrinsics.checkNotNullParameter((Object)$this$git, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        $this$git.setSourceURL(url);
        $this$git.setSourceConfig$plugin(new GitSourceConfig(commit, false, 2, null));
    }

    public static final void registerDirectorySourcesTask(@NotNull LibraryExtension $this$registerDirectorySourcesTask, @NotNull DirectorySourceConfig srcConfig, @NotNull KonanTarget konanTarget) {
        Intrinsics.checkNotNullParameter((Object)$this$registerDirectorySourcesTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)srcConfig, (String)"srcConfig");
        Intrinsics.checkNotNullParameter((Object)konanTarget, (String)"konanTarget");
        $this$registerDirectorySourcesTask.getProject().getTasks().register($this$registerDirectorySourcesTask.extractSourcesTaskName(konanTarget), Copy.class, new Action(srcConfig, $this$registerDirectorySourcesTask, konanTarget){
            final /* synthetic */ DirectorySourceConfig $srcConfig;
            final /* synthetic */ LibraryExtension $this_registerDirectorySourcesTask;
            final /* synthetic */ KonanTarget $konanTarget;
            {
                this.$srcConfig = $srcConfig;
                this.$this_registerDirectorySourcesTask = $receiver;
                this.$konanTarget = $konanTarget;
            }

            public final void execute(@NotNull Copy $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                Object[] objectArray = new Object[]{this.$srcConfig.getFile()};
                $this$register.from(objectArray);
                $this$register.setDestinationDir((File)this.$this_registerDirectorySourcesTask.getSourcesDir().invoke((Object)this.$konanTarget));
            }
        });
    }

    public static final void registerGitDownloadTask(@NotNull LibraryExtension $this$registerGitDownloadTask, @NotNull GitSourceConfig srcConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$registerGitDownloadTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)srcConfig, (String)"srcConfig");
        String configRepoTaskName = $this$registerGitDownloadTask.getDownloadSourcesTaskName() + "_configRepo";
        $this$registerGitDownloadTask.getProject().getTasks().register(configRepoTaskName, Exec.class, new Action($this$registerGitDownloadTask){
            final /* synthetic */ LibraryExtension $this_registerGitDownloadTask;
            {
                this.$this_registerGitDownloadTask = $receiver;
            }

            public final void execute(@NotNull Exec $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                File repoDir = this.$this_registerGitDownloadTask.gitRepoDir();
                $this$register.getInputs().property("url", (Object)this.$this_registerGitDownloadTask.getSourceURL());
                $this$register.getOutputs().file((Object)FilesKt.resolve((File)repoDir, (String)"config"));
                $this$register.onlyIf(new Spec(repoDir){
                    final /* synthetic */ File $repoDir;
                    {
                        this.$repoDir = $repoDir;
                    }

                    public final boolean isSatisfiedBy(Task it) {
                        return !FilesKt.resolve((File)this.$repoDir, (String)"config").exists();
                    }
                });
                $this$register.doFirst(new Action($this$register, this.$this_registerGitDownloadTask, repoDir){
                    final /* synthetic */ Exec $this_register;
                    final /* synthetic */ LibraryExtension $this_registerGitDownloadTask;
                    final /* synthetic */ File $repoDir;
                    {
                        this.$this_register = $this_register;
                        this.$this_registerGitDownloadTask = $receiver;
                        this.$repoDir = $repoDir;
                    }

                    public final void execute(@NotNull Task $this$doFirst) {
                        Intrinsics.checkNotNullParameter((Object)$this$doFirst, (String)"$this$doFirst");
                        $this$doFirst.getProject().exec(new Action(this.$this_registerGitDownloadTask, this.$repoDir){
                            final /* synthetic */ LibraryExtension $this_registerGitDownloadTask;
                            final /* synthetic */ File $repoDir;
                            {
                                this.$this_registerGitDownloadTask = $receiver;
                                this.$repoDir = $repoDir;
                            }

                            public final void execute(@NotNull ExecSpec $this$exec) {
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                Object[] objectArray = new Object[4];
                                LibraryExtension this_$iv = this.$this_registerGitDownloadTask;
                                boolean $i$f$getBinaries = false;
                                objectArray[0] = BinaryPluginKt.getBinariesExtension(this_$iv.getProject()).getGitBinary();
                                objectArray[1] = "init";
                                objectArray[2] = "--bare";
                                objectArray[3] = this.$repoDir;
                                $this$exec.commandLine(objectArray);
                                List list = $this$exec.getCommandLine();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                                System.out.println((Object)("running#: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
                            }
                        });
                        List list = this.$this_register.getCommandLine();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                        System.out.println((Object)("running: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
                    }
                });
                $this$register.getOutputs().dir((Object)repoDir);
                $this$register.setWorkingDir(this.$this_registerGitDownloadTask.gitRepoDir());
                Object[] objectArray = new Object[5];
                LibraryExtension this_$iv = this.$this_registerGitDownloadTask;
                boolean $i$f$getBinaries = false;
                objectArray[0] = BinaryPluginKt.getBinariesExtension(this_$iv.getProject()).getGitBinary();
                objectArray[1] = "remote";
                objectArray[2] = "add";
                objectArray[3] = "origin";
                objectArray[4] = this.$this_registerGitDownloadTask.getSourceURL();
                $this$register.commandLine(objectArray);
            }
        });
        $this$registerGitDownloadTask.getProject().getTasks().register($this$registerGitDownloadTask.getDownloadSourcesTaskName(), Exec.class, new Action($this$registerGitDownloadTask, srcConfig, configRepoTaskName){
            final /* synthetic */ LibraryExtension $this_registerGitDownloadTask;
            final /* synthetic */ GitSourceConfig $srcConfig;
            final /* synthetic */ String $configRepoTaskName;
            {
                this.$this_registerGitDownloadTask = $receiver;
                this.$srcConfig = $srcConfig;
                this.$configRepoTaskName = $configRepoTaskName;
            }

            public final void execute(@NotNull Exec $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.getInputs().property("url", (Object)this.$this_registerGitDownloadTask.getSourceURL());
                $this$register.getInputs().property("commit", (Object)this.$srcConfig.getCommit());
                Object[] objectArray = new Object[]{this.$configRepoTaskName};
                $this$register.dependsOn(objectArray);
                File repoDir = this.$this_registerGitDownloadTask.gitRepoDir();
                $this$register.getOutputs().dir((Object)repoDir);
                $this$register.setGroup("xtras");
                $this$register.workingDir((Object)repoDir);
                Object[] objectArray2 = new Object[6];
                LibraryExtension this_$iv = this.$this_registerGitDownloadTask;
                boolean $i$f$getBinaries = false;
                objectArray2[0] = BinaryPluginKt.getBinariesExtension(this_$iv.getProject()).getGitBinary();
                objectArray2[1] = "fetch";
                objectArray2[2] = "--depth";
                objectArray2[3] = "1";
                objectArray2[4] = "origin";
                objectArray2[5] = this.$srcConfig.getCommit();
                $this$register.commandLine(objectArray2);
            }
        });
    }

    public static final void registerGitExtractTask(@NotNull LibraryExtension $this$registerGitExtractTask, @NotNull GitSourceConfig srcConfig, @NotNull KonanTarget konanTarget) {
        Intrinsics.checkNotNullParameter((Object)$this$registerGitExtractTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)srcConfig, (String)"srcConfig");
        Intrinsics.checkNotNullParameter((Object)konanTarget, (String)"konanTarget");
        String extractSourcesTaskName = $this$registerGitExtractTask.extractSourcesTaskName(konanTarget);
        String initTaskName = extractSourcesTaskName + "_init";
        $this$registerGitExtractTask.getProject().getTasks().register(initTaskName, new Action($this$registerGitExtractTask, konanTarget){
            final /* synthetic */ LibraryExtension $this_registerGitExtractTask;
            final /* synthetic */ KonanTarget $konanTarget;
            {
                this.$this_registerGitExtractTask = $receiver;
                this.$konanTarget = $konanTarget;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                Object[] objectArray = new Object[]{LibraryExtension.downloadArchiveTaskName$default(this.$this_registerGitExtractTask, this.$konanTarget, null, 2, null)};
                $this$register.mustRunAfter(objectArray);
                objectArray = new Object[]{this.$this_registerGitExtractTask.getDownloadSourcesTaskName()};
                $this$register.dependsOn(objectArray);
                FileCollection fileCollection = $this$register.getProject().getTasks().getAt(this.$this_registerGitExtractTask.getDownloadSourcesTaskName()).getOutputs().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"project.tasks.getAt(down\u2026esTaskName).outputs.files");
                File gitRepo = (File)CollectionsKt.first((Iterable)((Iterable)fileCollection));
                File destDir = (File)this.$this_registerGitExtractTask.getSourcesDir().invoke((Object)this.$konanTarget);
                $this$register.getOutputs().dir((Object)destDir);
                $this$register.doFirst((Action)registerGitExtractTask.1.INSTANCE);
                $this$register.onlyIf(new Spec(destDir){
                    final /* synthetic */ File $destDir;
                    {
                        this.$destDir = $destDir;
                    }

                    public final boolean isSatisfiedBy(Task it) {
                        return !FilesKt.resolve((File)this.$destDir, (String)".git").exists();
                    }
                });
                $this$register.getActions().add(new Action(destDir, this.$this_registerGitExtractTask){
                    final /* synthetic */ File $destDir;
                    final /* synthetic */ LibraryExtension $this_registerGitExtractTask;
                    {
                        this.$destDir = $destDir;
                        this.$this_registerGitExtractTask = $receiver;
                    }

                    public final void execute(@NotNull Task $this$add) {
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        $this$add.getProject().exec(new Action(this.$destDir, this.$this_registerGitExtractTask){
                            final /* synthetic */ File $destDir;
                            final /* synthetic */ LibraryExtension $this_registerGitExtractTask;
                            {
                                this.$destDir = $destDir;
                                this.$this_registerGitExtractTask = $receiver;
                            }

                            public final void execute(@NotNull ExecSpec $this$exec) {
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                $this$exec.workingDir((Object)this.$destDir);
                                Object[] objectArray = new Object[2];
                                LibraryExtension this_$iv = this.$this_registerGitExtractTask;
                                boolean $i$f$getBinaries = false;
                                objectArray[0] = BinaryPluginKt.getBinariesExtension(this_$iv.getProject()).getGitBinary();
                                objectArray[1] = "init";
                                $this$exec.commandLine(objectArray);
                                List list = $this$exec.getCommandLine();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                                System.out.println((Object)("running: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
                            }
                        });
                    }
                });
                $this$register.getActions().add(new Action(destDir, this.$this_registerGitExtractTask, gitRepo){
                    final /* synthetic */ File $destDir;
                    final /* synthetic */ LibraryExtension $this_registerGitExtractTask;
                    final /* synthetic */ File $gitRepo;
                    {
                        this.$destDir = $destDir;
                        this.$this_registerGitExtractTask = $receiver;
                        this.$gitRepo = $gitRepo;
                    }

                    public final void execute(@NotNull Task $this$add) {
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        $this$add.getProject().exec(new Action(this.$destDir, this.$this_registerGitExtractTask, this.$gitRepo){
                            final /* synthetic */ File $destDir;
                            final /* synthetic */ LibraryExtension $this_registerGitExtractTask;
                            final /* synthetic */ File $gitRepo;
                            {
                                this.$destDir = $destDir;
                                this.$this_registerGitExtractTask = $receiver;
                                this.$gitRepo = $gitRepo;
                            }

                            public final void execute(@NotNull ExecSpec $this$exec) {
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                $this$exec.workingDir((Object)this.$destDir);
                                Object[] objectArray = new Object[5];
                                LibraryExtension this_$iv = this.$this_registerGitExtractTask;
                                boolean $i$f$getBinaries = false;
                                objectArray[0] = BinaryPluginKt.getBinariesExtension(this_$iv.getProject()).getGitBinary();
                                objectArray[1] = "remote";
                                objectArray[2] = "add";
                                objectArray[3] = "origin";
                                objectArray[4] = this.$gitRepo;
                                $this$exec.commandLine(objectArray);
                                List list = $this$exec.getCommandLine();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                                System.out.println((Object)("running: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
                            }
                        });
                    }
                });
            }
        });
        $this$registerGitExtractTask.getProject().getTasks().register(extractSourcesTaskName, new Action(initTaskName, $this$registerGitExtractTask, konanTarget, srcConfig){
            final /* synthetic */ String $initTaskName;
            final /* synthetic */ LibraryExtension $this_registerGitExtractTask;
            final /* synthetic */ KonanTarget $konanTarget;
            final /* synthetic */ GitSourceConfig $srcConfig;
            {
                this.$initTaskName = $initTaskName;
                this.$this_registerGitExtractTask = $receiver;
                this.$konanTarget = $konanTarget;
                this.$srcConfig = $srcConfig;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("xtras");
                Object[] objectArray = new Object[]{this.$initTaskName};
                $this$register.dependsOn(objectArray);
                File destDir = (File)this.$this_registerGitExtractTask.getSourcesDir().invoke((Object)this.$konanTarget);
                $this$register.getInputs().property("commit", (Object)this.$srcConfig.getCommit());
                $this$register.getOutputs().dir((Object)destDir);
                $this$register.getActions().add(new Action(destDir, this.$this_registerGitExtractTask){
                    final /* synthetic */ File $destDir;
                    final /* synthetic */ LibraryExtension $this_registerGitExtractTask;
                    {
                        this.$destDir = $destDir;
                        this.$this_registerGitExtractTask = $receiver;
                    }

                    public final void execute(@NotNull Task $this$add) {
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        $this$add.getProject().exec(new Action(this.$destDir, this.$this_registerGitExtractTask){
                            final /* synthetic */ File $destDir;
                            final /* synthetic */ LibraryExtension $this_registerGitExtractTask;
                            {
                                this.$destDir = $destDir;
                                this.$this_registerGitExtractTask = $receiver;
                            }

                            public final void execute(@NotNull ExecSpec $this$exec) {
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                $this$exec.setWorkingDir(this.$destDir);
                                Object[] objectArray = new Object[3];
                                LibraryExtension this_$iv = this.$this_registerGitExtractTask;
                                boolean $i$f$getBinaries = false;
                                objectArray[0] = BinaryPluginKt.getBinariesExtension(this_$iv.getProject()).getGitBinary();
                                objectArray[1] = "clean";
                                objectArray[2] = "-xdf";
                                $this$exec.commandLine(objectArray);
                                List list = $this$exec.getCommandLine();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                                System.out.println((Object)("running: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
                            }
                        });
                    }
                });
                $this$register.getActions().add(new Action(this.$srcConfig, destDir, this.$this_registerGitExtractTask){
                    final /* synthetic */ GitSourceConfig $srcConfig;
                    final /* synthetic */ File $destDir;
                    final /* synthetic */ LibraryExtension $this_registerGitExtractTask;
                    {
                        this.$srcConfig = $srcConfig;
                        this.$destDir = $destDir;
                        this.$this_registerGitExtractTask = $receiver;
                    }

                    public final void execute(@NotNull Task $this$add) {
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        $this$add.getProject().exec(new Action(this.$destDir, this.$this_registerGitExtractTask, this.$srcConfig){
                            final /* synthetic */ File $destDir;
                            final /* synthetic */ LibraryExtension $this_registerGitExtractTask;
                            final /* synthetic */ GitSourceConfig $srcConfig;
                            {
                                this.$destDir = $destDir;
                                this.$this_registerGitExtractTask = $receiver;
                                this.$srcConfig = $srcConfig;
                            }

                            public final void execute(@NotNull ExecSpec $this$exec) {
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                $this$exec.setWorkingDir(this.$destDir);
                                Object[] objectArray = new Object[6];
                                LibraryExtension this_$iv = this.$this_registerGitExtractTask;
                                boolean $i$f$getBinaries = false;
                                objectArray[0] = BinaryPluginKt.getBinariesExtension(this_$iv.getProject()).getGitBinary();
                                objectArray[1] = "fetch";
                                objectArray[2] = "--depth";
                                objectArray[3] = "1";
                                objectArray[4] = "origin";
                                objectArray[5] = this.$srcConfig.getCommit();
                                $this$exec.commandLine(objectArray);
                                List list = $this$exec.getCommandLine();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                                System.out.println((Object)("running: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
                            }
                        });
                        System.out.println((Object)("checking out commit:" + this.$srcConfig.getCommit() + " in " + this.$destDir));
                    }
                });
                $this$register.getActions().add(new Action(destDir, this.$this_registerGitExtractTask, this.$srcConfig){
                    final /* synthetic */ File $destDir;
                    final /* synthetic */ LibraryExtension $this_registerGitExtractTask;
                    final /* synthetic */ GitSourceConfig $srcConfig;
                    {
                        this.$destDir = $destDir;
                        this.$this_registerGitExtractTask = $receiver;
                        this.$srcConfig = $srcConfig;
                    }

                    public final void execute(@NotNull Task $this$add) {
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        $this$add.getProject().exec(new Action(this.$destDir, this.$this_registerGitExtractTask, this.$srcConfig){
                            final /* synthetic */ File $destDir;
                            final /* synthetic */ LibraryExtension $this_registerGitExtractTask;
                            final /* synthetic */ GitSourceConfig $srcConfig;
                            {
                                this.$destDir = $destDir;
                                this.$this_registerGitExtractTask = $receiver;
                                this.$srcConfig = $srcConfig;
                            }

                            public final void execute(@NotNull ExecSpec $this$exec) {
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                $this$exec.setWorkingDir(this.$destDir);
                                Object[] objectArray = new Object[3];
                                LibraryExtension this_$iv = this.$this_registerGitExtractTask;
                                boolean $i$f$getBinaries = false;
                                objectArray[0] = BinaryPluginKt.getBinariesExtension(this_$iv.getProject()).getGitBinary();
                                objectArray[1] = "checkout";
                                objectArray[2] = this.$srcConfig.getCommit();
                                $this$exec.commandLine(objectArray);
                                List list = $this$exec.getCommandLine();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                                System.out.println((Object)("running: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
                            }
                        });
                    }
                });
            }
        });
    }

    public static final void registerArchiveDownloadTask(@NotNull LibraryExtension $this$registerArchiveDownloadTask) {
        Intrinsics.checkNotNullParameter((Object)$this$registerArchiveDownloadTask, (String)"<this>");
        $this$registerArchiveDownloadTask.getProject().getTasks().register($this$registerArchiveDownloadTask.getDownloadSourcesTaskName(), Exec.class, new Action($this$registerArchiveDownloadTask){
            final /* synthetic */ LibraryExtension $this_registerArchiveDownloadTask;
            {
                this.$this_registerArchiveDownloadTask = $receiver;
            }

            public final void execute(@NotNull Exec $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("xtras");
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                File downloadsDir = XtrasKt.getXtrasDownloadsDir(project);
                String string = this.$this_registerArchiveDownloadTask.getSourceURL();
                Intrinsics.checkNotNull((Object)string);
                File outputFile = FilesKt.resolve((File)downloadsDir, (String)StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null));
                TaskInputsInternal taskInputsInternal = $this$register.getInputs();
                String string2 = this.$this_registerArchiveDownloadTask.getSourceURL();
                Intrinsics.checkNotNull((Object)string2);
                taskInputsInternal.property("url", (Object)string2);
                $this$register.getOutputs().file((Object)outputFile);
                $this$register.setEnabled(!outputFile.exists());
                $this$register.doFirst(new Action(downloadsDir, $this$register){
                    final /* synthetic */ File $downloadsDir;
                    final /* synthetic */ Exec $this_register;
                    {
                        this.$downloadsDir = $downloadsDir;
                        this.$this_register = $this_register;
                    }

                    public final void execute(@NotNull Task $this$doFirst) {
                        Intrinsics.checkNotNullParameter((Object)$this$doFirst, (String)"$this$doFirst");
                        if (!this.$downloadsDir.exists()) {
                            this.$downloadsDir.mkdirs();
                        }
                        List list = this.$this_register.getCommandLine();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                        System.out.println((Object)("running: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
                    }
                });
                Object[] objectArray = new Object[6];
                LibraryExtension this_$iv = this.$this_registerArchiveDownloadTask;
                boolean $i$f$getBinaries = false;
                objectArray[0] = BinaryPluginKt.getBinariesExtension(this_$iv.getProject()).getWgetBinary();
                objectArray[1] = "-q";
                objectArray[2] = "-c";
                objectArray[3] = $this$register.getInputs().getProperties().get("url");
                objectArray[4] = "-P";
                objectArray[5] = outputFile.getParent();
                $this$register.commandLine(objectArray);
            }
        });
    }

    public static final void registerArchiveExtractTask(@NotNull LibraryExtension $this$registerArchiveExtractTask, @NotNull ArchiveSourceConfig srcConfig, @NotNull KonanTarget konanTarget) {
        Intrinsics.checkNotNullParameter((Object)$this$registerArchiveExtractTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)srcConfig, (String)"srcConfig");
        Intrinsics.checkNotNullParameter((Object)konanTarget, (String)"konanTarget");
        $this$registerArchiveExtractTask.getProject().getTasks().register($this$registerArchiveExtractTask.extractSourcesTaskName(konanTarget), Exec.class, new Action($this$registerArchiveExtractTask, konanTarget, srcConfig){
            final /* synthetic */ LibraryExtension $this_registerArchiveExtractTask;
            final /* synthetic */ KonanTarget $konanTarget;
            final /* synthetic */ ArchiveSourceConfig $srcConfig;
            {
                this.$this_registerArchiveExtractTask = $receiver;
                this.$konanTarget = $konanTarget;
                this.$srcConfig = $srcConfig;
            }

            public final void execute(@NotNull Exec $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("xtras");
                Object[] objectArray = new Object[]{LibraryExtension.downloadArchiveTaskName$default(this.$this_registerArchiveExtractTask, this.$konanTarget, null, 2, null)};
                $this$register.mustRunAfter(objectArray);
                objectArray = new Object[]{this.$this_registerArchiveExtractTask.getDownloadSourcesTaskName()};
                $this$register.dependsOn(objectArray);
                File destDir = (File)this.$this_registerArchiveExtractTask.getSourcesDir().invoke((Object)this.$konanTarget);
                FileCollection fileCollection = $this$register.getProject().getTasks().getAt(this.$this_registerArchiveExtractTask.getDownloadSourcesTaskName()).getOutputs().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"project.tasks.getAt(down\u2026esTaskName).outputs.files");
                File archiveFile = (File)CollectionsKt.first((Iterable)((Iterable)fileCollection));
                $this$register.getInputs().file((Object)archiveFile);
                $this$register.getOutputs().dir((Object)destDir);
                $this$register.doFirst(new Action(archiveFile, destDir, $this$register){
                    final /* synthetic */ File $archiveFile;
                    final /* synthetic */ File $destDir;
                    final /* synthetic */ Exec $this_register;
                    {
                        this.$archiveFile = $archiveFile;
                        this.$destDir = $destDir;
                        this.$this_register = $this_register;
                    }

                    public final void execute(@NotNull Task $this$doFirst) {
                        Intrinsics.checkNotNullParameter((Object)$this$doFirst, (String)"$this$doFirst");
                        Project project = $this$doFirst.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                        LoggingKt.log$default(project, "extracting " + this.$archiveFile + " to " + this.$destDir, null, 2, null);
                        Project project2 = $this$doFirst.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                        List list = this.$this_register.getCommandLine();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                        LoggingKt.log$default(project2, "running: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, 2, null);
                    }
                });
                $this$register.workingDir((Object)destDir);
                Object[] objectArray2 = new String[3];
                objectArray2[0] = "tar";
                objectArray2[1] = this.$srcConfig.getTarExtractOptions();
                Intrinsics.checkNotNullExpressionValue((Object)archiveFile.getAbsolutePath(), (String)"archiveFile.absolutePath");
                List cmdLine = CollectionsKt.mutableListOf((Object[])objectArray2);
                if (this.$srcConfig.getStripTopDir()) {
                    ((Collection)cmdLine).add("--strip-components=1");
                }
                $this$register.commandLine((Iterable)cmdLine);
            }
        });
    }
}

