/*
 * Decompiled with CFR 0.152.
 */
package org.kaikikm.threadresloader;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import org.kaikikm.threadresloader.AccessibleURLClassLoader;

public final class ResourceLoader {
    private static final InheritableThreadLocal<AccessibleURLClassLoader> CLASS_LOADER = new InheritableThreadLocal<AccessibleURLClassLoader>(){

        @Override
        protected AccessibleURLClassLoader initialValue() {
            return new AccessibleURLClassLoader();
        }

        @Override
        protected AccessibleURLClassLoader childValue(AccessibleURLClassLoader parentValue) {
            return new AccessibleURLClassLoader(parentValue);
        }
    };

    private ResourceLoader() {
    }

    public static void setDefault() {
        CLASS_LOADER.set(new AccessibleURLClassLoader());
    }

    public static void setURLs(URL ... urls) {
        CLASS_LOADER.set(new AccessibleURLClassLoader(urls));
    }

    public static void setURLs(Collection<URL> urls) {
        ResourceLoader.setURLs(urls.toArray(new URL[0]));
    }

    public static void injectURLs(URL ... urls) {
        CLASS_LOADER.set(new AccessibleURLClassLoader((ClassLoader)CLASS_LOADER.get(), urls));
    }

    public static void injectURLs(Collection<URL> urls) {
        ResourceLoader.injectURLs(urls.toArray(new URL[0]));
    }

    public static URL getResource(String path) {
        return ((AccessibleURLClassLoader)CLASS_LOADER.get()).getResource(path);
    }

    public static InputStream getResourceAsStream(String path) {
        return ((AccessibleURLClassLoader)CLASS_LOADER.get()).getResourceAsStream(path);
    }

    public static void addURL(URL url) {
        ((AccessibleURLClassLoader)CLASS_LOADER.get()).addURL(url);
    }

    public static ClassLoader getClassLoader() {
        return (ClassLoader)CLASS_LOADER.get();
    }

    public static Class<?> classForName(String name) throws ClassNotFoundException {
        return ResourceLoader.classForName(name, true);
    }

    public static Class<?> classForName(String name, boolean initialize) throws ClassNotFoundException {
        return Class.forName(name, initialize, (ClassLoader)CLASS_LOADER.get());
    }
}

