/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCloud;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Tag;
import org.dasein.cloud.Taggable;
import org.dasein.cloud.aws.EC2Provider;
import org.dasein.cloud.aws.RegionsAndZones;
import org.dasein.cloud.aws.admin.AWSAdminServices;
import org.dasein.cloud.aws.compute.EC2ComputeServices;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.aws.identity.AWSIdentityServices;
import org.dasein.cloud.aws.network.EC2NetworkServices;
import org.dasein.cloud.aws.platform.AWSPlatformServices;
import org.dasein.cloud.aws.storage.AWSCloudStorageServices;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.storage.BlobStoreSupport;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AWSCloud
extends AbstractCloud {
    private static final Logger logger = AWSCloud.getLogger(AWSCloud.class);
    public static final String P_ACCESS = "AWSAccessKeyId";
    public static final String P_ACTION = "Action";
    public static final String P_CFAUTH = "Authorization";
    public static final String P_AWS_DATE = "x-amz-date";
    public static final String P_GOOG_DATE = "x-goog-date";
    public static final String P_SIGNATURE = "Signature";
    public static final String P_SIGNATURE_METHOD = "SignatureMethod";
    public static final String P_SIGNATURE_VERSION = "SignatureVersion";
    public static final String P_TIMESTAMP = "Timestamp";
    public static final String P_VERSION = "Version";
    public static final String CLOUD_FRONT_ALGORITHM = "HmacSHA1";
    public static final String EC2_ALGORITHM = "HmacSHA256";
    public static final String S3_ALGORITHM = "HmacSHA1";
    public static final String SIGNATURE = "2";
    private volatile transient EC2Provider provider;

    private static String getLastItem(String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    public static Logger getLogger(Class<?> cls) {
        String pkg = AWSCloud.getLastItem(cls.getPackage().getName());
        pkg = pkg.equals("aws") ? "" : pkg + ".";
        return Logger.getLogger((String)("dasein.cloud.aws.std." + pkg + AWSCloud.getLastItem(cls.getName())));
    }

    public static Logger getWireLogger(Class<?> cls) {
        return Logger.getLogger((String)("dasein.cloud.aws.wire." + AWSCloud.getLastItem(cls.getPackage().getName()) + "." + AWSCloud.getLastItem(cls.getName())));
    }

    public static String encode(String value, boolean encodePath) throws InternalException {
        String encoded;
        try {
            encoded = URLEncoder.encode(value, "utf-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            if (encodePath) {
                encoded = encoded.replace("%2F", "/");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        return encoded;
    }

    public static String escapeXml(String nonxml) {
        StringBuilder str = new StringBuilder();
        block9: for (int i = 0; i < nonxml.length(); ++i) {
            char c = nonxml.charAt(i);
            switch (c) {
                case '&': {
                    str.append("&amp;");
                    continue block9;
                }
                case '>': {
                    str.append("&gt;");
                    continue block9;
                }
                case '<': {
                    str.append("&lt;");
                    continue block9;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block9;
                }
                case '[': {
                    str.append("&#091;");
                    continue block9;
                }
                case ']': {
                    str.append("&#093;");
                    continue block9;
                }
                case '!': {
                    str.append("&#033;");
                    continue block9;
                }
                default: {
                    str.append(c);
                }
            }
        }
        return str.toString();
    }

    private String buildEc2AuthString(String method, String serviceUrl, Map<String, String> parameters) throws InternalException {
        URI endpoint;
        StringBuilder authString = new StringBuilder();
        authString.append(method);
        authString.append("\n");
        try {
            endpoint = new URI(serviceUrl);
        }
        catch (URISyntaxException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        authString.append(endpoint.getHost().toLowerCase());
        authString.append("\n");
        String tmp = endpoint.getPath();
        if (tmp == null || tmp.length() == 0) {
            tmp = "/";
        }
        authString.append(AWSCloud.encode(tmp, true));
        authString.append("\n");
        TreeSet<String> sortedKeys = new TreeSet<String>();
        sortedKeys.addAll(parameters.keySet());
        boolean first = true;
        for (String key : sortedKeys) {
            String value = parameters.get(key);
            if (!first) {
                authString.append("&");
            } else {
                first = false;
            }
            authString.append(AWSCloud.encode(key, false));
            authString.append("=");
            authString.append(AWSCloud.encode(value, false));
        }
        return authString.toString();
    }

    public boolean createTags(String resourceId, Tag ... keyValuePairs) {
        try {
            Map<String, String> parameters = this.getStandardParameters(this.getContext(), "CreateTags");
            parameters.put("ResourceId.1", resourceId);
            for (int i = 0; i < keyValuePairs.length; ++i) {
                String key = keyValuePairs[i].getKey();
                String value = keyValuePairs[i].getValue();
                parameters.put("Tag." + i + ".Key", key);
                parameters.put("Tag." + i + ".Value", value);
            }
            EC2Method method = new EC2Method(this, this.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                String code = e.getCode();
                if (code != null && code.equals("InvalidInstanceID.NotFound")) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    parameters = this.getStandardParameters(this.getContext(), "CreateTags");
                    parameters.put("ResourceId.1", resourceId);
                    for (int i = 0; i < keyValuePairs.length; ++i) {
                        String key = keyValuePairs[i].getKey();
                        String value = keyValuePairs[i].getValue();
                        parameters.put("Tag." + i + ".Key", key);
                        parameters.put("Tag." + i + ".Value", value);
                    }
                    method = new EC2Method(this, this.getEc2Url(), parameters);
                    try {
                        method.invoke();
                        return true;
                    }
                    catch (EC2Exception ignore) {
                        // empty catch block
                    }
                }
                logger.error((Object)("EC2 error settings tags for " + resourceId + ": " + e.getSummary()));
                return false;
            }
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public AWSAdminServices getAdminServices() {
        EC2Provider p = this.getEC2Provider();
        if (p.isAWS() || p.isEnStratus() || p.isOpenStack() || p.isEucalyptus()) {
            return new AWSAdminServices(this);
        }
        return null;
    }

    @Nonnull
    private String[] getBootstrapUrls(@Nullable ProviderContext ctx) {
        String second;
        String endpoint;
        String string = endpoint = ctx == null ? null : ctx.getEndpoint();
        if (endpoint == null) {
            return new String[0];
        }
        if (!endpoint.contains(",")) {
            return new String[]{endpoint};
        }
        String[] endpoints = endpoint.split(",");
        if (endpoints == null) {
            endpoints = new String[]{};
        }
        if (endpoints.length > 1 && !(second = endpoints[1]).startsWith("http") && endpoints[0].startsWith("http")) {
            return new String[]{endpoint + (this.getEC2Provider().isEucalyptus() ? "/Eucalyptus" : "")};
        }
        for (int i = 0; i < endpoints.length; ++i) {
            if (endpoints[i].startsWith("http")) continue;
            endpoints[i] = "https://" + endpoints[i] + (this.getEC2Provider().isEucalyptus() ? "/Eucalyptus" : "");
        }
        return endpoints;
    }

    @Nonnull
    public String getCloudName() {
        ProviderContext ctx = this.getContext();
        String name = ctx == null ? null : ctx.getCloudName();
        return name == null ? "AWS" : name;
    }

    public EC2ComputeServices getComputeServices() {
        if (this.getEC2Provider().isStorage()) {
            return null;
        }
        return new EC2ComputeServices(this);
    }

    @Nonnull
    public RegionsAndZones getDataCenterServices() {
        return new RegionsAndZones(this);
    }

    @Nonnull
    public EC2Provider getEC2Provider() {
        if (this.provider == null) {
            this.provider = EC2Provider.valueOf(this.getProviderName());
        }
        return this.provider;
    }

    @Nullable
    public String getEc2Url() throws InternalException, CloudException {
        ProviderContext ctx = this.getContext();
        String url = this.getEc2Url(ctx == null ? null : ctx.getRegionId());
        if (this.getEC2Provider().isEucalyptus()) {
            return url + "/Eucalyptus";
        }
        return url;
    }

    @Nullable
    String getEc2Url(@Nullable String regionId) throws InternalException, CloudException {
        String url;
        ProviderContext ctx = this.getContext();
        if (regionId == null) {
            return this.getBootstrapUrls(ctx)[0];
        }
        if (this.getEC2Provider().isAWS()) {
            String url2;
            String string = url2 = ctx == null ? null : ctx.getEndpoint();
            if (url2 != null && url2.endsWith("amazonaws.com")) {
                return "https://ec2." + regionId + ".amazonaws.com";
            }
            return "https://ec2." + regionId + ".amazonaws.com";
        }
        if (!this.getEC2Provider().isEucalyptus()) {
            String url3;
            String string = url3 = ctx == null ? null : ctx.getEndpoint();
            if (url3 == null) {
                return null;
            }
            if (!url3.startsWith("http")) {
                String cloudUrl = ctx.getEndpoint();
                if (cloudUrl != null && cloudUrl.startsWith("http:")) {
                    return "http://" + url3 + "/" + regionId;
                }
                return "https://" + url3 + "/" + regionId;
            }
            return url3 + "/" + regionId;
        }
        String string = url = ctx == null ? null : ctx.getEndpoint();
        if (url == null) {
            return null;
        }
        if (!url.startsWith("http")) {
            String cloudUrl = ctx.getEndpoint();
            if (cloudUrl != null && cloudUrl.startsWith("http:")) {
                return "http://" + url;
            }
            return "https://" + url;
        }
        return url;
    }

    public String getAutoScaleVersion() {
        return "2009-05-15";
    }

    public String getCloudWatchVersion() {
        return "2010-08-01";
    }

    public String getEc2Version() {
        if (this.getEC2Provider().isAWS()) {
            return "2012-07-20";
        }
        if (this.getEC2Provider().isEucalyptus()) {
            return "2010-11-15";
        }
        if (this.getEC2Provider().isOpenStack()) {
            return "2009-11-30";
        }
        return "2012-07-20";
    }

    public String getElbVersion() {
        return "2009-05-15";
    }

    public String getRdsVersion() {
        return "2011-04-01";
    }

    public String getRoute53Version() {
        return "2010-10-01";
    }

    public String getSdbVersion() {
        return "2009-04-15";
    }

    public String getSnsVersion() {
        return "2010-03-31";
    }

    public String getSqsVersion() {
        return "2009-02-01";
    }

    public AWSIdentityServices getIdentityServices() {
        if (this.getEC2Provider().isStorage()) {
            return null;
        }
        return new AWSIdentityServices(this);
    }

    public EC2NetworkServices getNetworkServices() {
        if (this.getEC2Provider().isStorage()) {
            return null;
        }
        return new EC2NetworkServices(this);
    }

    @Nullable
    public AWSPlatformServices getPlatformServices() {
        EC2Provider p = this.getEC2Provider();
        if (p.isAWS() || p.isEnStratus()) {
            return new AWSPlatformServices(this);
        }
        return null;
    }

    @Nonnull
    public String getProviderName() {
        ProviderContext ctx = this.getContext();
        String name = ctx == null ? null : ctx.getProviderName();
        return name == null ? EC2Provider.AWS.getName() : name;
    }

    @Nullable
    public String getProxyHost() {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            return null;
        }
        Properties props = ctx.getCustomProperties();
        return props == null ? null : props.getProperty("proxyHost");
    }

    public int getProxyPort() {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            return -1;
        }
        Properties props = ctx.getCustomProperties();
        if (props == null) {
            return -1;
        }
        String port = props.getProperty("proxyPort");
        if (port != null) {
            return Integer.parseInt(port);
        }
        return -1;
    }

    @Nonnull
    public AWSCloudStorageServices getStorageServices() {
        return new AWSCloudStorageServices(this);
    }

    public Map<String, String> getStandardParameters(ProviderContext ctx, String action) throws InternalException {
        return this.getStandardParameters(ctx, action, this.getEc2Version());
    }

    public Map<String, String> getStandardParameters(ProviderContext ctx, String action, String version) throws InternalException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(P_ACTION, action);
        parameters.put(P_SIGNATURE_VERSION, SIGNATURE);
        try {
            parameters.put(P_ACCESS, new String(ctx.getAccessPublic(), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        parameters.put(P_SIGNATURE_METHOD, EC2_ALGORITHM);
        parameters.put(P_TIMESTAMP, this.getTimestamp(System.currentTimeMillis(), true));
        parameters.put(P_VERSION, version);
        return parameters;
    }

    public Map<String, String> getStandardCloudWatchParameters(ProviderContext ctx, String action) throws InternalException {
        Map<String, String> parameters = this.getStandardParameters(ctx, action);
        parameters.put(P_VERSION, this.getCloudWatchVersion());
        return parameters;
    }

    public Map<String, String> getStandardRdsParameters(ProviderContext ctx, String action) throws InternalException {
        Map<String, String> parameters = this.getStandardParameters(ctx, action);
        parameters.put(P_VERSION, this.getRdsVersion());
        return parameters;
    }

    public Map<String, String> getStandardSimpleDBParameters(ProviderContext ctx, String action) throws InternalException {
        Map<String, String> parameters = this.getStandardParameters(ctx, action);
        parameters.put(P_VERSION, this.getSdbVersion());
        return parameters;
    }

    public Map<String, String> getStandardSnsParameters(ProviderContext ctx, String action) throws InternalException {
        Map<String, String> parameters = this.getStandardParameters(ctx, action);
        parameters.put(P_VERSION, this.getSnsVersion());
        return parameters;
    }

    public Map<String, String> getStandardSqsParameters(ProviderContext ctx, String action) throws InternalException {
        Map<String, String> parameters = this.getStandardParameters(ctx, action);
        parameters.put(P_VERSION, this.getSqsVersion());
        return parameters;
    }

    @Nonnull
    public String getTimestamp(long timestamp, boolean withMillis) {
        SimpleDateFormat fmt = withMillis ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return fmt.format(new Date(timestamp));
    }

    public long parseTime(@Nullable String time) throws CloudException {
        if (time == null) {
            return 0L;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        if (time.length() > 0) {
            try {
                return fmt.parse(time).getTime();
            }
            catch (ParseException e) {
                fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                try {
                    return fmt.parse(time).getTime();
                }
                catch (ParseException encore) {
                    throw new CloudException("Could not parse date: " + time);
                }
            }
        }
        return 0L;
    }

    private String sign(byte[] key, String authString, String algorithm) throws InternalException {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return new String(Base64.encodeBase64((byte[])mac.doFinal(authString.getBytes("utf-8"))));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        catch (IllegalStateException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
    }

    public String signUploadPolicy(String base64Policy) throws InternalException {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            throw new InternalException("No context for signing the request");
        }
        return this.sign(ctx.getAccessPrivate(), base64Policy, "HmacSHA1");
    }

    public String signCloudFront(String accessKey, byte[] secretKey, String dateString) throws InternalException {
        String signature = this.sign(secretKey, dateString, "HmacSHA1");
        if (this.getEC2Provider().isStorage() && "google".equalsIgnoreCase(this.getProviderName())) {
            return "GOOG1 " + accessKey + ":" + signature;
        }
        return "AWS " + accessKey + ":" + signature;
    }

    public String signEc2(byte[] key, String serviceUrl, Map<String, String> parameters) throws InternalException {
        return this.sign(key, this.buildEc2AuthString("POST", serviceUrl, parameters), EC2_ALGORITHM);
    }

    public String signAWS3(String keyId, byte[] key, String dateString) throws InternalException {
        return "AWS3-HTTPS AWSAccessKeyId=" + keyId + ",Algorithm=" + EC2_ALGORITHM + ",Signature=" + this.sign(key, dateString, EC2_ALGORITHM);
    }

    public String signS3(String accessKey, byte[] secretKey, String action, String hash, String contentType, Map<String, String> headers, String bucket, String object) throws InternalException {
        StringBuilder toSign = new StringBuilder();
        toSign.append(action);
        toSign.append("\n");
        if (hash != null) {
            toSign.append(hash);
        }
        toSign.append("\n");
        if (contentType != null) {
            toSign.append(contentType);
        }
        toSign.append("\n\n");
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(headers.keySet());
        Collections.sort(keys);
        for (String hkey : keys) {
            String val;
            if (!hkey.startsWith("x-amz") && (!this.getEC2Provider().isStorage() || !hkey.startsWith("x-goog")) || (val = headers.get(hkey)) == null) continue;
            toSign.append(hkey);
            toSign.append(":");
            toSign.append(headers.get(hkey).trim());
            toSign.append("\n");
        }
        toSign.append("/");
        if (this.getEC2Provider().isEucalyptus()) {
            toSign.append("services/Walrus/");
        }
        if (bucket != null) {
            toSign.append(bucket);
            toSign.append("/");
        }
        if (object != null) {
            toSign.append(object.toLowerCase());
        }
        String signature = this.sign(secretKey, toSign.toString(), "HmacSHA1");
        if (this.getEC2Provider().isStorage() && "google".equalsIgnoreCase(this.getProviderName())) {
            return "GOOG1 " + accessKey + ":" + signature;
        }
        return "AWS " + accessKey + ":" + signature;
    }

    public String testContext() {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            logger.warn((Object)"No context exists for testing");
            return null;
        }
        try {
            EC2ComputeServices compute = this.getComputeServices();
            if (compute != null) {
                VirtualMachineSupport support = compute.getVirtualMachineSupport();
                if (support == null || !support.isSubscribed()) {
                    logger.warn((Object)"Not subscribed to virtual machine support");
                    return null;
                }
            } else {
                AWSCloudStorageServices storage = this.getStorageServices();
                BlobStoreSupport support = storage.getBlobStoreSupport();
                if (support == null || !support.isSubscribed()) {
                    logger.warn((Object)"No subscribed to storage services");
                    return null;
                }
            }
        }
        catch (Throwable t) {
            logger.warn((Object)("Unable to connect to AWS for " + ctx.getAccountNumber() + ": " + t.getMessage()));
            return null;
        }
        return ctx.getAccountNumber();
    }

    public void setTags(@Nonnull Node attr, @Nonnull Taggable item) {
        if (attr.hasChildNodes()) {
            NodeList tags = attr.getChildNodes();
            for (int j = 0; j < tags.getLength(); ++j) {
                Node tag = tags.item(j);
                if (!tag.getNodeName().equals("item") || !tag.hasChildNodes()) continue;
                NodeList parts = tag.getChildNodes();
                String key = null;
                String value = null;
                for (int k = 0; k < parts.getLength(); ++k) {
                    Node part = parts.item(k);
                    if (part.getNodeName().equalsIgnoreCase("key")) {
                        if (!part.hasChildNodes()) continue;
                        key = part.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (!part.getNodeName().equalsIgnoreCase("value") || !part.hasChildNodes()) continue;
                    value = part.getFirstChild().getNodeValue().trim();
                }
                if (key == null || value == null) continue;
                item.setTag(key, value);
            }
        }
    }
}

