/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RegionsAndZones
implements DataCenterServices {
    private static final Logger logger = Logger.getLogger(RegionsAndZones.class);
    public static final String DESCRIBE_AVAILABILITY_ZONES = "DescribeAvailabilityZones";
    public static final String DESCRIBE_REGIONS = "DescribeRegions";
    private AWSCloud provider = null;
    private String oneRegionId;
    private String oneZoneId;

    RegionsAndZones(AWSCloud provider) {
        this.provider = provider;
        if (provider.getEC2Provider().isStorage() && "google".equalsIgnoreCase(provider.getProviderName())) {
            this.oneRegionId = "us";
            this.oneZoneId = "us1";
        } else {
            this.oneRegionId = "region-1";
            this.oneZoneId = "zone-1";
        }
    }

    @Nonnull
    private DataCenter getZone() {
        DataCenter dc = new DataCenter();
        dc.setActive(true);
        dc.setAvailable(true);
        dc.setName(this.oneZoneId);
        dc.setProviderDataCenterId(this.oneZoneId);
        dc.setRegionId(this.oneRegionId);
        return dc;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public DataCenter getDataCenter(@Nonnull String zoneId) throws InternalException, CloudException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getProviderTermForDataCenter(Locale locale) {
        return "availability zone";
    }

    public String getProviderTermForRegion(Locale locale) {
        return "region";
    }

    @Nonnull
    private Region getRegion() {
        Region region = new Region();
        region.setActive(true);
        region.setAvailable(true);
        region.setJurisdiction("US");
        region.setName(this.oneRegionId);
        region.setProviderRegionId(this.oneRegionId);
        return region;
    }

    /*
     * Exception decompiling
     */
    public Region getRegion(String regionId) throws InternalException, CloudException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DataCenter> listDataCenters(String regionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listDataCenters");
        try {
            Document doc;
            ArrayList<DataCenter> dataCenters;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            Cache cache = null;
            if (regionId.equals(ctx.getRegionId()) && (dataCenters = (ArrayList<DataCenter>)(cache = Cache.getInstance((CloudProvider)this.provider, (String)"dataCenters", DataCenter.class, (CacheLevel)CacheLevel.REGION_ACCOUNT)).get(ctx)) != null) {
                ArrayList<DataCenter> arrayList = dataCenters;
                return arrayList;
            }
            if (this.provider.getEC2Provider().isStorage()) {
                if (regionId.equals(this.oneRegionId)) {
                    List<DataCenter> list = Collections.singletonList(this.getZone());
                    return list;
                }
                throw new CloudException("No such region: " + regionId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), DESCRIBE_AVAILABILITY_ZONES);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            dataCenters = new ArrayList<DataCenter>();
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("availabilityZoneInfo");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList zones = blocks.item(i).getChildNodes();
                for (int j = 0; j < zones.getLength(); ++j) {
                    Node region = zones.item(j);
                    if (!region.getNodeName().equals("item")) continue;
                    dataCenters.add(this.toDataCenter(regionId, zones.item(j)));
                }
            }
            if (cache != null) {
                cache.put(ctx, dataCenters);
            }
            ArrayList<DataCenter> arrayList = dataCenters;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Region> listRegions() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listRegions");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)"regions", Region.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT);
            ArrayList<Region> regions = (ArrayList<Region>)cache.get(ctx);
            if (regions != null) {
                ArrayList<Region> arrayList = regions;
                return arrayList;
            }
            if (this.provider.getEC2Provider().isStorage()) {
                List<Region> list = Collections.singletonList(this.getRegion());
                return list;
            }
            regions = new ArrayList<Region>();
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), DESCRIBE_REGIONS);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                e.printStackTrace();
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("regionInfo");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList nodes = blocks.item(i).getChildNodes();
                for (int j = 0; j < nodes.getLength(); ++j) {
                    Node region = nodes.item(j);
                    if (!region.getNodeName().equals("item")) continue;
                    Region r = this.toRegion(nodes.item(j));
                    if (this.provider.getEC2Provider().isEucalyptus()) {
                        if (!r.getProviderRegionId().equalsIgnoreCase("eucalyptus")) continue;
                        regions.add(r);
                        continue;
                    }
                    regions.add(r);
                }
            }
            cache.put(ctx, regions);
            ArrayList<Region> arrayList = regions;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> mapRegions(String url) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"mapRegions");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), DESCRIBE_REGIONS);
            HashMap<String, String> results = new HashMap<String, String>();
            EC2Method method = new EC2Method(this.provider, url, parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("regionInfo");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList regions = blocks.item(i).getChildNodes();
                for (int j = 0; j < regions.getLength(); ++j) {
                    Node region = regions.item(j);
                    if (!region.getNodeName().equals("item")) continue;
                    NodeList data = region.getChildNodes();
                    String name = null;
                    String endpoint = null;
                    for (int k = 0; k < data.getLength(); ++k) {
                        Node item = data.item(k);
                        if (item.getNodeName().equals("regionName")) {
                            name = item.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (!item.getNodeName().equals("regionEndpoint")) continue;
                        endpoint = item.getFirstChild().getNodeValue();
                    }
                    if (name == null || endpoint == null) continue;
                    logger.debug((Object)(name + "=" + endpoint));
                    results.put(name, endpoint);
                }
            }
            HashMap<String, String> hashMap = results;
            return hashMap;
        }
        finally {
            APITrace.end();
        }
    }

    private DataCenter toDataCenter(String regionId, Node zone) throws CloudException {
        NodeList data = zone.getChildNodes();
        DataCenter dc = new DataCenter();
        dc.setActive(true);
        dc.setAvailable(false);
        dc.setRegionId(regionId);
        for (int i = 0; i < data.getLength(); ++i) {
            String value;
            Node item = data.item(i);
            String name = item.getNodeName();
            if (name.equals("zoneName")) {
                value = item.getFirstChild().getNodeValue().trim();
                dc.setName(value);
                dc.setProviderDataCenterId(value);
                continue;
            }
            if (name.equals("zoneState")) {
                value = item.getFirstChild().getNodeValue();
                if (!this.provider.getEC2Provider().isAWS()) {
                    dc.setAvailable(true);
                    continue;
                }
                dc.setAvailable(value != null && value.trim().equalsIgnoreCase("available"));
                continue;
            }
            if (!name.equals("regionName") || !item.hasChildNodes() || (value = item.getFirstChild().getNodeValue()) == null) continue;
            dc.setRegionId(value.trim());
        }
        if (dc.getName() == null) {
            throw new CloudException("Availability zone info is incomplete for " + dc.getProviderDataCenterId() + ".");
        }
        return dc;
    }

    private Region toRegion(Node region) throws CloudException {
        String name = null;
        String endpoint = null;
        NodeList data = region.getChildNodes();
        for (int i = 0; i < data.getLength(); ++i) {
            Node item = data.item(i);
            if (item.getNodeName().equals("regionName")) {
                name = item.getFirstChild().getNodeValue();
                continue;
            }
            if (!item.getNodeName().equals("regionEndpoint")) continue;
            endpoint = item.getFirstChild().getNodeValue();
        }
        if (name == null || endpoint == null) {
            throw new CloudException("Invalid region data.");
        }
        Region r = new Region();
        r.setActive(true);
        r.setAvailable(true);
        r.setName(name);
        r.setProviderRegionId(name);
        if (name.startsWith("eu")) {
            r.setJurisdiction("EU");
        } else if (name.startsWith("ap-northeast")) {
            r.setJurisdiction("JP");
        } else if (name.startsWith("ap-southeast")) {
            if (name.equals("ap-southeast-1")) {
                r.setJurisdiction("SG");
            } else {
                r.setJurisdiction("AU");
            }
        } else if (name.startsWith("sa-east")) {
            r.setJurisdiction("BR");
        } else {
            r.setJurisdiction("US");
        }
        return r;
    }
}

