/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.admin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.admin.Offering;
import org.dasein.cloud.admin.Prepayment;
import org.dasein.cloud.admin.PrepaymentState;
import org.dasein.cloud.admin.PrepaymentSupport;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2ComputeServices;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.identity.ServiceAction;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReservedInstance
implements PrepaymentSupport {
    private static final Logger logger = AWSCloud.getLogger(ReservedInstance.class);
    private static final int SECONDS_IN_DAY = 86400;
    private AWSCloud provider = null;

    ReservedInstance(@Nonnull AWSCloud provider) {
        this.provider = provider;
    }

    @Nullable
    public Offering getOffering(@Nonnull String offeringId) throws InternalException, CloudException {
        Document doc;
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeReservedInstancesOfferings");
        parameters.put("ReservedInstancesOfferingId", offeringId);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidReservedInstancesOfferingId")) {
                return null;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("reservedInstancesOfferingsSet");
        for (int i = 0; i < blocks.getLength(); ++i) {
            NodeList items = blocks.item(i).getChildNodes();
            for (int j = 0; j < items.getLength(); ++j) {
                Offering offering;
                Node item = items.item(j);
                if (!item.getNodeName().equals("item") || (offering = this.toOffering(item)) == null || !offering.getProviderOfferingId().equals(offeringId)) continue;
                return offering;
            }
        }
        return null;
    }

    @Nullable
    public Prepayment getPrepayment(@Nonnull String prepaymentId) throws InternalException, CloudException {
        Document doc;
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeReservedInstances");
        parameters.put("ReservedInstancesId.1", prepaymentId);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidReservedInstancesId")) {
                return null;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("reservedInstancesSet");
        for (int i = 0; i < blocks.getLength(); ++i) {
            NodeList items = blocks.item(i).getChildNodes();
            for (int j = 0; j < items.getLength(); ++j) {
                Prepayment prepayment;
                Node item = items.item(j);
                if (!item.getNodeName().equals("item") || (prepayment = this.toPrepayment(item)) == null || !prepayment.getProviderPrepaymentId().equals(prepaymentId)) continue;
                return prepayment;
            }
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForOffering(@Nonnull Locale locale) {
        return "offering";
    }

    @Nonnull
    public String getProviderTermForPrepayment(@Nonnull Locale locale) {
        return "reserved instance";
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        EC2ComputeServices svc = this.provider.getComputeServices();
        if (svc == null) {
            return false;
        }
        VirtualMachineSupport support = svc.getVirtualMachineSupport();
        return support != null && support.isSubscribed();
    }

    @Nonnull
    public Collection<Offering> listOfferings() throws InternalException, CloudException {
        Document doc;
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeReservedInstancesOfferings");
        ArrayList<Offering> list = new ArrayList<Offering>();
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("reservedInstancesOfferingsSet");
        for (int i = 0; i < blocks.getLength(); ++i) {
            NodeList items = blocks.item(i).getChildNodes();
            for (int j = 0; j < items.getLength(); ++j) {
                Offering offering;
                Node item = items.item(j);
                if (!item.getNodeName().equals("item") || (offering = this.toOffering(item)) == null) continue;
                list.add(offering);
            }
        }
        return list;
    }

    @Nonnull
    public Collection<Prepayment> listPrepayments() throws InternalException, CloudException {
        Document doc;
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeReservedInstances");
        ArrayList<Prepayment> list = new ArrayList<Prepayment>();
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("reservedInstancesSet");
        for (int i = 0; i < blocks.getLength(); ++i) {
            NodeList items = blocks.item(i).getChildNodes();
            for (int j = 0; j < items.getLength(); ++j) {
                Prepayment prepayment;
                Node item = items.item(j);
                if (!item.getNodeName().equals("item") || (prepayment = this.toPrepayment(item)) == null) continue;
                list.add(prepayment);
            }
        }
        return list;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)PrepaymentSupport.ANY)) {
            return new String[]{"ec2:*"};
        }
        if (action.equals((Object)PrepaymentSupport.GET_OFFERING) || action.equals((Object)PrepaymentSupport.LIST_OFFERING)) {
            return new String[]{"ec2:DescribeReservedInstancesOfferings"};
        }
        if (action.equals((Object)PrepaymentSupport.GET_PREPAYMENT) || action.equals((Object)PrepaymentSupport.LIST_PREPAYMENT)) {
            return new String[]{"ec2:DescribeReservedInstances"};
        }
        if (action.equals((Object)PrepaymentSupport.PREPAY)) {
            return new String[]{"ec2:PurchaseReservedInstancesOffering"};
        }
        return new String[0];
    }

    @Nonnull
    public String prepay(@Nonnull String offeringId, @Nonnegative int count) throws InternalException, CloudException {
        Document doc;
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "PurchaseReservedInstancesOffering");
        parameters.put("ReservedInstanceOfferingId.1", offeringId);
        parameters.put("InstanceCount.1", String.valueOf(count));
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("reservedInstancesId");
        if (blocks.getLength() > 0) {
            return blocks.item(0).getFirstChild().getNodeValue().trim();
        }
        throw new CloudException("Unable to identify newly reserved instance");
    }

    @Nullable
    private Offering toOffering(@Nullable Node node) throws CloudException {
        if (node == null) {
            return null;
        }
        Offering offering = new Offering();
        NodeList attrs = node.getChildNodes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("reservedInstancesOfferingId")) {
                offering.setOfferingId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("instanceType")) {
                offering.setSize(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("availabilityZone")) {
                offering.setDataCenterId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("fixedPrice")) {
                double fixedFee = Double.parseDouble(attr.getFirstChild().getNodeValue().trim());
                offering.setFixedFee(fixedFee);
                continue;
            }
            if (name.equals("usagePrice")) {
                double usageFee = Double.parseDouble(attr.getFirstChild().getNodeValue().trim());
                offering.setUsageFee(usageFee);
                continue;
            }
            if (!name.equals("duration")) continue;
            int seconds = Integer.parseInt(attr.getFirstChild().getNodeValue().trim());
            offering.setPeriodInDays(seconds / 86400);
        }
        offering.setCurrencyCode("USD");
        offering.setPlatform(Platform.UNIX);
        offering.setSoftware(null);
        return offering;
    }

    @Nullable
    private Prepayment toPrepayment(@Nullable Node node) throws CloudException {
        if (node == null) {
            return null;
        }
        Prepayment prepayment = new Prepayment();
        NodeList attrs = node.getChildNodes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("reservedInstancesId")) {
                prepayment.setPrepaymentId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("instanceType")) {
                prepayment.setSize(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("availabilityZone")) {
                prepayment.setDataCenterId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("instanceCount")) {
                int count = Integer.parseInt(attr.getFirstChild().getNodeValue().trim());
                prepayment.setCount(count);
                continue;
            }
            if (name.equals("fixedPrice")) {
                double fixedFee = Double.parseDouble(attr.getFirstChild().getNodeValue().trim());
                prepayment.setFixedFee(fixedFee);
                continue;
            }
            if (name.equals("usagePrice")) {
                double usageFee = Double.parseDouble(attr.getFirstChild().getNodeValue().trim());
                prepayment.setUsageFee(usageFee);
                continue;
            }
            if (name.equals("duration")) {
                int seconds = Integer.parseInt(attr.getFirstChild().getNodeValue().trim());
                prepayment.setPeriodInDays(seconds / 86400);
                continue;
            }
            if (name.equals("start")) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                String start = attr.getFirstChild().getNodeValue().trim();
                try {
                    prepayment.setPeriodStartTimestamp(fmt.parse(start).getTime());
                    continue;
                }
                catch (ParseException e) {
                    logger.error((Object)e);
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
            }
            if (!name.equals("state")) continue;
            String state = attr.getFirstChild().getNodeValue().trim();
            if (state.equalsIgnoreCase("active")) {
                prepayment.setPrepaymentState(PrepaymentState.PAID);
                continue;
            }
            if (state.equalsIgnoreCase("payment-failed")) {
                prepayment.setPrepaymentState(PrepaymentState.REJECTED);
                continue;
            }
            if (state.equalsIgnoreCase("retired")) {
                prepayment.setPrepaymentState(PrepaymentState.RETIRED);
                continue;
            }
            prepayment.setPrepaymentState(PrepaymentState.PENDING);
        }
        prepayment.setCurrencyCode("USD");
        prepayment.setPlatform(Platform.UNIX);
        prepayment.setSoftware(null);
        return prepayment;
    }
}

