/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.compute;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.aws.storage.S3Method;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.MachineImageSupport;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.util.APITrace;
import org.dasein.util.Jiterator;
import org.dasein.util.JiteratorPopulator;
import org.dasein.util.PopulatorThread;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMI
implements MachineImageSupport {
    private static final Logger logger = Logger.getLogger(AMI.class);
    private AWSCloud provider = null;
    private static Collection<ImageClass> supportedClasses;
    private static Collection<MachineImageType> supportedTypes;

    AMI(AWSCloud provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageShare(@Nonnull String providerImageId, @Nonnull String accountNumber) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"addImageShare");
        try {
            this.setPrivateShare(providerImageId, true, accountNumber);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPublicShare(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"addPublicShare");
        try {
            this.setPublicShare(providerImageId, true);
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String bundleVirtualMachine(@Nonnull String virtualMachineId, @Nonnull MachineImageFormat format, @Nonnull String bucket, @Nonnull String name) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not yet implemented");
    }

    public void bundleVirtualMachineAsync(@Nonnull String virtualMachineId, @Nonnull MachineImageFormat format, @Nonnull String bucket, @Nonnull String name, @Nonnull AsynchronousTask<String> trackingTask) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not yet implemented");
    }

    @Nonnull
    public MachineImage captureImage(@Nonnull ImageCreateOptions options) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        return this.captureImage(ctx, options, null);
    }

    @Nonnull
    private MachineImage captureImage(@Nonnull ProviderContext ctx, @Nonnull ImageCreateOptions options, @Nullable AsynchronousTask<MachineImage> task) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"captureImage");
        try {
            if (task != null) {
                task.setStartTime(System.currentTimeMillis());
            }
            VirtualMachine vm = null;
            long timeout = System.currentTimeMillis() + 1800000L;
            while (timeout > System.currentTimeMillis()) {
                try {
                    vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(options.getVirtualMachineId());
                    if (vm == null || VmState.TERMINATED.equals((Object)vm.getCurrentState()) || VmState.RUNNING.equals((Object)vm.getCurrentState()) || VmState.STOPPED.equals((Object)vm.getCurrentState())) break;
                    if (!vm.isPersistent() && vm.getPlatform().isWindows()) {
                        String bucket = this.provider.getStorageServices().getBlobStoreSupport().createBucket("dsnwin" + System.currentTimeMillis() % 10000L, true).getBucketName();
                        if (bucket == null) {
                            throw new CloudException("There is no bucket");
                        }
                        MachineImage machineImage = this.captureWindows(this.provider.getContext(), options, bucket, task);
                        return machineImage;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {}
            }
            if (vm == null) {
                throw new CloudException("No such virtual machine: " + options.getVirtualMachineId());
            }
            String lastMessage = null;
            int attempts = 5;
            while (attempts > 0) {
                Document doc;
                Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateImage");
                parameters.put("InstanceId", options.getVirtualMachineId());
                parameters.put("Name", options.getName());
                parameters.put("Description", options.getDescription());
                EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
                NodeList blocks = doc.getElementsByTagName("imageId");
                if (blocks.getLength() > 0) {
                    String errorMessage;
                    Node imageIdNode = blocks.item(0);
                    String id = imageIdNode.getFirstChild().getNodeValue().trim();
                    MachineImage img = this.getImage(id);
                    if (img == null) {
                        for (int i = 0; i < 5; ++i) {
                            try {
                                Thread.sleep(5000L * (long)i);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                            img = this.getImage(id);
                            if (img != null) break;
                        }
                        if (img == null) {
                            throw new CloudException("No image exists for " + id + " as created during the capture process");
                        }
                    }
                    if (MachineImageState.DELETED.equals((Object)img.getCurrentState()) && (errorMessage = (String)img.getTag("stateReason")) != null) {
                        if (errorMessage.contains("try again")) {
                            lastMessage = errorMessage;
                            --attempts;
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException ignore) {}
                            continue;
                        }
                        throw new CloudException(errorMessage);
                    }
                    MachineImage machineImage = img;
                    return machineImage;
                }
                throw new CloudException("No error occurred during imaging, but no machine image was specified");
            }
            if (lastMessage == null) {
                lastMessage = "Unknown error";
            }
            throw new CloudException(lastMessage);
        }
        finally {
            APITrace.end();
        }
    }

    public void captureImageAsync(final @Nonnull ImageCreateOptions options, final @Nonnull AsynchronousTask<MachineImage> taskTracker) throws CloudException, InternalException {
        final ProviderContext ctx = this.provider.getContext();
        VirtualMachine vm = null;
        long timeout = System.currentTimeMillis() + 1800000L;
        while (timeout > System.currentTimeMillis()) {
            try {
                vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(options.getVirtualMachineId());
                if (vm == null) break;
                if (!vm.isPersistent()) {
                    throw new OperationNotSupportedException("You cannot capture instance-backed virtual machines");
                }
                if (VmState.RUNNING.equals((Object)vm.getCurrentState()) || VmState.STOPPED.equals((Object)vm.getCurrentState())) {
                    break;
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {}
        }
        if (vm == null) {
            throw new CloudException("No such virtual machine: " + options.getVirtualMachineId());
        }
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    taskTracker.completeWithResult((Object)AMI.this.captureImage(ctx, options, (AsynchronousTask<MachineImage>)taskTracker));
                }
                catch (Throwable t) {
                    taskTracker.complete(t);
                }
                finally {
                    AMI.this.provider.release();
                }
            }
        };
        this.provider.hold();
        t.setName("Imaging " + options.getVirtualMachineId() + " as " + options.getName());
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MachineImage captureWindows(@Nonnull ProviderContext ctx, @Nonnull ImageCreateOptions options, @Nonnull String bucket, @Nullable AsynchronousTask<MachineImage> task) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"captureWindows");
        try {
            Document doc;
            String base64Policy;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "BundleInstance");
            StringBuilder uploadPolicy = new StringBuilder();
            uploadPolicy.append("{");
            uploadPolicy.append("\"expiration\":\"");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            Date date = new Date(System.currentTimeMillis() + 43200000L);
            uploadPolicy.append(fmt.format(date));
            uploadPolicy.append("\",\"conditions\":");
            uploadPolicy.append("[");
            uploadPolicy.append("{\"bucket\":\"");
            uploadPolicy.append(bucket);
            uploadPolicy.append("\"},");
            uploadPolicy.append("{\"acl\": \"ec2-bundle-read\"},");
            uploadPolicy.append("[\"starts-with\", \"$key\", \"");
            uploadPolicy.append(options.getName());
            uploadPolicy.append("\"]");
            uploadPolicy.append("]");
            uploadPolicy.append("}");
            try {
                base64Policy = S3Method.toBase64(uploadPolicy.toString().getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e);
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            parameters.put("InstanceId", options.getVirtualMachineId());
            parameters.put("Storage.S3.Bucket", bucket);
            parameters.put("Storage.S3.Prefix", options.getName());
            parameters.put("Storage.S3.AWSAccessKeyId", ctx.getAccountNumber());
            parameters.put("Storage.S3.UploadPolicy", base64Policy);
            parameters.put("Storage.S3.UploadPolicySignature", this.provider.signUploadPolicy(base64Policy));
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("bundleId");
            if (blocks.getLength() < 1) {
                throw new CloudException("Unable to identify the bundle task ID.");
            }
            String bundleId = blocks.item(0).getFirstChild().getNodeValue();
            String manifest = bucket + "/" + options.getName() + ".manifest.xml";
            if (task == null) {
                task = new AsynchronousTask();
                task.setStartTime(System.currentTimeMillis());
            }
            this.waitForBundle(bundleId, manifest, options.getPlatform(), options.getName(), options.getDescription(), (AsynchronousTask<MachineImage>)task);
            Throwable t = task.getTaskError();
            if (t != null) {
                if (t instanceof CloudException) {
                    throw (CloudException)t;
                }
                if (t instanceof InternalException) {
                    throw (InternalException)t;
                }
                throw new InternalException(t);
            }
            MachineImage img = (MachineImage)task.getResult();
            if (img == null) {
                throw new CloudException("No image was created, but no error was given");
            }
            MachineImage machineImage = img;
            return machineImage;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Iterable<MachineImage> executeImageSearch(@Nullable String ownerId, @Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture, @Nonnull ImageClass cls) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"executeImageSearch");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeImages");
            ArrayList<MachineImage> list = new ArrayList<MachineImage>();
            parameters.put("ExecutableBy.1", ctx.getAccountNumber());
            int filter = 1;
            if (architecture != null) {
                parameters.put("Filter." + filter + ".Name", "architecture");
                parameters.put("Filter." + filter++ + ".Value.1", architecture.equals((Object)Architecture.I32) ? "i386" : "x86_64");
            }
            if (platform != null && platform.equals((Object)Platform.WINDOWS)) {
                parameters.put("Filter." + filter + ".Name", "platform");
                parameters.put("Filter." + filter++ + ".Value.1", "windows");
            }
            String t = "machine";
            switch (cls) {
                case MACHINE: {
                    t = "machine";
                    break;
                }
                case KERNEL: {
                    t = "kernel";
                    break;
                }
                case RAMDISK: {
                    t = "ramdisk";
                }
            }
            parameters.put("Filter." + filter + ".Name", "image-type");
            parameters.put("Filter." + filter++ + ".Value.1", t);
            parameters.put("Filter." + filter + ".Name", "state");
            parameters.put("Filter." + filter + ".Value.1", "available");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("imagesSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList instances = blocks.item(i).getChildNodes();
                for (int j = 0; j < instances.getLength(); ++j) {
                    MachineImage image;
                    Node instance = instances.item(j);
                    if (!instance.getNodeName().equals("item") || (image = this.toMachineImage(instance)) == null || !this.matches(image, ownerId, keyword, platform)) continue;
                    list.add(image);
                }
            }
            ArrayList<MachineImage> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Iterable<MachineImage> executePublicImageSearch(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture, @Nonnull ImageClass cls) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"executePublicImageSearch");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeImages");
            ArrayList<MachineImage> list = new ArrayList<MachineImage>();
            parameters.put("ExecutableBy.1", "all");
            int filter = 1;
            if (architecture != null) {
                parameters.put("Filter." + filter + ".Name", "architecture");
                parameters.put("Filter." + filter++ + ".Value.1", architecture.equals((Object)Architecture.I32) ? "i386" : "x86_64");
            }
            if (platform != null && platform.equals((Object)Platform.WINDOWS)) {
                parameters.put("Filter." + filter + ".Name", "platform");
                parameters.put("Filter." + filter++ + ".Value.1", "windows");
            }
            String t = "machine";
            switch (cls) {
                case MACHINE: {
                    t = "machine";
                    break;
                }
                case KERNEL: {
                    t = "kernel";
                    break;
                }
                case RAMDISK: {
                    t = "ramdisk";
                }
            }
            parameters.put("Filter." + filter + ".Name", "image-type");
            parameters.put("Filter." + filter++ + ".Value.1", t);
            parameters.put("Filter." + filter + ".Name", "state");
            parameters.put("Filter." + filter + ".Value.1", "available");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("imagesSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList instances = blocks.item(i).getChildNodes();
                for (int j = 0; j < instances.getLength(); ++j) {
                    MachineImage image;
                    Node instance = instances.item(j);
                    if (!instance.getNodeName().equals("item") || (image = this.toMachineImage(instance)) == null || !this.matches(image, null, keyword, platform)) continue;
                    list.add(image);
                }
            }
            ArrayList<MachineImage> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public MachineImage getImage(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getImage");
        try {
            Iterator<MachineImage> i$;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            if (!this.provider.getEC2Provider().isAWS()) {
                i$ = this.listImages(ImageClass.MACHINE).iterator();
            } else {
                Document doc;
                Map<String, String> parameters = this.provider.getStandardParameters(ctx, "DescribeImages");
                parameters.put("ImageId", providerImageId);
                EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    String code = e.getCode();
                    if (code != null && code.startsWith("InvalidAMIID")) {
                        MachineImage machineImage = null;
                        APITrace.end();
                        return machineImage;
                    }
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
                NodeList blocks = doc.getElementsByTagName("imagesSet");
                int i = 0;
                while (true) {
                    if (i >= blocks.getLength()) {
                        MachineImage machineImage = null;
                        return machineImage;
                    }
                    NodeList instances = blocks.item(i).getChildNodes();
                    for (int j = 0; j < instances.getLength(); ++j) {
                        MachineImage image;
                        Node instance = instances.item(j);
                        if (!instance.getNodeName().equals("item") || (image = this.toMachineImage(instance)) == null || !image.getProviderMachineImageId().equals(providerImageId)) continue;
                        MachineImage machineImage = image;
                        return machineImage;
                    }
                    ++i;
                }
            }
            while (i$.hasNext()) {
                MachineImage image = i$.next();
                if (!image.getProviderMachineImageId().equals(providerImageId)) continue;
                MachineImage machineImage = image;
                return machineImage;
            }
            for (MachineImage image : this.listImages(ImageClass.KERNEL)) {
                if (!image.getProviderMachineImageId().equals(providerImageId)) continue;
                MachineImage machineImage = image;
                return machineImage;
            }
            for (MachineImage image : this.listImages(ImageClass.RAMDISK)) {
                if (!image.getProviderMachineImageId().equals(providerImageId)) continue;
                MachineImage machineImage = image;
                return machineImage;
            }
            MachineImage machineImage = null;
            return machineImage;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public MachineImage getMachineImage(@Nonnull String imageId) throws InternalException, CloudException {
        return this.getImage(imageId);
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale) {
        return this.getProviderTermForImage(locale, ImageClass.MACHINE);
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        switch (cls) {
            case MACHINE: {
                return "AMI";
            }
            case KERNEL: {
                return "AKI";
            }
            case RAMDISK: {
                return "ARI";
            }
        }
        return "image";
    }

    @Nonnull
    public String getProviderTermForCustomImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        return this.getProviderTermForImage(locale, cls);
    }

    public boolean hasPublicLibrary() {
        return true;
    }

    @Nonnull
    public Requirement identifyLocalBundlingRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Deprecated
    @Nonnull
    public AsynchronousTask<String> imageVirtualMachine(@Nonnull String vmId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(vmId);
        if (vm == null) {
            throw new CloudException("No such virtual machine: " + vmId);
        }
        final AsynchronousTask task = new AsynchronousTask();
        final AsynchronousTask oldTask = new AsynchronousTask();
        this.captureImageAsync(ImageCreateOptions.getInstance((VirtualMachine)vm, (String)name, (String)description), (AsynchronousTask<MachineImage>)task);
        final long timeout = System.currentTimeMillis() + 0x6DDD00L;
        Thread t = new Thread(){

            @Override
            public void run() {
                while (timeout > System.currentTimeMillis()) {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    oldTask.setPercentComplete(task.getPercentComplete());
                    Throwable error = task.getTaskError();
                    MachineImage img = (MachineImage)task.getResult();
                    if (error != null) {
                        oldTask.complete(error);
                        return;
                    }
                    if (img != null) {
                        oldTask.completeWithResult((Object)img.getProviderMachineImageId());
                        return;
                    }
                    if (!task.isComplete()) continue;
                    oldTask.complete((Throwable)new CloudException("Task completed without info"));
                    return;
                }
                oldTask.complete((Throwable)new CloudException("Image creation task timed out"));
            }
        };
        t.setDaemon(true);
        t.start();
        return oldTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isImageSharedWithPublic(@Nonnull String machineImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"isImageSharedWithPublic");
        try {
            MachineImage image = this.getMachineImage(machineImageId);
            if (image == null) {
                boolean bl = false;
                return bl;
            }
            String p = (String)image.getTag("public");
            boolean bl = p != null && p.equalsIgnoreCase("true");
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"isSubscribed");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeImages");
            if (this.provider.getEC2Provider().isAWS()) {
                parameters.put("Owner", ctx.getAccountNumber());
            }
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
                boolean bl = true;
                return bl;
            }
            catch (EC2Exception e) {
                block10: {
                    String msg = e.getSummary();
                    if (msg == null || !msg.contains("not able to validate the provided access credentials")) break block10;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                logger.error((Object)("AWS Error checking subscription: " + e.getCode() + "/" + e.getSummary()));
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listImageStatus(@Nonnull ImageClass cls) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listImageStatus");
        try {
            ResourceStatus status;
            Node instance;
            int j;
            NodeList instances;
            int i;
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeImages");
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            String accountNumber = ctx.getAccountNumber();
            if (this.provider.getEC2Provider().isAWS()) {
                parameters.put("Owner", accountNumber);
            }
            String t = "machine";
            switch (cls) {
                case MACHINE: {
                    t = "machine";
                    break;
                }
                case KERNEL: {
                    t = "kernel";
                    break;
                }
                case RAMDISK: {
                    t = "ramdisk";
                }
            }
            parameters.put("Filter.1.Name", "image-type");
            parameters.put("Filter.1.Value", t);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("imagesSet");
            for (i = 0; i < blocks.getLength(); ++i) {
                instances = blocks.item(i).getChildNodes();
                for (j = 0; j < instances.getLength(); ++j) {
                    instance = instances.item(j);
                    if (!instance.getNodeName().equals("item") || (status = this.toStatus(instance)) == null) continue;
                    list.add(status);
                }
            }
            if (this.provider.getEC2Provider().isAWS()) {
                parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeImages");
                parameters.put("ExecutableBy", accountNumber);
                parameters.put("Filter.1.Name", "image-type");
                parameters.put("Filter.1.Value", t);
                method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
                blocks = doc.getElementsByTagName("imagesSet");
                for (i = 0; i < blocks.getLength(); ++i) {
                    instances = blocks.item(i).getChildNodes();
                    for (j = 0; j < instances.getLength(); ++j) {
                        instance = instances.item(j);
                        if (!instance.getNodeName().equals("item") || (status = this.toStatus(instance)) == null) continue;
                        list.add(status);
                    }
                }
            }
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<MachineImage> listImages(final @Nonnull ImageClass cls) throws CloudException, InternalException {
        final ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<MachineImage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void populate(@Nonnull Jiterator<MachineImage> iterator) throws CloudException, InternalException {
                try {
                    AMI.this.populateImages(ctx, null, (Jiterator<MachineImage>)iterator, cls);
                }
                finally {
                    AMI.this.provider.release();
                }
            }
        });
        populator.populate();
        return populator.getResult();
    }

    @Nonnull
    public Iterable<MachineImage> listImages(final @Nonnull ImageClass cls, final @Nonnull String ownedBy) throws CloudException, InternalException {
        final ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<MachineImage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void populate(@Nonnull Jiterator<MachineImage> iterator) throws CloudException, InternalException {
                try {
                    AMI.this.populateImages(ctx, ownedBy, (Jiterator<MachineImage>)iterator, cls);
                }
                finally {
                    AMI.this.provider.release();
                }
            }
        });
        populator.populate();
        return populator.getResult();
    }

    @Deprecated
    @Nonnull
    public Collection<MachineImage> listMachineImages() throws InternalException, CloudException {
        return (Collection)this.listImages(ImageClass.MACHINE);
    }

    @Deprecated
    @Nonnull
    public Collection<MachineImage> listMachineImagesOwnedBy(@Nonnull String owner) throws InternalException, CloudException {
        return (Collection)this.listImages(ImageClass.MACHINE, owner);
    }

    @Nonnull
    public Iterable<String> listShares(@Nonnull String forMachineImageId) throws CloudException, InternalException {
        return this.sharesAsList(forMachineImageId);
    }

    @Nonnull
    public Iterable<ImageClass> listSupportedImageClasses() throws CloudException, InternalException {
        if (supportedClasses == null) {
            ArrayList<ImageClass> list = new ArrayList<ImageClass>();
            list.add(ImageClass.MACHINE);
            list.add(ImageClass.KERNEL);
            list.add(ImageClass.RAMDISK);
            supportedClasses = Collections.unmodifiableCollection(list);
        }
        return supportedClasses;
    }

    @Nonnull
    public Iterable<MachineImageType> listSupportedImageTypes() throws CloudException, InternalException {
        if (supportedTypes == null) {
            ArrayList<MachineImageType> types = new ArrayList<MachineImageType>();
            types.add(MachineImageType.STORAGE);
            types.add(MachineImageType.VOLUME);
            supportedTypes = Collections.unmodifiableCollection(types);
        }
        return supportedTypes;
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageFormat.AWS);
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormatsForBundling() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageFormat.AWS);
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)MachineImageSupport.ANY)) {
            return new String[]{"ec2:*"};
        }
        if (action.equals((Object)MachineImageSupport.DOWNLOAD_IMAGE)) {
            return new String[0];
        }
        if (action.equals((Object)MachineImageSupport.GET_IMAGE)) {
            return new String[]{"ec2:DescribeImages"};
        }
        if (action.equals((Object)MachineImageSupport.IMAGE_VM)) {
            return new String[]{"ec2:CreateImage", "ec2:RegisterImage"};
        }
        if (action.equals((Object)MachineImageSupport.LIST_IMAGE)) {
            return new String[]{"ec2:DescribeImages"};
        }
        if (action.equals((Object)MachineImageSupport.MAKE_PUBLIC)) {
            return new String[]{"ec2:ModifyImageAttribute"};
        }
        if (action.equals((Object)MachineImageSupport.REGISTER_IMAGE)) {
            return new String[]{"ec2:RegisterImage"};
        }
        if (action.equals((Object)MachineImageSupport.REMOVE_IMAGE)) {
            return new String[]{"ec2:DeregisterImage"};
        }
        if (action.equals((Object)MachineImageSupport.SHARE_IMAGE)) {
            return new String[]{"ec2:ModifyImageAttribute"};
        }
        if (action.equals((Object)MachineImageSupport.UPLOAD_IMAGE)) {
            return new String[0];
        }
        return new String[0];
    }

    private boolean matches(@Nonnull MachineImage image, @Nullable String ownerId, @Nullable String keyword, @Nullable Platform platform) {
        if (ownerId != null && !ownerId.equals(image.getProviderOwnerId())) {
            return false;
        }
        if (platform != null && !platform.equals((Object)Platform.UNKNOWN)) {
            Platform mine = image.getPlatform();
            if (platform.isWindows() && !mine.isWindows()) {
                return false;
            }
            if (platform.isUnix() && !mine.isUnix()) {
                return false;
            }
            if (platform.isBsd() && !mine.isBsd()) {
                return false;
            }
            if (platform.isLinux() && !mine.isLinux()) {
                return false;
            }
            if (platform.equals((Object)Platform.UNIX) ? !mine.isUnix() : !platform.equals((Object)mine)) {
                return false;
            }
        }
        if (keyword != null) {
            keyword = keyword.toLowerCase();
            if (!(image.getDescription().toLowerCase().contains(keyword) || image.getName().toLowerCase().contains(keyword) || image.getProviderMachineImageId().toLowerCase().contains(keyword))) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateImages(@Nonnull ProviderContext ctx, @Nullable String accountNumber, @Nonnull Jiterator<MachineImage> iterator, @Nonnull ImageClass cls) throws CloudException, InternalException {
        block18: {
            APITrace.begin((CloudProvider)this.provider, (String)"populateImages");
            try {
                MachineImage image;
                Node instance;
                int j;
                NodeList instances;
                int i;
                Document doc;
                Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeImages");
                if (accountNumber == null) {
                    accountNumber = ctx.getAccountNumber();
                }
                if (this.provider.getEC2Provider().isAWS()) {
                    parameters.put("Owner", accountNumber);
                }
                String t = "machine";
                switch (cls) {
                    case MACHINE: {
                        t = "machine";
                        break;
                    }
                    case KERNEL: {
                        t = "kernel";
                        break;
                    }
                    case RAMDISK: {
                        t = "ramdisk";
                    }
                }
                parameters.put("Filter.1.Name", "image-type");
                parameters.put("Filter.1.Value", t);
                EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
                NodeList blocks = doc.getElementsByTagName("imagesSet");
                for (i = 0; i < blocks.getLength(); ++i) {
                    instances = blocks.item(i).getChildNodes();
                    for (j = 0; j < instances.getLength(); ++j) {
                        instance = instances.item(j);
                        if (!instance.getNodeName().equals("item") || (image = this.toMachineImage(instance)) == null) continue;
                        iterator.push((Object)image);
                    }
                }
                if (!this.provider.getEC2Provider().isAWS()) break block18;
                parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeImages");
                parameters.put("ExecutableBy", accountNumber);
                parameters.put("Filter.1.Name", "image-type");
                parameters.put("Filter.1.Value", t);
                method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
                blocks = doc.getElementsByTagName("imagesSet");
                for (i = 0; i < blocks.getLength(); ++i) {
                    instances = blocks.item(i).getChildNodes();
                    for (j = 0; j < instances.getLength(); ++j) {
                        instance = instances.item(j);
                        if (!instance.getNodeName().equals("item") || (image = this.toMachineImage(instance)) == null) continue;
                        iterator.push((Object)image);
                    }
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    @Nonnull
    public MachineImage registerImageBundle(@Nonnull ImageCreateOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"registerImageBundle");
        try {
            Document doc;
            if (!MachineImageFormat.AWS.equals((Object)options.getBundleFormat())) {
                throw new CloudException("Unsupported bundle format: " + options.getBundleFormat());
            }
            if (options.getBundleLocation() == null) {
                throw new OperationNotSupportedException("A valid bundle location in object storage was not provided");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "RegisterImage");
            parameters.put("ImageLocation", options.getBundleLocation());
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("imageId");
            if (blocks.getLength() > 0) {
                Node imageIdNode = blocks.item(0);
                String id = imageIdNode.getFirstChild().getNodeValue().trim();
                MachineImage img = this.getMachineImage(id);
                if (img == null) {
                    throw new CloudException("Expected to find newly registered machine image '" + id + "', but none was found");
                }
                MachineImage machineImage = img;
                return machineImage;
            }
            throw new CloudException("No machine image was registered, but no error was thrown");
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"remove");
        try {
            Node imageIdNode;
            Document doc;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeregisterImage");
            parameters.put("ImageId", providerImageId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("return");
            if (blocks.getLength() > 0 && !(imageIdNode = blocks.item(0)).getFirstChild().getNodeValue().trim().equals("true")) {
                throw new CloudException("Failed to de-register image " + providerImageId);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public void remove(@Nonnull String providerImageId, boolean checkState) throws CloudException, InternalException {
        if (checkState) {
            long timeout = System.currentTimeMillis() + 1800000L;
            while (timeout > System.currentTimeMillis()) {
                try {
                    MachineImage img = this.getMachineImage(providerImageId);
                    if (img == null || MachineImageState.DELETED.equals((Object)img.getCurrentState())) {
                        return;
                    }
                    if (MachineImageState.ACTIVE.equals((Object)img.getCurrentState())) {
                        break;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {}
            }
        }
        this.remove(providerImageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllImageShares(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeAllImageShares");
        try {
            List<String> shares = this.sharesAsList(providerImageId);
            this.setPrivateShare(providerImageId, false, shares.toArray(new String[shares.size()]));
            this.setPublicShare(providerImageId, false);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageShare(@Nonnull String providerImageId, @Nonnull String accountNumber) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeImageShare");
        try {
            this.setPrivateShare(providerImageId, false, accountNumber);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePublicShare(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removePublicShare");
        try {
            this.setPublicShare(providerImageId, false);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<MachineImage> searchImages(@Nullable String ownerId, @Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture, ImageClass ... classes) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"searchImages");
        try {
            if (classes == null || classes.length < 1) {
                Iterable<MachineImage> iterable = this.executeImageSearch(ownerId, keyword, platform, architecture, ImageClass.MACHINE);
                return iterable;
            }
            if (classes.length == 1) {
                Iterable<MachineImage> iterable = this.executeImageSearch(ownerId, keyword, platform, architecture, classes[0]);
                return iterable;
            }
            ArrayList<MachineImage> images = new ArrayList<MachineImage>();
            for (ImageClass cls : classes) {
                for (MachineImage img : this.executeImageSearch(ownerId, keyword, platform, architecture, cls)) {
                    images.add(img);
                }
            }
            ArrayList<MachineImage> arrayList = images;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Deprecated
    @Nonnull
    public Iterable<MachineImage> searchMachineImages(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture) throws InternalException, CloudException {
        return this.searchPublicImages(keyword, platform, architecture, ImageClass.MACHINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<MachineImage> searchPublicImages(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture, ImageClass ... classes) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"searchPublicImages");
        try {
            if (classes == null || classes.length < 1) {
                Iterable<MachineImage> iterable = this.executePublicImageSearch(keyword, platform, architecture, ImageClass.MACHINE);
                return iterable;
            }
            if (classes.length == 1) {
                Iterable<MachineImage> iterable = this.executePublicImageSearch(keyword, platform, architecture, classes[0]);
                return iterable;
            }
            ArrayList<MachineImage> images = new ArrayList<MachineImage>();
            for (ImageClass cls : classes) {
                for (MachineImage img : this.executePublicImageSearch(keyword, platform, architecture, cls)) {
                    images.add(img);
                }
            }
            ArrayList<MachineImage> arrayList = images;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    private void setPrivateShare(@Nonnull String imageId, boolean allowed, String ... accountIds) throws CloudException, InternalException {
        Document doc;
        if (accountIds.length < 1) {
            return;
        }
        long timeout = System.currentTimeMillis() + 1800000L;
        while (timeout > System.currentTimeMillis()) {
            try {
                MachineImage img = this.getMachineImage(imageId);
                if (img == null) {
                    throw new CloudException("The machine image " + imageId + " disappeared while waiting to set sharing");
                }
                if (MachineImageState.ACTIVE.equals((Object)img.getCurrentState())) {
                    break;
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {}
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ModifyImageAttribute");
        parameters.put("ImageId", imageId);
        for (int i = 0; i < accountIds.length; ++i) {
            if (allowed) {
                parameters.put("LaunchPermission.Add." + (i + 1) + ".UserId", accountIds[i]);
                continue;
            }
            parameters.put("LaunchPermission.Remove." + (i + 1) + ".UserId", accountIds[i]);
        }
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidImageID")) {
                return;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("return");
        if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
            throw new CloudException("Share of image failed without explanation.");
        }
        timeout = System.currentTimeMillis() + 30000L;
        while (timeout > System.currentTimeMillis()) {
            try {
                MachineImage img = this.getMachineImage(imageId);
                if (img == null) {
                    return;
                }
                boolean present = true;
                for (String accountId : accountIds) {
                    boolean found = false;
                    for (String share : this.listShares(imageId)) {
                        if (!share.equals(accountId)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    present = false;
                    break;
                }
                if (present == allowed) {
                    return;
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ignore) {}
        }
    }

    private void setPublicShare(@Nonnull String imageId, boolean allowed) throws CloudException, InternalException {
        Document doc;
        long timeout = System.currentTimeMillis() + 1800000L;
        while (timeout > System.currentTimeMillis()) {
            try {
                MachineImage img = this.getMachineImage(imageId);
                if (img == null) {
                    throw new CloudException("The machine image " + imageId + " disappeared while waiting to set sharing");
                }
                if (MachineImageState.ACTIVE.equals((Object)img.getCurrentState())) {
                    break;
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {}
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ModifyImageAttribute");
        parameters.put("ImageId", imageId);
        if (allowed) {
            parameters.put("LaunchPermission.Add.1.Group", "all");
        } else {
            parameters.put("LaunchPermission.Remove.1.Group", "all");
        }
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidImageID")) {
                return;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("return");
        if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
            throw new CloudException("Share of image failed without explanation.");
        }
        timeout = System.currentTimeMillis() + 30000L;
        while (timeout > System.currentTimeMillis()) {
            try {
                MachineImage img = this.getMachineImage(imageId);
                if (img == null) {
                    return;
                }
                if (allowed == this.isImageSharedWithPublic(imageId)) {
                    return;
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ignore) {}
        }
    }

    @Deprecated
    public void shareMachineImage(@Nonnull String machineImageId, @Nullable String withAccountId, boolean allowShare) throws CloudException, InternalException {
        if (withAccountId == null) {
            this.setPublicShare(machineImageId, allowShare);
        } else {
            this.setPrivateShare(machineImageId, allowShare, withAccountId);
        }
    }

    @Nonnull
    private List<String> sharesAsList(@Nonnull String forMachineImageId) throws CloudException, InternalException {
        Document doc;
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeImageAttribute");
        ArrayList<String> list = new ArrayList<String>();
        parameters.put("ImageId", forMachineImageId);
        parameters.put("Attribute", "launchPermission");
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidImageID")) {
                return list;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("launchPermission");
        for (int i = 0; i < blocks.getLength(); ++i) {
            NodeList items = blocks.item(i).getChildNodes();
            for (int j = 0; j < items.getLength(); ++j) {
                Node item = items.item(j);
                if (!item.getNodeName().equals("item")) continue;
                NodeList attrs = item.getChildNodes();
                for (int k = 0; k < attrs.getLength(); ++k) {
                    String userId;
                    Node attr = attrs.item(k);
                    if (!attr.getNodeName().equals("userId") || (userId = attr.getFirstChild().getNodeValue()) == null || (userId = userId.trim()).length() <= 0) continue;
                    list.add(userId);
                }
            }
        }
        return list;
    }

    public boolean supportsCustomImages() {
        return true;
    }

    public boolean supportsDirectImageUpload() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageCapture(@Nonnull MachineImageType type) throws CloudException, InternalException {
        return MachineImageType.VOLUME.equals((Object)type);
    }

    public boolean supportsImageSharing() {
        return true;
    }

    public boolean supportsImageSharingWithPublic() {
        return true;
    }

    public boolean supportsPublicLibrary(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return true;
    }

    private BundleTask toBundleTask(Node node) throws CloudException, InternalException {
        NodeList attributes = node.getChildNodes();
        BundleTask task = new BundleTask();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName();
            if (name.equals("bundleId")) {
                task.bundleId = attribute.getFirstChild().getNodeValue();
                continue;
            }
            if (name.equals("state")) {
                task.state = attribute.getFirstChild().getNodeValue();
                continue;
            }
            if (name.equals("message")) {
                if (!attribute.hasChildNodes()) continue;
                task.message = attribute.getFirstChild().getNodeValue();
                continue;
            }
            if (!name.equals("progress")) continue;
            String tmp = attribute.getFirstChild().getNodeValue();
            if (tmp == null) {
                task.progress = 0.0;
                continue;
            }
            if (tmp.endsWith("%")) {
                if (tmp.equals("%")) {
                    task.progress = 0.0;
                    continue;
                }
                try {
                    task.progress = Double.parseDouble(tmp.substring(0, tmp.length() - 1));
                }
                catch (NumberFormatException e) {
                    task.progress = 0.0;
                }
                continue;
            }
            try {
                task.progress = Double.parseDouble(tmp);
                continue;
            }
            catch (NumberFormatException e) {
                task.progress = 0.0;
            }
        }
        return task;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request");
        }
        NodeList attributes = node.getChildNodes();
        MachineImageState state = MachineImageState.PENDING;
        String imageId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName();
            if (name.equals("imageId")) {
                imageId = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!name.equals("imageState")) continue;
            String value = null;
            if (attribute.getChildNodes().getLength() > 0) {
                value = attribute.getFirstChild().getNodeValue().trim();
            }
            state = value != null && value.equalsIgnoreCase("available") ? MachineImageState.ACTIVE : (value != null && value.equalsIgnoreCase("failed") ? MachineImageState.DELETED : MachineImageState.PENDING);
        }
        if (imageId == null) {
            return null;
        }
        return new ResourceStatus(imageId, (Object)state);
    }

    @Nullable
    private MachineImage toMachineImage(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request");
        }
        NodeList attributes = node.getChildNodes();
        MachineImage image = new MachineImage();
        String location = null;
        image.setSoftware("");
        image.setProviderRegionId(regionId);
        image.setImageClass(ImageClass.MACHINE);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String value;
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName();
            if (name.equals("imageType")) {
                value = attribute.getFirstChild().getNodeValue().trim();
                if (value.equalsIgnoreCase("machine")) {
                    image.setImageClass(ImageClass.MACHINE);
                    continue;
                }
                if (value.equalsIgnoreCase("kernel")) {
                    image.setImageClass(ImageClass.KERNEL);
                    continue;
                }
                if (!value.equalsIgnoreCase("ramdisk")) continue;
                image.setImageClass(ImageClass.RAMDISK);
                continue;
            }
            if (name.equals("imageId")) {
                value = attribute.getFirstChild().getNodeValue().trim();
                image.setProviderMachineImageId(value);
                if (value.startsWith("ami")) {
                    image.setImageClass(ImageClass.MACHINE);
                    continue;
                }
                if (value.startsWith("aki")) {
                    image.setImageClass(ImageClass.KERNEL);
                    continue;
                }
                if (!value.startsWith("ari")) continue;
                image.setImageClass(ImageClass.RAMDISK);
                continue;
            }
            if (name.equals("imageLocation")) {
                location = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (name.equals("imageState")) {
                value = null;
                if (attribute.getChildNodes().getLength() > 0) {
                    value = attribute.getFirstChild().getNodeValue().trim();
                }
                if (value != null && value.equalsIgnoreCase("available")) {
                    image.setCurrentState(MachineImageState.ACTIVE);
                    continue;
                }
                if (value != null && value.equalsIgnoreCase("failed")) {
                    image.setCurrentState(MachineImageState.DELETED);
                    continue;
                }
                image.setCurrentState(MachineImageState.PENDING);
                continue;
            }
            if (name.equalsIgnoreCase("statereason") && attribute.hasChildNodes()) {
                NodeList parts = attribute.getChildNodes();
                for (int j = 0; j < parts.getLength(); ++j) {
                    Node part = parts.item(j);
                    if (!part.getNodeName().equalsIgnoreCase("message") || !part.hasChildNodes()) continue;
                    String value2 = part.getFirstChild().getNodeValue().trim();
                    image.setTag("stateReason", value2);
                }
                continue;
            }
            if (name.equals("imageOwnerId")) {
                value = null;
                if (attribute.getChildNodes().getLength() > 0) {
                    value = attribute.getFirstChild().getNodeValue();
                }
                image.setProviderOwnerId(value == null ? value : value.trim());
                continue;
            }
            if (name.equals("isPublic")) {
                value = null;
                if (attribute.getChildNodes().getLength() > 0) {
                    value = attribute.getFirstChild().getNodeValue();
                }
                image.addTag("public", String.valueOf(value != null && value.trim().equalsIgnoreCase("true")));
                continue;
            }
            if (name.equals("architecture")) {
                value = attribute.getFirstChild().getNodeValue().trim();
                if (value.equals("i386")) {
                    image.setArchitecture(Architecture.I32);
                    continue;
                }
                image.setArchitecture(Architecture.I64);
                continue;
            }
            if (name.equals("platform")) {
                if (!attribute.hasChildNodes()) continue;
                value = attribute.getFirstChild().getNodeValue();
                image.setPlatform(Platform.guess((String)value));
                continue;
            }
            if (name.equals("name")) {
                if (!attribute.hasChildNodes()) continue;
                value = attribute.getFirstChild().getNodeValue();
                image.setName(value);
                continue;
            }
            if (name.equals("description")) {
                if (!attribute.hasChildNodes()) continue;
                value = attribute.getFirstChild().getNodeValue();
                image.setDescription(value);
                continue;
            }
            if (!name.equals("rootDeviceType") || !attribute.hasChildNodes()) continue;
            String type = attribute.getFirstChild().getNodeValue();
            if (type.equalsIgnoreCase("ebs")) {
                image.setType(MachineImageType.VOLUME);
                continue;
            }
            image.setType(MachineImageType.STORAGE);
        }
        if (image.getPlatform() == null) {
            if (location != null) {
                image.setPlatform(Platform.guess(location));
            } else {
                image.setPlatform(Platform.UNKNOWN);
            }
        }
        if (location != null) {
            int i;
            String[] parts = location.split("/");
            if (parts != null && parts.length > 1) {
                location = parts[parts.length - 1];
            }
            if ((i = location.indexOf(".manifest.xml")) > -1) {
                location = location.substring(0, i);
            }
            if (image.getName() == null || image.getName().equals("")) {
                image.setName(location);
            }
            if (image.getDescription() == null || image.getDescription().equals("")) {
                image.setDescription(location + " (" + image.getArchitecture().toString() + " " + image.getPlatform().toString() + ")");
            }
        } else {
            if (image.getName() == null || image.getName().equals("")) {
                image.setName(image.getProviderMachineImageId());
            }
            if (image.getDescription() == null || image.getDescription().equals("")) {
                image.setDescription(image.getName() + " (" + image.getArchitecture().toString() + " " + image.getPlatform().toString() + ")");
            }
        }
        if (!this.provider.getEC2Provider().isAWS()) {
            image.setProviderOwnerId(ctx.getAccountNumber());
        }
        return image;
    }

    public void updateTags(@Nonnull String imageId, Tag ... tags) throws CloudException, InternalException {
        this.provider.createTags(imageId, tags);
    }

    private void waitForBundle(@Nonnull String bundleId, @Nonnull String manifest, @Nonnull Platform platform, @Nonnull String name, @Nonnull String description, AsynchronousTask<MachineImage> task) {
        try {
            long failurePoint = -1L;
            while (!task.isComplete()) {
                Document doc;
                Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeBundleTasks");
                parameters.put("BundleId", bundleId);
                EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    throw new CloudException((Throwable)e);
                }
                NodeList blocks = doc.getElementsByTagName("bundleInstanceTasksSet");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    NodeList instances = blocks.item(i).getChildNodes();
                    for (int j = 0; j < instances.getLength(); ++j) {
                        Node node = instances.item(j);
                        if (!node.getNodeName().equals("item")) continue;
                        BundleTask bt = this.toBundleTask(node);
                        if (!bt.bundleId.equals(bundleId)) continue;
                        if (bt.state.equals("complete")) {
                            task.setPercentComplete(99.0);
                            String imageId = this.registerImageBundle(ImageCreateOptions.getInstance((MachineImageFormat)MachineImageFormat.AWS, (String)manifest, (Platform)platform, (String)name, (String)description)).getProviderMachineImageId();
                            task.setPercentComplete(100.0);
                            task.completeWithResult((Object)this.getMachineImage(imageId));
                            continue;
                        }
                        if (bt.state.equals("failed")) {
                            String message = bt.message;
                            if (message == null) {
                                if (failurePoint == -1L) {
                                    failurePoint = System.currentTimeMillis();
                                }
                                if (System.currentTimeMillis() - failurePoint > 120000L) {
                                    message = "Bundle failed without further information.";
                                }
                            }
                            if (message == null) continue;
                            task.complete((Throwable)new CloudException(message));
                            continue;
                        }
                        if (bt.state.equals("pending") || bt.state.equals("waiting-for-shutdown")) {
                            task.setPercentComplete(0.0);
                            continue;
                        }
                        if (bt.state.equals("bundling")) {
                            double p = bt.progress / 2.0;
                            if (p > 50.0) {
                                p = 50.0;
                            }
                            task.setPercentComplete(p);
                            continue;
                        }
                        if (bt.state.equals("storing")) {
                            double p = 50.0 + bt.progress / 2.0;
                            if (p > 100.0) {
                                p = 100.0;
                            }
                            task.setPercentComplete(p);
                            continue;
                        }
                        task.setPercentComplete(0.0);
                    }
                }
                if (task.isComplete()) continue;
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ignore) {}
            }
        }
        catch (Throwable t) {
            logger.error((Object)t);
            t.printStackTrace();
            task.complete(t);
        }
    }

    private class BundleTask {
        public String bundleId;
        public double progress;
        public String message;
        public String state;

        private BundleTask() {
        }
    }
}

