/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.compute;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.compute.AutoScalingSupport;
import org.dasein.cloud.compute.LaunchConfiguration;
import org.dasein.cloud.compute.ScalingGroup;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AutoScaling
implements AutoScalingSupport {
    private static final Logger logger = Logger.getLogger(AutoScaling.class);
    private AWSCloud provider = null;

    AutoScaling(AWSCloud provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createAutoScalingGroup(String name, String launchConfigurationId, int minServers, int maxServers, int cooldown, String ... zoneIds) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"createAutoScalingGroup");
        try {
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "CreateAutoScalingGroup");
            if (minServers < 0) {
                minServers = 0;
            }
            if (maxServers < minServers) {
                maxServers = minServers;
            }
            parameters.put("AutoScalingGroupName", name);
            parameters.put("LaunchConfigurationName", launchConfigurationId);
            parameters.put("MinSize", String.valueOf(minServers));
            parameters.put("MaxSize", String.valueOf(maxServers));
            parameters.put("Cooldown", String.valueOf(cooldown));
            int i = 1;
            for (String zoneId : zoneIds) {
                parameters.put("AvailabilityZones.member." + i++, zoneId);
            }
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            String string = name;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createLaunchConfiguration(String name, String imageId, VirtualMachineProduct size, String ... firewalls) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"createLaunchConfigursation");
        try {
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "CreateLaunchConfiguration");
            parameters.put("LaunchConfigurationName", name);
            parameters.put("ImageId", imageId);
            parameters.put("InstanceType", size.getProviderProductId());
            int i = 1;
            for (String fw : firewalls) {
                parameters.put("SecurityGroup.member." + i++, fw);
            }
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            String string = name;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAutoScalingGroup(String providerAutoScalingGroupId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"deleteAutoScalingGroup");
        try {
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "DeleteAutoScalingGroup");
            parameters.put("AutoScalingGroupName", providerAutoScalingGroupId);
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLaunchConfiguration(String providerLaunchConfigurationId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"deleteLaunchConfiguration");
        try {
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "DeleteLaunchConfiguration");
            parameters.put("LaunchConfigurationName", providerLaunchConfigurationId);
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setTrigger(String name, String scalingGroupId, String statistic, String unitOfMeasure, String metric, int periodInSeconds, double lowerThreshold, double upperThreshold, int lowerIncrement, boolean lowerIncrementAbsolute, int upperIncrement, boolean upperIncrementAbsolute, int breachDuration) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"setTrigger");
        try {
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "CreateOrUpdateScalingTrigger");
            parameters.put("AutoScalingGroupName", scalingGroupId);
            parameters.put("MeasureName", metric);
            parameters.put("Period", String.valueOf(periodInSeconds));
            parameters.put("LowerThreshold", String.valueOf(lowerThreshold));
            parameters.put("UpperThreshold", String.valueOf(upperThreshold));
            parameters.put("UpperBreachScaleIncrement", String.valueOf(upperIncrement));
            parameters.put("LowerBreachScaleIncrement", String.valueOf(lowerIncrement));
            parameters.put("BreachDuration", String.valueOf(breachDuration));
            parameters.put("TriggerName", name);
            parameters.put("Unit", unitOfMeasure);
            parameters.put("Statistic", statistic);
            parameters.put("Dimensions.member.1.Name", "AutoScalingGroupName");
            parameters.put("Dimensions.member.1.Value", scalingGroupId);
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            String string = name;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getAutoScalingParameters(ProviderContext ctx, String action) throws InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getAutoScalingParameters");
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("Action", action);
            parameters.put("SignatureVersion", "2");
            try {
                parameters.put("AWSAccessKeyId", new String(ctx.getAccessPublic(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e);
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            parameters.put("SignatureMethod", "HmacSHA256");
            parameters.put("Timestamp", this.provider.getTimestamp(System.currentTimeMillis(), true));
            parameters.put("Version", this.provider.getAutoScaleVersion());
            HashMap<String, String> hashMap = parameters;
            return hashMap;
        }
        finally {
            APITrace.end();
        }
    }

    private String getAutoScalingUrl() throws CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context has been set for this request");
        }
        return "https://autoscaling." + ctx.getRegionId() + ".amazonaws.com";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LaunchConfiguration getLaunchConfiguration(String providerLaunchConfigurationId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getLaunchConfiguration");
        try {
            Document doc;
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "DescribeLaunchConfigurations");
            parameters.put("LaunchConfigurationNames.member.1", providerLaunchConfigurationId);
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("LaunchConfigurations");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    LaunchConfiguration cfg;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("member") || (cfg = this.toLaunchConfiguration(item)) == null) continue;
                    LaunchConfiguration launchConfiguration = cfg;
                    return launchConfiguration;
                }
            }
            LaunchConfiguration launchConfiguration = null;
            return launchConfiguration;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScalingGroup getScalingGroup(String providerScalingGroupId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getScalingGroup");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context has been set for this request");
            }
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "DescribeAutoScalingGroups");
            parameters.put("AutoScalingGroupNames.member.1", providerScalingGroupId);
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("AutoScalingGroups");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList members = blocks.item(i).getChildNodes();
                for (int j = 0; j < members.getLength(); ++j) {
                    ScalingGroup group;
                    Node item = members.item(j);
                    if (!item.getNodeName().equals("member") || (group = this.toScalingGroup(ctx, item)) == null) continue;
                    ScalingGroup scalingGroup = group;
                    return scalingGroup;
                }
            }
            ScalingGroup scalingGroup = null;
            return scalingGroup;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"isSubscribed");
        try {
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "DescribeAutoScalingGroups");
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                method.invoke();
                boolean bl = true;
                return bl;
            }
            catch (EC2Exception e) {
                block8: {
                    String msg = e.getSummary();
                    if (msg == null || !msg.contains("not able to validate the provided access credentials")) break block8;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                logger.error((Object)("AWS Error checking subscription: " + e.getCode() + "/" + e.getSummary()));
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listLaunchConfigurationStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listLaunchConfigurationStatus");
        try {
            Document doc;
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "DescribeLaunchConfigurations");
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("LaunchConfigurations");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    ResourceStatus status;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("member") || (status = this.toLCStatus(item)) == null) continue;
                    list.add(status);
                }
            }
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LaunchConfiguration> listLaunchConfigurations() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listLaunchConfigurations");
        try {
            Document doc;
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "DescribeLaunchConfigurations");
            ArrayList<LaunchConfiguration> list = new ArrayList<LaunchConfiguration>();
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("LaunchConfigurations");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    LaunchConfiguration cfg;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("member") || (cfg = this.toLaunchConfiguration(item)) == null) continue;
                    list.add(cfg);
                }
            }
            ArrayList<LaunchConfiguration> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ResourceStatus> listScalingGroupStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listScalingGroupStatus");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context has been set for this request");
            }
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "DescribeAutoScalingGroups");
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("AutoScalingGroups");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    ResourceStatus status;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("member") || (status = this.toGroupStatus(item)) == null) continue;
                    list.add(status);
                }
            }
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ScalingGroup> listScalingGroups() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listScalingGroups");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context has been set for this request");
            }
            ArrayList<ScalingGroup> list = new ArrayList<ScalingGroup>();
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "DescribeAutoScalingGroups");
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("AutoScalingGroups");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    ScalingGroup group;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("member") || (group = this.toScalingGroup(ctx, item)) == null) continue;
                    list.add(group);
                }
            }
            ArrayList<ScalingGroup> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)AutoScalingSupport.ANY)) {
            return new String[]{"autoscaling:*"};
        }
        if (action.equals((Object)AutoScalingSupport.CREATE_LAUNCH_CONFIGURATION)) {
            return new String[]{"autoscaling:CreateLaunchConfiguration"};
        }
        if (action.equals((Object)AutoScalingSupport.CREATE_SCALING_GROUP)) {
            return new String[]{"autoscaling:CreateAutoScalingGroup"};
        }
        if (action.equals((Object)AutoScalingSupport.GET_LAUNCH_CONFIGURATION)) {
            return new String[]{"autoscaling:DescribeLaunchConfigurations"};
        }
        if (action.equals((Object)AutoScalingSupport.GET_SCALING_GROUP)) {
            return new String[]{"autoscaling:DescribeAutoScalingGroups"};
        }
        if (action.equals((Object)AutoScalingSupport.LIST_LAUNCH_CONFIGURATION)) {
            return new String[]{"autoscaling:DescribeLaunchConfigurations"};
        }
        if (action.equals((Object)AutoScalingSupport.LIST_SCALING_GROUP)) {
            return new String[]{"autoscaling:DescribeAutoScalingGroups"};
        }
        if (action.equals((Object)AutoScalingSupport.REMOVE_LAUNCH_CONFIGURATION)) {
            return new String[]{"autoscaling:DeleteLaunchConfiguration"};
        }
        if (action.equals((Object)AutoScalingSupport.REMOVE_SCALING_GROUP)) {
            return new String[]{"autoscaling:DeleteAutoScalingGroup"};
        }
        if (action.equals((Object)AutoScalingSupport.SET_CAPACITY)) {
            return new String[]{"autoscaling:SetDesiredCapacity"};
        }
        if (action.equals((Object)AutoScalingSupport.SET_SCALING_TRIGGER)) {
            return new String[]{"autoscaling:CreateOrUpdateScalingTrigger"};
        }
        if (action.equals((Object)AutoScalingSupport.UPDATE_SCALING_GROUP)) {
            return new String[]{"autoscaling:UpdateAutoScalingGroup"};
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDesiredCapacity(String scalingGroupId, int capacity) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"setDesiredCapacity");
        try {
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "SetDesiredCapacity");
            parameters.put("AutoScalingGroupName", scalingGroupId);
            parameters.put("DesiredCapacity", String.valueOf(capacity));
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private ResourceStatus toGroupStatus(@Nullable Node item) {
        if (item == null) {
            return null;
        }
        NodeList attrs = item.getChildNodes();
        String groupId = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if (!attr.getNodeName().equalsIgnoreCase("AutoScalingGroupName")) continue;
            groupId = attr.getFirstChild().getNodeValue();
        }
        if (groupId == null) {
            return null;
        }
        return new ResourceStatus(groupId, (Object)true);
    }

    @Nullable
    private LaunchConfiguration toLaunchConfiguration(@Nullable Node item) {
        if (item == null) {
            return null;
        }
        LaunchConfiguration cfg = new LaunchConfiguration();
        NodeList attrs = item.getChildNodes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String[] ids;
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equalsIgnoreCase("ImageId")) {
                cfg.setProviderImageId(attr.getFirstChild().getNodeValue());
                continue;
            }
            if (name.equalsIgnoreCase("InstanceType")) {
                cfg.setServerSizeId(attr.getFirstChild().getNodeValue());
                continue;
            }
            if (name.equalsIgnoreCase("LaunchConfigurationName")) {
                String lcname = attr.getFirstChild().getNodeValue();
                cfg.setProviderLaunchConfigurationId(lcname);
                cfg.setName(lcname);
                continue;
            }
            if (name.equalsIgnoreCase("CreatedTime")) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                try {
                    cfg.setCreationTimestamp(fmt.parse(attr.getFirstChild().getNodeValue()).getTime());
                }
                catch (ParseException e) {
                    logger.error((Object)("Could not parse timestamp: " + attr.getFirstChild().getNodeValue()));
                    cfg.setCreationTimestamp(System.currentTimeMillis());
                }
                continue;
            }
            if (!name.equalsIgnoreCase("SecurityGroups")) continue;
            if (attr.hasChildNodes()) {
                int j;
                ArrayList<String> instanceIds = new ArrayList<String>();
                NodeList instances = attr.getChildNodes();
                for (j = 0; j < instances.getLength(); ++j) {
                    Node instance = instances.item(j);
                    if (!instance.getNodeName().equalsIgnoreCase("member") || !instance.hasChildNodes()) continue;
                    NodeList items = instance.getChildNodes();
                    for (int k = 0; k < items.getLength(); ++k) {
                        Node val = items.item(k);
                        if (!val.getNodeName().equalsIgnoreCase("InstanceId")) continue;
                        instanceIds.add(val.getFirstChild().getNodeValue());
                    }
                }
                ids = new String[instanceIds.size()];
                j = 0;
                for (String id : instanceIds) {
                    ids[j++] = id;
                }
            } else {
                ids = new String[]{};
            }
            cfg.setProviderFirewallIds(ids);
        }
        return cfg;
    }

    @Nullable
    private ResourceStatus toLCStatus(@Nullable Node item) {
        if (item == null) {
            return null;
        }
        NodeList attrs = item.getChildNodes();
        String lcId = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if (!attr.getNodeName().equalsIgnoreCase("LaunchConfigurationName")) continue;
            lcId = attr.getFirstChild().getNodeValue();
        }
        if (lcId == null) {
            return null;
        }
        return new ResourceStatus(lcId, (Object)true);
    }

    @Nullable
    private ScalingGroup toScalingGroup(@Nonnull ProviderContext ctx, @Nullable Node item) {
        if (item == null) {
            return null;
        }
        NodeList attrs = item.getChildNodes();
        ScalingGroup group = new ScalingGroup();
        group.setProviderOwnerId(ctx.getAccountNumber());
        group.setProviderRegionId(ctx.getRegionId());
        for (int i = 0; i < attrs.getLength(); ++i) {
            String[] ids;
            int j;
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equalsIgnoreCase("MinSize")) {
                group.setMinServers(Integer.parseInt(attr.getFirstChild().getNodeValue()));
                continue;
            }
            if (name.equalsIgnoreCase("MaxSize")) {
                group.setMaxServers(Integer.parseInt(attr.getFirstChild().getNodeValue()));
                continue;
            }
            if (name.equalsIgnoreCase("Cooldown")) {
                group.setCooldown(Integer.parseInt(attr.getFirstChild().getNodeValue()));
                continue;
            }
            if (name.equalsIgnoreCase("CreatedTime")) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                try {
                    group.setCreationTimestamp(fmt.parse(attr.getFirstChild().getNodeValue()).getTime());
                }
                catch (ParseException e) {
                    logger.error((Object)("Could not parse timestamp: " + attr.getFirstChild().getNodeValue()));
                    group.setCreationTimestamp(System.currentTimeMillis());
                }
                continue;
            }
            if (name.equalsIgnoreCase("DesiredCapacity")) {
                group.setTargetCapacity(Integer.parseInt(attr.getFirstChild().getNodeValue()));
                continue;
            }
            if (name.equalsIgnoreCase("LaunchConfigurationName")) {
                group.setProviderLaunchConfigurationId(attr.getFirstChild().getNodeValue());
                continue;
            }
            if (name.equalsIgnoreCase("AutoScalingGroupName")) {
                String gname = attr.getFirstChild().getNodeValue();
                group.setProviderScalingGroupId(gname);
                group.setName(gname);
                group.setDescription(gname);
                continue;
            }
            if (name.equalsIgnoreCase("Instances")) {
                if (attr.hasChildNodes()) {
                    ArrayList<String> instanceIds = new ArrayList<String>();
                    NodeList instances = attr.getChildNodes();
                    for (j = 0; j < instances.getLength(); ++j) {
                        Node instance = instances.item(j);
                        if (!instance.getNodeName().equals("member") || !instance.hasChildNodes()) continue;
                        NodeList items = instance.getChildNodes();
                        for (int k = 0; k < items.getLength(); ++k) {
                            Node val = items.item(k);
                            if (!val.getNodeName().equalsIgnoreCase("InstanceId")) continue;
                            instanceIds.add(val.getFirstChild().getNodeValue());
                        }
                    }
                    ids = new String[instanceIds.size()];
                    j = 0;
                    for (String id : instanceIds) {
                        ids[j++] = id;
                    }
                } else {
                    ids = new String[]{};
                }
                group.setProviderServerIds(ids);
                continue;
            }
            if (!name.equalsIgnoreCase("AvailabilityZones")) continue;
            if (attr.hasChildNodes()) {
                ArrayList<String> zoneIds = new ArrayList<String>();
                NodeList zones = attr.getChildNodes();
                for (j = 0; j < zones.getLength(); ++j) {
                    Node zone = zones.item(j);
                    if (!zone.getNodeName().equalsIgnoreCase("member")) continue;
                    zoneIds.add(zone.getFirstChild().getNodeValue());
                }
                ids = new String[zoneIds.size()];
                j = 0;
                for (String zoneId : zoneIds) {
                    ids[j++] = zoneId;
                }
            } else {
                ids = new String[]{};
            }
            group.setProviderDataCenterIds(ids);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAutoScalingGroup(@Nonnull String scalingGroupId, @Nonnull String launchConfigurationId, @Nonnegative int minServers, @Nonnegative int maxServers, @Nonnegative int cooldown, String ... zoneIds) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"updateAutoScalingGroup");
        try {
            Map<String, String> parameters = this.getAutoScalingParameters(this.provider.getContext(), "UpdateAutoScalingGroup");
            if (minServers < 0) {
                minServers = 0;
            }
            if (maxServers < minServers) {
                maxServers = minServers;
            }
            parameters.put("AutoScalingGroupName", scalingGroupId);
            parameters.put("LaunchConfigurationName", launchConfigurationId);
            parameters.put("MinSize", String.valueOf(minServers));
            parameters.put("MaxSize", String.valueOf(maxServers));
            parameters.put("Cooldown", String.valueOf(cooldown));
            int i = 1;
            for (String zoneId : zoneIds) {
                parameters.put("AvailabilityZones.member." + i++, zoneId);
            }
            EC2Method method = new EC2Method(this.provider, this.getAutoScalingUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }
}

