/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.compute;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EBSVolume;
import org.dasein.cloud.aws.compute.EC2ComputeServices;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.compute.Snapshot;
import org.dasein.cloud.compute.SnapshotState;
import org.dasein.cloud.compute.SnapshotSupport;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EBSSnapshot
implements SnapshotSupport {
    private static final Logger logger = AWSCloud.getLogger(EBSSnapshot.class);
    private AWSCloud provider = null;

    EBSSnapshot(@Nonnull AWSCloud provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSnapshotShare(@Nonnull String providerSnapshotId, @Nonnull String accountNumber) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"addSnapshotShare");
        try {
            this.setPrivateShare(providerSnapshotId, true, accountNumber);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPublicShare(@Nonnull String providerSnapshotId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"addPublicShare");
        try {
            this.setPublicShare(providerSnapshotId, true);
        }
        finally {
            APITrace.end();
        }
    }

    @Deprecated
    @Nonnull
    public String create(@Nonnull String fromVolumeId, @Nonnull String description) throws InternalException, CloudException {
        String name = description == null ? "From " + fromVolumeId : description;
        return this.snapshot(fromVolumeId, name, name, new Tag[0]).getProviderSnapshotId();
    }

    @Nonnull
    public String getProviderTermForSnapshot(@Nonnull Locale locale) {
        return "snapshot";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Snapshot getSnapshot(@Nonnull String snapshotId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"getSnapshot");
        try {
            Iterator<Snapshot> i$;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context exists for this request.");
            }
            if (!this.provider.getEC2Provider().isAWS()) {
                i$ = this.listSnapshots().iterator();
            } else {
                Document doc;
                Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeSnapshots");
                parameters.put("SnapshotId.1", snapshotId);
                EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    String code = e.getCode();
                    if (code != null && (code.startsWith("InvalidSnapshot.NotFound") || code.equals("InvalidParameterValue"))) {
                        Snapshot snapshot = null;
                        APITrace.end();
                        return snapshot;
                    }
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
                NodeList blocks = doc.getElementsByTagName("snapshotSet");
                int i = 0;
                while (true) {
                    if (i >= blocks.getLength()) {
                        Snapshot snapshot = null;
                        return snapshot;
                    }
                    NodeList items = blocks.item(i).getChildNodes();
                    for (int j = 0; j < items.getLength(); ++j) {
                        Snapshot snapshot;
                        Node item = items.item(j);
                        if (!item.getNodeName().equals("item") || (snapshot = this.toSnapshot(ctx, item)) == null || !snapshot.getProviderSnapshotId().equals(snapshotId)) continue;
                        Snapshot snapshot2 = snapshot;
                        return snapshot2;
                    }
                    ++i;
                }
            }
            while (i$.hasNext()) {
                Snapshot snapshot = i$.next();
                if (!snapshot.getProviderSnapshotId().equals(snapshotId)) continue;
                Snapshot snapshot3 = snapshot;
                return snapshot3;
            }
            Snapshot snapshot = null;
            return snapshot;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Requirement identifyAttachmentRequirement() throws InternalException, CloudException {
        return Requirement.OPTIONAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPublic(@Nonnull String snapshotId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"isPublic");
        try {
            Document doc;
            if (!this.provider.getEC2Provider().isAWS()) {
                boolean bl = false;
                return bl;
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeSnapshotAttribute");
            parameters.put("SnapshotId.1", snapshotId);
            parameters.put("Attribute", "createVolumePermission");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                String code = e.getCode();
                if (code != null && code.startsWith("InvalidSnapshot.NotFound")) {
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("createVolumePermission");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("item")) continue;
                    NodeList attrs = item.getChildNodes();
                    for (int k = 0; k < attrs.getLength(); ++k) {
                        String group;
                        Node attr = attrs.item(k);
                        if (!attr.getNodeName().equals("group") || (group = attr.getFirstChild().getNodeValue()) == null) continue;
                        boolean bl = group.equals("all");
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSubscribed() throws InternalException, CloudException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<String> listShares(@Nonnull String forSnapshotId) throws InternalException, CloudException {
        Document doc;
        APITrace.begin((CloudProvider)this.provider, (String)"listShares");
        if (!this.provider.getEC2Provider().isAWS()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeSnapshotAttribute");
        ArrayList<String> list = new ArrayList<String>();
        parameters.put("SnapshotId.1", forSnapshotId);
        parameters.put("Attribute", "createVolumePermission");
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && (code.startsWith("InvalidSnapshotID") || code.equals("InvalidSnapshot.NotFound"))) {
                ArrayList<String> arrayList = list;
                APITrace.end();
                return arrayList;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("createVolumePermission");
        for (int i = 0; i < blocks.getLength(); ++i) {
            NodeList items = blocks.item(i).getChildNodes();
            for (int j = 0; j < items.getLength(); ++j) {
                Node item = items.item(j);
                if (!item.getNodeName().equals("item")) continue;
                NodeList attrs = item.getChildNodes();
                for (int k = 0; k < attrs.getLength(); ++k) {
                    String userId;
                    Node attr = attrs.item(k);
                    if (!attr.getNodeName().equals("userId") || (userId = attr.getFirstChild().getNodeValue()) == null || (userId = userId.trim()).length() <= 0) continue;
                    list.add(userId);
                }
            }
        }
        ArrayList<String> arrayList = list;
        return arrayList;
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listSnapshotStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listSnapshotStatus");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context exists for this request.");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeSnapshots");
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            parameters.put("Owner.1", "self");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("snapshotSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    ResourceStatus status;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("item") || (status = this.toStatus(item)) == null) continue;
                    list.add(status);
                }
            }
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Snapshot> listSnapshots() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listSnapshots");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context exists for this request.");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeSnapshots");
            ArrayList<Snapshot> list = new ArrayList<Snapshot>();
            parameters.put("Owner.1", "self");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("snapshotSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    Snapshot snapshot;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("item") || (snapshot = this.toSnapshot(ctx, item)) == null) continue;
                    list.add(snapshot);
                }
            }
            ArrayList<Snapshot> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)SnapshotSupport.ANY)) {
            return new String[]{"ec2:*"};
        }
        if (action.equals((Object)SnapshotSupport.CREATE_SNAPSHOT)) {
            return new String[]{"ec2:CreateSnapshot"};
        }
        if (action.equals((Object)SnapshotSupport.GET_SNAPSHOT) || action.equals((Object)SnapshotSupport.LIST_SNAPSHOT)) {
            return new String[]{"ec2:DescribeSnapshots"};
        }
        if (action.equals((Object)SnapshotSupport.MAKE_PUBLIC) || action.equals((Object)SnapshotSupport.SHARE_SNAPSHOT)) {
            return new String[]{"ec2:ModifySnapshotAttribute"};
        }
        if (action.equals((Object)SnapshotSupport.REMOVE_SNAPSHOT)) {
            return new String[]{"ec2:DeleteSnapshot"};
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(@Nonnull String snapshotId) throws InternalException, CloudException {
        Document doc;
        APITrace.begin((CloudProvider)this.provider, (String)"remove");
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteSnapshot");
        parameters.put("SnapshotId", snapshotId);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.equals("InvalidSnapshot.NotFound")) {
                APITrace.end();
                return;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("return");
        if (blocks.getLength() <= 0 || blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) return;
        throw new CloudException("Deletion of snapshot denied.");
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllSnapshotShares(@Nonnull String providerSnapshotId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeAllSnapshotShares");
        try {
            List shares = (List)this.listShares(providerSnapshotId);
            if (shares.isEmpty()) {
                return;
            }
            this.setPrivateShare(providerSnapshotId, false, shares.toArray(new String[shares.size()]));
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSnapshotShare(@Nonnull String providerSnapshotId, @Nonnull String accountNumber) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeSnapshotShare");
        try {
            this.setPrivateShare(providerSnapshotId, false, accountNumber);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePublicShare(@Nonnull String providerSnapshotId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removePublicShare");
        try {
            this.setPublicShare(providerSnapshotId, false);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Snapshot> searchSnapshots(@Nullable String ownerId, @Nullable String keyword) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"searchSnapshots");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context exists for this request.");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeSnapshots");
            ArrayList<Snapshot> list = new ArrayList<Snapshot>();
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("snapshotSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    Snapshot snapshot;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("item") || (snapshot = this.toSnapshot(ctx, item)) == null || ownerId != null && !ownerId.equals(snapshot.getProviderSnapshotId()) || keyword != null && !snapshot.getName().contains(keyword) && !snapshot.getDescription().contains(keyword)) continue;
                    list.add(snapshot);
                }
            }
            ArrayList<Snapshot> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    private void setPublicShare(@Nonnull String snapshotId, boolean affirmative) throws InternalException, CloudException {
        Document doc;
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ModifySnapshotAttribute");
        parameters.put("SnapshotId", snapshotId);
        parameters.put("UserGroup.1", "all");
        parameters.put("Attribute", "createVolumePermission");
        parameters.put("OperationType", affirmative ? "add" : "remove");
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidSnapshot.NotFound")) {
                return;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("return");
        if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
            throw new CloudException("Deletion of snapshot denied.");
        }
    }

    private void setPrivateShare(@Nonnull String snapshotId, boolean affirmative, String ... accountIds) throws InternalException, CloudException {
        Document doc;
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ModifySnapshotAttribute");
        parameters.put("SnapshotId", snapshotId);
        for (int i = 0; i < accountIds.length; ++i) {
            parameters.put("UserId." + i, accountIds[i]);
        }
        parameters.put("Attribute", "createVolumePermission");
        parameters.put("OperationType", affirmative ? "add" : "remove");
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidSnapshot.NotFound")) {
                return;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("return");
        if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
            throw new CloudException("Deletion of snapshot denied.");
        }
    }

    @Deprecated
    public void shareSnapshot(@Nonnull String snapshotId, @Nullable String withAccountId, boolean affirmative) throws InternalException, CloudException {
        if (withAccountId == null) {
            this.setPublicShare(snapshotId, affirmative);
        } else {
            this.setPrivateShare(snapshotId, affirmative, withAccountId);
        }
    }

    @Nonnull
    public Snapshot snapshot(@Nonnull String volumeId, @Nonnull String name, @Nonnull String description, Tag ... tags) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"snapshot");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateSnapshot");
            parameters.put("VolumeId", volumeId);
            parameters.put("Description", description);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("snapshotId");
            if (blocks.getLength() > 0) {
                Tag[] toCreate;
                Snapshot snapshot = this.getSnapshot(blocks.item(0).getFirstChild().getNodeValue().trim());
                if (snapshot == null) {
                    throw new CloudException("No error occurred, but no snapshot was provided");
                }
                if (tags == null || tags.length < 1) {
                    toCreate = new Tag[1];
                } else {
                    toCreate = new Tag[1 + tags.length];
                    System.arraycopy(tags, 0, toCreate, 0, tags.length);
                }
                Tag t = new Tag();
                t.setKey("Name");
                t.setValue(name);
                toCreate[toCreate.length - 1] = t;
                this.provider.createTags(snapshot.getProviderSnapshotId(), toCreate);
                snapshot.setName(name);
                Snapshot snapshot2 = snapshot;
                return snapshot2;
            }
            throw new CloudException("No error occurred, but no snapshot was provided");
        }
        finally {
            APITrace.end();
        }
    }

    public boolean supportsSnapshotCreation() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsSnapshotSharing() throws InternalException, CloudException {
        return this.provider.getEC2Provider().isAWS();
    }

    public boolean supportsSnapshotSharingWithPublic() throws InternalException, CloudException {
        return this.provider.getEC2Provider().isAWS();
    }

    @Nullable
    private Snapshot toSnapshot(@Nonnull ProviderContext ctx, @Nullable Node node) throws CloudException {
        EC2ComputeServices svc;
        if (node == null) {
            return null;
        }
        NodeList attrs = node.getChildNodes();
        Snapshot snapshot = new Snapshot();
        if (!this.provider.getEC2Provider().isAWS()) {
            snapshot.setOwner(ctx.getAccountNumber());
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            NodeList children;
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("snapshotId")) {
                snapshot.setProviderSnapshotId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("volumeId")) {
                String vol;
                children = attr.getChildNodes();
                if (children == null || children.getLength() <= 0 || (vol = children.item(0).getNodeValue()) == null || (vol = vol.trim()).length() <= 0) continue;
                snapshot.setVolumeId(vol);
                continue;
            }
            if (name.equals("status")) {
                String s = attr.getFirstChild().getNodeValue().trim();
                SnapshotState state = s.equals("completed") ? SnapshotState.AVAILABLE : (s.equals("deleting") || s.equals("deleted") ? SnapshotState.DELETED : SnapshotState.PENDING);
                snapshot.setCurrentState(state);
                continue;
            }
            if (name.equals("startTime")) {
                String t;
                children = attr.getChildNodes();
                long ts = 0L;
                if (children != null && children.getLength() > 0 && (t = children.item(0).getNodeValue()) != null) {
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                    if ((t = t.trim()).length() > 0) {
                        try {
                            ts = fmt.parse(t).getTime();
                        }
                        catch (ParseException e) {
                            logger.error((Object)e);
                            e.printStackTrace();
                            throw new CloudException((Throwable)e);
                        }
                    }
                }
                snapshot.setSnapshotTimestamp(ts);
                continue;
            }
            if (name.equals("progress")) {
                String p;
                children = attr.getChildNodes();
                String progress = "100%";
                if (children != null && children.getLength() > 0 && (p = children.item(0).getNodeValue()) != null && (p = p.trim()).length() > 0) {
                    progress = p;
                }
                snapshot.setProgress(progress);
                continue;
            }
            if (name.equals("ownerId")) {
                snapshot.setOwner(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("volumeSize")) {
                String val = attr.getFirstChild().getNodeValue().trim();
                if (val == null || val.equals("n/a")) {
                    snapshot.setSizeInGb(0);
                    continue;
                }
                snapshot.setSizeInGb(Integer.parseInt(val));
                continue;
            }
            if (name.equals("description")) {
                String d;
                children = attr.getChildNodes();
                String description = null;
                if (children != null && children.getLength() > 0 && (d = children.item(0).getNodeValue()) != null) {
                    description = d.trim();
                }
                snapshot.setDescription(description);
                continue;
            }
            if (!name.equals("tagSet") || !attr.hasChildNodes()) continue;
            NodeList tags = attr.getChildNodes();
            for (int j = 0; j < tags.getLength(); ++j) {
                Node tag = tags.item(j);
                if (!tag.getNodeName().equals("item") || !tag.hasChildNodes()) continue;
                NodeList parts = tag.getChildNodes();
                String key = null;
                String value = null;
                for (int k = 0; k < parts.getLength(); ++k) {
                    Node part = parts.item(k);
                    if (part.getNodeName().equalsIgnoreCase("key")) {
                        if (!part.hasChildNodes()) continue;
                        key = part.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (!part.getNodeName().equalsIgnoreCase("value") || !part.hasChildNodes()) continue;
                    value = part.getFirstChild().getNodeValue().trim();
                }
                if (key == null) continue;
                if (key.equalsIgnoreCase("name")) {
                    snapshot.setName(value);
                    continue;
                }
                snapshot.addTag(key, value);
            }
        }
        if (snapshot.getName() == null) {
            snapshot.setName(snapshot.getProviderSnapshotId());
        }
        if (snapshot.getDescription() == null) {
            snapshot.setDescription(snapshot.getName() + " [" + snapshot.getSizeInGb() + " GB]");
        }
        snapshot.setRegionId(ctx.getRegionId());
        if (snapshot.getSizeInGb() < 1 && (svc = this.provider.getComputeServices()) != null) {
            EBSVolume vs = svc.getVolumeSupport();
            try {
                Volume volume = vs.getVolume(snapshot.getProviderSnapshotId());
                if (volume != null) {
                    snapshot.setSizeInGb(volume.getSizeInGigabytes());
                }
            }
            catch (InternalException ignore) {
                // empty catch block
            }
        }
        return snapshot;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) throws CloudException {
        if (node == null) {
            return null;
        }
        NodeList attrs = node.getChildNodes();
        SnapshotState state = SnapshotState.PENDING;
        String snapshotId = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("snapshotId")) {
                snapshotId = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!name.equals("status")) continue;
            String s = attr.getFirstChild().getNodeValue().trim();
            state = s.equals("completed") ? SnapshotState.AVAILABLE : (s.equals("deleting") || s.equals("deleted") ? SnapshotState.DELETED : SnapshotState.PENDING);
        }
        if (snapshotId == null) {
            return null;
        }
        return new ResourceStatus(snapshotId, (Object)state);
    }
}

