/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.compute;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Taggable;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.compute.VolumeProduct;
import org.dasein.cloud.compute.VolumeState;
import org.dasein.cloud.compute.VolumeSupport;
import org.dasein.cloud.compute.VolumeType;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EBSVolume
implements VolumeSupport {
    private static final Logger logger = Logger.getLogger(EBSVolume.class);
    private AWSCloud provider = null;

    EBSVolume(AWSCloud provider) {
        this.provider = provider;
    }

    public void attach(@Nonnull String volumeId, @Nonnull String toServer, @Nonnull String device) throws InternalException, CloudException {
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "AttachVolume");
        parameters.put("VolumeId", volumeId);
        parameters.put("InstanceId", toServer);
        parameters.put("Device", device);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            method.invoke();
        }
        catch (EC2Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public String create(@Nullable String fromSnapshot, @Nonnegative int sizeInGb, @Nonnull String inZone) throws InternalException, CloudException {
        if (fromSnapshot != null) {
            return this.createVolume(VolumeCreateOptions.getInstanceForSnapshot((String)fromSnapshot, (Storage)new Storage((Number)sizeInGb, (StorageUnit)Storage.GIGABYTE), (String)"dsn-auto-volume", (String)"dsn-auto-volume").inDataCenter(inZone));
        }
        return this.createVolume(VolumeCreateOptions.getInstance((Storage)new Storage((Number)sizeInGb, (StorageUnit)Storage.GIGABYTE), (String)"dsn-auto-volume", (String)"dsn-auto-volume").inDataCenter(inZone));
    }

    @Nonnull
    public String createVolume(@Nonnull VolumeCreateOptions options) throws InternalException, CloudException {
        Document doc;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("No context was specified for this request");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(ctx, "CreateVolume");
        if (options.getSnapshotId() != null) {
            parameters.put("SnapshotId", options.getSnapshotId());
        }
        parameters.put("Size", String.valueOf(options.getVolumeSize().getQuantity().intValue()));
        String az = options.getDataCenterId();
        if (az == null) {
            for (DataCenter dc : this.provider.getDataCenterServices().listDataCenters(ctx.getRegionId())) {
                az = dc.getProviderDataCenterId();
            }
            if (az == null) {
                throw new CloudException("Unable to identify a launch data center");
            }
        }
        parameters.put("AvailabilityZone", az);
        if ((this.provider.getEC2Provider().isAWS() || this.provider.getEC2Provider().isEnStratus()) && options.getVolumeProductId() != null) {
            VolumeProduct prd = null;
            for (VolumeProduct p : this.listVolumeProducts()) {
                if (!p.getProviderProductId().equals(options.getVolumeProductId())) continue;
                prd = p;
                break;
            }
            if (prd != null) {
                parameters.put("VolumeType", prd.getProviderProductId());
                if (prd.getMaxIops() > 0 && options.getIops() > 0) {
                    parameters.put("Iops", String.valueOf(options.getIops()));
                } else if (prd.getMinIops() > 0) {
                    parameters.put("Iops", String.valueOf(prd.getMinIops()));
                }
            }
        }
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("volumeId");
        if (blocks.getLength() > 0) {
            return blocks.item(0).getFirstChild().getNodeValue().trim();
        }
        throw new CloudException("Successful POST, but no volume information was provided");
    }

    public void detach(@Nonnull String volumeId) throws InternalException, CloudException {
        this.detach(volumeId, false);
    }

    public void detach(@Nonnull String volumeId, boolean force) throws InternalException, CloudException {
        Document doc;
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DetachVolume");
        parameters.put("VolumeId", volumeId);
        if (force) {
            parameters.put("Force", "true");
        }
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("return");
        if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
            throw new CloudException("Detach of volume denied.");
        }
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return -2;
    }

    @Nullable
    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1024, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)10, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "volume";
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        ArrayList<String> list = new ArrayList<String>();
        if (platform.isWindows()) {
            list.add("xvdf");
            list.add("xvdg");
            list.add("xvdh");
            list.add("xvdi");
            list.add("xvdj");
        } else {
            list.add("/dev/sdf");
            list.add("/dev/sdg");
            list.add("/dev/sdh");
            list.add("/dev/sdi");
            list.add("/dev/sdj");
        }
        return list;
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    @Nonnull
    public Iterable<VolumeProduct> listVolumeProducts() throws InternalException, CloudException {
        String regionId;
        ArrayList<VolumeProduct> prds = new ArrayList<VolumeProduct>();
        ProviderContext ctx = this.provider.getContext();
        float rawPrice = 0.11f;
        if (ctx != null && (regionId = ctx.getRegionId()) != null) {
            if (regionId.equals("us-east-1") || regionId.equals("us-west-2")) {
                rawPrice = 0.1f;
            } else if (regionId.equals("ap-northeast-1")) {
                rawPrice = 0.12f;
            } else if (regionId.equals("sa-east-1")) {
                rawPrice = 0.19f;
            }
        }
        prds.add(VolumeProduct.getInstance((String)"standard", (String)"Standard", (String)"Standard EBS with no IOPS Guarantees", (VolumeType)VolumeType.HDD, this.getMinimumVolumeSize(), (String)"USD", (int)0, (int)0, (Float)Float.valueOf(rawPrice), (Float)Float.valueOf(0.0f)));
        prds.add(VolumeProduct.getInstance((String)"io1", (String)"IOPS EBS", (String)"EBS Volume with IOPS guarantees", (VolumeType)VolumeType.HDD, this.getMinimumVolumeSize(), (String)"USD", (int)100, (int)1000, (Float)Float.valueOf(0.125f), (Float)Float.valueOf(0.1f)));
        return prds;
    }

    @Nullable
    public Volume getVolume(@Nonnull String volumeId) throws InternalException, CloudException {
        Document doc;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context exists for this request.");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeVolumes");
        parameters.put("VolumeId.1", volumeId);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && (code.startsWith("InvalidVolume.NotFound") || code.equals("InvalidParameterValue"))) {
                return null;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("volumeSet");
        for (int i = 0; i < blocks.getLength(); ++i) {
            NodeList items = blocks.item(i).getChildNodes();
            for (int j = 0; j < items.getLength(); ++j) {
                Volume volume;
                Node item = items.item(j);
                if (!item.getNodeName().equals("item") || (volume = this.toVolume(ctx, item)) == null || !volume.getProviderVolumeId().equals(volumeId)) continue;
                return volume;
            }
        }
        return null;
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return this.provider.getEC2Provider().isEucalyptus() || this.provider.getEC2Provider().isOpenStack() ? Requirement.NONE : Requirement.OPTIONAL;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public Iterable<ResourceStatus> listVolumeStatus() throws InternalException, CloudException {
        Document doc;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context exists for this request.");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeVolumes");
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("volumeSet");
        for (int i = 0; i < blocks.getLength(); ++i) {
            NodeList items = blocks.item(i).getChildNodes();
            for (int j = 0; j < items.getLength(); ++j) {
                ResourceStatus status;
                Node item = items.item(j);
                if (!item.getNodeName().equals("item") || (status = this.toStatus(item)) == null) continue;
                list.add(status);
            }
        }
        return list;
    }

    @Nonnull
    public Iterable<Volume> listVolumes() throws InternalException, CloudException {
        Document doc;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context exists for this request.");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeVolumes");
        ArrayList<Volume> list = new ArrayList<Volume>();
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("volumeSet");
        for (int i = 0; i < blocks.getLength(); ++i) {
            NodeList items = blocks.item(i).getChildNodes();
            for (int j = 0; j < items.getLength(); ++j) {
                Volume volume;
                Node item = items.item(j);
                if (!item.getNodeName().equals("item") || (volume = this.toVolume(ctx, item)) == null) continue;
                list.add(volume);
            }
        }
        return list;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)VolumeSupport.ANY)) {
            return new String[]{"ec2:*"};
        }
        if (action.equals((Object)VolumeSupport.ATTACH)) {
            return new String[]{"ec2:AttachVolume"};
        }
        if (action.equals((Object)VolumeSupport.CREATE_VOLUME)) {
            return new String[]{"ec2:CreateVolume"};
        }
        if (action.equals((Object)VolumeSupport.DETACH)) {
            return new String[]{"ec2:DetachVolume"};
        }
        if (action.equals((Object)VolumeSupport.GET_VOLUME) || action.equals((Object)VolumeSupport.LIST_VOLUME)) {
            return new String[]{"ec2:DescribeVolumes"};
        }
        if (action.equals((Object)VolumeSupport.REMOVE_VOLUME)) {
            return new String[]{"ec2:DeleteVolume"};
        }
        return new String[0];
    }

    public void remove(@Nonnull String volumeId) throws InternalException, CloudException {
        Document doc;
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteVolume");
        parameters.put("VolumeId", volumeId);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("return");
        if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
            throw new CloudException("Deletion of volume denied.");
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) throws CloudException {
        if (node == null) {
            return null;
        }
        NodeList attrs = node.getChildNodes();
        VolumeState state = VolumeState.PENDING;
        String volumeId = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("volumeId")) {
                volumeId = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!name.equals("status")) continue;
            String s = attr.getFirstChild().getNodeValue().trim();
            state = s.equals("creating") || s.equals("attaching") || s.equals("attached") || s.equals("detaching") || s.equals("detached") ? VolumeState.PENDING : (s.equals("available") || s.equals("in-use") ? VolumeState.AVAILABLE : VolumeState.DELETED);
        }
        if (volumeId == null) {
            return null;
        }
        return new ResourceStatus(volumeId, (Object)state);
    }

    @Nullable
    private Volume toVolume(@Nonnull ProviderContext ctx, @Nullable Node node) throws CloudException {
        if (node == null) {
            return null;
        }
        NodeList attrs = node.getChildNodes();
        Volume volume = new Volume();
        volume.setProviderProductId("standard");
        volume.setType(VolumeType.HDD);
        volume.setFormat(VolumeFormat.BLOCK);
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("volumeId")) {
                volume.setProviderVolumeId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equalsIgnoreCase("name") && attr.hasChildNodes()) {
                volume.setName(attr.getFirstChild().getNodeName().trim());
                continue;
            }
            if (name.equalsIgnoreCase("description") && attr.hasChildNodes()) {
                volume.setDescription(attr.getFirstChild().getNodeName().trim());
                continue;
            }
            if (name.equals("size")) {
                int size = Integer.parseInt(attr.getFirstChild().getNodeValue().trim());
                volume.setSize(new Storage((Number)size, (StorageUnit)Storage.GIGABYTE));
                continue;
            }
            if (name.equals("snapshotId")) {
                NodeList values = attr.getChildNodes();
                if (values == null || values.getLength() <= 0) continue;
                volume.setProviderSnapshotId(values.item(0).getNodeValue().trim());
                continue;
            }
            if (name.equals("availabilityZone")) {
                String zoneId = attr.getFirstChild().getNodeValue().trim();
                volume.setProviderDataCenterId(zoneId);
                continue;
            }
            if (name.equalsIgnoreCase("volumeType") && attr.hasChildNodes()) {
                volume.setProviderProductId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equalsIgnoreCase("iops") && attr.hasChildNodes()) {
                volume.setIops(Integer.parseInt(attr.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (name.equals("createTime")) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                String value = attr.getFirstChild().getNodeValue().trim();
                try {
                    volume.setCreationTimestamp(fmt.parse(value).getTime());
                    continue;
                }
                catch (ParseException e) {
                    logger.error((Object)e);
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
            }
            if (name.equals("status")) {
                String s = attr.getFirstChild().getNodeValue().trim();
                VolumeState state = s.equals("creating") || s.equals("attaching") || s.equals("attached") || s.equals("detaching") || s.equals("detached") ? VolumeState.PENDING : (s.equals("available") || s.equals("in-use") ? VolumeState.AVAILABLE : VolumeState.DELETED);
                volume.setCurrentState(state);
                continue;
            }
            if (name.equals("tagSet")) {
                Taggable tmp = new Taggable(){
                    HashMap<String, String> tags = new HashMap();

                    @Nonnull
                    public Map<String, String> getTags() {
                        return this.tags;
                    }

                    public void setTag(@Nonnull String key, @Nonnull String value) {
                        this.tags.put(key, value);
                    }
                };
                this.provider.setTags(attr, tmp);
                String s = (String)tmp.getTags().get("Name");
                if (s != null && volume.getName() == null) {
                    volume.setName(s);
                }
                if ((s = (String)tmp.getTags().get("Description")) == null || volume.getDescription() != null) continue;
                volume.setDescription(s);
                continue;
            }
            if (!name.equals("attachmentSet")) continue;
            NodeList attachments = attr.getChildNodes();
            for (int j = 0; j < attachments.getLength(); ++j) {
                Node item = attachments.item(j);
                if (!item.getNodeName().equals("item")) continue;
                NodeList infoList = item.getChildNodes();
                for (int k = 0; k < infoList.getLength(); ++k) {
                    Node info = infoList.item(k);
                    name = info.getNodeName();
                    if (name.equals("instanceId")) {
                        volume.setProviderVirtualMachineId(info.getFirstChild().getNodeValue().trim());
                        continue;
                    }
                    if (!name.equals("device")) continue;
                    String deviceId = info.getFirstChild().getNodeValue().trim();
                    if (deviceId.startsWith("unknown,requested:")) {
                        deviceId = deviceId.substring(18);
                    }
                    volume.setDeviceId(deviceId);
                }
            }
        }
        if (volume.getProviderVolumeId() == null) {
            return null;
        }
        if (volume.getName() == null) {
            volume.setName(volume.getProviderVolumeId());
        }
        if (volume.getDescription() == null) {
            volume.setDescription(volume.getName());
        }
        volume.setProviderRegionId(ctx.getRegionId());
        return volume;
    }
}

