/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.compute;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.AMI;
import org.dasein.cloud.aws.compute.AutoScaling;
import org.dasein.cloud.aws.compute.EBSSnapshot;
import org.dasein.cloud.aws.compute.EBSVolume;
import org.dasein.cloud.aws.compute.EC2Instance;
import org.dasein.cloud.compute.AbstractComputeServices;

public class EC2ComputeServices
extends AbstractComputeServices {
    private AWSCloud cloud;

    public EC2ComputeServices(@Nonnull AWSCloud cloud) {
        this.cloud = cloud;
    }

    @Nullable
    public AutoScaling getAutoScalingSupport() {
        if (!this.cloud.getEC2Provider().isAWS() && !this.cloud.getEC2Provider().isEnStratus()) {
            return null;
        }
        return new AutoScaling(this.cloud);
    }

    @Nonnull
    public AMI getImageSupport() {
        return new AMI(this.cloud);
    }

    @Nonnull
    public EBSSnapshot getSnapshotSupport() {
        return new EBSSnapshot(this.cloud);
    }

    @Nonnull
    public EC2Instance getVirtualMachineSupport() {
        return new EC2Instance(this.cloud);
    }

    @Nonnull
    public EBSVolume getVolumeSupport() {
        return new EBSVolume(this.cloud);
    }
}

