/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.compute;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.aws.network.EC2NetworkServices;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VMScalingOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VmStatistics;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.VLANSupport;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EC2Instance
implements VirtualMachineSupport {
    private static final Logger logger = Logger.getLogger(EC2Instance.class);
    private static final Calendar UTC_CALENDAR = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
    private AWSCloud provider = null;
    private static volatile Collection<Architecture> architectures;

    EC2Instance(AWSCloud provider) {
        this.provider = provider;
    }

    public VirtualMachine alterVirtualMachine(@Nonnull String vmId, @Nonnull VMScalingOptions options) throws InternalException, CloudException {
        throw new OperationNotSupportedException("AWS does not support vertical scaling of instances");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(@Nonnull String instanceId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"startVM");
        try {
            VirtualMachine vm = this.getVirtualMachine(instanceId);
            if (vm == null) {
                throw new CloudException("No such instance: " + instanceId);
            }
            if (!vm.isPersistent()) {
                throw new OperationNotSupportedException("Instances backed by ephemeral drives are not start/stop capable");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "StartInstances");
            parameters.put("InstanceId.1", instanceId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Metric> calculate(String metric, String unit, String instanceId, long startTimestamp, long endTimestamp) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"calculateVMAnalytics");
        try {
            Document doc;
            if (!this.provider.getEC2Provider().isAWS()) {
                TreeSet<Metric> treeSet = new TreeSet<Metric>();
                return treeSet;
            }
            Map<String, String> parameters = this.provider.getStandardCloudWatchParameters(this.provider.getContext(), "GetMetricStatistics");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            fmt.setCalendar(UTC_CALENDAR);
            parameters.put("EndTime", fmt.format(new Date(endTimestamp)));
            parameters.put("StartTime", fmt.format(new Date(startTimestamp)));
            parameters.put("MetricName", metric);
            parameters.put("Namespace", "AWS/EC2");
            parameters.put("Unit", unit);
            parameters.put("Dimensions.member.Name.1", "InstanceId");
            parameters.put("Dimensions.member.Value.1", instanceId);
            parameters.put("Statistics.member.1", "Average");
            parameters.put("Statistics.member.2", "Minimum");
            parameters.put("Statistics.member.3", "Maximum");
            parameters.put("Period", "60");
            EC2Method method = new EC2Method(this.provider, this.getCloudWatchUrl(this.provider.getContext()), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            TreeSet<Metric> metrics = new TreeSet<Metric>();
            fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            fmt.setCalendar(UTC_CALENDAR);
            NodeList blocks = doc.getElementsByTagName("member");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                Metric m = new Metric();
                for (int j = 0; j < items.getLength(); ++j) {
                    Node item = items.item(j);
                    if (item.getNodeName().equals("Timestamp")) {
                        String dateString = item.getFirstChild().getNodeValue();
                        try {
                            m.timestamp = fmt.parse(dateString).getTime();
                            continue;
                        }
                        catch (ParseException e) {
                            logger.error((Object)e);
                            e.printStackTrace();
                            throw new InternalException((Throwable)e);
                        }
                    }
                    if (item.getNodeName().equals("Average")) {
                        m.average = Double.parseDouble(item.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (item.getNodeName().equals("Minimum")) {
                        m.minimum = Double.parseDouble(item.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (item.getNodeName().equals("Maximum")) {
                        m.maximum = Double.parseDouble(item.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (!item.getNodeName().equals("Samples")) continue;
                    m.samples = (int)Double.parseDouble(item.getFirstChild().getNodeValue());
                }
                metrics.add(m);
            }
            TreeSet<Metric> treeSet = metrics;
            return treeSet;
        }
        finally {
            APITrace.end();
        }
    }

    private void calculate(VmStatistics stats, String metricName, String unit, String instanceId, long startTimestamp, long endTimestamp, ApplyCalcs apply) throws CloudException, InternalException {
        Set<Metric> metrics = this.calculate(metricName, unit, instanceId, startTimestamp, endTimestamp);
        double minimum = -1.0;
        double maximum = 0.0;
        double sum = 0.0;
        long start = -1L;
        long end = 0L;
        int samples = 0;
        for (Metric metric : metrics) {
            if (start < 0L) {
                start = metric.timestamp;
            }
            if (metric.timestamp > end) {
                end = metric.timestamp;
            }
            ++samples;
            if (metric.minimum < minimum || minimum < 0.0) {
                minimum = metric.minimum;
            }
            if (metric.maximum > maximum) {
                maximum = metric.maximum;
            }
            sum += metric.average;
        }
        if (start < 0L) {
            start = startTimestamp;
        }
        if (end < 0L) {
            end = endTimestamp;
        }
        if (minimum < 0.0) {
            minimum = 0.0;
        }
        apply.apply(stats, start, end, samples, sum / (double)samples, minimum, maximum);
    }

    private void calculateCpuUtilization(VmStatistics statistics, String instanceId, long startTimestamp, long endTimestamp) throws CloudException, InternalException {
        ApplyCalcs apply = new ApplyCalcs(){

            @Override
            public void apply(VmStatistics stats, long start, long end, int samples, double average, double minimum, double maximum) {
                stats.setSamples(samples);
                stats.setStartTimestamp(start);
                stats.setMinimumCpuUtilization(minimum);
                stats.setAverageCpuUtilization(average);
                stats.setMaximumCpuUtilization(maximum);
                stats.setEndTimestamp(end);
            }
        };
        this.calculate(statistics, "CPUUtilization", "Percent", instanceId, startTimestamp, endTimestamp, apply);
    }

    private void calculateDiskReadBytes(VmStatistics statistics, String instanceId, long startTimestamp, long endTimestamp) throws CloudException, InternalException {
        ApplyCalcs apply = new ApplyCalcs(){

            @Override
            public void apply(VmStatistics stats, long start, long end, int samples, double average, double minimum, double maximum) {
                stats.setMinimumDiskReadBytes(minimum);
                stats.setAverageDiskReadBytes(average);
                stats.setMaximumDiskReadBytes(maximum);
            }
        };
        this.calculate(statistics, "DiskReadBytes", "Bytes", instanceId, startTimestamp, endTimestamp, apply);
    }

    private void calculateDiskReadOps(VmStatistics statistics, String instanceId, long startTimestamp, long endTimestamp) throws CloudException, InternalException {
        ApplyCalcs apply = new ApplyCalcs(){

            @Override
            public void apply(VmStatistics stats, long start, long end, int samples, double average, double minimum, double maximum) {
                stats.setMinimumDiskReadOperations(minimum);
                stats.setAverageDiskReadOperations(average);
                stats.setMaximumDiskReadOperations(maximum);
            }
        };
        this.calculate(statistics, "DiskReadOps", "Count", instanceId, startTimestamp, endTimestamp, apply);
    }

    private void calculateDiskWriteBytes(VmStatistics statistics, String instanceId, long startTimestamp, long endTimestamp) throws CloudException, InternalException {
        ApplyCalcs apply = new ApplyCalcs(){

            @Override
            public void apply(VmStatistics stats, long start, long end, int samples, double average, double minimum, double maximum) {
                stats.setMinimumDiskWriteBytes(minimum);
                stats.setAverageDiskWriteBytes(average);
                stats.setMaximumDiskWriteBytes(maximum);
            }
        };
        this.calculate(statistics, "DiskWriteBytes", "Bytes", instanceId, startTimestamp, endTimestamp, apply);
    }

    private void calculateDiskWriteOps(VmStatistics statistics, String instanceId, long startTimestamp, long endTimestamp) throws CloudException, InternalException {
        ApplyCalcs apply = new ApplyCalcs(){

            @Override
            public void apply(VmStatistics stats, long start, long end, int samples, double average, double minimum, double maximum) {
                stats.setMinimumDiskWriteOperations(minimum);
                stats.setAverageDiskWriteOperations(average);
                stats.setMaximumDiskWriteOperations(maximum);
            }
        };
        this.calculate(statistics, "DiskWriteOps", "Count", instanceId, startTimestamp, endTimestamp, apply);
    }

    private void calculateNetworkIn(VmStatistics statistics, String instanceId, long startTimestamp, long endTimestamp) throws CloudException, InternalException {
        ApplyCalcs apply = new ApplyCalcs(){

            @Override
            public void apply(VmStatistics stats, long start, long end, int samples, double average, double minimum, double maximum) {
                stats.setMinimumNetworkIn(minimum);
                stats.setAverageNetworkIn(average);
                stats.setMaximumNetworkIn(maximum);
            }
        };
        this.calculate(statistics, "NetworkIn", "Bytes", instanceId, startTimestamp, endTimestamp, apply);
    }

    private void calculateNetworkOut(VmStatistics statistics, String instanceId, long startTimestamp, long endTimestamp) throws CloudException, InternalException {
        ApplyCalcs apply = new ApplyCalcs(){

            @Override
            public void apply(VmStatistics stats, long start, long end, int samples, double average, double minimum, double maximum) {
                stats.setMinimumNetworkOut(minimum);
                stats.setAverageNetworkOut(average);
                stats.setMaximumNetworkOut(maximum);
            }
        };
        this.calculate(statistics, "NetworkOut", "Bytes", instanceId, startTimestamp, endTimestamp, apply);
    }

    @Nonnull
    public VirtualMachine clone(@Nonnull String vmId, @Nonnull String intoDcId, @Nonnull String name, @Nonnull String description, boolean powerOn, String ... firewallIds) throws InternalException, CloudException {
        throw new OperationNotSupportedException("AWS instances cannot be cloned.");
    }

    @Nullable
    public VMScalingCapabilities describeVerticalScalingCapabilities() throws CloudException, InternalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableAnalytics(String instanceId) throws InternalException, CloudException {
        block5: {
            APITrace.begin((CloudProvider)this.provider, (String)"enableVMAnalytics");
            try {
                if (!this.provider.getEC2Provider().isAWS() && !this.provider.getEC2Provider().isEnStratus()) break block5;
                Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "MonitorInstances");
                parameters.put("InstanceId.1", instanceId);
                EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    private Architecture getArchitecture(String size) {
        if (size.equals("m1.small") || size.equals("c1.medium")) {
            return Architecture.I32;
        }
        return Architecture.I64;
    }

    @Nonnull
    private String getCloudWatchUrl(@Nonnull ProviderContext ctx) {
        return "https://monitoring." + ctx.getRegionId() + ".amazonaws.com";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String getConsoleOutput(@Nonnull String instanceId) throws InternalException, CloudException {
        Node item;
        int i;
        Document doc;
        APITrace.begin((CloudProvider)this.provider, (String)"getConsoleOutput");
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "GetConsoleOutput");
        String output = null;
        parameters.put("InstanceId", instanceId);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidInstanceID")) {
                String string = "";
                APITrace.end();
                return string;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("timestamp");
        for (i = 0; i < blocks.getLength(); ++i) {
            long timestamp;
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            fmt.setCalendar(UTC_CALENDAR);
            String ts = blocks.item(i).getFirstChild().getNodeValue();
            try {
                timestamp = fmt.parse(ts).getTime();
            }
            catch (ParseException e) {
                logger.error((Object)e);
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            if (timestamp > -1L) break;
        }
        blocks = doc.getElementsByTagName("output");
        for (i = 0; !(i >= blocks.getLength() || (item = blocks.item(i)).hasChildNodes() && (output = item.getFirstChild().getNodeValue().trim()) != null); ++i) {
        }
        if (output != null) {
            try {
                String i2 = new String(Base64.decodeBase64((byte[])output.getBytes("utf-8")), "utf-8");
                return i2;
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e);
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
        }
        String string = "";
        return string;
        finally {
            APITrace.end();
        }
    }

    public int getCostFactor(@Nonnull VmState vmState) throws InternalException, CloudException {
        return vmState.equals((Object)VmState.STOPPED) ? 0 : 100;
    }

    public int getMaximumVirtualMachineCount() throws CloudException, InternalException {
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<String> listFirewalls(@Nonnull String instanceId) throws InternalException, CloudException {
        Document doc;
        APITrace.begin((CloudProvider)this.provider, (String)"listFirewallsForVM");
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeInstances");
        ArrayList<String> firewalls = new ArrayList<String>();
        parameters.put("InstanceId.1", instanceId);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidInstanceID")) {
                ArrayList<String> arrayList = firewalls;
                APITrace.end();
                return arrayList;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("groupSet");
        for (int i = 0; i < blocks.getLength(); ++i) {
            NodeList items = blocks.item(i).getChildNodes();
            block7: for (int j = 0; j < items.getLength(); ++j) {
                Node item = items.item(j);
                if (!item.getNodeName().equals("item")) continue;
                NodeList sub = item.getChildNodes();
                for (int k = 0; k < sub.getLength(); ++k) {
                    Node id = sub.item(k);
                    if (!id.getNodeName().equalsIgnoreCase("groupId") || !id.hasChildNodes()) continue;
                    firewalls.add(id.getFirstChild().getNodeValue().trim());
                    continue block7;
                }
            }
        }
        ArrayList<String> arrayList = firewalls;
        return arrayList;
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForServer(@Nonnull Locale locale) {
        return "instance";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public VirtualMachine getVirtualMachine(@Nonnull String instanceId) throws InternalException, CloudException {
        block13: {
            APITrace.begin((CloudProvider)this.provider, (String)"getVirtualMachine");
            ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was established for this request");
            }
            parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeInstances");
            parameters.put("InstanceId.1", instanceId);
            method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                code = e.getCode();
                if (code != null && code.startsWith("InvalidInstanceID")) {
                    var9_11 = null;
                    APITrace.end();
                    return var9_11;
                }
                EC2Instance.logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            blocks = doc.getElementsByTagName("instancesSet");
            i = 0;
lbl23:
            // 2 sources

            while (true) {
                if (i < blocks.getLength()) {
                    instances = blocks.item(i).getChildNodes();
                    break block13;
                }
                var7_8 = null;
                return var7_8;
            }
            finally {
                APITrace.end();
            }
        }
        for (j = 0; j < instances.getLength(); ++j) {
            instance = instances.item(j);
            if (!instance.getNodeName().equals("item")) continue;
            addresses /* !! */  = Collections.emptyList();
            if (this.provider.hasNetworkServices() && (services = this.provider.getNetworkServices()) != null && (support = services.getIpAddressSupport()) != null) {
                addresses /* !! */  = support.listIpPool(IPVersion.IPV4, false);
            }
            if ((server = this.toVirtualMachine(ctx, instance, addresses /* !! */ )) == null || !server.getProviderVirtualMachineId().equals(instanceId)) continue;
            var13_17 = server;
            return var13_17;
        }
        ++i;
        ** continue;
    }

    @Nullable
    public VirtualMachineProduct getProduct(@Nonnull String sizeId) throws CloudException, InternalException {
        for (Architecture a : this.listSupportedArchitectures()) {
            for (VirtualMachineProduct prd : this.listProducts(a)) {
                if (!prd.getProviderProductId().equals(sizeId)) continue;
                return prd;
            }
        }
        return null;
    }

    private VmState getServerState(String state) {
        if (state.equals("pending")) {
            return VmState.PENDING;
        }
        if (state.equals("running")) {
            return VmState.RUNNING;
        }
        if (state.equals("terminating") || state.equals("stopping")) {
            return VmState.STOPPING;
        }
        if (state.equals("stopped")) {
            return VmState.STOPPED;
        }
        if (state.equals("shutting-down")) {
            return VmState.STOPPING;
        }
        if (state.equals("terminated")) {
            return VmState.TERMINATED;
        }
        if (state.equals("rebooting")) {
            return VmState.REBOOTING;
        }
        logger.warn((Object)("Unknown server state: " + state));
        return VmState.PENDING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VmStatistics getVMStatistics(String instanceId, long startTimestamp, long endTimestamp) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"getVMStatistics");
        try {
            VmStatistics statistics = new VmStatistics();
            if (endTimestamp < 1L) {
                endTimestamp = System.currentTimeMillis() + 1000L;
            }
            if (startTimestamp > endTimestamp - 120000L) {
                startTimestamp = endTimestamp - 120000L;
            } else if (startTimestamp < System.currentTimeMillis() - 172800000L) {
                startTimestamp = System.currentTimeMillis() - 172800000L;
            }
            this.calculateCpuUtilization(statistics, instanceId, startTimestamp, endTimestamp);
            this.calculateDiskReadBytes(statistics, instanceId, startTimestamp, endTimestamp);
            this.calculateDiskReadOps(statistics, instanceId, startTimestamp, endTimestamp);
            this.calculateDiskWriteBytes(statistics, instanceId, startTimestamp, endTimestamp);
            this.calculateDiskWriteOps(statistics, instanceId, startTimestamp, endTimestamp);
            this.calculateNetworkIn(statistics, instanceId, startTimestamp, endTimestamp);
            this.calculateNetworkOut(statistics, instanceId, startTimestamp, endTimestamp);
            VmStatistics vmStatistics = statistics;
            return vmStatistics;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VmStatistics> getVMStatisticsForPeriod(@Nonnull String instanceId, long startTimestamp, long endTimestamp) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"getVMStatisticsForPeriod");
        try {
            VmStatistics stats;
            int minute;
            if (endTimestamp < 1L) {
                endTimestamp = System.currentTimeMillis() + 1000L;
            }
            if (startTimestamp > endTimestamp - 120000L) {
                startTimestamp = endTimestamp - 120000L;
            } else if (startTimestamp < System.currentTimeMillis() - 86400000L) {
                startTimestamp = System.currentTimeMillis() - 86400000L;
            }
            TreeMap<Integer, VmStatistics> statMap = new TreeMap<Integer, VmStatistics>();
            int minutes = (int)((endTimestamp - startTimestamp) / 60000L);
            for (int i = 1; i <= minutes; ++i) {
                statMap.put(i, new VmStatistics());
            }
            Set<Metric> metrics = this.calculate("CPUUtilization", "Percent", instanceId, startTimestamp, endTimestamp);
            for (Metric m : metrics) {
                minute = 1 + (int)((m.timestamp - startTimestamp) / 60000L);
                stats = (VmStatistics)statMap.get(minute);
                if (stats == null) {
                    stats = new VmStatistics();
                    statMap.put(minute, stats);
                }
                stats.setAverageCpuUtilization(m.average);
                stats.setMaximumCpuUtilization(m.maximum);
                stats.setMinimumCpuUtilization(m.minimum);
                stats.setStartTimestamp(m.timestamp);
                stats.setEndTimestamp(m.timestamp);
                stats.setSamples(m.samples);
            }
            metrics = this.calculate("DiskReadBytes", "Bytes", instanceId, startTimestamp, endTimestamp);
            for (Metric m : metrics) {
                minute = 1 + (int)((m.timestamp - startTimestamp) / 60000L);
                stats = (VmStatistics)statMap.get(minute);
                if (stats == null) {
                    stats = new VmStatistics();
                    statMap.put(minute, stats);
                }
                stats.setAverageDiskReadBytes(m.average);
                stats.setMinimumDiskReadBytes(m.minimum);
                stats.setMaximumDiskReadBytes(m.maximum);
                if (stats.getSamples() >= 1) continue;
                stats.setSamples(m.samples);
            }
            metrics = this.calculate("DiskReadOps", "Count", instanceId, startTimestamp, endTimestamp);
            for (Metric m : metrics) {
                minute = 1 + (int)((m.timestamp - startTimestamp) / 60000L);
                stats = (VmStatistics)statMap.get(minute);
                if (stats == null) {
                    stats = new VmStatistics();
                    statMap.put(minute, stats);
                }
                stats.setAverageDiskReadOperations(m.average);
                stats.setMinimumDiskReadOperations(m.minimum);
                stats.setMaximumDiskReadOperations(m.maximum);
                if (stats.getSamples() >= 1) continue;
                stats.setSamples(m.samples);
            }
            metrics = this.calculate("DiskWriteBytes", "Bytes", instanceId, startTimestamp, endTimestamp);
            for (Metric m : metrics) {
                minute = 1 + (int)((m.timestamp - startTimestamp) / 60000L);
                stats = (VmStatistics)statMap.get(minute);
                if (stats == null) {
                    stats = new VmStatistics();
                    statMap.put(minute, stats);
                }
                stats.setAverageDiskWriteBytes(m.average);
                stats.setMinimumDiskWriteBytes(m.minimum);
                stats.setMaximumDiskWriteBytes(m.maximum);
                if (stats.getSamples() >= 1) continue;
                stats.setSamples(m.samples);
            }
            metrics = this.calculate("DiskWriteOps", "Count", instanceId, startTimestamp, endTimestamp);
            for (Metric m : metrics) {
                minute = 1 + (int)((m.timestamp - startTimestamp) / 60000L);
                stats = (VmStatistics)statMap.get(minute);
                if (stats == null) {
                    stats = new VmStatistics();
                    statMap.put(minute, stats);
                }
                stats.setAverageDiskWriteOperations(m.average);
                stats.setMinimumDiskWriteOperations(m.minimum);
                stats.setMaximumDiskWriteOperations(m.maximum);
                if (stats.getSamples() >= 1) continue;
                stats.setSamples(m.samples);
            }
            metrics = this.calculate("NetworkIn", "Bytes", instanceId, startTimestamp, endTimestamp);
            for (Metric m : metrics) {
                minute = 1 + (int)((m.timestamp - startTimestamp) / 60000L);
                stats = (VmStatistics)statMap.get(minute);
                if (stats == null) {
                    stats = new VmStatistics();
                    statMap.put(minute, stats);
                }
                stats.setAverageNetworkIn(m.average);
                stats.setMinimumNetworkIn(m.minimum);
                stats.setMaximumNetworkIn(m.maximum);
                if (stats.getSamples() >= 1) continue;
                stats.setSamples(m.samples);
            }
            metrics = this.calculate("NetworkOut", "Bytes", instanceId, startTimestamp, endTimestamp);
            for (Metric m : metrics) {
                minute = 1 + (int)((m.timestamp - startTimestamp) / 60000L);
                stats = (VmStatistics)statMap.get(minute);
                if (stats == null) {
                    stats = new VmStatistics();
                    statMap.put(minute, stats);
                }
                stats.setAverageNetworkOut(m.average);
                stats.setMinimumNetworkOut(m.minimum);
                stats.setMaximumNetworkOut(m.maximum);
                if (stats.getSamples() >= 1) continue;
                stats.setSamples(m.samples);
            }
            ArrayList<VmStatistics> list = new ArrayList<VmStatistics>();
            for (Map.Entry entry : statMap.entrySet()) {
                stats = (VmStatistics)entry.getValue();
                if (stats == null || stats.getSamples() <= 0) continue;
                list.add(stats);
            }
            ArrayList<VmStatistics> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Requirement identifyImageRequirement(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return ImageClass.MACHINE.equals((Object)cls) ? Requirement.REQUIRED : Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyPasswordRequirement() {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyPasswordRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyRootVolumeRequirement() {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement() {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyStaticIPRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyVlanRequirement() {
        return this.provider.getEC2Provider().isEucalyptus() ? Requirement.NONE : Requirement.OPTIONAL;
    }

    public boolean isAPITerminationPreventable() {
        return this.provider.getEC2Provider().isAWS();
    }

    public boolean isBasicAnalyticsSupported() {
        return this.provider.getEC2Provider().isAWS() || this.provider.getEC2Provider().isEnStratus();
    }

    public boolean isExtendedAnalyticsSupported() {
        return this.provider.getEC2Provider().isAWS() || this.provider.getEC2Provider().isEnStratus();
    }

    public boolean isSubscribed() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"isSubscribedVirtualMachine");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeInstances");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
                boolean bl = true;
                return bl;
            }
            catch (EC2Exception e) {
                block9: {
                    block8: {
                        if (e.getStatus() != 401 && e.getStatus() != 403) break block8;
                        boolean bl = false;
                        APITrace.end();
                        return bl;
                    }
                    String code = e.getCode();
                    if (code == null || !code.equals("SignatureDoesNotMatch")) break block9;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                logger.warn((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isUserDataSupported() {
        return true;
    }

    public Iterable<VirtualMachineProduct> listProducts(Architecture architecture) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)("products" + architecture.name()), VirtualMachineProduct.class, (CacheLevel)CacheLevel.REGION, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
        ArrayList<VirtualMachineProduct> products = cache.get(ctx);
        if (products == null) {
            ArrayList<VirtualMachineProduct> list = new ArrayList<VirtualMachineProduct>();
            try {
                InputStream input = EC2Instance.class.getResourceAsStream("/org/dasein/cloud/aws/vmproducts.json");
                if (input != null) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    StringBuilder json = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        json.append(line);
                        json.append("\n");
                    }
                    JSONArray arr = new JSONArray(json.toString());
                    JSONObject toCache = null;
                    for (int i = 0; i < arr.length(); ++i) {
                        JSONObject productSet = arr.getJSONObject(i);
                        if (!productSet.has("cloud")) continue;
                        String cloud = productSet.getString("cloud");
                        if (!productSet.has("provider")) continue;
                        String provider = productSet.getString("provider");
                        if (!productSet.has("products")) continue;
                        if (toCache == null || provider.equals("AWS") && cloud.equals("AWS")) {
                            toCache = productSet;
                        }
                        if (!provider.equalsIgnoreCase(this.provider.getProviderName()) || !cloud.equalsIgnoreCase(this.provider.getCloudName())) continue;
                        toCache = productSet;
                        break;
                    }
                    if (toCache == null) {
                        logger.warn((Object)"No products were defined");
                        return Collections.emptyList();
                    }
                    JSONArray plist = toCache.getJSONArray("products");
                    for (int i = 0; i < plist.length(); ++i) {
                        VirtualMachineProduct prd;
                        int j;
                        JSONObject product = plist.getJSONObject(i);
                        boolean supported = false;
                        if (product.has("architectures")) {
                            JSONArray architectures = product.getJSONArray("architectures");
                            for (j = 0; j < architectures.length(); ++j) {
                                String a = architectures.getString(j);
                                if (!architecture.name().equals(a)) continue;
                                supported = true;
                                break;
                            }
                        }
                        if (!supported) continue;
                        if (product.has("excludesRegions")) {
                            JSONArray regions = product.getJSONArray("excludesRegions");
                            for (j = 0; j < regions.length(); ++j) {
                                String r = regions.getString(j);
                                if (!r.equals(ctx.getRegionId())) continue;
                                supported = false;
                                break;
                            }
                        }
                        if (!supported || (prd = this.toProduct(product)) == null) continue;
                        list.add(prd);
                    }
                } else {
                    logger.warn((Object)"No standard products resource exists for /org/dasein/cloud/aws/vmproducts.json");
                }
                input = EC2Instance.class.getResourceAsStream("/org/dasein/cloud/aws/vmproducts-custom.json");
                if (input != null) {
                    String line;
                    ArrayList<VirtualMachineProduct> customList = new ArrayList<VirtualMachineProduct>();
                    TreeSet<String> discard = new TreeSet<String>();
                    boolean discardAll = false;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    StringBuilder json = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        json.append(line);
                        json.append("\n");
                    }
                    JSONArray arr = new JSONArray(json.toString());
                    JSONObject toCache = null;
                    for (int i = 0; i < arr.length(); ++i) {
                        JSONObject listing = arr.getJSONObject(i);
                        String endpoint = null;
                        if (!listing.has("cloud")) continue;
                        String cloud = listing.getString("cloud");
                        if (!listing.has("provider")) continue;
                        String provider = listing.getString("provider");
                        if (listing.has("endpoint")) {
                            endpoint = listing.getString("endpoint");
                        }
                        if (!cloud.equals(this.provider.getCloudName()) || !provider.equals(this.provider.getProviderName())) continue;
                        if (endpoint != null && endpoint.equals(ctx.getEndpoint())) {
                            toCache = listing;
                            break;
                        }
                        if (endpoint != null || toCache != null) continue;
                        toCache = listing;
                    }
                    if (toCache != null) {
                        if (toCache.has("discardDefaults")) {
                            discardAll = toCache.getBoolean("discardDefaults");
                        }
                        if (toCache.has("discard")) {
                            JSONArray dlist = toCache.getJSONArray("discard");
                            for (int i = 0; i < dlist.length(); ++i) {
                                discard.add(dlist.getString(i));
                            }
                        }
                        if (toCache.has("products")) {
                            JSONArray plist = toCache.getJSONArray("products");
                            for (int i = 0; i < plist.length(); ++i) {
                                VirtualMachineProduct prd;
                                int j;
                                JSONObject product = plist.getJSONObject(i);
                                boolean supported = false;
                                if (product.has("architectures")) {
                                    JSONArray architectures = product.getJSONArray("architectures");
                                    for (j = 0; j < architectures.length(); ++j) {
                                        String a = architectures.getString(j);
                                        if (!architecture.name().equals(a)) continue;
                                        supported = true;
                                        break;
                                    }
                                }
                                if (!supported) continue;
                                if (product.has("excludesRegions")) {
                                    JSONArray regions = product.getJSONArray("excludesRegions");
                                    for (j = 0; j < regions.length(); ++j) {
                                        String r = regions.getString(j);
                                        if (!r.equals(ctx.getRegionId())) continue;
                                        supported = false;
                                        break;
                                    }
                                }
                                if (!supported || (prd = this.toProduct(product)) == null) continue;
                                customList.add(prd);
                            }
                        }
                        if (!discardAll) {
                            for (VirtualMachineProduct product : list) {
                                if (discard.contains(product.getProviderProductId())) continue;
                                customList.add(product);
                            }
                        }
                        list = customList;
                    }
                }
                products = list;
                cache.put(ctx, products);
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e);
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return products;
    }

    public Iterable<Architecture> listSupportedArchitectures() {
        if (architectures == null) {
            ArrayList<Architecture> list = new ArrayList<Architecture>();
            list.add(Architecture.I64);
            list.add(Architecture.I32);
            architectures = Collections.unmodifiableCollection(list);
        }
        return architectures;
    }

    private String guess(String privateDnsAddress) {
        String dnsAddress = privateDnsAddress;
        String[] parts = dnsAddress.split("\\.");
        if (parts != null && parts.length > 1) {
            dnsAddress = parts[0];
        }
        if (dnsAddress.startsWith("ip-")) {
            dnsAddress = dnsAddress.replace('-', '.');
            return dnsAddress.substring(3);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nonnull
    public VirtualMachine launch(@Nonnull VMLaunchOptions cfg) throws CloudException, InternalException {
        Tag[] toCreate;
        void var15_29;
        Document doc;
        VMLaunchOptions.NICConfig[] nics;
        int i;
        String[] ids;
        APITrace.begin((CloudProvider)this.provider, (String)"launchVM");
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was established for this request");
        }
        MachineImage img = this.provider.getComputeServices().getImageSupport().getMachineImage(cfg.getMachineImageId());
        if (img == null) {
            throw new InternalException("No such machine image: " + cfg.getMachineImageId());
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "RunInstances");
        String ramdiskImage = (String)cfg.getMetaData().get("ramdiskImageId");
        String kernelImage = (String)cfg.getMetaData().get("kernelImageId");
        parameters.put("ImageId", cfg.getMachineImageId());
        parameters.put("MinCount", "1");
        parameters.put("MaxCount", "1");
        parameters.put("InstanceType", cfg.getStandardProductId());
        if (ramdiskImage != null) {
            parameters.put("ramdiskId", ramdiskImage);
        }
        if (kernelImage != null) {
            parameters.put("kernelId", kernelImage);
        }
        if (cfg.getUserData() != null) {
            try {
                parameters.put("UserData", Base64.encodeBase64String((byte[])cfg.getUserData().getBytes("utf-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalException((Throwable)e);
            }
        }
        if (cfg.isPreventApiTermination()) {
            parameters.put("DisableApiTermination", "true");
        }
        if ((ids = cfg.getFirewallIds()).length > 0) {
            int i2 = 1;
            for (String string : ids) {
                parameters.put("SecurityGroupId." + i2++, string);
            }
        }
        if (cfg.getDataCenterId() != null) {
            parameters.put("Placement.AvailabilityZone", cfg.getDataCenterId());
        } else if (cfg.getVolumes().length > 0) {
            String dc = null;
            for (String string : cfg.getVolumes()) {
                if (((VMLaunchOptions.VolumeAttachment)string).volumeToCreate != null && (dc = ((VMLaunchOptions.VolumeAttachment)string).volumeToCreate.getDataCenterId()) != null) break;
            }
            if (dc != null) {
                cfg.inDataCenter(dc);
            }
        }
        if (cfg.getBootstrapKey() != null) {
            parameters.put("KeyName", cfg.getBootstrapKey());
        }
        if (cfg.getVlanId() != null) {
            parameters.put("SubnetId", cfg.getVlanId());
        }
        if (this.provider.getEC2Provider().isAWS()) {
            parameters.put("Monitoring.Enabled", String.valueOf(cfg.isExtendedAnalytics()));
        }
        final ArrayList<VMLaunchOptions.VolumeAttachment> existingVolumes = new ArrayList<VMLaunchOptions.VolumeAttachment>();
        TreeSet<String> deviceIds = new TreeSet<String>();
        if (cfg.getVolumes().length > 0) {
            Iterable<String> possibles = this.provider.getComputeServices().getVolumeSupport().listPossibleDeviceIds(img.getPlatform());
            i = 1;
            for (VMLaunchOptions.VolumeAttachment volumeAttachment : cfg.getVolumes()) {
                if (volumeAttachment.deviceId != null) {
                    deviceIds.add(volumeAttachment.deviceId);
                    continue;
                }
                if (volumeAttachment.volumeToCreate == null || volumeAttachment.volumeToCreate.getDeviceId() == null) continue;
                deviceIds.add(volumeAttachment.volumeToCreate.getDeviceId());
                volumeAttachment.deviceId = volumeAttachment.volumeToCreate.getDeviceId();
            }
            for (VMLaunchOptions.VolumeAttachment volumeAttachment : cfg.getVolumes()) {
                if (volumeAttachment.deviceId == null) {
                    for (String id : possibles) {
                        if (deviceIds.contains(id)) continue;
                        volumeAttachment.deviceId = id;
                        deviceIds.add(id);
                    }
                    if (volumeAttachment.deviceId == null) {
                        throw new InternalException("Unable to identify a device ID for volume");
                    }
                }
                if (volumeAttachment.existingVolumeId == null) {
                    parameters.put("BlockDeviceMapping." + i + ".DeviceName", volumeAttachment.deviceId);
                    if (volumeAttachment.volumeToCreate.getSnapshotId() != null) {
                        parameters.put("BlockDeviceMapping." + i + ".Ebs.SnapshotId", volumeAttachment.volumeToCreate.getSnapshotId());
                    } else {
                        parameters.put("BlockDeviceMapping." + i + ".Ebs.VolumeSize", String.valueOf(volumeAttachment.volumeToCreate.getVolumeSize().getQuantity().intValue()));
                    }
                    ++i;
                    continue;
                }
                existingVolumes.add(volumeAttachment);
            }
        }
        if ((nics = cfg.getNetworkInterfaces()) != null && nics.length > 0) {
            i = 1;
            for (VMLaunchOptions.NICConfig nICConfig : nics) {
                parameters.put("NetworkInterface." + i + ".DeviceIndex", String.valueOf(i));
                if (nICConfig.nicId == null) {
                    parameters.put("NetworkInterface." + i + ".SubnetId", nICConfig.nicToCreate.getSubnetId());
                    parameters.put("NetworkInterface." + i + ".Description", nICConfig.nicToCreate.getDescription());
                    if (nICConfig.nicToCreate.getIpAddress() != null) {
                        parameters.put("NetworkInterface." + i + ".PrivateIpAddress", nICConfig.nicToCreate.getIpAddress());
                    }
                    if (nICConfig.nicToCreate.getFirewallIds().length > 0) {
                        int j = 1;
                        for (String id : nICConfig.nicToCreate.getFirewallIds()) {
                            parameters.put("NetworkInterface." + i + ".SecurityGroupId." + j, id);
                            ++j;
                        }
                    }
                } else {
                    parameters.put("NetworkInterface." + i + ".NetworkInterfaceId", nICConfig.nicId);
                }
                ++i;
            }
        }
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String string = e.getCode();
            if (string != null && string.equals("InsufficientInstanceCapacity")) {
                VirtualMachine len$ = null;
                APITrace.end();
                return len$;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("instancesSet");
        VirtualMachine server = null;
        boolean bl = false;
        while (var15_29 < blocks.getLength()) {
            Node node;
            NodeList instances = blocks.item((int)var15_29).getChildNodes();
            for (int j = 0; !(j >= instances.getLength() || (node = instances.item(j)).getNodeName().equals("item") && (server = this.toVirtualMachine(ctx, node, new ArrayList<IpAddress>())) != null); ++j) {
            }
            ++var15_29;
        }
        if (server != null && cfg.getBootstrapKey() != null) {
            try {
                final String string = server.getProviderVirtualMachineId();
                Callable<String> pwMethod = new Callable<String>(){

                    @Override
                    public String call() throws CloudException {
                        try {
                            Map<String, String> params = EC2Instance.this.provider.getStandardParameters(EC2Instance.this.provider.getContext(), "GetPasswordData");
                            params.put("InstanceId", string);
                            EC2Method m = new EC2Method(EC2Instance.this.provider, EC2Instance.this.provider.getEc2Url(), params);
                            Document doc = m.invoke();
                            NodeList blocks = doc.getElementsByTagName("passwordData");
                            if (blocks.getLength() > 0) {
                                Node pw = blocks.item(0);
                                if (pw.hasChildNodes()) {
                                    String password = pw.getFirstChild().getNodeValue();
                                    EC2Instance.this.provider.release();
                                    return password;
                                }
                                return null;
                            }
                            return null;
                        }
                        catch (Throwable t) {
                            throw new CloudException("Unable to retrieve password for " + string + ", Let's hope it's Unix: " + t.getMessage());
                        }
                    }
                };
                this.provider.hold();
                try {
                    String password = (String)pwMethod.call();
                    if (password == null) {
                        server.setRootPassword(null);
                        server.setPasswordCallback((Callable)pwMethod);
                    } else {
                        server.setRootPassword(password);
                    }
                    server.setPlatform(Platform.WINDOWS);
                }
                catch (CloudException e) {
                    logger.warn((Object)e.getMessage());
                }
            }
            catch (Throwable throwable) {
                logger.warn((Object)("Unable to retrieve password for " + server.getProviderVirtualMachineId() + ", Let's hope it's Unix: " + throwable.getMessage()));
            }
        }
        Map map = cfg.getMetaData();
        int i4 = 0;
        if (map.isEmpty()) {
            toCreate = new Tag[2];
        } else {
            void var18_50;
            boolean bl2 = false;
            for (Map.Entry entry : map.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("name") || ((String)entry.getKey()).equalsIgnoreCase("description")) continue;
                ++var18_50;
            }
            toCreate = new Tag[var18_50 + 2];
            for (Map.Entry entry : map.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("name") || ((String)entry.getKey()).equalsIgnoreCase("description")) continue;
                toCreate[i4++] = new Tag((String)entry.getKey(), entry.getValue().toString());
            }
        }
        Tag tag = new Tag();
        tag.setKey("Name");
        tag.setValue(cfg.getFriendlyName());
        toCreate[i4++] = tag;
        Tag tag2 = new Tag();
        tag2.setKey("Description");
        tag2.setValue(cfg.getDescription());
        toCreate[i4] = tag2;
        this.provider.createTags(server.getProviderVirtualMachineId(), toCreate);
        if (!existingVolumes.isEmpty()) {
            final VirtualMachine vm = server;
            this.provider.hold();
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (VMLaunchOptions.VolumeAttachment a : existingVolumes) {
                            try {
                                EC2Instance.this.provider.getComputeServices().getVolumeSupport().attach(a.existingVolumeId, vm.getProviderMachineImageId(), a.deviceId);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    }
                    finally {
                        EC2Instance.this.provider.release();
                    }
                }
            };
            thread.setName("Volume Mounter for " + server);
            thread.start();
        }
        VirtualMachine virtualMachine = server;
        return virtualMachine;
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull String imageId, @Nonnull VirtualMachineProduct size, @Nullable String inZoneId, @Nonnull String name, @Nullable String description, @Nullable String keypair, @Nullable String inVlanId, boolean withMonitoring, boolean asImageSandbox, String ... protectedByFirewalls) throws CloudException, InternalException {
        VMLaunchOptions cfg = VMLaunchOptions.getInstance((String)size.getProviderProductId(), (String)imageId, (String)name, (String)(description == null ? name : description));
        if (keypair != null) {
            cfg.withBoostrapKey(keypair);
        }
        if (inVlanId != null) {
            VLANSupport support;
            EC2NetworkServices svc;
            if (inZoneId == null && (svc = this.provider.getNetworkServices()) != null && (support = svc.getVlanSupport()) != null) {
                Subnet subnet = support.getSubnet(inVlanId);
                if (subnet == null) {
                    throw new CloudException("No such VPC subnet: " + inVlanId);
                }
                inZoneId = subnet.getProviderDataCenterId();
            }
            if (inZoneId == null) {
                throw new CloudException("Unable to match zone to subnet");
            }
            cfg.inVlan(null, inZoneId, inVlanId);
        } else if (inZoneId != null) {
            cfg.inDataCenter(inZoneId);
        }
        if (withMonitoring) {
            cfg.withExtendedAnalytics();
        }
        if (protectedByFirewalls != null && protectedByFirewalls.length > 0) {
            cfg.behindFirewalls(protectedByFirewalls);
        }
        return this.launch(cfg);
    }

    @Deprecated
    @Nonnull
    public VirtualMachine launch(@Nonnull String imageId, @Nonnull VirtualMachineProduct size, @Nullable String inZoneId, @Nonnull String name, @Nullable String description, @Nullable String keypair, @Nullable String inVlanId, boolean withMonitoring, boolean asImageSandbox, @Nullable String[] protectedByFirewalls, Tag ... tags) throws CloudException, InternalException {
        VMLaunchOptions cfg = VMLaunchOptions.getInstance((String)size.getProviderProductId(), (String)imageId, (String)name, (String)(description == null ? name : description));
        if (keypair != null) {
            cfg.withBoostrapKey(keypair);
        }
        if (inVlanId != null) {
            VLANSupport support;
            EC2NetworkServices svc;
            if (inZoneId == null && (svc = this.provider.getNetworkServices()) != null && (support = svc.getVlanSupport()) != null) {
                Subnet subnet = support.getSubnet(inVlanId);
                if (subnet == null) {
                    throw new CloudException("No such VPC subnet: " + inVlanId);
                }
                inZoneId = subnet.getProviderDataCenterId();
            }
            if (inZoneId == null) {
                throw new CloudException("Unable to match zone to subnet");
            }
            cfg.inVlan(null, inZoneId, inVlanId);
        } else if (inZoneId != null) {
            cfg.inDataCenter(inZoneId);
        }
        if (withMonitoring) {
            cfg.withExtendedAnalytics();
        }
        if (protectedByFirewalls != null && protectedByFirewalls.length > 0) {
            cfg.behindFirewalls(protectedByFirewalls);
        }
        if (tags != null && tags.length > 0) {
            HashMap<String, String> meta = new HashMap<String, String>();
            for (Tag t : tags) {
                meta.put(t.getKey(), t.getValue());
            }
            cfg.withMetaData(meta);
        }
        return this.launch(cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVirtualMachineStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listVirtualMachineStatus");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was established for this request");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeInstances");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("instancesSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList instances = blocks.item(i).getChildNodes();
                for (int j = 0; j < instances.getLength(); ++j) {
                    ResourceStatus status;
                    Node instance = instances.item(j);
                    if (!instance.getNodeName().equals("item") || (status = this.toStatus(instance)) == null) continue;
                    list.add(status);
                }
            }
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listVirtualMachines");
        try {
            Document doc;
            IpAddressSupport support;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was established for this request");
            }
            List<IpAddress> addresses = Collections.emptyList();
            EC2NetworkServices services = this.provider.getNetworkServices();
            if (services != null && services.hasIpAddressSupport() && (support = services.getIpAddressSupport()) != null) {
                addresses = support.listIpPool(IPVersion.IPV4, false);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeInstances");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            ArrayList<VirtualMachine> list = new ArrayList<VirtualMachine>();
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("instancesSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList instances = blocks.item(i).getChildNodes();
                for (int j = 0; j < instances.getLength(); ++j) {
                    Node instance = instances.item(j);
                    if (!instance.getNodeName().equals("item")) continue;
                    list.add(this.toVirtualMachine(ctx, instance, addresses));
                }
            }
            ArrayList<VirtualMachine> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public void pause(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Pause/unpause not supported by the EC2 API");
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)VirtualMachineSupport.ANY)) {
            return new String[]{"ec2:*"};
        }
        if (action.equals((Object)VirtualMachineSupport.BOOT)) {
            return new String[]{"ec2:StartInstances"};
        }
        if (action.equals((Object)VirtualMachineSupport.CLONE)) {
            return new String[0];
        }
        if (action.equals((Object)VirtualMachineSupport.CREATE_VM)) {
            return new String[]{"ec2:RunInstances"};
        }
        if (action.equals((Object)VirtualMachineSupport.GET_VM) || action.equals((Object)VirtualMachineSupport.LIST_VM)) {
            return new String[]{"ec2:DescribeInstances"};
        }
        if (action.equals((Object)VirtualMachineSupport.PAUSE)) {
            return new String[]{"ec2:StopInstances"};
        }
        if (action.equals((Object)VirtualMachineSupport.REBOOT)) {
            return new String[]{"ec2:RebootInstances"};
        }
        if (action.equals((Object)VirtualMachineSupport.REMOVE_VM)) {
            return new String[]{"ec2:TerminateInstances"};
        }
        if (action.equals((Object)VirtualMachineSupport.TOGGLE_ANALYTICS)) {
            return new String[]{"ec2:MonitorInstances"};
        }
        if (action.equals((Object)VirtualMachineSupport.VIEW_ANALYTICS)) {
            return new String[]{"ec2:GetMetricStatistics"};
        }
        if (action.equals((Object)VirtualMachineSupport.VIEW_CONSOLE)) {
            return new String[]{"ec2:GetConsoleOutput"};
        }
        return new String[0];
    }

    public void stop(@Nonnull String instanceId) throws InternalException, CloudException {
        this.stop(instanceId, false);
        long timeout = System.currentTimeMillis() + 600000L;
        while (timeout > System.currentTimeMillis()) {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                VirtualMachine vm = this.getVirtualMachine(instanceId);
                if (vm != null && !VmState.TERMINATED.equals((Object)vm.getCurrentState()) && !VmState.STOPPED.equals((Object)vm.getCurrentState())) continue;
                return;
            }
            catch (Throwable ignore) {
            }
        }
        this.stop(instanceId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@Nonnull String instanceId, boolean force) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"stopVM");
        try {
            VirtualMachine vm = this.getVirtualMachine(instanceId);
            if (vm == null) {
                throw new CloudException("No such instance: " + instanceId);
            }
            if (!vm.isPersistent()) {
                throw new OperationNotSupportedException("Instances backed by ephemeral drives are not start/stop capable");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "StopInstances");
            parameters.put("InstanceId.1", instanceId);
            if (force) {
                parameters.put("Force", "true");
            }
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot(@Nonnull String instanceId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"rebootVM");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "RebootInstances");
            parameters.put("InstanceId.1", instanceId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public void resume(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Suspend/resume not supported by the EC2 API");
    }

    private String resolve(String dnsName) {
        if (dnsName != null && dnsName.length() > 0) {
            InetAddress[] addresses;
            try {
                addresses = InetAddress.getAllByName(dnsName);
            }
            catch (UnknownHostException e) {
                addresses = null;
            }
            if (addresses != null && addresses.length > 0) {
                dnsName = addresses[0].getHostAddress();
            } else {
                dnsName = dnsName.split("\\.")[0];
                dnsName = dnsName.replaceAll("-", "\\.");
                dnsName = dnsName.substring(4);
            }
        }
        return dnsName;
    }

    public boolean supportsAnalytics() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsPauseUnpause(@Nonnull VirtualMachine vm) {
        return false;
    }

    public boolean supportsStartStop(@Nonnull VirtualMachine vm) {
        return vm.isPersistent();
    }

    public boolean supportsSuspendResume(@Nonnull VirtualMachine vm) {
        return false;
    }

    public void suspend(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Suspend/resume not supported by the EC2 API");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(@Nonnull String instanceId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"terminateVM");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "TerminateInstances");
            parameters.put("InstanceId.1", instanceId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public void unpause(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Pause/unpause not supported by the EC2 API");
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node instance) throws CloudException {
        if (instance == null) {
            return null;
        }
        NodeList attrs = instance.getChildNodes();
        VmState state = VmState.PENDING;
        String vmId = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("instanceId")) {
                vmId = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!name.equals("instanceState")) continue;
            NodeList details = attr.getChildNodes();
            for (int j = 0; j < details.getLength(); ++j) {
                Node detail = details.item(j);
                name = detail.getNodeName();
                if (!name.equals("name")) continue;
                String value = detail.getFirstChild().getNodeValue().trim();
                state = this.getServerState(value);
            }
        }
        if (vmId == null) {
            return null;
        }
        return new ResourceStatus(vmId, (Object)state);
    }

    @Nullable
    private VirtualMachine toVirtualMachine(@Nonnull ProviderContext ctx, @Nullable Node instance, @Nonnull Iterable<IpAddress> addresses) throws CloudException {
        if (instance == null) {
            return null;
        }
        NodeList attrs = instance.getChildNodes();
        VirtualMachine server = new VirtualMachine();
        server.setPersistent(false);
        server.setProviderOwnerId(ctx.getAccountNumber());
        server.setCurrentState(VmState.PENDING);
        server.setName(null);
        server.setDescription(null);
        block2: for (int i = 0; i < attrs.getLength(); ++i) {
            Node part;
            int k;
            String value;
            NodeList details;
            String value2;
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("instanceId")) {
                value2 = attr.getFirstChild().getNodeValue().trim();
                server.setProviderVirtualMachineId(value2);
                continue;
            }
            if (name.equals("architecture")) {
                value2 = attr.getFirstChild().getNodeValue().trim();
                Architecture architecture = value2.equalsIgnoreCase("i386") ? Architecture.I32 : Architecture.I64;
                server.setArchitecture(architecture);
                continue;
            }
            if (name.equals("imageId")) {
                value2 = attr.getFirstChild().getNodeValue().trim();
                server.setProviderMachineImageId(value2);
                continue;
            }
            if (name.equals("kernelId")) {
                value2 = attr.getFirstChild().getNodeValue().trim();
                server.setTag("kernelImageId", value2);
                server.setProviderKernelImageId(value2);
                continue;
            }
            if (name.equals("ramdiskId")) {
                value2 = attr.getFirstChild().getNodeValue().trim();
                server.setTag("ramdiskImageId", value2);
                server.setProviderRamdiskImageId(value2);
                continue;
            }
            if (name.equalsIgnoreCase("subnetId")) {
                server.setProviderSubnetId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equalsIgnoreCase("vpcId")) {
                server.setProviderVlanId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("instanceState")) {
                details = attr.getChildNodes();
                for (int j = 0; j < details.getLength(); ++j) {
                    Node detail = details.item(j);
                    name = detail.getNodeName();
                    if (!name.equals("name")) continue;
                    value = detail.getFirstChild().getNodeValue().trim();
                    server.setCurrentState(this.getServerState(value));
                }
                continue;
            }
            if (name.equals("privateDnsName")) {
                if (!attr.hasChildNodes()) continue;
                value2 = attr.getFirstChild().getNodeValue();
                server.setPrivateDnsAddress(value2);
                if (server.getPrivateIpAddresses() != null && server.getPrivateIpAddresses().length >= 1) continue;
                if ((value2 = this.guess(value2)) != null) {
                    server.setPrivateIpAddresses(new String[]{value2});
                    continue;
                }
                server.setPrivateIpAddresses(new String[0]);
                continue;
            }
            if (name.equals("dnsName")) {
                if (!attr.hasChildNodes()) continue;
                value2 = attr.getFirstChild().getNodeValue();
                server.setPublicDnsAddress(value2);
                if (server.getPublicIpAddresses() != null && server.getPublicIpAddresses().length >= 1) continue;
                server.setPublicIpAddresses(new String[]{this.resolve(value2)});
                continue;
            }
            if (name.equals("privateIpAddress")) {
                if (!attr.hasChildNodes()) continue;
                value2 = attr.getFirstChild().getNodeValue();
                server.setPrivateIpAddresses(new String[]{value2});
                continue;
            }
            if (name.equals("ipAddress")) {
                if (!attr.hasChildNodes()) continue;
                value2 = attr.getFirstChild().getNodeValue();
                server.setPublicIpAddresses(new String[]{value2});
                for (IpAddress addr : addresses) {
                    if (!value2.equals(addr.getAddress())) continue;
                    server.setProviderAssignedIpAddressId(addr.getProviderIpAddressId());
                    continue block2;
                }
                continue;
            }
            if (name.equals("rootDeviceType")) {
                if (!attr.hasChildNodes()) continue;
                server.setPersistent(attr.getFirstChild().getNodeValue().equalsIgnoreCase("ebs"));
                continue;
            }
            if (name.equals("tagSet")) {
                if (!attr.hasChildNodes()) continue;
                NodeList tags = attr.getChildNodes();
                for (int j = 0; j < tags.getLength(); ++j) {
                    Node tag = tags.item(j);
                    if (!tag.getNodeName().equals("item") || !tag.hasChildNodes()) continue;
                    NodeList parts = tag.getChildNodes();
                    String key = null;
                    String value3 = null;
                    for (k = 0; k < parts.getLength(); ++k) {
                        part = parts.item(k);
                        if (part.getNodeName().equalsIgnoreCase("key")) {
                            if (!part.hasChildNodes()) continue;
                            key = part.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (!part.getNodeName().equalsIgnoreCase("value") || !part.hasChildNodes()) continue;
                        value3 = part.getFirstChild().getNodeValue().trim();
                    }
                    if (key == null) continue;
                    if (key.equalsIgnoreCase("name")) {
                        server.setName(value3);
                        continue;
                    }
                    if (key.equalsIgnoreCase("description")) {
                        server.setDescription(value3);
                        continue;
                    }
                    server.addTag(key, value3);
                }
                continue;
            }
            if (name.equals("instanceType")) {
                value2 = attr.getFirstChild().getNodeValue().trim();
                server.setProductId(value2);
                continue;
            }
            if (name.equals("launchTime")) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                fmt.setCalendar(UTC_CALENDAR);
                String value4 = attr.getFirstChild().getNodeValue().trim();
                try {
                    server.setLastBootTimestamp(fmt.parse(value4).getTime());
                    server.setCreationTimestamp(server.getLastBootTimestamp());
                    continue;
                }
                catch (ParseException e) {
                    logger.error((Object)e);
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
            }
            if (name.equals("platform")) {
                if (!attr.hasChildNodes()) continue;
                Platform platform = Platform.guess((String)attr.getFirstChild().getNodeValue());
                if (platform.equals((Object)Platform.UNKNOWN)) {
                    platform = Platform.UNIX;
                }
                server.setPlatform(platform);
                continue;
            }
            if (name.equals("placement")) {
                details = attr.getChildNodes();
                for (int j = 0; j < details.getLength(); ++j) {
                    Node detail = details.item(j);
                    name = detail.getNodeName();
                    if (!name.equals("availabilityZone") || !detail.hasChildNodes()) continue;
                    value = detail.getFirstChild().getNodeValue().trim();
                    server.setProviderDataCenterId(value);
                }
                continue;
            }
            if (name.equals("keyName")) {
                value2 = attr.getFirstChild().getNodeValue().trim();
                server.setProviderKeypairId(value2);
                continue;
            }
            if (!name.equals("groupSet")) continue;
            ArrayList<String> firewalls = new ArrayList<String>();
            if (attr.hasChildNodes()) {
                NodeList tags = attr.getChildNodes();
                for (int j = 0; j < tags.getLength(); ++j) {
                    Node tag = tags.item(j);
                    if (!tag.getNodeName().equals("item") || !tag.hasChildNodes()) continue;
                    NodeList parts = tag.getChildNodes();
                    String groupId = null;
                    for (k = 0; k < parts.getLength(); ++k) {
                        part = parts.item(k);
                        if (!part.getNodeName().equalsIgnoreCase("groupId") || !part.hasChildNodes()) continue;
                        groupId = part.getFirstChild().getNodeValue().trim();
                    }
                    if (groupId == null) continue;
                    firewalls.add(groupId);
                }
            }
            if (firewalls.size() <= 0) continue;
            server.setProviderFirewallIds(firewalls.toArray(new String[0]));
        }
        if (server.getPlatform() == null) {
            server.setPlatform(Platform.UNKNOWN);
        }
        server.setProviderRegionId(ctx.getRegionId());
        if (server.getName() == null) {
            server.setName(server.getProviderVirtualMachineId());
        }
        if (server.getDescription() == null) {
            server.setDescription(server.getName() + " (" + server.getProductId() + ")");
        }
        if (server.getArchitecture() == null && server.getProductId() != null) {
            server.setArchitecture(this.getArchitecture(server.getProductId()));
        } else if (server.getArchitecture() == null) {
            server.setArchitecture(Architecture.I64);
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAnalytics(String instanceId) throws InternalException, CloudException {
        block5: {
            APITrace.begin((CloudProvider)this.provider, (String)"disableVMAnalytics");
            try {
                if (!this.provider.getEC2Provider().isAWS() && !this.provider.getEC2Provider().isEnStratus()) break block5;
                Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "UnmonitorInstances");
                parameters.put("InstanceId.1", instanceId);
                EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    @Nullable
    private VirtualMachineProduct toProduct(@Nonnull JSONObject json) throws InternalException {
        VirtualMachineProduct prd = new VirtualMachineProduct();
        try {
            if (!json.has("id")) {
                return null;
            }
            prd.setProviderProductId(json.getString("id"));
            if (json.has("name")) {
                prd.setName(json.getString("name"));
            } else {
                prd.setName(prd.getProviderProductId());
            }
            if (json.has("description")) {
                prd.setDescription(json.getString("description"));
            } else {
                prd.setDescription(prd.getName());
            }
            if (json.has("cpuCount")) {
                prd.setCpuCount(json.getInt("cpuCount"));
            } else {
                prd.setCpuCount(1);
            }
            if (json.has("rootVolumeSizeInGb")) {
                prd.setRootVolumeSize(new Storage((Number)json.getInt("rootVolumeSizeInGb"), (StorageUnit)Storage.GIGABYTE));
            } else {
                prd.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
            }
            if (json.has("ramSizeInMb")) {
                prd.setRamSize(new Storage((Number)json.getInt("ramSizeInMb"), (StorageUnit)Storage.MEGABYTE));
            } else {
                prd.setRamSize(new Storage((Number)512, (StorageUnit)Storage.MEGABYTE));
            }
            if (json.has("standardHourlyRates")) {
                JSONArray rates = json.getJSONArray("standardHourlyRates");
                for (int i = 0; i < rates.length(); ++i) {
                    JSONObject rate = rates.getJSONObject(i);
                    if (!rate.has("rate")) continue;
                    prd.setStandardHourlyRate((float)rate.getDouble("rate"));
                }
            }
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
        return prd;
    }

    public void updateTags(@Nonnull String vmId, Tag ... tags) throws CloudException, InternalException {
        this.provider.createTags(vmId, tags);
    }

    private static interface ApplyCalcs {
        public void apply(VmStatistics var1, long var2, long var4, int var6, double var7, double var9, double var11);
    }

    private static class Metric
    implements Comparable<Metric> {
        int samples = 0;
        long timestamp = -1L;
        double minimum = -1.0;
        double maximum = 0.0;
        double average = 0.0;

        private Metric() {
        }

        @Override
        public int compareTo(Metric other) {
            if (other == this) {
                return 0;
            }
            return new Long(this.timestamp).compareTo(other.timestamp);
        }
    }
}

