/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.compute;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.admin.PrepaymentSupport;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.compute.AutoScalingSupport;
import org.dasein.cloud.compute.MachineImageSupport;
import org.dasein.cloud.compute.SnapshotSupport;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VolumeSupport;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.identity.ShellKeySupport;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.VLANSupport;
import org.dasein.cloud.network.VPNSupport;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.XMLParser;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EC2Method {
    private static final Logger logger = AWSCloud.getLogger(EC2Method.class);
    private static final Logger wire = AWSCloud.getWireLogger(EC2Method.class);
    public static final String AUTOSCALING_PREFIX = "autoscaling:";
    public static final String CREATE_AUTO_SCALING_GROUP = "CreateAutoScalingGroup";
    public static final String CREATE_LAUNCH_CONFIGURATION = "CreateLaunchConfiguration";
    public static final String CREATE_OR_UPDATE_SCALING_TRIGGER = "CreateOrUpdateScalingTrigger";
    public static final String DELETE_AUTO_SCALING_GROUP = "DeleteAutoScalingGroup";
    public static final String DELETE_LAUNCH_CONFIGURATION = "DeleteLaunchConfiguration";
    public static final String DESCRIBE_AUTO_SCALING_GROUPS = "DescribeAutoScalingGroups";
    public static final String DESCRIBE_LAUNCH_CONFIGURATIONS = "DescribeLaunchConfigurations";
    public static final String SET_DESIRED_CAPACITY = "SetDesiredCapacity";
    public static final String UPDATE_AUTO_SCALING_GROUP = "UpdateAutoScalingGroup";
    public static final String EC2_PREFIX = "ec2:";
    public static final String RDS_PREFIX = "rds:";
    public static final String SDB_PREFIX = "sdb:";
    public static final String SNS_PREFIX = "sns:";
    public static final String SQS_PREFIX = "sqs:";
    public static final String BUNDLE_INSTANCE = "BundleInstance";
    public static final String CREATE_IMAGE = "CreateImage";
    public static final String DESCRIBE_BUNDLE_TASKS = "DescribeBundleTasks";
    public static final String DEREGISTER_IMAGE = "DeregisterImage";
    public static final String DESCRIBE_IMAGE_ATTRIBUTE = "DescribeImageAttribute";
    public static final String DESCRIBE_IMAGES = "DescribeImages";
    public static final String MODIFY_IMAGE_ATTRIBUTE = "ModifyImageAttribute";
    public static final String REGISTER_IMAGE = "RegisterImage";
    public static final String ATTACH_VOLUME = "AttachVolume";
    public static final String CREATE_VOLUME = "CreateVolume";
    public static final String DELETE_VOLUME = "DeleteVolume";
    public static final String DETACH_VOLUME = "DetachVolume";
    public static final String DESCRIBE_VOLUMES = "DescribeVolumes";
    public static final String ALLOCATE_ADDRESS = "AllocateAddress";
    public static final String ASSOCIATE_ADDRESS = "AssociateAddress";
    public static final String DESCRIBE_ADDRESSES = "DescribeAddresses";
    public static final String DISASSOCIATE_ADDRESS = "DisassociateAddress";
    public static final String RELEASE_ADDRESS = "ReleaseAddress";
    public static final String DESCRIBE_INSTANCES = "DescribeInstances";
    public static final String GET_CONSOLE_OUTPUT = "GetConsoleOutput";
    public static final String GET_METRIC_STATISTICS = "GetMetricStatistics";
    public static final String GET_PASSWORD_DATA = "GetPasswordData";
    public static final String MONITOR_INSTANCES = "MonitorInstances";
    public static final String REBOOT_INSTANCES = "RebootInstances";
    public static final String RUN_INSTANCES = "RunInstances";
    public static final String START_INSTANCES = "StartInstances";
    public static final String STOP_INSTANCES = "StopInstances";
    public static final String TERMINATE_INSTANCES = "TerminateInstances";
    public static final String UNMONITOR_INSTANCES = "UnmonitorInstances";
    public static final String CREATE_KEY_PAIR = "CreateKeyPair";
    public static final String DELETE_KEY_PAIR = "DeleteKeyPair";
    public static final String DESCRIBE_KEY_PAIRS = "DescribeKeyPairs";
    public static final String IMPORT_KEY_PAIR = "ImportKeyPair";
    public static final String DESCRIBE_RESERVED_INSTANCES = "DescribeReservedInstances";
    public static final String DESCRIBE_RESERVED_INSTANCES_OFFERINGS = "DescribeReservedInstancesOfferings";
    public static final String PURCHASE_RESERVED_INSTANCES_OFFERING = "PurchaseReservedInstancesOffering";
    public static final String AUTHORIZE_SECURITY_GROUP_INGRESS = "AuthorizeSecurityGroupIngress";
    public static final String AUTHORIZE_SECURITY_GROUP_EGRESS = "AuthorizeSecurityGroupEgress";
    public static final String CREATE_SECURITY_GROUP = "CreateSecurityGroup";
    public static final String DELETE_SECURITY_GROUP = "DeleteSecurityGroup";
    public static final String DESCRIBE_SECURITY_GROUPS = "DescribeSecurityGroups";
    public static final String REVOKE_SECURITY_GROUP_EGRESS = "RevokeSecurityGroupEgress";
    public static final String REVOKE_SECURITY_GROUP_INGRESS = "RevokeSecurityGroupIngress";
    public static final String CREATE_SNAPSHOT = "CreateSnapshot";
    public static final String DELETE_SNAPSHOT = "DeleteSnapshot";
    public static final String DESCRIBE_SNAPSHOTS = "DescribeSnapshots";
    public static final String DESCRIBE_SNAPSHOT_ATTRIBUTE = "DescribeSnapshotAttribute";
    public static final String MODIFY_SNAPSHOT_ATTRIBUTE = "ModifySnapshotAttribute";
    public static final String ASSOCIATE_DHCP_OPTIONS = "AssociateDhcpOptions";
    public static final String ASSOCIATE_ROUTE_TABLE = "AssociateRouteTable";
    public static final String ATTACH_INTERNET_GATEWAY = "AttachInternetGateway";
    public static final String CREATE_DHCP_OPTIONS = "CreateDhcpOptions";
    public static final String CREATE_INTERNET_GATEWAY = "CreateInternetGateway";
    public static final String CREATE_ROUTE = "CreateRoute";
    public static final String CREATE_ROUTE_TABLE = "CreateRouteTable";
    public static final String CREATE_SUBNET = "CreateSubnet";
    public static final String CREATE_VPC = "CreateVpc";
    public static final String DELETE_INTERNET_GATEWAY = "DeleteInternetGateway";
    public static final String DELETE_SUBNET = "DeleteSubnet";
    public static final String DELETE_VPC = "DeleteVpc";
    public static final String DESCRIBE_DHCP_OPTIONS = "DescribeDhcpOptions";
    public static final String DESCRIBE_INTERNET_GATEWAYS = "DescribeInternetGateways";
    public static final String DELETE_ROUTE = "DeleteRoute";
    public static final String DELETE_ROUTE_TABLE = "DeleteRouteTable";
    public static final String DESCRIBE_ROUTE_TABLES = "DescribeRouteTables";
    public static final String DESCRIBE_SUBNETS = "DescribeSubnets";
    public static final String DESCRIBE_VPCS = "DescribeVpcs";
    public static final String DETACH_INTERNET_GATEWAY = "DetachInternetGateway";
    public static final String REPLACE_ROUTE_TABLE_ASSOCIATION = "ReplaceRouteTableAssociation";
    public static final String ATTACH_NIC = "AttachNetworkInterface";
    public static final String CREATE_NIC = "CreateNetworkInterface";
    public static final String DELETE_NIC = "DeleteNetworkInterface";
    public static final String DETACH_NIC = "DetachNetworkInterface";
    public static final String DESCRIBE_NICS = "DescribeNetworkInterfaces";
    public static final String ATTACH_VPN_GATEWAY = "AttachVpnGateway";
    public static final String CREATE_CUSTOMER_GATEWAY = "CreateCustomerGateway";
    public static final String CREATE_VPN_CONNECTION = "CreateVpnConnection";
    public static final String CREATE_VPN_GATEWAY = "CreateVpnGateway";
    public static final String DELETE_CUSTOMER_GATEWAY = "DeleteCustomerGateway";
    public static final String DELETE_VPN_GATEWAY = "DeleteVpnGateway";
    public static final String DELETE_VPN_CONNECTION = "DeleteVpnConnection";
    public static final String DESCRIBE_CUSTOMER_GATEWAYS = "DescribeCustomerCateways";
    public static final String DESCRIBE_VPN_CONNECTIONS = "DescribeVpnConnections";
    public static final String DESCRIBE_VPN_GATEWAYS = "DescribeVpnGateways";
    public static final String DETACH_VPN_GATEWAY = "DetachVpnGateway";
    private int attempts = 0;
    private Map<String, String> parameters = null;
    private AWSCloud provider = null;
    private String url = null;

    @Nonnull
    public static ServiceAction[] asAutoScalingServiceAction(@Nonnull String action) {
        if (action.equals(CREATE_AUTO_SCALING_GROUP)) {
            return new ServiceAction[]{AutoScalingSupport.CREATE_SCALING_GROUP};
        }
        if (action.equals(CREATE_LAUNCH_CONFIGURATION)) {
            return new ServiceAction[]{AutoScalingSupport.CREATE_LAUNCH_CONFIGURATION};
        }
        if (action.equals(CREATE_OR_UPDATE_SCALING_TRIGGER)) {
            return new ServiceAction[]{AutoScalingSupport.SET_SCALING_TRIGGER};
        }
        if (action.equals(DELETE_AUTO_SCALING_GROUP)) {
            return new ServiceAction[]{AutoScalingSupport.REMOVE_SCALING_GROUP};
        }
        if (action.equals(DELETE_LAUNCH_CONFIGURATION)) {
            return new ServiceAction[]{AutoScalingSupport.REMOVE_LAUNCH_CONFIGURATION};
        }
        if (action.equals(DESCRIBE_AUTO_SCALING_GROUPS)) {
            return new ServiceAction[]{AutoScalingSupport.GET_SCALING_GROUP, AutoScalingSupport.LIST_SCALING_GROUP};
        }
        if (action.equals(DESCRIBE_LAUNCH_CONFIGURATIONS)) {
            return new ServiceAction[]{AutoScalingSupport.GET_LAUNCH_CONFIGURATION, AutoScalingSupport.LIST_LAUNCH_CONFIGURATION};
        }
        if (action.equals(SET_DESIRED_CAPACITY)) {
            return new ServiceAction[]{AutoScalingSupport.SET_CAPACITY};
        }
        if (action.equals(UPDATE_AUTO_SCALING_GROUP)) {
            return new ServiceAction[]{AutoScalingSupport.UPDATE_SCALING_GROUP};
        }
        return new ServiceAction[0];
    }

    @Nonnull
    public static ServiceAction[] asEC2ServiceAction(@Nonnull String action) {
        if (action.equals(BUNDLE_INSTANCE)) {
            return new ServiceAction[]{MachineImageSupport.IMAGE_VM};
        }
        if (action.equals(CREATE_IMAGE) || action.equals(REGISTER_IMAGE)) {
            return new ServiceAction[]{MachineImageSupport.REGISTER_IMAGE};
        }
        if (action.equals(DESCRIBE_BUNDLE_TASKS)) {
            return new ServiceAction[0];
        }
        if (action.equals(DEREGISTER_IMAGE)) {
            return new ServiceAction[]{MachineImageSupport.REMOVE_IMAGE};
        }
        if (action.equals(DESCRIBE_IMAGE_ATTRIBUTE) || action.equals(DESCRIBE_IMAGES)) {
            return new ServiceAction[]{MachineImageSupport.GET_IMAGE, MachineImageSupport.LIST_IMAGE};
        }
        if (action.equals(MODIFY_IMAGE_ATTRIBUTE)) {
            return new ServiceAction[]{MachineImageSupport.MAKE_PUBLIC, MachineImageSupport.SHARE_IMAGE};
        }
        if (action.equals(ATTACH_VOLUME)) {
            return new ServiceAction[]{VolumeSupport.ATTACH};
        }
        if (action.equals(CREATE_VOLUME)) {
            return new ServiceAction[]{VolumeSupport.CREATE_VOLUME};
        }
        if (action.equals(DELETE_VOLUME)) {
            return new ServiceAction[]{VolumeSupport.REMOVE_VOLUME};
        }
        if (action.equals(DETACH_VOLUME)) {
            return new ServiceAction[]{VolumeSupport.DETACH};
        }
        if (action.equals(DESCRIBE_VOLUMES)) {
            return new ServiceAction[]{VolumeSupport.GET_VOLUME, VolumeSupport.LIST_VOLUME};
        }
        if (action.equals(ALLOCATE_ADDRESS)) {
            return new ServiceAction[]{IpAddressSupport.CREATE_IP_ADDRESS};
        }
        if (action.equals(ASSOCIATE_ADDRESS)) {
            return new ServiceAction[]{IpAddressSupport.ASSIGN};
        }
        if (action.equals(DESCRIBE_ADDRESSES)) {
            return new ServiceAction[]{IpAddressSupport.GET_IP_ADDRESS, IpAddressSupport.LIST_IP_ADDRESS};
        }
        if (action.equals(DISASSOCIATE_ADDRESS)) {
            return new ServiceAction[]{IpAddressSupport.RELEASE};
        }
        if (action.equals(RELEASE_ADDRESS)) {
            return new ServiceAction[]{IpAddressSupport.REMOVE_IP_ADDRESS};
        }
        if (action.equals(DESCRIBE_INSTANCES)) {
            return new ServiceAction[]{VirtualMachineSupport.GET_VM, VirtualMachineSupport.LIST_VM};
        }
        if (action.equals(GET_CONSOLE_OUTPUT)) {
            return new ServiceAction[]{VirtualMachineSupport.VIEW_CONSOLE};
        }
        if (action.equals(GET_METRIC_STATISTICS)) {
            return new ServiceAction[]{VirtualMachineSupport.VIEW_ANALYTICS};
        }
        if (action.equals(GET_PASSWORD_DATA)) {
            return new ServiceAction[]{VirtualMachineSupport.GET_VM};
        }
        if (action.equals(MONITOR_INSTANCES) || action.equals(UNMONITOR_INSTANCES)) {
            return new ServiceAction[]{VirtualMachineSupport.TOGGLE_ANALYTICS};
        }
        if (action.equals(REBOOT_INSTANCES)) {
            return new ServiceAction[]{VirtualMachineSupport.REBOOT};
        }
        if (action.equals(RUN_INSTANCES)) {
            return new ServiceAction[]{VirtualMachineSupport.CREATE_VM};
        }
        if (action.equals(START_INSTANCES)) {
            return new ServiceAction[]{VirtualMachineSupport.BOOT};
        }
        if (action.equals(STOP_INSTANCES)) {
            return new ServiceAction[]{VirtualMachineSupport.PAUSE};
        }
        if (action.equals(TERMINATE_INSTANCES)) {
            return new ServiceAction[]{VirtualMachineSupport.REMOVE_VM};
        }
        if (action.equals(CREATE_KEY_PAIR)) {
            return new ServiceAction[]{ShellKeySupport.CREATE_KEYPAIR};
        }
        if (action.equals(DELETE_KEY_PAIR)) {
            return new ServiceAction[]{ShellKeySupport.REMOVE_KEYPAIR};
        }
        if (action.equals(IMPORT_KEY_PAIR)) {
            return new ServiceAction[]{ShellKeySupport.CREATE_KEYPAIR};
        }
        if (action.equals(DESCRIBE_KEY_PAIRS)) {
            return new ServiceAction[]{ShellKeySupport.GET_KEYPAIR, ShellKeySupport.LIST_KEYPAIR};
        }
        if (action.equals(DESCRIBE_RESERVED_INSTANCES)) {
            return new ServiceAction[]{PrepaymentSupport.GET_PREPAYMENT, PrepaymentSupport.LIST_PREPAYMENT};
        }
        if (action.equals(DESCRIBE_RESERVED_INSTANCES_OFFERINGS)) {
            return new ServiceAction[]{PrepaymentSupport.GET_OFFERING, PrepaymentSupport.LIST_OFFERING};
        }
        if (action.equals(PURCHASE_RESERVED_INSTANCES_OFFERING)) {
            return new ServiceAction[]{PrepaymentSupport.PREPAY};
        }
        if (action.equals(AUTHORIZE_SECURITY_GROUP_INGRESS)) {
            return new ServiceAction[]{FirewallSupport.AUTHORIZE};
        }
        if (action.equals(AUTHORIZE_SECURITY_GROUP_EGRESS)) {
            return new ServiceAction[]{FirewallSupport.AUTHORIZE};
        }
        if (action.equals(CREATE_SECURITY_GROUP)) {
            return new ServiceAction[]{FirewallSupport.CREATE_FIREWALL};
        }
        if (action.equals(DELETE_SECURITY_GROUP)) {
            return new ServiceAction[]{FirewallSupport.REMOVE_FIREWALL};
        }
        if (action.equals(DESCRIBE_SECURITY_GROUPS)) {
            return new ServiceAction[]{FirewallSupport.GET_FIREWALL, FirewallSupport.LIST_FIREWALL};
        }
        if (action.equals(REVOKE_SECURITY_GROUP_INGRESS)) {
            return new ServiceAction[]{FirewallSupport.REVOKE};
        }
        if (action.equals(REVOKE_SECURITY_GROUP_EGRESS)) {
            return new ServiceAction[]{FirewallSupport.REVOKE};
        }
        if (action.equals(CREATE_SNAPSHOT)) {
            return new ServiceAction[]{SnapshotSupport.CREATE_SNAPSHOT};
        }
        if (action.equals(DELETE_SNAPSHOT)) {
            return new ServiceAction[]{SnapshotSupport.REMOVE_SNAPSHOT};
        }
        if (action.equals(DESCRIBE_SNAPSHOTS)) {
            return new ServiceAction[]{SnapshotSupport.GET_SNAPSHOT, SnapshotSupport.LIST_SNAPSHOT};
        }
        if (action.equals(DESCRIBE_SNAPSHOT_ATTRIBUTE)) {
            return new ServiceAction[]{SnapshotSupport.GET_SNAPSHOT};
        }
        if (action.equals(MODIFY_SNAPSHOT_ATTRIBUTE)) {
            return new ServiceAction[]{SnapshotSupport.MAKE_PUBLIC, SnapshotSupport.SHARE_SNAPSHOT};
        }
        if (action.equals(ASSOCIATE_DHCP_OPTIONS)) {
            return new ServiceAction[0];
        }
        if (action.equals(ASSOCIATE_ROUTE_TABLE)) {
            return new ServiceAction[]{VLANSupport.ASSIGN_ROUTE_TO_SUBNET};
        }
        if (action.equals(CREATE_DHCP_OPTIONS)) {
            return new ServiceAction[0];
        }
        if (action.equals(CREATE_ROUTE_TABLE)) {
            return new ServiceAction[]{VLANSupport.CREATE_ROUTING_TABLE};
        }
        if (action.equals(CREATE_ROUTE)) {
            return new ServiceAction[]{VLANSupport.ADD_ROUTE};
        }
        if (action.equals(CREATE_SUBNET)) {
            return new ServiceAction[]{VLANSupport.CREATE_SUBNET};
        }
        if (action.equals(CREATE_VPC)) {
            return new ServiceAction[]{VLANSupport.CREATE_VLAN};
        }
        if (action.equals(DELETE_INTERNET_GATEWAY)) {
            return new ServiceAction[]{VLANSupport.REMOVE_INTERNET_GATEWAY};
        }
        if (action.equals(DELETE_ROUTE)) {
            return new ServiceAction[]{VLANSupport.REMOVE_ROUTE};
        }
        if (action.equals(DELETE_ROUTE_TABLE)) {
            return new ServiceAction[]{VLANSupport.REMOVE_ROUTING_TABLE};
        }
        if (action.equals(DELETE_SUBNET)) {
            return new ServiceAction[]{VLANSupport.REMOVE_SUBNET};
        }
        if (action.equals(DELETE_VPC)) {
            return new ServiceAction[]{VLANSupport.REMOVE_VLAN};
        }
        if (action.equals(DESCRIBE_DHCP_OPTIONS)) {
            return new ServiceAction[0];
        }
        if (action.equalsIgnoreCase(DESCRIBE_ROUTE_TABLES)) {
            return new ServiceAction[]{VLANSupport.GET_ROUTING_TABLE, VLANSupport.LIST_ROUTING_TABLE};
        }
        if (action.equals(DESCRIBE_SUBNETS)) {
            return new ServiceAction[]{VLANSupport.GET_SUBNET, VLANSupport.LIST_SUBNET};
        }
        if (action.equals(DESCRIBE_VPCS)) {
            return new ServiceAction[]{VLANSupport.GET_VLAN, VLANSupport.LIST_VLAN};
        }
        if (action.equals(CREATE_INTERNET_GATEWAY)) {
            return new ServiceAction[]{VLANSupport.CREATE_VLAN};
        }
        if (action.equals(ATTACH_INTERNET_GATEWAY)) {
            return new ServiceAction[]{VLANSupport.CREATE_VLAN};
        }
        if (action.equals(CREATE_NIC)) {
            return new ServiceAction[]{VLANSupport.CREATE_NIC};
        }
        if (action.equals(ATTACH_NIC)) {
            return new ServiceAction[]{VLANSupport.ATTACH_NIC};
        }
        if (action.equals(DETACH_NIC)) {
            return new ServiceAction[]{VLANSupport.DETACH_NIC};
        }
        if (action.equals(DELETE_NIC)) {
            return new ServiceAction[]{VLANSupport.REMOVE_NIC};
        }
        if (action.equals(DESCRIBE_NICS)) {
            return new ServiceAction[]{VLANSupport.GET_NIC, VLANSupport.LIST_NIC};
        }
        if (action.equals(CREATE_CUSTOMER_GATEWAY)) {
            return new ServiceAction[]{VPNSupport.CREATE_GATEWAY};
        }
        if (action.equals(ATTACH_VPN_GATEWAY)) {
            return new ServiceAction[]{VPNSupport.ATTACH};
        }
        if (action.equals(CREATE_VPN_GATEWAY)) {
            return new ServiceAction[]{VPNSupport.CREATE_VPN};
        }
        if (action.equals(DELETE_CUSTOMER_GATEWAY)) {
            return new ServiceAction[]{VPNSupport.REMOVE_GATEWAY};
        }
        if (action.equals(DELETE_VPN_GATEWAY)) {
            return new ServiceAction[]{VPNSupport.REMOVE_VPN};
        }
        if (action.equals(DESCRIBE_CUSTOMER_GATEWAYS)) {
            return new ServiceAction[]{VPNSupport.LIST_GATEWAY, VPNSupport.GET_GATEWAY};
        }
        if (action.equals(DESCRIBE_VPN_CONNECTIONS)) {
            return new ServiceAction[]{VPNSupport.LIST_GATEWAY, VPNSupport.GET_GATEWAY, VPNSupport.LIST_VPN, VPNSupport.GET_VPN};
        }
        if (action.equals(DESCRIBE_VPN_GATEWAYS)) {
            return new ServiceAction[]{VPNSupport.LIST_VPN, VPNSupport.GET_VPN};
        }
        if (action.equals(CREATE_VPN_CONNECTION)) {
            return new ServiceAction[]{VPNSupport.CONNECT_GATEWAY};
        }
        if (action.equals(DELETE_VPN_CONNECTION)) {
            return new ServiceAction[]{VPNSupport.DISCONNECT_GATEWAY};
        }
        if (action.equals(DETACH_INTERNET_GATEWAY)) {
            return new ServiceAction[]{VPNSupport.REMOVE_GATEWAY};
        }
        if (action.equals(DETACH_VPN_GATEWAY)) {
            return new ServiceAction[]{VPNSupport.DETACH};
        }
        return new ServiceAction[0];
    }

    public EC2Method(AWSCloud provider, String url, Map<String, String> parameters) throws InternalException, CloudException {
        this.url = url;
        this.parameters = parameters;
        this.provider = provider;
        ProviderContext ctx = provider.getContext();
        if (ctx == null) {
            throw new CloudException("Provider context is necessary for this request");
        }
        parameters.put("Signature", provider.signEc2(ctx.getAccessPrivate(), url, parameters));
    }

    public void checkSuccess(NodeList returnNodes) throws CloudException {
        if (returnNodes.getLength() > 0 && !returnNodes.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
            throw new CloudException("Failed to revoke security group rule without explanation.");
        }
    }

    public Document invoke() throws EC2Exception, CloudException, InternalException {
        return this.invoke(false);
    }

    @Nonnull
    protected HttpClient getClient() throws InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("No context was specified for this request");
        }
        boolean ssl = this.url.startsWith("https");
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Dasein Cloud");
        Properties p = ctx.getCustomProperties();
        if (p != null) {
            String proxyHost = p.getProperty("proxyHost");
            String proxyPort = p.getProperty("proxyPort");
            if (proxyHost != null) {
                int port = 0;
                if (proxyPort != null && proxyPort.length() > 0) {
                    port = Integer.parseInt(proxyPort);
                }
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, port, ssl ? "https" : "http"));
            }
        }
        return new DefaultHttpClient((HttpParams)params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Document invoke(boolean debug) throws EC2Exception, CloudException, InternalException {
        block69: {
            if (EC2Method.logger.isTraceEnabled()) {
                EC2Method.logger.trace((Object)("ENTER - " + EC2Method.class.getName() + ".invoke(" + debug + ")"));
            }
            if (EC2Method.wire.isDebugEnabled()) {
                EC2Method.wire.debug((Object)"");
                EC2Method.wire.debug((Object)"--------------------------------------------------------------------------------------");
            }
            if (EC2Method.logger.isDebugEnabled()) {
                EC2Method.logger.debug((Object)("Talking to server at " + this.url));
            }
            APITrace.trace((CloudProvider)this.provider, (String)this.parameters.get("Action"));
            post = new HttpPost(this.url);
            client = this.getClient();
            ++this.attempts;
            post.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            params = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            try {
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalException((Throwable)e);
            }
            if (EC2Method.wire.isDebugEnabled()) {
                EC2Method.wire.debug((Object)post.getRequestLine().toString());
                for (Header header : post.getAllHeaders()) {
                    EC2Method.wire.debug((Object)(header /* !! */ .getName() + ": " + header /* !! */ .getValue()));
                }
                EC2Method.wire.debug((Object)"");
                try {
                    EC2Method.wire.debug((Object)EntityUtils.toString((HttpEntity)post.getEntity()));
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                EC2Method.wire.debug((Object)"");
            }
            try {
                response = client.execute((HttpUriRequest)post);
                if (EC2Method.wire.isDebugEnabled()) {
                    EC2Method.wire.debug((Object)response.getStatusLine().toString());
                }
            }
            catch (IOException e) {
                EC2Method.logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                entity = response.getEntity();
                if (entity == null) {
                    throw new EC2Exception(status, null, "NoResponse", "No response body was specified");
                }
                input = entity.getContent();
                try {
                    header /* !! */  = this.parseResponse(input);
                }
                catch (Throwable var10_33) {
                    try {
                        input.close();
                        throw var10_33;
                    }
                    catch (IOException e) {
                        EC2Method.logger.error((Object)("Error parsing response from AWS: " + e.getMessage()));
                        e.printStackTrace();
                        throw new CloudException(CloudErrorType.COMMUNICATION, status, null, e.getMessage());
                    }
                }
                input.close();
                return header /* !! */ ;
            }
            if (status != 403) break block69;
            msg = "API Access Denied (403)";
            try {
                entity = response.getEntity();
                if (entity == null) {
                    throw new EC2Exception(status, null, "NoResponse", "No response body was specified");
                }
                input = entity.getContent();
                try {
                    in = new BufferedReader(new InputStreamReader(input));
                    sb = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        sb.append(line);
                        sb.append("\n");
                    }
                    try {
                        doc = this.parseResponse(sb.toString());
                        if (doc != null) {
                            blocks = doc.getElementsByTagName("Error");
                            code = null;
                            message = null;
                            requestId = null;
                            if (blocks.getLength() > 0) {
                                error = blocks.item(0);
                                attrs = error.getChildNodes();
                                for (i = 0; i < attrs.getLength(); ++i) {
                                    attr = attrs.item(i);
                                    if (attr.getNodeName().equals("Code")) {
                                        code = attr.getFirstChild().getNodeValue().trim();
                                        continue;
                                    }
                                    if (!attr.getNodeName().equals("Message")) continue;
                                    message = attr.getFirstChild().getNodeValue().trim();
                                }
                            }
                            if ((blocks = doc.getElementsByTagName("RequestID")).getLength() > 0) {
                                id = blocks.item(0);
                                requestId = id.getFirstChild().getNodeValue().trim();
                            }
                            if (message == null && code == null) {
                                throw new CloudException(CloudErrorType.COMMUNICATION, status, null, "Unable to identify error condition: " + status + "/" + requestId + "/" + code);
                            }
                            if (message == null) {
                                message = code;
                            }
                            throw new EC2Exception(status, requestId, code, message);
                        }
                    }
                    catch (RuntimeException ignore) {
                    }
                    catch (Error ignore) {
                        // empty catch block
                    }
                    msg = msg + ": " + sb.toString().trim().replaceAll("\n", " / ");
                }
                finally {
                    input.close();
                }
            }
            catch (IOException ignore) {
            }
            catch (RuntimeException ignore) {
            }
            catch (Error ignore) {
                // empty catch block
            }
            throw new CloudException(msg);
        }
        if (EC2Method.logger.isDebugEnabled()) {
            EC2Method.logger.debug((Object)("Received " + status + " from " + this.parameters.get("Action")));
        }
        if (status != 503 && status != 500) ** GOTO lbl-1000
        if (this.attempts >= 5) {
            if (status == 503) {
                msg = "Cloud service is currently unavailable.";
            } else {
                msg = "The cloud service encountered a server error while processing your request.";
                try {
                    entity = response.getEntity();
                    if (entity == null) {
                        throw new EC2Exception(status, null, "NoResponse", "No response body was specified");
                    }
                    msg = msg + "Response from server was:\n" + EntityUtils.toString((HttpEntity)entity);
                }
                catch (IOException ignore) {
                }
                catch (RuntimeException ignore) {
                }
                catch (Error ignore) {
                    // empty catch block
                }
            }
            EC2Method.logger.error((Object)msg);
            throw new CloudException(msg);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        e = this.invoke();
        return e;
lbl-1000:
        // 1 sources

        {
            try {
                entity = response.getEntity();
                if (entity == null) {
                    throw new EC2Exception(status, null, "NoResponse", "No response body was specified");
                }
                input = entity.getContent();
                try {
                    doc = this.parseResponse(input);
                }
                finally {
                    input.close();
                }
                if (doc != null) {
                    blocks = doc.getElementsByTagName("Error");
                    code = null;
                    message = null;
                    requestId = null;
                    if (blocks.getLength() > 0) {
                        error = blocks.item(0);
                        attrs = error.getChildNodes();
                        for (i = 0; i < attrs.getLength(); ++i) {
                            attr = attrs.item(i);
                            if (attr.getNodeName().equals("Code")) {
                                code = attr.getFirstChild().getNodeValue().trim();
                                continue;
                            }
                            if (!attr.getNodeName().equals("Message")) continue;
                            message = attr.getFirstChild().getNodeValue().trim();
                        }
                    }
                    if ((blocks = doc.getElementsByTagName("RequestID")).getLength() > 0) {
                        id = blocks.item(0);
                        requestId = id.getFirstChild().getNodeValue().trim();
                    }
                    if (message == null) {
                        throw new CloudException(CloudErrorType.COMMUNICATION, status, null, "Unable to identify error condition: " + status + "/" + requestId + "/" + code);
                    }
                    throw new EC2Exception(status, requestId, code, message);
                }
                throw new CloudException("Unable to parse error.");
            }
            catch (IOException e) {
                EC2Method.logger.error((Object)e);
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (EC2Method.logger.isTraceEnabled()) {
                EC2Method.logger.trace((Object)("EXIT - " + EC2Method.class.getName() + ".invoke()"));
            }
            if (EC2Method.wire.isDebugEnabled()) {
                EC2Method.wire.debug((Object)"--------------------------------------------------------------------------------------");
                EC2Method.wire.debug((Object)"");
            }
        }
    }

    private Document parseResponse(String responseBody) throws CloudException, InternalException {
        try {
            if (wire.isDebugEnabled()) {
                String[] lines = responseBody.split("\n");
                if (lines.length < 1) {
                    lines = new String[]{responseBody};
                }
                for (String l : lines) {
                    wire.debug((Object)l);
                }
            }
            return XMLParser.parse((InputStream)new ByteArrayInputStream(responseBody.getBytes()));
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new CloudException((Throwable)e);
        }
        catch (SAXException e) {
            throw new CloudException((Throwable)e);
        }
    }

    private Document parseResponse(InputStream responseBodyAsStream) throws CloudException, InternalException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(responseBodyAsStream));
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            in.close();
            return this.parseResponse(sb.toString());
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
    }
}

