/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.identity;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.admin.PrepaymentSupport;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2ComputeServices;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.aws.identity.IAMMethod;
import org.dasein.cloud.aws.network.ELBMethod;
import org.dasein.cloud.aws.network.Route53Method;
import org.dasein.cloud.aws.platform.CloudFrontMethod;
import org.dasein.cloud.aws.platform.RDS;
import org.dasein.cloud.aws.platform.SNS;
import org.dasein.cloud.aws.platform.SQS;
import org.dasein.cloud.aws.platform.SimpleDB;
import org.dasein.cloud.aws.storage.S3Method;
import org.dasein.cloud.compute.AutoScalingSupport;
import org.dasein.cloud.compute.MachineImageSupport;
import org.dasein.cloud.compute.SnapshotSupport;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VolumeSupport;
import org.dasein.cloud.identity.AccessKey;
import org.dasein.cloud.identity.CloudGroup;
import org.dasein.cloud.identity.CloudPermission;
import org.dasein.cloud.identity.CloudPolicy;
import org.dasein.cloud.identity.CloudUser;
import org.dasein.cloud.identity.IdentityAndAccessSupport;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.identity.ShellKeySupport;
import org.dasein.cloud.network.DNSSupport;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.LoadBalancerSupport;
import org.dasein.cloud.platform.CDNSupport;
import org.dasein.cloud.platform.KeyValueDatabaseSupport;
import org.dasein.cloud.platform.MessageQueueSupport;
import org.dasein.cloud.platform.PushNotificationSupport;
import org.dasein.cloud.platform.RelationalDatabaseSupport;
import org.dasein.cloud.storage.BlobStoreSupport;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IAM
implements IdentityAndAccessSupport {
    private static final Logger logger = AWSCloud.getLogger(IAM.class);
    private AWSCloud provider;

    public IAM(@Nonnull AWSCloud cloud) {
        this.provider = cloud;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserToGroups(@Nonnull String providerUserId, String ... providerGroupIds) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".addUserToGroups(" + providerUserId + "," + Arrays.toString(providerGroupIds) + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for the attempt at addUserToGroups()");
                throw new InternalException("No context was established for this call.");
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Adding " + providerUserId + " to " + providerGroupIds.length + " groups..."));
            }
            for (String groupId : providerGroupIds) {
                this.addUserToGroup(ctx, providerUserId, groupId);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("User " + providerUserId + " successfully added to all groups."));
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".addUserToGroups()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserToGroup(@Nonnull ProviderContext ctx, @Nonnull String providerUserId, @Nonnull String providerGroupId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".addUserToGroup(" + ctx + "," + providerUserId + "," + providerGroupId + ")"));
        }
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "AddUserToGroup", "2010-05-08");
            CloudUser user = this.getUser(providerUserId);
            if (user == null) {
                throw new CloudException("No such user: " + providerUserId);
            }
            CloudGroup group = this.getGroup(providerGroupId);
            if (group == null) {
                throw new CloudException("No such group: " + providerGroupId);
            }
            parameters.put("GroupName", group.getName());
            parameters.put("UserName", user.getUserName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Adding " + providerUserId + " to " + providerGroupId + "..."));
                }
                method.invoke();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Added.");
                }
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".addUserToGroup()"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public CloudGroup createGroup(@Nonnull String groupName, @Nullable String path, boolean asAdminGroup) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".createGroup(" + groupName + "," + path + "," + asAdminGroup + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for the attempt at createGroup()");
                throw new InternalException("No context was established for this call.");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateGroup", "2010-05-08");
            groupName = this.validateName(groupName);
            parameters.put("GroupName", groupName);
            if (path != null) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                parameters.put("Path", path);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Creating group " + groupName + " in " + path + "..."));
                }
                Document doc = method.invoke();
                NodeList blocks = doc.getElementsByTagName("Group");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    CloudGroup cloudGroup = this.toGroup(ctx, blocks.item(i));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("cloudGroup=" + cloudGroup));
                    }
                    if (cloudGroup == null) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Created.");
                    }
                    if (asAdminGroup) {
                        logger.info((Object)("Setting up admin group rights for new group " + cloudGroup));
                        this.saveGroupPolicy(cloudGroup.getProviderGroupId(), "AdminGroup", CloudPermission.ALLOW, null, null);
                    }
                    CloudGroup cloudGroup2 = cloudGroup;
                    return cloudGroup2;
                }
                logger.error((Object)"No group was created as a result of the request");
                throw new CloudException("No group was created as a result of the request");
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".createGroup()"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public CloudUser createUser(@Nonnull String userName, @Nullable String path, String ... autoJoinGroupIds) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".createUser(" + userName + "," + path + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for the attempt at createUser()");
                throw new InternalException("No context was established for this call.");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateUser", "2010-05-08");
            parameters.put("UserName", userName);
            if (path != null) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                parameters.put("Path", path);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Creating user " + userName + " in " + path + "..."));
                }
                Document doc = method.invoke();
                NodeList blocks = doc.getElementsByTagName("User");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    CloudUser cloudUser = this.toUser(ctx, blocks.item(i));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("cloudUser=" + cloudUser));
                    }
                    if (cloudUser == null) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Created.");
                    }
                    CloudUser cloudUser2 = cloudUser;
                    return cloudUser2;
                }
                logger.error((Object)"No user was created as a result of the request");
                throw new CloudException("No user was created as a result of the request");
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".createUser()"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public AccessKey enableAPIAccess(@Nonnull String providerUserId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".enableAPIAccess(" + providerUserId + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudUser user = this.getUser(providerUserId);
            if (user == null) {
                throw new CloudException("No such user: " + providerUserId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateAccessKey", "2010-05-08");
            parameters.put("UserName", user.getUserName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Creating access keys for " + providerUserId));
                }
                Document doc = method.invoke();
                NodeList blocks = doc.getElementsByTagName("AccessKey");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    AccessKey key = this.toAccessKey(ctx, blocks.item(i));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("key=" + key));
                    }
                    if (key == null) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Created.");
                    }
                    AccessKey accessKey = key;
                    return accessKey;
                }
                logger.error((Object)"No access key was created as a result of the request");
                throw new CloudException("No access key was created as a result of the request");
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".enableAPIAccess()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableConsoleAccess(@Nonnull String providerUserId, @Nonnull byte[] password) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".enableConsoleAccess(" + providerUserId + ",[omitted])"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudUser user = this.getUser(providerUserId);
            if (user == null) {
                throw new CloudException("No such user: " + providerUserId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateLoginProfile", "2010-05-08");
            parameters.put("UserName", user.getUserName());
            try {
                parameters.put("Password", new String(password, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalException((Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"parameters=[omitted due to password sensitivity]");
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                Document doc;
                NodeList blocks;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Creating console access for " + providerUserId));
                }
                if ((blocks = (doc = method.invoke()).getElementsByTagName("LoginProfile")).getLength() < 1) {
                    logger.error((Object)"No console access was created as a result of the request");
                    throw new CloudException("No console access was created as a result of the request");
                }
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".enableConsoleAccess()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CloudGroup getGroup(@Nonnull String providerGroupId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".getGroup(" + providerGroupId + ")"));
        }
        try {
            for (CloudGroup group : this.listGroups(null)) {
                if (!providerGroupId.equals(group.getProviderGroupId())) continue;
                CloudGroup cloudGroup = group;
                return cloudGroup;
            }
            CloudGroup cloudGroup = null;
            return cloudGroup;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".getGroup()"));
            }
        }
    }

    @Nullable
    private CloudPolicy[] getGroupPolicy(@Nonnull CloudGroup group, @Nonnull String policyName) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".getGroupPolicy(" + group + "," + policyName + ")"));
        }
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "GetGroupPolicy", "2010-05-08");
            parameters.put("GroupName", group.getName());
            parameters.put("PolicyName", policyName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                Document doc = method.invoke();
                NodeList blocks = doc.getElementsByTagName("GetGroupPolicyResult");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    Node policyNode = blocks.item(i);
                    if (!policyNode.hasChildNodes()) continue;
                    NodeList attrs = policyNode.getChildNodes();
                    for (int j = 0; j < attrs.getLength(); ++j) {
                        String json;
                        JSONObject stmt;
                        Node attr = attrs.item(j);
                        if (!attr.getNodeName().equalsIgnoreCase("PolicyDocument") || !(stmt = new JSONObject(json = URLDecoder.decode(attr.getFirstChild().getNodeValue().trim(), "utf-8"))).has("Statement")) continue;
                        CloudPolicy[] cloudPolicyArray = this.toPolicy(policyName, stmt.getJSONArray("Statement"));
                        return cloudPolicyArray;
                    }
                }
                CloudPolicy[] i = null;
                return i;
            }
            catch (EC2Exception e) {
                if (e.getStatus() == 404) {
                    CloudPolicy[] cloudPolicyArray = null;
                    return cloudPolicyArray;
                }
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            catch (JSONException e) {
                logger.error((Object)("Failed to parse policy statement: " + e.getMessage()));
                throw new CloudException((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)("Unknown encoding in utf-8: " + e.getMessage()));
                throw new InternalException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".getGroupPolicy()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CloudUser getUser(@Nonnull String providerUserId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".getUser(" + providerUserId + ")"));
        }
        try {
            for (CloudUser user : this.listUsersInPath(null)) {
                if (!providerUserId.equals(user.getProviderUserId())) continue;
                CloudUser cloudUser = user;
                return cloudUser;
            }
            CloudUser cloudUser = null;
            return cloudUser;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".getUser()"));
            }
        }
    }

    @Nullable
    private CloudUser getUserByName(@Nonnull String userName) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".getUserByName(" + userName + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ListUsers", "2010-05-08");
            parameters.put("UserName", userName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                ArrayList users = new ArrayList();
                Document doc = method.invoke();
                NodeList blocks = doc.getElementsByTagName("member");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    CloudUser cloudUser = this.toUser(ctx, blocks.item(i));
                    if (cloudUser == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("cloudUser=" + cloudUser));
                    }
                    CloudUser cloudUser2 = cloudUser;
                    return cloudUser2;
                }
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"cloudUser=null");
            }
            CloudUser cloudUser = null;
            return cloudUser;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".getUserByName()"));
            }
        }
    }

    @Nullable
    private CloudPolicy[] getUserPolicy(@Nonnull CloudUser user, @Nonnull String policyName) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".getUserPolicy(" + user + "," + policyName + ")"));
        }
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "GetPolicy", "2010-05-08");
            parameters.put("UserName", user.getUserName());
            parameters.put("PolicyName", policyName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                Document doc = method.invoke();
                NodeList blocks = doc.getElementsByTagName("GetUserPolicyResult");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    Node policyNode = blocks.item(i);
                    if (!policyNode.hasChildNodes()) continue;
                    NodeList attrs = policyNode.getChildNodes();
                    for (int j = 0; j < attrs.getLength(); ++j) {
                        String json;
                        JSONObject stmt;
                        Node attr = attrs.item(j);
                        if (!attr.getNodeName().equalsIgnoreCase("PolicyDocument") || !(stmt = new JSONObject(json = URLDecoder.decode(attr.getFirstChild().getNodeValue().trim(), "utf-8"))).has("Statement")) continue;
                        CloudPolicy[] cloudPolicyArray = this.toPolicy(policyName, stmt.getJSONArray("Statement"));
                        return cloudPolicyArray;
                    }
                }
                CloudPolicy[] i = null;
                return i;
            }
            catch (EC2Exception e) {
                if (e.getStatus() == 404) {
                    CloudPolicy[] cloudPolicyArray = null;
                    return cloudPolicyArray;
                }
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            catch (JSONException e) {
                logger.error((Object)("Failed to parse policy statement: " + e.getMessage()));
                throw new CloudException((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)("Unknown encoding in utf-8: " + e.getMessage()));
                throw new InternalException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".getUserPolicy()"));
            }
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        EC2ComputeServices svc = this.provider.getComputeServices();
        if (svc == null) {
            return false;
        }
        VirtualMachineSupport support = svc.getVirtualMachineSupport();
        return support != null && support.isSubscribed();
    }

    @Nonnull
    public Iterable<CloudGroup> listGroups(@Nullable String pathBase) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".listGroups(" + pathBase + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ListGroups", "2010-05-08");
            if (pathBase != null) {
                parameters.put("PathPrefix", pathBase);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                ArrayList<CloudGroup> groups = new ArrayList<CloudGroup>();
                Document doc = method.invoke();
                NodeList blocks = doc.getElementsByTagName("member");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    CloudGroup cloudGroup = this.toGroup(ctx, blocks.item(i));
                    if (cloudGroup == null) continue;
                    groups.add(cloudGroup);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("groups=" + groups));
                }
                ArrayList<CloudGroup> arrayList = groups;
                return arrayList;
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".listGroups()"));
            }
        }
    }

    @Nonnull
    public Iterable<CloudGroup> listGroupsForUser(@Nonnull String providerUserId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".listGroupsForUser(" + providerUserId + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudUser user = this.getUser(providerUserId);
            if (user == null) {
                throw new CloudException("No such user: " + providerUserId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ListGroupsForUser", "2010-05-08");
            parameters.put("UserName", user.getUserName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                ArrayList<CloudGroup> groups = new ArrayList<CloudGroup>();
                Document doc = method.invoke();
                NodeList blocks = doc.getElementsByTagName("member");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    CloudGroup cloudGroup = this.toGroup(ctx, blocks.item(i));
                    if (cloudGroup == null) continue;
                    groups.add(cloudGroup);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("groups=" + groups));
                }
                ArrayList<CloudGroup> arrayList = groups;
                return arrayList;
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".listGroupsForUser()"));
            }
        }
    }

    @Nonnull
    public Iterable<CloudPolicy> listPoliciesForGroup(@Nonnull String providerGroupId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".listPoliciesForGroup(" + providerGroupId + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudGroup group = this.getGroup(providerGroupId);
            if (group == null) {
                throw new CloudException("No such group: " + providerGroupId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ListGroupPolicies", "2010-05-08");
            parameters.put("GroupName", group.getName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                ArrayList<String> names = new ArrayList<String>();
                Document doc = method.invoke();
                NodeList blocks = doc.getElementsByTagName("member");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    String name;
                    Node member = blocks.item(i);
                    if (!member.hasChildNodes() || (name = member.getFirstChild().getNodeValue().trim()).length() <= 0) continue;
                    names.add(name);
                }
                ArrayList<CloudPolicy> policies = new ArrayList<CloudPolicy>();
                for (String name : names) {
                    Collections.addAll(policies, this.getGroupPolicy(group, name));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("policies=" + policies));
                }
                ArrayList<CloudPolicy> arrayList = policies;
                return arrayList;
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".listPoliciesForGroup()"));
            }
        }
    }

    @Nonnull
    public Iterable<CloudPolicy> listPoliciesForUser(@Nonnull String providerUserId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".listPoliciesForUser(" + providerUserId + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudUser user = this.getUser(providerUserId);
            if (user == null) {
                throw new CloudException("No such user: " + providerUserId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ListUserPolicies", "2010-05-08");
            parameters.put("UserName", user.getUserName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                ArrayList<String> names = new ArrayList<String>();
                Document doc = method.invoke();
                NodeList blocks = doc.getElementsByTagName("member");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    String name;
                    Node member = blocks.item(i);
                    if (!member.hasChildNodes() || (name = member.getFirstChild().getNodeValue().trim()).length() <= 0) continue;
                    names.add(name);
                }
                ArrayList<CloudPolicy> policies = new ArrayList<CloudPolicy>();
                for (String name : names) {
                    Collections.addAll(policies, this.getUserPolicy(user, name));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("policies=" + policies));
                }
                ArrayList<CloudPolicy> arrayList = policies;
                return arrayList;
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".listPoliciesForGroup()"));
            }
        }
    }

    @Nonnull
    public Iterable<CloudUser> listUsersInGroup(@Nonnull String inProviderGroupId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".listUsersInGroup(" + inProviderGroupId + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudGroup group = this.getGroup(inProviderGroupId);
            if (group == null) {
                throw new CloudException("No such group: " + inProviderGroupId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "GetGroup", "2010-05-08");
            parameters.put("GroupName", group.getName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                ArrayList<CloudUser> users = new ArrayList<CloudUser>();
                Document doc = method.invoke();
                NodeList blocks = doc.getElementsByTagName("member");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    CloudUser user = this.toUser(ctx, blocks.item(i));
                    if (user == null) continue;
                    users.add(user);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("users=" + users));
                }
                ArrayList<CloudUser> arrayList = users;
                return arrayList;
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".listUsersInGroup()"));
            }
        }
    }

    @Nonnull
    public Iterable<CloudUser> listUsersInPath(@Nullable String pathBase) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".listUsersInPath(" + pathBase + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ListUsers", "2010-05-08");
            if (pathBase != null) {
                parameters.put("PathPrefix", pathBase);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                ArrayList<CloudUser> users = new ArrayList<CloudUser>();
                Document doc = method.invoke();
                NodeList blocks = doc.getElementsByTagName("member");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    CloudUser cloudUser = this.toUser(ctx, blocks.item(i));
                    if (cloudUser == null) continue;
                    users.add(cloudUser);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("users=" + users));
                }
                ArrayList<CloudUser> arrayList = users;
                return arrayList;
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".listUsersInPath()"));
            }
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)IdentityAndAccessSupport.ANY)) {
            return new String[]{"iam:*"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.ADD_GROUP_ACCESS)) {
            return new String[]{"iam:PutGroupPolicy"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.ADD_USER_ACCESS)) {
            return new String[]{"iam:PutUserPolicy"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.CREATE_GROUP)) {
            return new String[]{"iam:CreateGroup"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.CREATE_USER)) {
            return new String[]{"iam:CreateUser"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.DISABLE_API)) {
            return new String[]{"iam:DeleteAccessKey"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.DISABLE_CONSOLE)) {
            return new String[]{"iam:DeleteLoginProfile"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.DROP_FROM_GROUP)) {
            return new String[]{"iam:RemoveUserFromGroup"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.ENABLE_API)) {
            return new String[]{"iam:CreateAccessKey"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.ENABLE_CONSOLE)) {
            return new String[]{"iam:CreateLoginProfile"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.GET_ACCESS_KEY)) {
            return new String[]{"iam:GetAccessKey"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.GET_GROUP)) {
            return new String[]{"iam:GetGroup"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.GET_GROUP_POLICY)) {
            return new String[]{"iam:GetGroupPolicy", "iam:ListGroupPolicies"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.GET_USER)) {
            return new String[]{"iam:GetUser"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.GET_USER_POLICY)) {
            return new String[]{"iam:GetPolicy", "iam:ListUserPolicies"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.JOIN_GROUP)) {
            return new String[]{"iam:AddUserToGroup"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.LIST_ACCESS_KEY)) {
            return new String[]{"iam:ListAccessKey"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.LIST_GROUP)) {
            return new String[]{"iam:ListGroups*"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.LIST_USER)) {
            return new String[]{"iam:ListUsers"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.REMOVE_GROUP)) {
            return new String[]{"iam:DeleteGroup"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.REMOVE_GROUP_ACCESS)) {
            return new String[]{"iam:PutGroupPolicy"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.REMOVE_USER)) {
            return new String[]{"iam:DeleteUser"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.REMOVE_USER_ACCESS)) {
            return new String[]{"iam:PutUserPolicy"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.UPDATE_GROUP)) {
            return new String[]{"iam:UpdateGroup"};
        }
        if (action.equals((Object)IdentityAndAccessSupport.UPDATE_USER)) {
            return new String[]{"iam:UpdateUser"};
        }
        return new String[0];
    }

    public void removeAccessKey(@Nonnull String sharedKeyPart) throws CloudException, InternalException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessKey(@Nonnull String sharedKeyPart, @Nonnull String providerUserId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".removeAccessKey(" + sharedKeyPart + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudUser user = this.getUser(providerUserId);
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteAccessKey", "2010-05-08");
            parameters.put("AccessKeyId", sharedKeyPart);
            parameters.put("UserName", user.getUserName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Removing access key for " + sharedKeyPart));
                }
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".removeAccessKey()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsoleAccess(@Nonnull String providerUserId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".removeConsoleAccess(" + providerUserId + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudUser user = this.getUser(providerUserId);
            if (user == null) {
                throw new CloudException("No such user: " + providerUserId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteLoginProfile", "2010-05-08");
            parameters.put("UserName", user.getUserName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Removing console access for " + providerUserId));
                }
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".removeConsoleAccess()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(@Nonnull String providerGroupId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".removeGroup(" + providerGroupId + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudGroup group = this.getGroup(providerGroupId);
            if (group == null) {
                throw new CloudException("No such group: " + providerGroupId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteGroup", "2010-05-08");
            parameters.put("GroupName", group.getName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Removing group " + providerGroupId));
                }
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".removeGroup()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(@Nonnull String providerUserId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".removeUser(" + providerUserId + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudUser user = this.getUser(providerUserId);
            if (user == null) {
                throw new CloudException("No such user: " + providerUserId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteUser", "2010-05-08");
            parameters.put("UserName", user.getUserName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Removing user " + providerUserId));
                }
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".removeUser()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserFromGroup(@Nonnull String providerUserId, @Nonnull String providerGroupId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".removeUserFromGroup(" + providerUserId + "," + providerGroupId + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudUser user = this.getUser(providerUserId);
            if (user == null) {
                throw new CloudException("No such user: " + providerUserId);
            }
            CloudGroup group = this.getGroup(providerGroupId);
            if (group == null) {
                throw new CloudException("No such group: " + providerGroupId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "RemoveUserFromGroup", "2010-05-08");
            parameters.put("UserName", user.getUserName());
            parameters.put("GroupName", group.getName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Removing user " + providerUserId + " from " + providerGroupId));
                }
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".removeUserFromGroup()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGroup(@Nonnull String providerGroupId, @Nullable String newGroupName, @Nullable String newPath) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".saveGroup(" + providerGroupId + "," + newGroupName + "," + newPath + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudGroup group = this.getGroup(providerGroupId);
            if (group == null) {
                throw new CloudException("No such group: " + providerGroupId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "UpdateGroup", "2010-05-08");
            parameters.put("GroupName", group.getName());
            if (newGroupName != null) {
                parameters.put("NewGroupName", providerGroupId);
            }
            if (newPath != null) {
                parameters.put("NewPath", newPath);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                Document doc;
                NodeList blocks;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Updating group " + providerGroupId + " with " + newPath + " - " + newGroupName + "..."));
                }
                if ((blocks = (doc = method.invoke()).getElementsByTagName("Group")).getLength() < 1) {
                    logger.error((Object)"No group was updated as a result of the request");
                    throw new CloudException("No group was updated as a result of the request");
                }
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".saveGroup()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGroupPolicy(@Nonnull String providerGroupId, @Nonnull String name, @Nonnull CloudPermission permission, @Nullable ServiceAction action, @Nullable String resourceId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".saveGroupPermission(" + providerGroupId + "," + permission + "," + action + "," + resourceId + ")"));
        }
        try {
            String[] actions;
            String[] stringArray;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudGroup group = this.getGroup(providerGroupId);
            if (group == null) {
                throw new CloudException("No such group: " + providerGroupId);
            }
            if (action == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*";
            } else {
                stringArray = action.map((CloudProvider)this.provider);
            }
            for (String actionId : actions = stringArray) {
                Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "PutGroupPolicy", "2010-05-08");
                parameters.put("GroupName", group.getName());
                parameters.put("PolicyName", name);
                ArrayList policies = new ArrayList();
                HashMap statement = new HashMap();
                HashMap<String, String> policy = new HashMap<String, String>();
                policy.put("Effect", permission.equals((Object)CloudPermission.ALLOW) ? "Allow" : "Deny");
                policy.put("Action", actionId);
                policy.put("Resource", resourceId == null ? "*" : resourceId);
                policies.add(policy);
                statement.put("Statement", policies);
                parameters.put("PolicyDocument", new JSONObject(statement).toString());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("parameters=" + parameters));
                }
                IAMMethod method = new IAMMethod(this.provider, parameters);
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Updating policy for group " + providerGroupId));
                    }
                    method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".saveGroupPermission()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserPolicy(@Nonnull String providerUserId, @Nonnull String name, @Nonnull CloudPermission permission, @Nullable ServiceAction action, @Nullable String resourceId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".saveUserPermission(" + providerUserId + "," + permission + "," + action + "," + resourceId + ")"));
        }
        try {
            String[] actions;
            String[] stringArray;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for this request.");
                throw new InternalException("No context was established for this request");
            }
            CloudUser user = this.getUser(providerUserId);
            if (user == null) {
                throw new CloudException("No such user: " + providerUserId);
            }
            if (action == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*";
            } else {
                stringArray = action.map((CloudProvider)this.provider);
            }
            for (String actionId : actions = stringArray) {
                Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "PutUserPolicy", "2010-05-08");
                parameters.put("UserName", user.getUserName());
                parameters.put("PolicyName", name);
                ArrayList policies = new ArrayList();
                HashMap statement = new HashMap();
                HashMap<String, String> policy = new HashMap<String, String>();
                policy.put("Effect", permission.equals((Object)CloudPermission.ALLOW) ? "Allow" : "Deny");
                policy.put("Action", actionId);
                policy.put("Resource", resourceId == null ? "*" : resourceId);
                policies.add(policy);
                statement.put("Statement", policies);
                parameters.put("PolicyDocument", new JSONObject(statement).toString());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("parameters=" + parameters));
                }
                IAMMethod method = new IAMMethod(this.provider, parameters);
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Updating policy for user " + providerUserId));
                    }
                    method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".saveUserPermission()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUser(@Nonnull String providerUserId, @Nullable String newUserName, @Nullable String newPath) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + IAM.class.getName() + ".saveUser(" + providerUserId + "," + newUserName + "," + newPath + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was established for the request.");
                throw new InternalException("No context was established for this request");
            }
            CloudUser user = this.getUser(providerUserId);
            if (user == null) {
                throw new CloudException("No such user: " + providerUserId);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "UpdateUser", "2010-05-08");
            parameters.put("UserName", user.getUserName());
            if (newUserName != null) {
                parameters.put("NewUserName", newUserName);
            }
            if (newPath != null) {
                parameters.put("NewPath", newPath);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parameters=" + parameters));
            }
            IAMMethod method = new IAMMethod(this.provider, parameters);
            try {
                Document doc;
                NodeList blocks;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Updating user " + providerUserId + " with " + newPath + " - " + newUserName + "..."));
                }
                if ((blocks = (doc = method.invoke()).getElementsByTagName("User")).getLength() < 1) {
                    logger.error((Object)"No user was updated as a result of the request");
                    throw new CloudException("No user was updated as a result of the request");
                }
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + IAM.class.getName() + ".saveUser()"));
            }
        }
    }

    public boolean supportsAccessControls() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsConsoleAccess() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsAPIAccess() throws CloudException, InternalException {
        return true;
    }

    @Nullable
    private AccessKey toAccessKey(@Nonnull ProviderContext ctx, @Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        AccessKey key = new AccessKey();
        key.setProviderOwnerId(ctx.getAccountNumber());
        String userName = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String attrName = attribute.getNodeName();
            if (attrName.equalsIgnoreCase("UserName") && attribute.hasChildNodes()) {
                userName = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (attrName.equalsIgnoreCase("AccessKeyId") && attribute.hasChildNodes()) {
                key.setSharedPart(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (attrName.equalsIgnoreCase("SecretAccessKey") && attribute.hasChildNodes()) {
                try {
                    key.setSecretPart(attribute.getFirstChild().getNodeValue().trim().getBytes("utf-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            if (!attrName.equalsIgnoreCase("Status") || attribute.hasChildNodes() && attribute.getFirstChild().getNodeValue().trim().equalsIgnoreCase("Active")) continue;
            return null;
        }
        if (userName != null) {
            CloudUser user = this.getUserByName(userName);
            if (user == null) {
                logger.warn((Object)("Found key " + key.getSharedPart() + " belonging to " + userName + ", but no matching user"));
                return null;
            }
            String userId = user.getProviderUserId();
            if (userId == null) {
                logger.warn((Object)("Found key " + key.getSharedPart() + " belonging to " + userName + ", but no matching user"));
                return null;
            }
            key.setProviderUserId(userId);
        }
        if (key.getSharedPart() == null || key.getSecretPart() == null) {
            return null;
        }
        return key;
    }

    @Nullable
    private CloudGroup toGroup(@Nonnull ProviderContext ctx, @Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        CloudGroup group = new CloudGroup();
        group.setPath("/");
        group.setProviderOwnerId(ctx.getAccountNumber());
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String attrName = attribute.getNodeName();
            if (attrName.equalsIgnoreCase("Path") && attribute.hasChildNodes()) {
                group.setPath(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (attrName.equalsIgnoreCase("GroupId") && attribute.hasChildNodes()) {
                group.setProviderGroupId(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!attrName.equalsIgnoreCase("GroupName") || !attribute.hasChildNodes()) continue;
            group.setName(attribute.getFirstChild().getNodeValue().trim());
        }
        if (group.getName() == null || group.getProviderGroupId() == null) {
            return null;
        }
        return group;
    }

    @Nullable
    private CloudPolicy[] toPolicy(@Nonnull String policyName, @Nonnull JSONArray policyStatements) throws JSONException {
        ArrayList<CloudPolicy> policyList = new ArrayList<CloudPolicy>();
        for (int i = 0; i < policyStatements.length(); ++i) {
            String resource;
            JSONObject policyStatement = policyStatements.getJSONObject(i);
            String effect = policyStatement.has("Effect") ? policyStatement.getString("Effect") : null;
            String action = policyStatement.has("Action") ? policyStatement.getString("Action") : null;
            String string = resource = policyStatement.has("Resource") ? policyStatement.getString("Resource") : null;
            if (effect == null) {
                return null;
            }
            CloudPermission permission = effect.equalsIgnoreCase("allow") ? CloudPermission.ALLOW : CloudPermission.DENY;
            ServiceAction[] serviceActions = null;
            String resourceId = null;
            if (action != null) {
                if (action.equals("*")) {
                    serviceActions = null;
                } else {
                    String svc;
                    int idx = action.indexOf(":");
                    if (idx < 1) {
                        svc = "ec2";
                        if (idx == 0) {
                            action = action.length() > 1 ? action.substring(1) : "*";
                        }
                    } else if (idx == action.length() - 1) {
                        svc = action.substring(0, idx);
                        action = "*";
                    } else {
                        svc = action.substring(0, idx);
                        action = action.substring(idx + 1);
                    }
                    if (action.equals("*")) {
                        action = null;
                    }
                    serviceActions = (svc = svc + ":").equals("iam:") ? (action == null ? new ServiceAction[]{IdentityAndAccessSupport.ANY} : IAMMethod.asIAMServiceAction(action)) : (svc.equals("ec2:") ? (action == null ? new ServiceAction[]{PrepaymentSupport.ANY, VirtualMachineSupport.ANY, MachineImageSupport.ANY, VolumeSupport.ANY, SnapshotSupport.ANY, IpAddressSupport.ANY, FirewallSupport.ANY, ShellKeySupport.ANY} : EC2Method.asEC2ServiceAction(action)) : (svc.equals("route53") ? (action == null ? new ServiceAction[]{DNSSupport.ANY} : Route53Method.asRoute53ServiceAction(action)) : (svc.equals("elasticloadbalancing:") ? (action == null ? new ServiceAction[]{LoadBalancerSupport.ANY} : ELBMethod.asELBServiceAction(action)) : (svc.equals("cloudfront:") ? (action == null ? new ServiceAction[]{CDNSupport.ANY} : CloudFrontMethod.asCloudFrontServiceAction(action)) : (svc.equals("autoscaling:") ? (action == null ? new ServiceAction[]{AutoScalingSupport.ANY} : EC2Method.asAutoScalingServiceAction(action)) : (svc.equals("rds:") ? (action == null ? new ServiceAction[]{RelationalDatabaseSupport.ANY} : RDS.asRDSServiceAction(action)) : (svc.equals("sdb:") ? (action == null ? new ServiceAction[]{KeyValueDatabaseSupport.ANY} : SimpleDB.asSimpleDBServiceAction(action)) : (svc.equals("sns:") ? (action == null ? new ServiceAction[]{PushNotificationSupport.ANY} : SNS.asSNSServiceAction(action)) : (svc.equals("sqs:") ? (action == null ? new ServiceAction[]{MessageQueueSupport.ANY} : SQS.asSQSServiceAction(action)) : (svc.equals("s3:") ? (action == null ? new ServiceAction[]{BlobStoreSupport.ANY} : S3Method.asS3ServiceAction(action)) : new ServiceAction[]{}))))))))));
                }
            }
            if (resource != null && !resource.equals("*")) {
                resourceId = resource;
            }
            if (serviceActions == null) {
                return new CloudPolicy[]{new CloudPolicy(policyName, permission, null, resourceId)};
            }
            for (void var15_17 : serviceActions) {
                policyList.add(new CloudPolicy(policyName, permission, (ServiceAction)var15_17, resourceId));
            }
        }
        return policyList.toArray(new CloudPolicy[policyList.size()]);
    }

    @Nullable
    private CloudUser toUser(@Nonnull ProviderContext ctx, @Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        CloudUser user = new CloudUser();
        user.setPath("/");
        user.setProviderOwnerId(ctx.getAccountNumber());
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String attrName = attribute.getNodeName();
            if (attrName.equalsIgnoreCase("Path") && attribute.hasChildNodes()) {
                user.setPath(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (attrName.equalsIgnoreCase("UserId") && attribute.hasChildNodes()) {
                user.setProviderUserId(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!attrName.equalsIgnoreCase("UserName") || !attribute.hasChildNodes()) continue;
            user.setUserName(attribute.getFirstChild().getNodeValue().trim());
        }
        if (user.getUserName() == null || user.getProviderUserId() == null) {
            return null;
        }
        return user;
    }

    @Nonnull
    private String validateName(@Nonnull String name) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                str.append(c);
                continue;
            }
            if (c == '+' || c == '=' || c == ',' || c == '.' || c == '@' || c == '_' || c == '-') {
                if (i == 0) {
                    str.append("a");
                }
                str.append(c);
                continue;
            }
            if (c != ' ') continue;
            str.append("-");
        }
        if (str.length() < 1) {
            return String.valueOf(System.currentTimeMillis());
        }
        return str.toString();
    }
}

