/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.identity;

import java.util.Map;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.identity.IdentityAndAccessSupport;
import org.dasein.cloud.identity.ServiceAction;

public class IAMMethod
extends EC2Method {
    public static final String IAM_PREFIX = "iam:";
    public static final String IAM_URL = "https://iam.amazonaws.com";
    public static final String VERSION = "2010-05-08";
    public static final String ADD_USER_TO_GROUP = "AddUserToGroup";
    public static final String CREATE_ACCESS_KEY = "CreateAccessKey";
    public static final String CREATE_GROUP = "CreateGroup";
    public static final String CREATE_LOGIN_PROFILE = "CreateLoginProfile";
    public static final String CREATE_USER = "CreateUser";
    public static final String DELETE_ACCESS_KEY = "DeleteAccessKey";
    public static final String DELETE_GROUP = "DeleteGroup";
    public static final String DELETE_LOGIN_PROFILE = "DeleteLoginProfile";
    public static final String DELETE_USER = "DeleteUser";
    public static final String GET_ACCESS_KEY = "GetAccessKey";
    public static final String GET_GROUP = "GetGroup";
    public static final String GET_GROUP_POLICY = "GetGroupPolicy";
    public static final String GET_USER = "GetUser";
    public static final String GET_USER_POLICY = "GetPolicy";
    public static final String LIST_ACCESS_KEY = "ListAccessKey";
    public static final String LIST_GROUP_POLICIES = "ListGroupPolicies";
    public static final String LIST_GROUPS = "ListGroups";
    public static final String LIST_GROUPS_FOR_USER = "ListGroupsForUser";
    public static final String LIST_USER_POLICIES = "ListUserPolicies";
    public static final String LIST_USERS = "ListUsers";
    public static final String PUT_GROUP_POLICY = "PutGroupPolicy";
    public static final String PUT_USER_POLICY = "PutUserPolicy";
    public static final String REMOVE_USER_FROM_GROUP = "RemoveUserFromGroup";
    public static final String UPDATE_GROUP = "UpdateGroup";
    public static final String UPDATE_USER = "UpdateUser";

    @Nonnull
    public static ServiceAction[] asIAMServiceAction(@Nonnull String action) {
        if (action.equals(ADD_USER_TO_GROUP)) {
            return new ServiceAction[]{IdentityAndAccessSupport.JOIN_GROUP};
        }
        if (action.equals(CREATE_ACCESS_KEY)) {
            return new ServiceAction[]{IdentityAndAccessSupport.ENABLE_API};
        }
        if (action.equals(CREATE_GROUP)) {
            return new ServiceAction[]{IdentityAndAccessSupport.CREATE_GROUP};
        }
        if (action.equals(CREATE_LOGIN_PROFILE)) {
            return new ServiceAction[]{IdentityAndAccessSupport.ENABLE_CONSOLE};
        }
        if (action.equals(CREATE_USER)) {
            return new ServiceAction[]{IdentityAndAccessSupport.CREATE_USER};
        }
        if (action.equals(DELETE_ACCESS_KEY)) {
            return new ServiceAction[]{IdentityAndAccessSupport.DISABLE_API};
        }
        if (action.equals(DELETE_GROUP)) {
            return new ServiceAction[]{IdentityAndAccessSupport.REMOVE_GROUP};
        }
        if (action.equals(DELETE_LOGIN_PROFILE)) {
            return new ServiceAction[]{IdentityAndAccessSupport.DISABLE_CONSOLE};
        }
        if (action.equals(DELETE_USER)) {
            return new ServiceAction[]{IdentityAndAccessSupport.REMOVE_USER};
        }
        if (action.equals(GET_ACCESS_KEY)) {
            return new ServiceAction[]{IdentityAndAccessSupport.GET_ACCESS_KEY};
        }
        if (action.equals(GET_GROUP)) {
            return new ServiceAction[]{IdentityAndAccessSupport.GET_GROUP};
        }
        if (action.equals(GET_GROUP_POLICY)) {
            return new ServiceAction[]{IdentityAndAccessSupport.GET_GROUP_POLICY};
        }
        if (action.equals(GET_USER)) {
            return new ServiceAction[]{IdentityAndAccessSupport.GET_USER};
        }
        if (action.equals(GET_USER_POLICY)) {
            return new ServiceAction[]{IdentityAndAccessSupport.GET_USER_POLICY};
        }
        if (action.equals(LIST_ACCESS_KEY)) {
            return new ServiceAction[]{IdentityAndAccessSupport.LIST_ACCESS_KEY};
        }
        if (action.equals(LIST_GROUP_POLICIES)) {
            return new ServiceAction[]{IdentityAndAccessSupport.GET_GROUP_POLICY};
        }
        if (action.equals(LIST_GROUPS)) {
            return new ServiceAction[]{IdentityAndAccessSupport.LIST_GROUP};
        }
        if (action.equals(LIST_GROUPS_FOR_USER)) {
            return new ServiceAction[]{IdentityAndAccessSupport.GET_USER};
        }
        if (action.equals(LIST_USER_POLICIES)) {
            return new ServiceAction[]{IdentityAndAccessSupport.GET_USER_POLICY};
        }
        if (action.equals(LIST_USERS)) {
            return new ServiceAction[]{IdentityAndAccessSupport.LIST_USER};
        }
        if (action.equals(PUT_GROUP_POLICY)) {
            return new ServiceAction[]{IdentityAndAccessSupport.ADD_GROUP_ACCESS};
        }
        if (action.equals(PUT_USER_POLICY)) {
            return new ServiceAction[]{IdentityAndAccessSupport.ADD_USER_ACCESS};
        }
        if (action.equals(REMOVE_USER_FROM_GROUP)) {
            return new ServiceAction[]{IdentityAndAccessSupport.DROP_FROM_GROUP};
        }
        if (action.equals(UPDATE_GROUP)) {
            return new ServiceAction[]{IdentityAndAccessSupport.UPDATE_GROUP};
        }
        if (action.equals(UPDATE_USER)) {
            return new ServiceAction[]{IdentityAndAccessSupport.UPDATE_USER};
        }
        return new ServiceAction[0];
    }

    public IAMMethod(AWSCloud provider, Map<String, String> parameters) throws CloudException, InternalException {
        super(provider, IAM_URL, parameters);
    }
}

