/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.identity;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.identity.SSHKeypair;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.identity.ShellKeySupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Keypairs
implements ShellKeySupport {
    private static final Logger logger = AWSCloud.getLogger(Keypairs.class);
    private AWSCloud provider = null;

    public Keypairs(@Nonnull AWSCloud provider) {
        this.provider = provider;
    }

    @Nonnull
    public SSHKeypair createKeypair(@Nonnull String name) throws InternalException, CloudException {
        Document doc;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was established for this call.");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request.");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateKeyPair");
        parameters.put("KeyName", name);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        String material = null;
        String fingerprint = null;
        NodeList blocks = doc.getElementsByTagName("CreateKeyPairResponse");
        for (int i = 0; i < blocks.getLength(); ++i) {
            Node item = blocks.item(i);
            NodeList attrs = item.getChildNodes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node attr = attrs.item(j);
                if (attr.getNodeName().equalsIgnoreCase("keyMaterial")) {
                    material = attr.getFirstChild().getNodeValue();
                    continue;
                }
                if (!attr.getNodeName().equalsIgnoreCase("keyFingerPrint")) continue;
                fingerprint = attr.getFirstChild().getNodeValue();
            }
        }
        if (fingerprint == null || material == null) {
            throw new CloudException("Invalid response to attempt to create the keypair");
        }
        SSHKeypair key = new SSHKeypair();
        try {
            key.setPrivateKey(material.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException((Throwable)e);
        }
        key.setFingerprint(fingerprint);
        key.setName(name);
        key.setProviderKeypairId(name);
        key.setProviderOwnerId(ctx.getAccountNumber());
        key.setProviderRegionId(regionId);
        return key;
    }

    public void deleteKeypair(@Nonnull String name) throws InternalException, CloudException {
        Document doc;
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteKeyPair");
        parameters.put("KeyName", name);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidKeyPair")) {
                return;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("return");
        if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
            throw new CloudException("Deletion of keypair denied.");
        }
    }

    @Nullable
    public String getFingerprint(@Nonnull String name) throws InternalException, CloudException {
        Document doc;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("No context was established for this call.");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeKeyPairs");
        parameters.put("KeyName.1", name);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidKeyPair")) {
                return null;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("keyFingerprint");
        if (blocks.getLength() > 0) {
            return blocks.item(0).getFirstChild().getNodeValue().trim();
        }
        throw new CloudException("Unable to identify key fingerprint.");
    }

    public Requirement getKeyImportSupport() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nullable
    public SSHKeypair getKeypair(@Nonnull String name) throws InternalException, CloudException {
        Document doc;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was established for this call.");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request.");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeKeyPairs");
        parameters.put("KeyName.1", name);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidKeyPair")) {
                return null;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("item");
        for (int i = 0; i < blocks.getLength(); ++i) {
            Node item = blocks.item(i);
            NodeList attrs = item.getChildNodes();
            String fingerprint = null;
            String keyName = null;
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node attr = attrs.item(j);
                if (attr.getNodeName().equalsIgnoreCase("keyFingerprint") && attr.hasChildNodes()) {
                    fingerprint = attr.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (!attr.getNodeName().equalsIgnoreCase("keyName") || !attr.hasChildNodes()) continue;
                keyName = attr.getFirstChild().getNodeValue().trim();
            }
            if (keyName == null || !keyName.equals(name) || fingerprint == null) continue;
            SSHKeypair kp = new SSHKeypair();
            kp.setFingerprint(fingerprint);
            kp.setName(keyName);
            kp.setPrivateKey(null);
            kp.setPublicKey(null);
            kp.setProviderKeypairId(keyName);
            kp.setProviderOwnerId(ctx.getAccountNumber());
            kp.setProviderRegionId(regionId);
            return kp;
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForKeypair(@Nonnull Locale locale) {
        return "keypair";
    }

    @Nonnull
    public SSHKeypair importKeypair(@Nonnull String name, @Nonnull String material) throws InternalException, CloudException {
        Document doc;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was established for this call.");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request.");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ImportKeyPair");
        parameters.put("KeyName", name);
        parameters.put("PublicKeyMaterial", material);
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        String fingerprint = null;
        NodeList blocks = doc.getElementsByTagName("ImportKeyPairResponse");
        for (int i = 0; i < blocks.getLength(); ++i) {
            Node item = blocks.item(i);
            NodeList attrs = item.getChildNodes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node attr = attrs.item(j);
                if (!attr.getNodeName().equalsIgnoreCase("keyFingerPrint")) continue;
                fingerprint = attr.getFirstChild().getNodeValue();
            }
        }
        if (fingerprint == null) {
            throw new CloudException("Invalid response to attempt to create the keypair");
        }
        SSHKeypair key = new SSHKeypair();
        try {
            key.setPrivateKey(material.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException((Throwable)e);
        }
        key.setFingerprint(fingerprint);
        key.setName(name);
        key.setProviderKeypairId(name);
        key.setProviderOwnerId(ctx.getAccountNumber());
        key.setProviderRegionId(regionId);
        return key;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        this.provider.testContext();
        return true;
    }

    @Nonnull
    public Collection<SSHKeypair> list() throws InternalException, CloudException {
        Document doc;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was established for this call.");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request.");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeKeyPairs");
        ArrayList<SSHKeypair> keypairs = new ArrayList<SSHKeypair>();
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidKeyPair")) {
                return Collections.emptyList();
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("item");
        for (int i = 0; i < blocks.getLength(); ++i) {
            Node item = blocks.item(i);
            if (!item.hasChildNodes()) continue;
            NodeList attrs = item.getChildNodes();
            String fingerprint = null;
            String keyName = null;
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node attr = attrs.item(j);
                if (attr.getNodeName().equalsIgnoreCase("keyName") && attr.hasChildNodes()) {
                    keyName = attr.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (!attr.getNodeName().equalsIgnoreCase("keyFingerprint") || !attr.hasChildNodes()) continue;
                fingerprint = attr.getFirstChild().getNodeValue().trim();
            }
            if (keyName == null || fingerprint == null) continue;
            SSHKeypair keypair = new SSHKeypair();
            keypair.setName(keyName);
            keypair.setProviderKeypairId(keyName);
            keypair.setFingerprint(fingerprint);
            keypair.setProviderOwnerId(ctx.getAccountNumber());
            keypair.setProviderRegionId(regionId);
            keypairs.add(keypair);
        }
        return keypairs;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)ShellKeySupport.ANY)) {
            return new String[]{"ec2:*"};
        }
        if (action.equals((Object)ShellKeySupport.CREATE_KEYPAIR)) {
            return new String[]{"ec2:CreateKeyPair", "ec2:ImportKeyPair"};
        }
        if (action.equals((Object)ShellKeySupport.GET_KEYPAIR) || action.equals((Object)ShellKeySupport.LIST_KEYPAIR)) {
            return new String[]{"ec2:DescribeKeyPairs"};
        }
        if (action.equals((Object)ShellKeySupport.REMOVE_KEYPAIR)) {
            return new String[]{"ec2:DeleteKeyPair"};
        }
        return new String[0];
    }
}

